/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.text.View;

public class BasicMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    private ChangeListener changeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    private transient Color disfg;
    private transient Object[] bindings;
    InputMap windowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static final String MAX_TEXT_WIDTH = "maxTextWidth";
    private static final String MAX_ACC_WIDTH = "maxAccWidth";
    private InputMap selectedWindowInputMap;
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(string + ".checkIcon");
        }
        this.disfg = UIManager.getColor("MenuItem.disabledForeground");
        this.bindings = (Object[])UIManager.get("Menu.selectedWindowInputMapBindings");
    }

    protected void installComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, jMenuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        this.changeListener = this.createMIChangeListener(this.menuItem);
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        this.menuItem.addChangeListener(this.changeListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent jComponent2 = (JComponent)container;
            jComponent2.putClientProperty(MAX_ACC_WIDTH, null);
            jComponent2.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
        BasicHTML.updateRenderer(jMenuItem, "");
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        this.menuItem.removeChangeListener(this.changeListener);
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
        this.changeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    private ChangeListener createMIChangeListener(JComponent jComponent) {
        return new ChangeHandler((JMenuItem)jComponent, this);
    }

    ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        String string2 = string + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string2);
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.put(string2, actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("doClick", new ClickAction());
        if (!(this instanceof BasicMenuUI)) {
            ActionMap actionMap = (ActionMap)UIManager.get("Menu.sharedActionMap");
            if (actionMap == null && (actionMap = this.createMISharedActionMap()) != null) {
                UIManager.put("MenuItemUI.sharedActionMap", actionMap);
            }
            if (actionMap != null) {
                actionMapUIResource.setParent(actionMap);
            }
        }
        return actionMapUIResource;
    }

    private ActionMap createMISharedActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("cancel", new CancelAction());
        actionMapUIResource.put("selectNext", new SelectNextItemAction());
        actionMapUIResource.put("selectPrevious", new SelectPreviousItemAction());
        actionMapUIResource.put("selectParent", new SelectParentItemAction());
        actionMapUIResource.put("selectChild", new SelectChildItemAction());
        actionMapUIResource.put("return", new ReturnAction());
        return actionMapUIResource;
    }

    InputMap createInputMap(int n) {
        if (n == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (keyStroke != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(keyStroke, "doClick");
        } else if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Serializable serializable;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Icon icon3 = jMenuItem.getIcon();
        String string = jMenuItem.getText();
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string2 = "";
        if (keyStroke != null) {
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n2);
                string2 = string2 + this.acceleratorDelimiter;
            }
            string2 = string2 + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        Font font = jMenuItem.getFont();
        FontMetrics fontMetrics = jMenuItem.getToolkit().getFontMetrics(font);
        FontMetrics fontMetrics2 = jMenuItem.getToolkit().getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fontMetrics, string, fontMetrics2, string2, icon3, icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n, n);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(BasicMenuItemUI.iconRect.x, BasicMenuItemUI.iconRect.y, BasicMenuItemUI.iconRect.width, BasicMenuItemUI.iconRect.height, r);
        Container container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int n3;
            serializable = (JComponent)container;
            Integer n4 = (Integer)((JComponent)serializable).getClientProperty(MAX_TEXT_WIDTH);
            Integer n5 = (Integer)((JComponent)serializable).getClientProperty(MAX_ACC_WIDTH);
            int n6 = n4 != null ? n4 : 0;
            int n7 = n3 = n5 != null ? n5 : 0;
            if (BasicMenuItemUI.r.width < n6) {
                BasicMenuItemUI.r.width = n6;
            } else {
                ((JComponent)serializable).putClientProperty(MAX_TEXT_WIDTH, new Integer(BasicMenuItemUI.r.width));
            }
            if (BasicMenuItemUI.acceleratorRect.width > n3) {
                n3 = BasicMenuItemUI.acceleratorRect.width;
                ((JComponent)serializable).putClientProperty(MAX_ACC_WIDTH, new Integer(BasicMenuItemUI.acceleratorRect.width));
            }
            BasicMenuItemUI.r.width += n3;
            BasicMenuItemUI.r.width += n;
        }
        if (this.useCheckAndArrow()) {
            BasicMenuItemUI.r.width += BasicMenuItemUI.checkIconRect.width;
            BasicMenuItemUI.r.width += n;
            BasicMenuItemUI.r.width += n;
            BasicMenuItemUI.r.width += BasicMenuItemUI.arrowIconRect.width;
        }
        BasicMenuItemUI.r.width += 2 * n;
        serializable = jMenuItem.getInsets();
        if (serializable != null) {
            BasicMenuItemUI.r.width += ((Insets)serializable).left + ((Insets)serializable).right;
            BasicMenuItemUI.r.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (BasicMenuItemUI.r.width % 2 == 0) {
            ++BasicMenuItemUI.r.width;
        }
        if (BasicMenuItemUI.r.height % 2 == 0) {
            ++BasicMenuItemUI.r.height;
        }
        return r.getSize();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        Object object;
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n2 = jMenuItem.getWidth();
        int n3 = jMenuItem.getHeight();
        Insets insets = jComponent.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n2, n3);
        BasicMenuItemUI.viewRect.x += insets.left;
        BasicMenuItemUI.viewRect.y += insets.top;
        BasicMenuItemUI.viewRect.width -= insets.right + BasicMenuItemUI.viewRect.x;
        BasicMenuItemUI.viewRect.height -= insets.bottom + BasicMenuItemUI.viewRect.y;
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.acceleratorFont);
        Color color3 = graphics.getColor();
        if (jComponent.isOpaque()) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n2, n3);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n2, n3);
            }
            graphics.setColor(color3);
        }
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n4 = keyStroke.getModifiers();
            if (n4 > 0) {
                string = KeyEvent.getKeyModifiersText(n4);
                string = string + this.acceleratorDelimiter;
            }
            string = string + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        String string2 = this.layoutMenuItem(fontMetrics, jMenuItem.getText(), fontMetrics2, string, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n, n);
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color3);
            }
            if (this.useCheckAndArrow()) {
                icon.paintIcon(jComponent, graphics, BasicMenuItemUI.checkIconRect.x, BasicMenuItemUI.checkIconRect.y);
            }
            graphics.setColor(color3);
        }
        if (jMenuItem.getIcon() != null) {
            if (!buttonModel.isEnabled()) {
                object = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                object = jMenuItem.getPressedIcon();
                if (object == null) {
                    object = jMenuItem.getIcon();
                }
            } else {
                object = jMenuItem.getIcon();
            }
            if (object != null) {
                object.paintIcon(jComponent, graphics, BasicMenuItemUI.iconRect.x, BasicMenuItemUI.iconRect.y);
            }
        }
        if (string2 != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, textRect);
            } else if (!buttonModel.isEnabled()) {
                if (this.disfg instanceof Color) {
                    graphics.setColor(this.disfg);
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x, BasicMenuItemUI.textRect.y + fontMetrics.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x, BasicMenuItemUI.textRect.y + fontMetrics.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x - 1, BasicMenuItemUI.textRect.y + fontMetrics.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(color3);
                }
                BasicGraphicsUtils.drawString(graphics, string2, buttonModel.getMnemonic(), BasicMenuItemUI.textRect.x, BasicMenuItemUI.textRect.y + fontMetrics.getAscent());
            }
        }
        if (string != null && !string.equals("")) {
            int n5 = 0;
            Container container = this.menuItem.getParent();
            if (container != null && container instanceof JComponent) {
                JComponent jComponent2 = (JComponent)container;
                Integer n6 = (Integer)jComponent2.getClientProperty(MAX_ACC_WIDTH);
                int n7 = n6 != null ? n6 : 0;
                n5 = n7 - BasicMenuItemUI.acceleratorRect.width;
            }
            graphics.setFont(this.acceleratorFont);
            if (!buttonModel.isEnabled()) {
                if (this.disabledForeground != null) {
                    graphics.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x - n5, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                } else {
                    graphics.setColor(jMenuItem.getBackground().brighter());
                    BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x - n5, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
                    graphics.setColor(jMenuItem.getBackground().darker());
                    BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x - n5 - 1, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent() - 1);
                }
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(this.acceleratorSelectionForeground);
                } else {
                    graphics.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(graphics, string, 0, BasicMenuItemUI.acceleratorRect.x - n5, BasicMenuItemUI.acceleratorRect.y + fontMetrics2.getAscent());
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (this.useCheckAndArrow()) {
                icon2.paintIcon(jComponent, graphics, BasicMenuItemUI.arrowIconRect.x, BasicMenuItemUI.arrowIconRect.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    private String layoutMenuItem(FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics2, string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        if (BasicGraphicsUtils.isLeftToRight(this.menuItem)) {
            rectangle3.x += n6;
            rectangle2.x += n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + n6;
                rectangle3.x += n6 + rectangle5.width;
                rectangle2.x += n6 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n6;
            rectangle2.x -= n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + rectangle.width - n6 - rectangle5.width;
                rectangle3.x -= n6 + rectangle5.width;
                rectangle2.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (this.useCheckAndArrow()) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private boolean useCheckAndArrow() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public MenuElement[] getPath() {
        MenuElement[] menuElementArray;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
        int n = menuElementArray2.length;
        if (n == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (menuElementArray2[n - 1].getComponent() == container) {
            menuElementArray = new MenuElement[n + 1];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n);
            menuElementArray[n] = this.menuItem;
        } else {
            int n2 = menuElementArray2.length - 1;
            while (n2 >= 0) {
                if (menuElementArray2[n2].getComponent() == container) break;
                --n2;
            }
            menuElementArray = new MenuElement[n2 + 2];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, n2 + 1);
            menuElementArray[n2 + 1] = this.menuItem;
        }
        return menuElementArray;
    }

    void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = 0;
        int n2 = menuElementArray.length;
        while (n < n2) {
            int n3 = 0;
            while (n3 <= n) {
                System.out.print("  ");
                ++n3;
            }
            MenuElement menuElement = menuElementArray[n];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
            } else if (menuElement == null) {
                System.out.println("NULL , ");
            } else {
                System.out.println("" + menuElement + ", ");
            }
            ++n;
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        int n3 = menuElementArray.length;
        while (n2 < n3) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        while (n2 >= 0) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            --n2;
        }
        return null;
    }

    private static class SelectChildItemAction
    extends AbstractAction {
        private SelectChildItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (!jMenuItem.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1].getComponent().isEnabled() && menuElementArray[menuElementArray.length - 1].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                menuElementArray2[menuElementArray.length] = ((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).getPopupMenu();
                MenuElement[] menuElementArray3 = menuElementArray2[menuElementArray.length].getSubElements();
                if (menuElementArray3.length > 0) {
                    menuElementArray2[menuElementArray.length + 1] = BasicMenuItemUI.nextEnabledChild(menuElementArray3, 0);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                }
            } else if (menuElementArray.length == 2 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 2];
                MenuElement[] menuElementArray4 = menuElement.getSubElements();
                MenuElement[] menuElementArray5 = menuElementArray;
                int n = 0;
                int n2 = menuElementArray4.length;
                while (n < n2) {
                    if (menuElementArray4[n] == menuElementArray5[menuElementArray5.length - 1]) {
                        MenuElement menuElement2 = BasicMenuItemUI.nextEnabledChild(menuElementArray4, n + 1);
                        if (menuElement2 == null) {
                            menuElement2 = BasicMenuItemUI.nextEnabledChild(menuElementArray4, 0);
                        }
                        if (menuElement2 != null) {
                            menuElementArray5[menuElementArray5.length - 1] = menuElement2;
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                        }
                        break;
                    }
                    ++n;
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray6;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement3 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray6 = menuElementArray[0].getSubElements();
                    int n = 0;
                    int n3 = menuElementArray6.length;
                    while (n < n3) {
                        if (menuElementArray6[n] == menuElementArray[1] && (menuElement = BasicMenuItemUI.nextEnabledChild(menuElementArray6, n + 1)) == null) {
                            menuElement = BasicMenuItemUI.nextEnabledChild(menuElementArray6, 0);
                        }
                        ++n;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement3 = null;
                    } else {
                        menuElementArray6 = jPopupMenu.getSubElements();
                        if (menuElementArray6.length > 0) {
                            menuElement3 = BasicMenuItemUI.nextEnabledChild(menuElementArray6, 0);
                        }
                    }
                    MenuElement[] menuElementArray7 = menuElement3 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement3} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray7);
                }
            }
        }
    }

    private static class SelectParentItemAction
    extends AbstractAction {
        private SelectParentItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (!jMenuItem.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 3 && menuElementArray[menuElementArray.length - 3].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 3].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else if (menuElementArray.length == 2 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 2];
                MenuElement[] menuElementArray3 = menuElement.getSubElements();
                MenuElement[] menuElementArray4 = menuElementArray;
                int n = 0;
                int n2 = menuElementArray3.length;
                while (n < n2) {
                    if (menuElementArray3[n] == menuElementArray4[menuElementArray4.length - 1]) {
                        MenuElement menuElement2 = BasicMenuItemUI.previousEnabledChild(menuElementArray3, n - 1);
                        if (menuElement2 == null) {
                            menuElement2 = BasicMenuItemUI.previousEnabledChild(menuElementArray3, menuElementArray3.length - 1);
                        }
                        if (menuElement2 != null) {
                            menuElementArray4[menuElementArray4.length - 1] = menuElement2;
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                        }
                        break;
                    }
                    ++n;
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray5;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement3 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray5 = menuElementArray[0].getSubElements();
                    int n = 0;
                    int n3 = menuElementArray5.length;
                    while (n < n3) {
                        if (menuElementArray5[n] == menuElementArray[1] && (menuElement = BasicMenuItemUI.previousEnabledChild(menuElementArray5, n - 1)) == null) {
                            menuElement = BasicMenuItemUI.previousEnabledChild(menuElementArray5, menuElementArray5.length - 1);
                        }
                        ++n;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement3 = null;
                    } else {
                        menuElementArray5 = jPopupMenu.getSubElements();
                        if (menuElementArray5.length > 0) {
                            menuElement3 = BasicMenuItemUI.nextEnabledChild(menuElementArray5, 0);
                        }
                    }
                    MenuElement[] menuElementArray6 = menuElement3 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement3} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray6);
                }
            }
        }
    }

    private static class SelectPreviousItemAction
    extends AbstractAction {
        private SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block13: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block14: {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    if (!jMenuItem.isEnabled()) {
                        return;
                    }
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block13;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block14;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block13;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = BasicMenuItemUI.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                    if (menuElementArray3[menuElementArray.length] == null) break block13;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block13;
                }
                if (menuElementArray.length == 2 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                    MenuElement[] menuElementArray4;
                    MenuElement menuElement2 = null;
                    JPopupMenu jPopupMenu = null;
                    MenuElement menuElement3 = null;
                    MenuElement[] menuElementArray5 = menuElementArray;
                    if (menuElementArray5.length > 1) {
                        menuElementArray4 = menuElementArray5[0].getSubElements();
                        int n = 0;
                        int n2 = menuElementArray4.length;
                        while (n < n2) {
                            if (menuElementArray4[n] == menuElementArray5[1] && (menuElement2 = BasicMenuItemUI.previousEnabledChild(menuElementArray4, n - 1)) == null) {
                                menuElement2 = BasicMenuItemUI.previousEnabledChild(menuElementArray4, menuElementArray4.length - 1);
                            }
                            ++n;
                        }
                    }
                    if (menuElement2 != null) {
                        jPopupMenu = ((JMenu)menuElement2).getPopupMenu();
                        if (((JMenu)menuElement2).isTopLevelMenu()) {
                            menuElement3 = null;
                        } else {
                            menuElementArray4 = jPopupMenu.getSubElements();
                            if (menuElementArray4.length > 0) {
                                menuElement3 = BasicMenuItemUI.nextEnabledChild(menuElementArray4, 0);
                            }
                        }
                        MenuElement[] menuElementArray6 = menuElement3 != null ? new MenuElement[]{menuElementArray5[0], menuElement2, jPopupMenu, menuElement3} : new MenuElement[]{menuElementArray5[0], menuElement2, jPopupMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray6);
                    }
                } else {
                    MenuElement[] menuElementArray7 = menuElement.getSubElements();
                    int n = 0;
                    int n3 = menuElementArray7.length;
                    while (n < n3) {
                        if (menuElementArray7[n] == menuElementArray[menuElementArray.length - 1]) {
                            MenuElement menuElement4 = BasicMenuItemUI.previousEnabledChild(menuElementArray7, n - 1);
                            if (menuElement4 == null) {
                                menuElement4 = BasicMenuItemUI.previousEnabledChild(menuElementArray7, menuElementArray7.length - 1);
                            }
                            if (menuElement4 == null) break;
                            menuElementArray[menuElementArray.length - 1] = menuElement4;
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        private SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block10: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block11: {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    if (!jMenuItem.isEnabled()) {
                        return;
                    }
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block10;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block11;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block10;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = BasicMenuItemUI.nextEnabledChild(menuElementArray2, 0);
                    if (menuElementArray3[menuElementArray.length] == null) break block10;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block10;
                }
                if (menuElementArray.length == 2 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                    MenuElement menuElement2 = null;
                    JPopupMenu jPopupMenu = null;
                    MenuElement menuElement3 = null;
                    MenuElement[] menuElementArray4 = menuElementArray;
                    if (menuElementArray4.length > 1) {
                        menuElement2 = menuElementArray4[1];
                    }
                    if (menuElement2 != null) {
                        jPopupMenu = ((JMenu)menuElement2).getPopupMenu();
                        int n = 0;
                        while (n < jPopupMenu.getComponentCount()) {
                            Component component = jPopupMenu.getComponent(n);
                            if (component != null && component.isEnabled()) {
                                menuElement3 = (MenuElement)((Object)component);
                                break;
                            }
                            ++n;
                        }
                        MenuElement[] menuElementArray5 = menuElement3 != null ? new MenuElement[]{menuElementArray4[0], menuElement2, jPopupMenu, menuElement3} : new MenuElement[]{menuElementArray4[0], menuElement2, jPopupMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                    }
                } else {
                    MenuElement[] menuElementArray6 = menuElement.getSubElements();
                    int n = 0;
                    int n2 = menuElementArray6.length;
                    while (n < n2) {
                        if (menuElementArray6[n] == menuElementArray[menuElementArray.length - 1]) {
                            MenuElement menuElement4 = BasicMenuItemUI.nextEnabledChild(menuElementArray6, n + 1);
                            if (menuElement4 == null) {
                                menuElement4 = BasicMenuItemUI.nextEnabledChild(menuElementArray6, 0);
                            }
                            if (menuElement4 == null) break;
                            menuElementArray[menuElementArray.length - 1] = menuElement4;
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
    }

    private class ReturnAction
    extends AbstractAction {
        private ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (!jMenuItem.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ((JMenuItem)menuElement).doClick(0);
                    ((JMenuItem)menuElement).setArmed(false);
                }
            }
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (!jMenuItem.isEnabled()) {
                return;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        public JMenuItem menu;
        public BasicMenuItemUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenuItem jMenuItem, BasicMenuItemUI basicMenuItemUI2) {
            this.menu = jMenuItem;
            this.ui = basicMenuItemUI2;
            this.validateKeyboardActions(this.menu.isSelected() || this.menu.isArmed());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.validateKeyboardActions(this.menu.isSelected() || this.menu.isArmed());
        }

        private Component findFocusedComponent(Component component) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof Window) {
                    return ((Window)container).getFocusOwner();
                }
                container = container.getParent();
            }
            return null;
        }

        private void validateKeyboardActions(boolean bl) {
            if (bl != this.isSelected) {
                this.isSelected = bl;
                if (this.isSelected) {
                    boolean bl2 = this.menu.isRequestFocusEnabled();
                    this.wasFocused = this.findFocusedComponent(this.menu);
                    if (this.wasFocused instanceof JComponent && ((JComponent)this.wasFocused).getRootPane() != this.menu.getRootPane()) {
                        this.wasFocused = null;
                    }
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(true);
                    }
                    this.menu.requestFocus();
                    if (!bl2) {
                        this.menu.setRequestFocusEnabled(false);
                    }
                    if (BasicMenuItemUI.this.selectedWindowInputMap == null && BasicMenuItemUI.this.bindings != null) {
                        BasicMenuItemUI.this.selectedWindowInputMap = LookAndFeel.makeComponentInputMap(BasicMenuItemUI.this.menuItem, BasicMenuItemUI.this.bindings);
                    }
                    if (BasicMenuItemUI.this.windowInputMap == null) {
                        BasicMenuItemUI.this.windowInputMap = BasicMenuItemUI.this.createInputMap(2);
                        SwingUtilities.replaceUIInputMap(BasicMenuItemUI.this.menuItem, 2, BasicMenuItemUI.this.windowInputMap);
                    }
                    if (BasicMenuItemUI.this.windowInputMap != null && BasicMenuItemUI.this.selectedWindowInputMap != null) {
                        BasicMenuItemUI.this.windowInputMap.setParent(BasicMenuItemUI.this.selectedWindowInputMap);
                    }
                } else {
                    if (BasicMenuItemUI.this.windowInputMap != null && BasicMenuItemUI.this.selectedWindowInputMap != null) {
                        BasicMenuItemUI.this.windowInputMap.setParent(null);
                    }
                    if (this.wasFocused != null) {
                        if (this.wasFocused instanceof JComponent) {
                            JComponent jComponent = (JComponent)this.wasFocused;
                            boolean bl3 = jComponent.isRequestFocusEnabled();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(true);
                            }
                            this.wasFocused.requestFocus();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(false);
                            }
                        } else {
                            this.wasFocused.requestFocus();
                        }
                        this.wasFocused = null;
                    }
                }
            }
        }
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            jMenuItem.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                BasicMenuItemUI.this.updateAcceleratorBinding();
            } else if (string.equals("text")) {
                JMenuItem jMenuItem = (JMenuItem)propertyChangeEvent.getSource();
                String string2 = jMenuItem.getText();
                BasicHTML.updateRenderer(jMenuItem, string2);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            int n = BasicMenuItemUI.this.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            if (this.lower(n) == this.lower(menuKeyEvent.getKeyChar())) {
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                menuSelectionManager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick(0);
                menuKeyEvent.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private int lower(int n) {
            if (n >= 65 && n <= 90) {
                return n + 97 - 65;
            }
            return n;
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                menuSelectionManager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick(0);
            } else {
                menuSelectionManager.clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.x < BasicMenuItemUI.this.menuItem.getWidth() && point.y >= 0 && point.y < BasicMenuItemUI.this.menuItem.getHeight()) {
                menuSelectionManager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick(0);
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                menuSelectionManager.setSelectedPath(BasicMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            int n = mouseEvent.getModifiers();
            if ((n & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n2 = 0;
                    int n3 = menuElementArray.length - 1;
                    while (n2 < n3) {
                        menuElementArray2[n2] = menuElementArray[n2];
                        ++n2;
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

