/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.basic.ComplexWrappedAreaView;
import javax.swing.plaf.basic.TabLayout;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sun.awt.font.Bidi;

class ComplexAreaView
extends View {
    TabLayout.FixedTabs tabs = new TabLayout.FixedTabs();
    float lx;
    float ly;
    boolean ltr;
    int lpos;
    Font cacheFont;
    FontRenderContext cacheFRC;
    float cacheTabWidth;
    boolean defaultIsLTR;
    boolean contextual;
    HashMap layoutCache = new HashMap(11);
    private final Segment lineBuffer = new Segment();
    float cacheLongWidth;
    Element cacheLongElement;
    int lineAscent = -1;
    int lineHeight = -1;
    static final float HPAD = 4.0f;
    private static final FontRenderContext defaultFRC = new FontRenderContext(null, false, false);

    ComplexAreaView(Element element) {
        super(element);
        this.defaultIsLTR = !Boolean.FALSE.equals(this.getDocument().getProperty("ltr orientation"));
        this.contextual = Boolean.TRUE.equals(this.getDocument().getProperty("contextual line direction"));
    }

    int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    TabLayout createLayout(Element element) {
        Document document = this.getDocument();
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        n2 = Math.min(n2, document.getLength());
        boolean bl = false;
        boolean bl2 = this.defaultIsLTR;
        if (this.contextual) {
            try {
                document.getText(n, n2 - n, this.lineBuffer);
                bl2 = Bidi.defaultIsLTR(this.lineBuffer.array, this.lineBuffer.offset, this.lineBuffer.offset + this.lineBuffer.count, this.defaultIsLTR);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        HashMap hashMap = new HashMap();
        hashMap.put(TextAttribute.FONT, this.cacheFont);
        hashMap.put(TextAttribute.RUN_DIRECTION, bl2 ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL);
        AttributedCharacterIterator attributedCharacterIterator = ComplexWrappedAreaView.getElementACI(element, hashMap);
        return TabLayout.create(attributedCharacterIterator, this.cacheFRC);
    }

    TabLayout getLayout(Element element) {
        TabLayout tabLayout = (TabLayout)this.layoutCache.get(element);
        if (tabLayout == null) {
            tabLayout = this.createLayout(element);
            this.layoutCache.put(element, tabLayout);
        }
        return tabLayout;
    }

    void clearLayoutCache() {
        this.layoutCache.clear();
    }

    void putLayoutCache(Element element, TabLayout tabLayout) {
        this.layoutCache.put(element, tabLayout);
    }

    void removeLayoutCache(Element element) {
        this.layoutCache.remove(element);
    }

    TabLayout getLayoutInfo(Element element) {
        TabLayout tabLayout = this.getLayout(element);
        this.lpos = element.getStartOffset();
        this.lx = 0.0f;
        this.ly = this.lineAscent;
        this.tabs.tabBase = 0.0f;
        this.tabs.tabWidth = tabLayout.isLeftToRight() ? this.cacheTabWidth : -this.cacheTabWidth;
        return tabLayout;
    }

    float getLayoutWidth(Element element) {
        TabLayout tabLayout = this.getLayoutInfo(element);
        return Math.abs(tabLayout.getAdvance(this.lx, this.ly, this.tabs));
    }

    TabLayout getLayoutInfo(int n, Rectangle2D rectangle2D) {
        Element element = this.getElement().getElement(n);
        TabLayout tabLayout = this.getLayoutInfo(element);
        if (rectangle2D != null) {
            this.lx = tabLayout.isLeftToRight() ? (float)rectangle2D.getX() : (float)(rectangle2D.getX() + rectangle2D.getWidth());
            this.tabs.tabBase = this.lx;
            this.ly = n * this.lineHeight + this.lineAscent;
        }
        return tabLayout;
    }

    void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (font != this.cacheFont) {
            this.cacheFont = font;
            Graphics graphics = container.getGraphics();
            this.cacheFRC = graphics == null ? defaultFRC : ((Graphics2D)graphics).getFontRenderContext();
            this.cacheTabWidth = (float)((double)this.getTabSize() * this.cacheFont.getStringBounds("m", this.cacheFRC).getWidth());
            FontMetrics fontMetrics = container.getFontMetrics(this.cacheFont);
            this.lineHeight = fontMetrics.getHeight();
            this.lineAscent = fontMetrics.getAscent();
            this.clearLayoutCache();
            this.recomputeLongElement();
        }
    }

    void recomputeLongElement() {
        this.cacheLongElement = null;
        this.cacheLongWidth = -1.0f;
        Element element = this.getElement();
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = element.getElement(n2);
            float f = this.getLayoutWidth(element2);
            if (f > this.cacheLongWidth) {
                this.cacheLongWidth = f;
                this.cacheLongElement = element2;
            }
            ++n2;
        }
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                return this.cacheLongWidth + 8.0f;
            }
            case 1: {
                int n2 = this.getElement().getElementCount();
                return n2 * this.lineHeight;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public void paint(Graphics graphics, Shape shape) {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        boolean bl = n != n2 && jTextComponent.getCaret().isSelectionVisible();
        Color color = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Color color2 = bl ? jTextComponent.getSelectedTextColor() : color;
        boolean bl2 = !color2.equals(color);
        Highlighter highlighter = jTextComponent.getHighlighter();
        LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        Rectangle2D rectangle2D2 = graphics.getClip().getBounds2D();
        float f = (float)(rectangle2D.getMaxY() - rectangle2D2.getMaxY());
        int n3 = Math.max(0, (int)(f / (float)this.lineHeight));
        float f2 = (float)(rectangle2D2.getY() - rectangle2D.getY());
        int n4 = Math.max(0, (int)(f2 / (float)this.lineHeight));
        int n5 = (int)(rectangle2D.getHeight() / (double)this.lineHeight);
        if (rectangle2D.getHeight() > (double)(n5 * this.lineHeight)) {
            ++n5;
        }
        Element element = this.getElement();
        int n6 = element.getElementCount();
        int n7 = Math.min(n6, n5 - n3);
        --n6;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n8 = n4;
        while (n8 < n7) {
            Element element2 = element.getElement(n8);
            int n9 = element2.getStartOffset();
            int n10 = element2.getEndOffset();
            if (layeredHighlighter != null) {
                if (n8 == n6) {
                    layeredHighlighter.paintLayeredHighlights(graphics, n9, n10, shape, jTextComponent, this);
                } else {
                    layeredHighlighter.paintLayeredHighlights(graphics, n9, n10 - 1, shape, jTextComponent, this);
                }
            }
            TabLayout tabLayout = this.getLayoutInfo(n8, rectangle2D);
            if (bl && n <= n9 && n2 >= n10) {
                graphics2D.setColor(color2);
                tabLayout.draw(graphics2D, this.lx, this.ly, this.tabs);
            } else {
                graphics2D.setColor(color);
                tabLayout.draw(graphics2D, this.lx, this.ly, this.tabs);
                if (bl2 && (n < n10 || n2 > n9)) {
                    Shape shape3 = graphics2D.getClip();
                    graphics2D.setClip(tabLayout.getLogicalHighlightShape(this.lx, this.ly, this.tabs, n - n9, n2 - n9, rectangle2D));
                    graphics2D.setColor(color2);
                    tabLayout.draw(graphics2D, this.lx, this.ly, this.tabs);
                    graphics2D.setClip(shape3);
                }
            }
            ++n8;
        }
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        boolean bl = bias != Position.Bias.Backward;
        Element element = this.getElement();
        int n3 = element.getElementCount();
        int n4 = element.getElementIndex(n);
        switch (n2) {
            case 1: 
            case 5: {
                int n5;
                TextHitInfo textHitInfo;
                int n6;
                Object object;
                Point point;
                if ((n2 != 1 || n4 <= 0) && (n2 != 5 || n4 >= n3 - 1)) break;
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                Caret caret = jTextComponent.getCaret();
                Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
                if (point == null) {
                    TabLayout tabLayout = this.getLayoutInfo(n4, rectangle2D);
                    object = bl ? TextHitInfo.afterOffset(n - this.lpos) : TextHitInfo.beforeOffset(n - this.lpos);
                    float f = tabLayout.position(this.lx, this.ly, this.tabs, (TextHitInfo)object);
                    point = new Point((int)f, (int)this.ly);
                }
                if ((n6 = (textHitInfo = ((TabLayout)(object = this.getLayoutInfo(n5 = n2 == 1 ? n4 - 1 : n4 + 1, rectangle2D))).hitTest(this.lx, this.ly, this.tabs, point.x, this.ly)).getInsertionIndex()) == ((TabLayout)object).getCharacterCount()) {
                    bl = true;
                    n = this.lpos + n6 - 1;
                    break;
                }
                bl = textHitInfo.isLeadingEdge();
                n = this.lpos + n6;
                break;
            }
            case 3: 
            case 7: {
                TabLayout tabLayout = this.getLayoutInfo(n4, rectangle2D);
                TextHitInfo textHitInfo = bl ? TextHitInfo.afterOffset(n - this.lpos) : TextHitInfo.beforeOffset(n - this.lpos);
                textHitInfo = tabLayout.getNextHit(textHitInfo, n2 == 3);
                if (textHitInfo == null || textHitInfo.getInsertionIndex() == tabLayout.getCharacterCount()) {
                    if (tabLayout.isLeftToRight() == (n2 == 3)) {
                        if (n4 >= n3 - 1) break;
                        bl = false;
                        n = this.lpos + tabLayout.getCharacterCount();
                        break;
                    }
                    if (n4 <= 0) break;
                    n = this.lpos - 1;
                    bl = true;
                    break;
                }
                n = this.lpos + textHitInfo.getInsertionIndex();
                bl = textHitInfo.isLeadingEdge();
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        biasArray[0] = bl ? Position.Bias.Forward : Position.Bias.Backward;
        return n;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        TabLayout tabLayout = this.getLayoutInfo(n2, rectangle2D);
        boolean bl = bias != Position.Bias.Backward;
        TextHitInfo textHitInfo = bl ? TextHitInfo.afterOffset(n - this.lpos) : TextHitInfo.beforeOffset(n - this.lpos);
        float f = tabLayout.position(this.lx, this.ly, this.tabs, textHitInfo);
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, this.ly - (float)this.lineAscent, 1.0f, this.lineHeight);
        return float_;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)rectangle2D.getX(), 0.0f, (float)rectangle2D.getWidth(), this.lineHeight);
        Element element = this.getElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2);
        if (n3 == n4) {
            TabLayout tabLayout = this.getLayoutInfo(n3, rectangle2D);
            float_.y = this.ly - (float)this.lineAscent;
            return tabLayout.getLogicalHighlightShape(this.lx, this.ly, this.tabs, n - this.lpos, n2 - this.lpos, float_);
        }
        TabLayout tabLayout = this.getLayoutInfo(n3, rectangle2D);
        float_.y = this.ly - (float)this.lineAscent;
        Shape shape3 = tabLayout.getLogicalHighlightShape(this.lx, this.ly, this.tabs, n - this.lpos, n2 - this.lpos, float_);
        float f = float_.y + (float)this.lineHeight;
        TabLayout tabLayout2 = this.getLayoutInfo(n4, rectangle2D);
        float_.y = this.ly - (float)this.lineAscent;
        Shape shape4 = tabLayout2.getLogicalHighlightShape(this.lx, this.ly, this.tabs, n - this.lpos, n2 - this.lpos, float_);
        GeneralPath generalPath = new GeneralPath(shape3);
        generalPath.append(shape4, false);
        if (n3 < n4 - 1) {
            float_.height = float_.y - f;
            float_.y = f;
            generalPath.append(float_, false);
        }
        return generalPath;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        int n = this.getElement().getElementCount();
        int n2 = (int)Math.floor(((double)f2 - rectangle2D.getY()) / (double)this.lineHeight);
        if (n2 < 0) {
            biasArray[0] = Position.Bias.Backward;
            return this.getStartOffset();
        }
        if (n2 >= n) {
            biasArray[0] = Position.Bias.Forward;
            return this.getEndOffset() - 1;
        }
        TabLayout tabLayout = this.getLayoutInfo(n2, rectangle2D);
        TextHitInfo textHitInfo = tabLayout.hitTest(this.lx, this.ly, this.tabs, f, f2);
        int n3 = textHitInfo.getInsertionIndex();
        if (n3 == tabLayout.getCharacterCount()) {
            biasArray[0] = Position.Bias.Forward;
            return this.lpos + n3 - 1;
        }
        biasArray[0] = textHitInfo.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        return this.lpos + n3;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.insertUpdate(documentEvent, shape2, viewFactory);
        this.updateDamage(documentEvent, shape2, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.removeUpdate(documentEvent, shape2, viewFactory);
        this.updateDamage(documentEvent, shape2, viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.changedUpdate(documentEvent, shape2, viewFactory);
        this.updateDamage(documentEvent, shape2, viewFactory);
    }

    void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container = this.getContainer();
        if (container.isShowing()) {
            Element[] elementArray;
            this.updateMetrics();
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
            Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
            if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
                int n;
                boolean bl = elementArray2.length != elementArray.length;
                boolean bl2 = false;
                if (elementArray2 != null) {
                    n = 0;
                    while (n < elementArray2.length) {
                        float f = this.getLayoutWidth(elementArray2[n]);
                        if (f > this.cacheLongWidth) {
                            this.cacheLongWidth = f;
                            this.cacheLongElement = elementArray2[n];
                            bl2 = true;
                        }
                        ++n;
                    }
                }
                if (elementArray != null) {
                    n = 0;
                    while (n < elementArray.length) {
                        this.removeLayoutCache(elementArray[n]);
                        if (elementArray[n] == this.cacheLongElement) {
                            this.recomputeLongElement();
                            bl2 = true;
                        }
                        ++n;
                    }
                }
                this.preferenceChanged(null, bl2, bl);
                container.repaint();
            } else {
                int n = element.getElementIndex(documentEvent.getOffset());
                Element element2 = element.getElement(n);
                this.putLayoutCache(element2, this.createLayout(element2));
                if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                    float f = this.getLayoutWidth(element2);
                    if (element2 == this.cacheLongElement) {
                        this.cacheLongWidth = f;
                        this.preferenceChanged(null, true, false);
                    } else if (f > this.cacheLongWidth) {
                        this.cacheLongWidth = f;
                        this.cacheLongElement = element2;
                        this.preferenceChanged(null, true, false);
                    }
                } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2 == this.cacheLongElement) {
                    this.recomputeLongElement();
                    this.preferenceChanged(null, true, false);
                }
                if (shape != null) {
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    float f = (float)(rectangle2D.getY() + (double)(n * this.lineHeight));
                    container.repaint((int)rectangle2D.getX(), (int)f, (int)Math.ceil(rectangle2D.getMaxX()), (int)Math.ceil(f + (float)this.lineHeight));
                }
            }
        }
    }

    protected Shape adjustAllocation(Shape shape) {
        if (shape != null) {
            Rectangle rectangle = shape.getBounds();
            rectangle.x = (int)((float)rectangle.x + 4.0f);
            rectangle.width = (int)((float)rectangle.width - 8.0f);
            return rectangle;
        }
        return shape;
    }
}

