/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.basic.MultiACI;
import javax.swing.plaf.basic.TabLayout;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sun.awt.font.Bidi;

class ComplexWrappedAreaView
extends View {
    TabLayout.FixedTabs tLineTabs = new TabLayout.FixedTabs();
    float tLinex;
    float tLiney;
    int tLinePos;
    int tParaLineIndex;
    Font cacheFont;
    FontRenderContext cacheFRC;
    float cacheTabWidth;
    float width;
    boolean contextual;
    boolean defaultIsLTR;
    boolean wordWrap;
    HashMap paragraphCache = new HashMap(11);
    private final Segment lineBuffer = new Segment();
    int lineAscent = -1;
    int lineHeight = -1;
    int lineCount = -1;
    static final float HPAD = 4.0f;
    private static final FontRenderContext defaultFRC = new FontRenderContext(null, false, false);

    ComplexWrappedAreaView(Element element, boolean bl) {
        super(element);
        this.wordWrap = bl;
        this.defaultIsLTR = !Boolean.FALSE.equals(this.getDocument().getProperty("ltr orientation"));
        this.contextual = Boolean.TRUE.equals(this.getDocument().getProperty("contextual line direction"));
    }

    int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    Paragraph getParagraph(Element element) {
        Paragraph paragraph = (Paragraph)this.paragraphCache.get(element);
        if (paragraph == null) {
            paragraph = this.createParagraph(element);
            this.paragraphCache.put(element, paragraph);
        }
        return paragraph;
    }

    void clearParagraphCache() {
        this.paragraphCache.clear();
    }

    void putParagraphCache(Element element, Paragraph paragraph) {
        this.paragraphCache.put(element, paragraph);
    }

    void removeParagraphCache(Element element) {
        this.paragraphCache.remove(element);
    }

    char[] getParagraphText(Element element) {
        Document document = this.getDocument();
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        int n3 = document.getLength();
        n2 = Math.min(n2, n3);
        int n4 = n2 - n;
        char[] cArray = null;
        try {
            if (n2 == n3) {
                ++n4;
            }
            cArray = new char[n4];
            if (n2 > n) {
                document.getText(n, n2 - n, this.lineBuffer);
                System.arraycopy(this.lineBuffer.array, this.lineBuffer.offset, cArray, 0, this.lineBuffer.count);
            }
            if (n2 == n3) {
                cArray[n4 - 1] = 10;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return cArray;
    }

    AttributedCharacterIterator getParagraphACI(Element element, char[] cArray, boolean bl) {
        HashMap hashMap = new HashMap();
        if (this.cacheFont == null) {
            System.out.println("cacheFont is null");
            new Exception().printStackTrace();
        }
        hashMap.put(TextAttribute.FONT, this.cacheFont);
        hashMap.put(TextAttribute.RUN_DIRECTION, bl ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL);
        AttributedCharacterIterator attributedCharacterIterator = ComplexWrappedAreaView.getElementACI(element, hashMap);
        return attributedCharacterIterator;
    }

    Paragraph createParagraph(Element element) {
        char[] cArray = this.getParagraphText(element);
        boolean bl = this.contextual ? Bidi.defaultIsLTR(cArray, 0, cArray.length, this.defaultIsLTR) : this.defaultIsLTR;
        AttributedCharacterIterator attributedCharacterIterator = this.getParagraphACI(element, cArray, bl);
        Paragraph paragraph = new Paragraph(element, new TabLayout[0]);
        this.updateLayouts(attributedCharacterIterator, 0, attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex(), 0, paragraph);
        return paragraph;
    }

    DamageInfo updateLayouts(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, int n3, Paragraph paragraph) {
        int n4;
        int n5;
        Object object;
        int n6;
        int n7 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        int n8 = 0;
        char[] cArray = new char[n7];
        int n9 = 0;
        int n10 = attributedCharacterIterator.first();
        while (n10 != 65535) {
            if (n10 == 9) {
                ++n8;
            }
            cArray[n9++] = n10;
            n10 = attributedCharacterIterator.next();
        }
        BreakIterator breakIterator = this.wordWrap ? BreakIterator.getLineInstance() : BreakIterator.getCharacterInstance();
        n10 = n7 - 1;
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, breakIterator, this.cacheFRC);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n11 = n8 == 0 ? n7 : -1;
        float f = this.width - 8.0f;
        if (f < 0.0f) {
            throw new InternalError("wrapWidth < 0");
        }
        float f2 = Math.abs(this.tLineTabs.tabWidth);
        int n12 = 0;
        int n13 = 0;
        while (n13 < paragraph.layouts.length) {
            n6 = paragraph.layouts[n13].getCharacterCount();
            if (n12 + n6 > n) {
                if (!this.wordWrap || n13 <= 0) break;
                n12 -= paragraph.layouts[--n13].getCharacterCount();
                break;
            }
            n12 += n6;
            ++n13;
        }
        lineBreakMeasurer.setPosition(n12);
        n6 = n13;
        int n14 = n12;
        int n15 = n2 - n3;
        while (lineBreakMeasurer.getPosition() != n7) {
            float f3 = 0.0f;
            vector.clear();
            object = null;
            do {
                TextLayout textLayout;
                if (n11 <= (n5 = lineBreakMeasurer.getPosition())) {
                    n11 = n5;
                    while (n11 < n10 && cArray[n11] != '\t') {
                        ++n11;
                    }
                    ++n11;
                }
                if ((textLayout = lineBreakMeasurer.nextLayout(f - f3, n11, vector.size() != 0)) == null) break;
                f3 += textLayout.getAdvance();
                f3 = TabLayout.FixedTabs.gridAway(f3, 0.0f, f2);
                vector.addElement(textLayout);
            } while (f3 < this.width);
            TextLayout[] textLayoutArray = new TextLayout[vector.size()];
            n4 = 0;
            while (n4 < textLayoutArray.length) {
                textLayoutArray[n4] = (TextLayout)vector.elementAt(n4);
                ++n4;
            }
            object = TabLayout.create(textLayoutArray, cArray[lineBreakMeasurer.getPosition() - 1] == '\t');
            if (vector2.size() == 0 && n13 < paragraph.layouts.length && ((TabLayout)object).getCharacterCount() == paragraph.layouts[n13].getCharacterCount() && n12 + ((TabLayout)object).getCharacterCount() <= n) {
                ++n13;
                ++n6;
                n14 = n12 += ((TabLayout)object).getCharacterCount();
                continue;
            }
            vector2.addElement(object);
            if ((n12 += ((TabLayout)object).getCharacterCount()) < n + n2) continue;
            while (n6 < paragraph.layouts.length && n14 + n15 < n12) {
                n14 += paragraph.layouts[n6++].getCharacterCount();
            }
            if (n14 + n15 == n12) break;
        }
        int n16 = n13 + vector2.size() + (paragraph.layouts.length - n6);
        object = new TabLayout[n16];
        n5 = 0;
        int n17 = 0;
        while (n17 < n13) {
            object[n5++] = paragraph.layouts[n17];
            ++n17;
        }
        int n18 = 0;
        while (n18 < vector2.size()) {
            object[n5++] = (TabLayout)vector2.elementAt(n18);
            ++n18;
        }
        n4 = n6;
        while (n4 < paragraph.layouts.length) {
            object[n5++] = paragraph.layouts[n4];
            ++n4;
        }
        paragraph.layouts = object;
        return new DamageInfo(n13, n6 - n13, vector2.size());
    }

    int getLineIndex(int n) {
        Element element = this.getElement();
        int n2 = element.getElementCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Element element2 = element.getElement(n4);
            Paragraph paragraph = this.getParagraph(element2);
            int n5 = paragraph.getCharacterCount();
            if (n < n5) {
                return n3 + paragraph.getLineIndex(n);
            }
            n3 += paragraph.getLineCount();
            n -= n5;
            ++n4;
        }
        return n3;
    }

    Paragraph getParagraphInfoForLine(int n) {
        Element element = this.getElement();
        int n2 = element.getElementCount();
        this.tParaLineIndex = 0;
        int n3 = 0;
        while (n3 < n2) {
            Element element2 = element.getElement(n3);
            Paragraph paragraph = this.getParagraph(element2);
            int n4 = paragraph.getLineCount();
            if (n < this.tParaLineIndex + n4) {
                return paragraph;
            }
            this.tParaLineIndex += n4;
            ++n3;
        }
        return null;
    }

    Paragraph getParagraphInfoForIndex(int n) {
        Element element = this.getElement();
        this.tParaLineIndex = 0;
        int n2 = 0;
        while (n2 < n) {
            Element element2 = element.getElement(n2);
            Paragraph paragraph = this.getParagraph(element2);
            this.tParaLineIndex += paragraph.getLineCount();
            ++n2;
        }
        return this.getParagraph(element.getElement(n));
    }

    TabLayout getLayoutInfo(int n, Rectangle2D rectangle2D) {
        Paragraph paragraph = this.getParagraphInfoForLine(n);
        int n2 = n - this.tParaLineIndex;
        TabLayout tabLayout = paragraph.getLayout(n2);
        this.tLinePos = paragraph.getLinePos(n2);
        this.tLinex = 0.0f;
        this.tLiney = this.lineAscent;
        this.tLineTabs.tabBase = 0.0f;
        float f = this.tLineTabs.tabWidth = tabLayout.isLeftToRight() ? this.cacheTabWidth : -this.cacheTabWidth;
        if (rectangle2D != null) {
            this.tLinex = tabLayout.isLeftToRight() ? (float)rectangle2D.getX() : (float)(rectangle2D.getX() + rectangle2D.getWidth());
            this.tLineTabs.tabBase = this.tLinex;
            this.tLiney = n * this.lineHeight + this.lineAscent;
        }
        return tabLayout;
    }

    static AttributedCharacterIterator getElementACI(Element element, Map map) {
        if (element.isLeaf()) {
            return ComplexWrappedAreaView.getLeafElementACI(element, map);
        }
        int n = element.getElementCount();
        switch (n) {
            case 0: {
                return ComplexWrappedAreaView.getLeafElementACI(element, map);
            }
            case 1: {
                return ComplexWrappedAreaView.getElementACI(element.getElement(0), map);
            }
        }
        int n2 = 0;
        int n3 = element.getEndOffset() - element.getStartOffset();
        AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[n];
        int n4 = 0;
        while (n4 < n) {
            Element element2 = element.getElement(n4);
            attributedCharacterIteratorArray[n4] = ComplexWrappedAreaView.getElementACI(element.getElement(n4), map);
            ++n4;
        }
        return new MultiACI(n2, n3, attributedCharacterIteratorArray);
    }

    static AttributedCharacterIterator getLeafElementACI(Element element, Map map) {
        AttributedString attributedString = null;
        Document document = element.getDocument();
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        int n3 = document.getLength();
        n2 = Math.min(n2, n3);
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
            attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
            if (n2 > n) {
                attributedString.addAttributes(map, 0, n2 - n);
            }
        } else {
            String string = "\n";
            if (n2 != n) {
                try {
                    string = document.getText(n, n2 - n);
                    if (n2 == n3 && string.charAt(string.length() - 1) != '\n') {
                        string = string + "\n";
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            attributedString = new AttributedString(string);
            attributedString.addAttributes(map, 0, string.length());
        }
        return attributedString.getIterator();
    }

    void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (font != this.cacheFont) {
            this.cacheFont = font;
            Graphics graphics = container.getGraphics();
            this.cacheFRC = graphics == null ? defaultFRC : ((Graphics2D)graphics).getFontRenderContext();
            this.cacheTabWidth = (float)((double)this.getTabSize() * this.cacheFont.getStringBounds("m", this.cacheFRC).getWidth());
            FontMetrics fontMetrics = container.getFontMetrics(this.cacheFont);
            this.lineHeight = fontMetrics.getHeight();
            this.lineAscent = fontMetrics.getAscent();
            this.clearParagraphCache();
            if (this.width > 0.0f) {
                this.recomputeLineCount();
            }
            this.preferenceChanged(null, false, true);
        }
    }

    void recomputeLineCount() {
        this.lineCount = 0;
        Element element = this.getElement();
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = element.getElement(n2);
            this.lineCount += this.getParagraph(element2).getLineCount();
            ++n2;
        }
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                return this.width == 0.0f ? 200.0f : this.width;
            }
            case 1: {
                int n2 = this.lineCount < 0 ? this.getElement().getElementCount() : this.lineCount;
                float f = n2 * this.lineHeight;
                return f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public void paint(Graphics graphics, Shape shape) {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        boolean bl = n != n2 && jTextComponent.getCaret().isSelectionVisible();
        Color color = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Color color2 = bl ? jTextComponent.getSelectedTextColor() : color;
        boolean bl2 = !color2.equals(color);
        Highlighter highlighter = jTextComponent.getHighlighter();
        LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        Rectangle2D rectangle2D2 = graphics.getClip().getBounds2D();
        float f = (float)(rectangle2D.getMaxY() - rectangle2D2.getMaxY());
        int n3 = Math.max(0, (int)(f / (float)this.lineHeight));
        float f2 = (float)(rectangle2D2.getY() - rectangle2D.getY());
        int n4 = Math.max(0, (int)(f2 / (float)this.lineHeight));
        int n5 = (int)(rectangle2D.getHeight() / (double)this.lineHeight);
        if (rectangle2D.getHeight() > (double)(n5 * this.lineHeight)) {
            ++n5;
        }
        Element element = this.getElement();
        int n6 = Math.min(this.lineCount, n5 - n3);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n7 = n4;
        while (n7 < n6) {
            TabLayout tabLayout = this.getLayoutInfo(n7, rectangle2D);
            int n8 = this.tLinePos;
            int n9 = n8 + tabLayout.getCharacterCount();
            if (layeredHighlighter != null) {
                if (n7 == this.lineCount - 1) {
                    layeredHighlighter.paintLayeredHighlights(graphics, n8, n9, shape, jTextComponent, this);
                } else {
                    layeredHighlighter.paintLayeredHighlights(graphics, n8, n9 - 1, shape, jTextComponent, this);
                }
            }
            if (bl && n <= n8 && n2 >= n9) {
                graphics2D.setColor(color2);
                tabLayout.draw(graphics2D, this.tLinex, this.tLiney, this.tLineTabs);
            } else {
                graphics2D.setColor(color);
                tabLayout.draw(graphics2D, this.tLinex, this.tLiney, this.tLineTabs);
                if (bl2 && (n < n9 || n2 > n8)) {
                    Shape shape3 = graphics2D.getClip();
                    graphics2D.setClip(tabLayout.getLogicalHighlightShape(this.tLinex, this.tLiney, this.tLineTabs, n - n8, n2 - n8, rectangle2D));
                    graphics2D.setColor(color2);
                    tabLayout.draw(graphics2D, this.tLinex, this.tLiney, this.tLineTabs);
                    graphics2D.setClip(shape3);
                }
            }
            ++n7;
        }
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        boolean bl = bias != Position.Bias.Backward;
        int n3 = this.getLineIndex(n);
        switch (n2) {
            case 1: 
            case 5: {
                int n4;
                TextHitInfo textHitInfo;
                int n5;
                Object object;
                Point point;
                if ((n2 != 1 || n3 <= 0) && (n2 != 5 || n3 >= this.lineCount - 1)) break;
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                Caret caret = jTextComponent.getCaret();
                Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
                if (point == null) {
                    TabLayout tabLayout = this.getLayoutInfo(n3, rectangle2D);
                    object = bl ? TextHitInfo.afterOffset(n - this.tLinePos) : TextHitInfo.beforeOffset(n - this.tLinePos);
                    float f = tabLayout.position(this.tLinex, this.tLiney, this.tLineTabs, (TextHitInfo)object);
                    point = new Point((int)f, (int)this.tLiney);
                }
                if ((n5 = (textHitInfo = ((TabLayout)(object = this.getLayoutInfo(n4 = n2 == 1 ? n3 - 1 : n3 + 1, rectangle2D))).hitTest(this.tLinex, this.tLiney, this.tLineTabs, point.x, this.tLiney)).getInsertionIndex()) == ((TabLayout)object).getCharacterCount()) {
                    bl = true;
                    n = this.tLinePos + n5 - 1;
                    break;
                }
                bl = textHitInfo.isLeadingEdge();
                n = this.tLinePos + n5;
                break;
            }
            case 3: 
            case 7: {
                TabLayout tabLayout = this.getLayoutInfo(n3, rectangle2D);
                TextHitInfo textHitInfo = bl ? TextHitInfo.afterOffset(n - this.tLinePos) : TextHitInfo.beforeOffset(n - this.tLinePos);
                textHitInfo = tabLayout.getNextHit(textHitInfo, n2 == 3);
                if (textHitInfo == null || textHitInfo.getInsertionIndex() == tabLayout.getCharacterCount()) {
                    if (tabLayout.isLeftToRight() == (n2 == 3)) {
                        if (n3 >= this.lineCount - 1) break;
                        bl = false;
                        n = this.tLinePos + tabLayout.getCharacterCount();
                        break;
                    }
                    if (n3 <= 0) break;
                    n = this.tLinePos - 1;
                    bl = true;
                    break;
                }
                n = this.tLinePos + textHitInfo.getInsertionIndex();
                bl = textHitInfo.isLeadingEdge();
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        biasArray[0] = bl ? Position.Bias.Forward : Position.Bias.Backward;
        return n;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        int n2 = this.getLineIndex(n);
        TabLayout tabLayout = this.getLayoutInfo(n2, rectangle2D);
        boolean bl = bias != Position.Bias.Backward;
        TextHitInfo textHitInfo = bl ? TextHitInfo.afterOffset(n - this.tLinePos) : TextHitInfo.beforeOffset(n - this.tLinePos);
        float f = tabLayout.position(this.tLinex, this.tLiney, this.tLineTabs, textHitInfo);
        if ((double)f < rectangle2D.getMinX()) {
            f = (float)rectangle2D.getMinX();
        } else if ((double)f > rectangle2D.getMaxX()) {
            f = (float)rectangle2D.getMaxX();
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, this.tLiney - (float)this.lineAscent, 1.0f, this.lineHeight);
        return float_;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)rectangle2D.getX(), 0.0f, (float)rectangle2D.getWidth(), this.lineHeight);
        int n3 = this.getLineIndex(n);
        int n4 = this.getLineIndex(n2);
        if (n3 == n4) {
            TabLayout tabLayout = this.getLayoutInfo(n3, rectangle2D);
            float_.y = this.tLiney - (float)this.lineAscent;
            return tabLayout.getLogicalHighlightShape(this.tLinex, this.tLiney, this.tLineTabs, n - this.tLinePos, n2 - this.tLinePos, float_);
        }
        TabLayout tabLayout = this.getLayoutInfo(n3, rectangle2D);
        float_.y = this.tLiney - (float)this.lineAscent;
        Shape shape3 = tabLayout.getLogicalHighlightShape(this.tLinex, this.tLiney, this.tLineTabs, n - this.tLinePos, n2 - this.tLinePos, float_);
        float f = float_.y + (float)this.lineHeight;
        TabLayout tabLayout2 = this.getLayoutInfo(n4, rectangle2D);
        float_.y = this.tLiney - (float)this.lineAscent;
        Shape shape4 = tabLayout2.getLogicalHighlightShape(this.tLinex, this.tLiney, this.tLineTabs, n - this.tLinePos, n2 - this.tLinePos, float_);
        GeneralPath generalPath = new GeneralPath(shape3);
        generalPath.append(shape4, false);
        if (n3 < n4 - 1) {
            float_.height = float_.y - f;
            float_.y = f;
            generalPath.append(float_, false);
        }
        return generalPath;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.updateMetrics();
        Shape shape2 = this.adjustAllocation(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        int n = (int)Math.floor(((double)f2 - rectangle2D.getY()) / (double)this.lineHeight);
        if (n < 0) {
            biasArray[0] = Position.Bias.Backward;
            return this.getStartOffset();
        }
        if (n >= this.lineCount) {
            biasArray[0] = Position.Bias.Forward;
            return this.getEndOffset() - 1;
        }
        TabLayout tabLayout = this.getLayoutInfo(n, rectangle2D);
        TextHitInfo textHitInfo = tabLayout.hitTest(this.tLinex, this.tLiney, this.tLineTabs, f, f2);
        int n2 = textHitInfo.getInsertionIndex();
        if (n2 == tabLayout.getCharacterCount()) {
            biasArray[0] = Position.Bias.Forward;
            return this.tLinePos + n2 - 1;
        }
        biasArray[0] = textHitInfo.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        return this.tLinePos + n2;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.insertUpdate(documentEvent, shape2, viewFactory);
        this.updateDamage(documentEvent, shape2, viewFactory, documentEvent.getLength(), 0);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.removeUpdate(documentEvent, shape2, viewFactory);
        this.updateDamage(documentEvent, shape2, viewFactory, 0, documentEvent.getLength());
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.changedUpdate(documentEvent, shape2, viewFactory);
        this.updateDamage(documentEvent, shape2, viewFactory, documentEvent.getLength(), documentEvent.getLength());
    }

    void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory, int n, int n2) {
        Container container = this.getContainer();
        if (container.isShowing() && this.width > 0.0f) {
            Element[] elementArray;
            this.updateMetrics();
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            Rectangle2D rectangle2D = shape != null ? shape.getBounds2D() : null;
            Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
            Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
            if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
                int n3;
                int n4 = 0;
                if (elementArray2 != null) {
                    n3 = 0;
                    while (n3 < elementArray2.length) {
                        n4 += this.getParagraph(elementArray2[n3]).getLineCount();
                        ++n3;
                    }
                }
                n3 = 0;
                if (elementArray != null) {
                    int n5 = 0;
                    while (n5 < elementArray.length) {
                        n3 += this.getParagraph(elementArray[n5]).getLineCount();
                        this.removeParagraphCache(elementArray[n5]);
                        ++n5;
                    }
                }
                this.lineCount += n4 - n3;
                this.preferenceChanged(null, false, n4 != n3);
                container.repaint();
            } else {
                int n6 = element.getElementIndex(documentEvent.getOffset());
                Paragraph paragraph = this.getParagraphInfoForIndex(n6);
                int n7 = documentEvent.getOffset() - paragraph.getPos();
                DamageInfo damageInfo = paragraph.update(n7, n, n2);
                if (damageInfo.linesAdded != damageInfo.linesRemoved) {
                    this.lineCount += damageInfo.linesAdded - damageInfo.linesRemoved;
                    this.preferenceChanged(null, false, true);
                }
                if (rectangle2D != null) {
                    int n8 = this.tParaLineIndex + damageInfo.lineStart;
                    int n9 = damageInfo.linesAdded == damageInfo.linesRemoved ? n8 + damageInfo.linesAdded : this.lineCount;
                    float f = (float)(rectangle2D.getY() + (double)(n8 * this.lineHeight));
                    float f2 = (float)(rectangle2D.getY() + (double)(n9 * this.lineHeight));
                    container.repaint((int)rectangle2D.getX(), (int)f, (int)Math.ceil(rectangle2D.getMaxX()), (int)Math.ceil(f2));
                }
            }
        }
    }

    public void setSize(float f, float f2) {
        if (this.width != f) {
            float f3 = this.width;
            this.width = f;
            if (this.cacheFont == null) {
                this.updateMetrics();
            } else {
                boolean bl = false;
                Element element = this.getElement();
                int n = element.getElementCount();
                int n2 = 0;
                while (n2 < n) {
                    Element element2 = element.getElement(n2);
                    Paragraph paragraph = this.getParagraph(element2);
                    if (paragraph.affectedByWidthChange(f3, f)) {
                        this.removeParagraphCache(element2);
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    int n3 = this.lineCount;
                    this.recomputeLineCount();
                    this.preferenceChanged(null, false, n3 != this.lineCount);
                }
            }
            this.getContainer().invalidate();
        }
    }

    protected Shape adjustAllocation(Shape shape) {
        if (shape != null) {
            Rectangle rectangle = shape.getBounds();
            rectangle.x = (int)((float)rectangle.x + 4.0f);
            rectangle.width = (int)((float)rectangle.width - 8.0f);
            return rectangle;
        }
        return shape;
    }

    class Paragraph {
        Element elem;
        TabLayout[] layouts;
        int cc;

        Paragraph(Element element, TabLayout[] tabLayoutArray) {
            this.elem = element;
            this.layouts = tabLayoutArray;
            this.cc = element.getEndOffset() - element.getStartOffset();
        }

        int getLineCount() {
            return this.layouts.length;
        }

        TabLayout getLayout(int n) {
            return this.layouts[n];
        }

        int getPos() {
            return this.elem.getStartOffset();
        }

        int getLinePos(int n) {
            int n2 = this.elem.getStartOffset();
            int n3 = 0;
            while (n3 < n) {
                n2 += this.layouts[n3].getCharacterCount();
                ++n3;
            }
            return n2;
        }

        int getCharacterCount() {
            return this.cc;
        }

        boolean affectedByWidthChange(float f, float f2) {
            if (this.layouts.length > 1) {
                return true;
            }
            TabLayout tabLayout = this.layouts[0];
            if (tabLayout.isLeftToRight() != ComplexWrappedAreaView.this.tLineTabs.tabWidth >= 0.0f) {
                ComplexWrappedAreaView.this.tLineTabs.tabWidth = -ComplexWrappedAreaView.this.tLineTabs.tabWidth;
            }
            return Math.abs(tabLayout.getAdvance(0.0f, 0.0f, ComplexWrappedAreaView.this.tLineTabs)) > f2;
        }

        int getLineIndex(int n) {
            int n2 = 0;
            while (n2 < this.layouts.length) {
                int n3 = this.layouts[n2].getCharacterCount();
                if (n < n3) {
                    return n2;
                }
                n -= n3;
                ++n2;
            }
            return this.layouts.length;
        }

        DamageInfo update(int n, int n2, int n3) {
            char[] cArray = ComplexWrappedAreaView.this.getParagraphText(this.elem);
            boolean bl = ComplexWrappedAreaView.this.contextual ? Bidi.defaultIsLTR(cArray, 0, cArray.length, ComplexWrappedAreaView.this.defaultIsLTR) : ComplexWrappedAreaView.this.defaultIsLTR;
            AttributedCharacterIterator attributedCharacterIterator = ComplexWrappedAreaView.this.getParagraphACI(this.elem, cArray, bl);
            if (bl != this.layouts[0].isLeftToRight()) {
                n = 0;
                n2 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
                n3 = this.cc;
            }
            DamageInfo damageInfo = ComplexWrappedAreaView.this.updateLayouts(attributedCharacterIterator, n, n2, n3, this);
            this.cc += n2 - n3;
            return damageInfo;
        }
    }

    static final class DamageInfo {
        int lineStart;
        int linesRemoved;
        int linesAdded;

        public DamageInfo(int n, int n2, int n3) {
            this.lineStart = n;
            this.linesRemoved = n2;
            this.linesAdded = n3;
        }
    }
}

