/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.ibm.jvm.io.LocalizedInputStream;
import java.awt.Font;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.NativeLibLoader;
import sun.awt.font.NativeFontWrapper;
import sun.io.CharToByteConverter;
import sun.io.CharacterEncoding;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.java2d.loops.RasterOutputManager;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected Properties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry;
    protected String aliasName;
    protected String styleString;
    private Object[] fontCache;
    protected static int FONTCACHESIZE;
    protected static int FONTCACHEMASK;
    protected static String osVersion;
    private static Properties fprops;
    private static boolean usesPlatformFont;

    public PlatformFont(String string, int n) {
        int n2;
        if (fprops == null) {
            this.props = null;
            return;
        }
        this.props = fprops;
        this.aliasName = this.props.getProperty("alias." + string.toLowerCase());
        if (this.aliasName == null) {
            this.aliasName = string.toLowerCase();
        }
        if (this.props.getProperty(this.aliasName + ".0") == null && this.props.getProperty(this.aliasName + ".plain.0") == null) {
            if (NativeFontWrapper.isKnown(string)) {
                this.props = null;
                return;
            }
            this.aliasName = "sansserif";
        }
        this.styleString = PlatformFont.styleStr(n);
        Vector vector = new Vector(5);
        int n3 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n3);
            String string3 = this.props.getProperty(this.aliasName + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(this.aliasName + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.aliasName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.aliasName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n4 = 1;
                int n5 = 0;
                while ((n5 = string5.indexOf(44, n5)) != -1) {
                    ++n5;
                    ++n4;
                }
                nArray = new int[n4];
                int n6 = 0;
                while (n6 < n4) {
                    String string6;
                    String string7;
                    int n7 = 0;
                    int n8 = 0;
                    try {
                        string7 = string5.substring(n6 * 10, n6 * 10 + 4);
                        string6 = string5.substring(n6 * 10 + 5, n6 * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n7 = Integer.parseInt(string7, 16);
                        n8 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[n6] = n7 << 16 | n8;
                    ++n6;
                }
            }
            vector.addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n3;
        }
        this.componentFonts = new FontDescriptor[n3];
        int n9 = 0;
        while (n9 < n3) {
            this.componentFonts[n9] = (FontDescriptor)vector.elementAt(n9);
            ++n9;
        }
        try {
            n2 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        int n10 = 0;
        while (n10 < this.componentFonts.length) {
            if (!this.componentFonts[n10].isExcluded((char)n2) && this.componentFonts[n10].fontCharset.canConvert((char)n2)) {
                this.defaultFont = this.componentFonts[n10];
                this.defaultChar = (char)n2;
                break;
            }
            ++n10;
        }
    }

    private static File tryOpeningFontProp(File file, Properties properties, String string, String string2, String string3, String string4, String string5) {
        File file2 = null;
        if (file != null) {
            file2 = file;
        } else {
            String string6 = usesPlatformFont ? "native" + File.separator : "";
            String string7 = "font.properties";
            String string8 = null;
            string8 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("ibm.jvm.fontproperties.dir");
                }
            });
            String string9 = string8 != null ? string8 + "/" : string + File.separator + "lib" + File.separator + string6;
            string7 = PlatformFont.getPropsFilename(string7, string2, string3, string4, string5);
            if (properties != null) {
                string7 = properties.getProperty(string7);
            }
            if (string7 != null && (file = new File(string9 + string7)).canRead()) {
                file2 = file;
            }
        }
        return file2;
    }

    protected static String getOsVersion() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        if (string.equals("Windows NT")) {
            return "NT" + string2;
        }
        return string2;
    }

    private static String getPropsFilename(String string, String string2, String string3, String string4, String string5) {
        if (string2 != null) {
            string = string + "." + string2;
            if (string3 != null) {
                string = string + "_" + string3;
                if (string4 != null) {
                    string = string + "_" + string4;
                    if (string5 != null) {
                        string = string + "." + string5;
                    }
                } else if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string4 != null) {
                string = string + "_" + string4;
                if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string5 != null) {
                string = string + "." + string5;
            }
        } else if (string4 != null) {
            string = string + "." + string4;
            if (string5 != null) {
                string = string + "." + string5;
            }
        } else if (string5 != null) {
            string = string + "." + string5;
        }
        return string;
    }

    private static void initializeProps() {
        Object object;
        String string = System.getProperty("java.home");
        if (string == null) {
            throw new Error("java.home property not set");
        }
        String string2 = System.getProperty("user.language", "en");
        String string3 = System.getProperty("user.region");
        String string4 = System.getProperty("file.encoding");
        String string5 = CharacterEncoding.aliasName(string4);
        if (string5 == null) {
            string5 = string4;
        }
        if (osVersion == null) {
            osVersion = PlatformFont.getOsVersion();
        }
        String string6 = usesPlatformFont ? "native" + File.separator : "";
        String string7 = string + File.separator + "lib" + File.separator + string6 + "fprop.dir";
        File file = new File(string7);
        Properties properties = null;
        if (file.exists()) {
            properties = new Properties();
            try {
                object = new BufferedInputStream(LocalizedInputStream.localize(new FileInputStream(file.getPath())));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = null;
        object = PlatformFont.tryOpeningFontProp(object, properties, string, string2, string3, string5, osVersion);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, string2, string3, string5, null);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, string2, string3, null, osVersion);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, string2, null, string5, osVersion);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, string2, string3, null, null);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, string2, null, string5, null);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, string2, null, null, osVersion);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, null, null, string5, osVersion);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, string2, null, null, null);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, null, null, string5, null);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, null, null, null, osVersion);
        object = PlatformFont.tryOpeningFontProp((File)object, properties, string, null, null, null, null);
        Properties properties2 = new Properties();
        properties2.put("serif.0", "unknown");
        properties2.put("sansserif.0", "unknown");
        properties2.put("monospaced.0", "unknown");
        properties2.put("dialog.0", "unknown");
        properties2.put("dialoginput.0", "unknown");
        fprops = new Properties(properties2);
        if (object != null && ((File)object).canRead()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize(new FileInputStream(((File)object).getPath())));
                fprops.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length());
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2) {
        CharsetString[] charsetStringArray;
        int n3;
        Object object;
        if (n2 < 1) {
            return new CharsetString[0];
        }
        Vector vector = null;
        char[] cArray2 = new char[n2];
        char c = this.defaultChar;
        Object object2 = this.defaultFont;
        int n4 = 0;
        while (n4 < this.componentFonts.length) {
            if (!this.componentFonts[n4].isExcluded(cArray[n]) && this.componentFonts[n4].fontCharset.canConvert(cArray[n])) {
                object2 = this.componentFonts[n4];
                c = cArray[n];
                break;
            }
            ++n4;
        }
        cArray2[0] = c;
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            char c2 = cArray[n + n6];
            object = this.defaultFont;
            c = this.defaultChar;
            n3 = 0;
            while (n3 < this.componentFonts.length) {
                if (!this.componentFonts[n3].isExcluded(c2) && this.componentFonts[n3].fontCharset.canConvert(c2)) {
                    object = this.componentFonts[n3];
                    c = c2;
                    break;
                }
                ++n3;
            }
            cArray2[n6] = c;
            if (object2 != object) {
                if (vector == null) {
                    vector = new Vector(3);
                }
                vector.addElement(new CharsetString(cArray2, n5, n6 - n5, (FontDescriptor)object2));
                object2 = object;
                object = this.defaultFont;
                n5 = n6;
            }
            ++n6;
        }
        object = new CharsetString(cArray2, n5, n2 - n5, (FontDescriptor)object2);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{object};
        } else {
            vector.addElement(object);
            charsetStringArray = new CharsetString[vector.size()];
            n3 = 0;
            while (n3 < vector.size()) {
                charsetStringArray[n3] = (CharsetString)vector.elementAt(n3);
                ++n3;
            }
        }
        return charsetStringArray;
    }

    public boolean mightHaveMultiFontMetrics() {
        return this.props != null;
    }

    public Object[] makeConvertedMultiFontString(String string) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length());
    }

    public Object[] makeConvertedMultiFontString(String string, Font font) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length(), font);
    }

    public Object[] makeConvertedMultiFontChars(char[] cArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(cArray, n, n2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object[] makeConvertedMultiFontChars(char[] var1_1, int var2_2, int var3_3, Font var4_4) throws MalformedInputException, ConversionBufferFullException {
        var5_5 = new Object[2];
        var7_6 = null;
        var8_7 = var2_2;
        var9_8 = 0;
        var10_9 = 0;
        var12_10 = null;
        var13_11 = null;
        var16_12 = var2_2 + var3_3;
        if (var2_2 < 0 || var16_12 > var1_1.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (var8_7 < var16_12) ** GOTO lbl78
        return null;
lbl-1000:
        // 1 sources

        {
            var14_14 = var1_1[var8_7];
            var11_13 = var14_14 & PlatformFont.FONTCACHEMASK;
            var15_15 = (PlatformFontCache)this.getFontCache()[var11_13];
            if (var15_15 == null || var15_15.uniChar != var14_14) {
                var12_10 = this.defaultFont;
                var14_14 = this.defaultChar;
                var17_16 = var1_1[var8_7];
                var18_18 = this.componentFonts.length;
                var19_19 = 0;
                while (var19_19 < var18_18) {
                    var20_20 /* !! */  = (char[])this.componentFonts[var19_19];
                    var20_20 /* !! */ .fontCharset.reset();
                    var20_20 /* !! */ .fontCharset.setSubstitutionMode(false);
                    if (!var20_20 /* !! */ .isExcluded(var17_16) && var20_20 /* !! */ .fontCharset.canConvert(var17_16) && (var4_4 == null || NativeFontWrapper.canDisplaySlot(var4_4, var19_19, var17_16))) {
                        var12_10 = var20_20 /* !! */ ;
                        var14_14 = var17_16;
                        break;
                    }
                    ++var19_19;
                }
                try {
                    var20_20 /* !! */  = new char[]{var14_14};
                    var15_15 = new PlatformFontCache();
                    var15_15.encodingSize = (byte)var12_10.fontCharset.convert(var20_20 /* !! */ , 0, 1, var15_15.encoding, 0, 4);
                    var15_15.fontDescriptor = var12_10;
                    var15_15.uniChar = var1_1[var8_7];
                    this.getFontCache()[var11_13] = var15_15;
                }
                catch (Exception var20_21) {
                    System.err.println(var20_21);
                    var20_21.printStackTrace();
                    return null;
                }
            }
            if (var13_11 != var15_15.fontDescriptor) {
                if (var13_11 != null) {
                    var5_5[var10_9++] = var13_11;
                    var5_5[var10_9++] = var7_6;
                    if (var7_6 != null) {
                        var7_6[0] = (byte)((var9_8 -= 4) >> 24);
                        var7_6[1] = (byte)(var9_8 >> 16);
                        var7_6[2] = (byte)(var9_8 >> 8);
                        var7_6[3] = (byte)var9_8;
                    }
                    if (var10_9 >= var5_5.length) {
                        var17_17 = new Object[var5_5.length * 2];
                        System.arraycopy(var5_5, 0, var17_17, 0, var5_5.length);
                        var5_5 = var17_17;
                    }
                }
                var7_6 = new byte[(var16_12 - var8_7 + 1) * var15_15.fontDescriptor.fontCharset.getMaxBytesPerChar() + 4];
                var9_8 = 4;
                var13_11 = var15_15.fontDescriptor;
            }
            if (var15_15.encodingSize == 1) {
                var7_6[var9_8++] = var15_15.encoding[0];
            } else if (var15_15.encodingSize == 2) {
                var7_6[var9_8++] = var15_15.encoding[0];
                var7_6[var9_8++] = var15_15.encoding[1];
            } else if (var15_15.encodingSize == 3) {
                var7_6[var9_8++] = var15_15.encoding[0];
                var7_6[var9_8++] = var15_15.encoding[1];
                var7_6[var9_8++] = var15_15.encoding[2];
            } else if (var15_15.encodingSize == 4) {
                var7_6[var9_8++] = var15_15.encoding[0];
                var7_6[var9_8++] = var15_15.encoding[1];
                var7_6[var9_8++] = var15_15.encoding[2];
                var7_6[var9_8++] = var15_15.encoding[3];
            }
            ++var8_7;
lbl78:
            // 2 sources

            ** while (var8_7 < var16_12)
        }
lbl79:
        // 1 sources

        var5_5[var10_9++] = var13_11;
        var5_5[var10_9++] = var7_6;
        if (var7_6 != null) {
            var7_6[0] = (byte)((var9_8 -= 4) >> 24);
            var7_6[1] = (byte)(var9_8 >> 16);
            var7_6[2] = (byte)(var9_8 >> 8);
            var7_6[3] = (byte)var9_8;
        }
        return var5_5;
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    protected final Object[] getFontCache() {
        if (this.fontCache == null) {
            this.fontCache = new Object[FONTCACHESIZE];
        }
        return this.fontCache;
    }

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    private static native void initIDs();

    static {
        NativeLibLoader.loadLibraries();
        PlatformFont.initIDs();
        charsetRegistry = new Hashtable(5);
        FONTCACHESIZE = 256;
        FONTCACHEMASK = FONTCACHESIZE - 1;
        usesPlatformFont = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    usesPlatformFont = RasterOutputManager.usesPlatformFont();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PlatformFont.initializeProps();
                return null;
            }
        });
    }

    class PlatformFontCache {
        char uniChar;
        FontDescriptor fontDescriptor;
        byte encodingSize;
        byte[] encoding = new byte[4];

        PlatformFontCache() {
        }
    }
}

