/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.ibm.jvm.io.LocalizedInputStream;
import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.awt.X11GraphicsDevice;
import sun.awt.font.NativeFontWrapper;
import sun.awt.motif.PSPrinterJob;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.LoadLibraryAction;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    Map fontNameMap;
    Map xlfdMap;
    private Vector nativeFonts;

    private static synchronized native void initDisplay();

    protected native int getNumScreens();

    protected GraphicsDevice makeScreenDevice(int n) {
        return new X11GraphicsDevice(n);
    }

    protected native int getDefaultScreenNum();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreenNum()];
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new PSPrinterJob();
    }

    protected boolean platformReady() {
        return true;
    }

    protected String getFontPropertyFD(String string) {
        if (string.charAt(0) != '-') {
            return super.getFontPropertyFD(string);
        }
        return string;
    }

    protected String getFileNameFromPlatformName(String string) {
        if (string.charAt(0) != '-') {
            return super.getFileNameFromPlatformName(string);
        }
        String string2 = null;
        String string3 = this.FontIDForName(string);
        if (this.fontNameMap == null) {
            this.fontNameMap = new Hashtable();
        }
        if ((string2 = (String)this.fontNameMap.get(string3)) == null) {
            string2 = super.getFileNameFromPlatformName(string3);
        }
        return string2;
    }

    protected String parseFamilyNameProperty(String string) {
        String string2;
        String string3 = "default";
        String string4 = this.FontIDForName(string);
        String string5 = null;
        if (string.charAt(0) != '-') {
            return super.parseFamilyNameProperty(string);
        }
        if (this.fontNameMap != null) {
            string5 = (String)this.fontNameMap.get(string4);
        }
        if (string5 == null) {
            string5 = super.getFileNameFromPlatformName(string4);
        }
        if (string5 != null && (string2 = NativeFontWrapper.getFullNameByFileName(string5)) != null) {
            string3 = string2;
        }
        return string3;
    }

    private String FontIDForName(String string) {
        String string2 = this.getFontField(string, 3);
        String string3 = this.getFontField(string, 4);
        String string4 = this.getFontField(string, 5);
        if (string4.equals("o")) {
            string4 = "i";
        }
        String string5 = string2 + "_" + string3 + "_" + string4;
        return string5.toLowerCase();
    }

    private String getFontField(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (--n > 0 && n2 >= 0) {
            n2 = string.indexOf("-", n2) + 1;
        }
        if (n2 == -1) {
            return "";
        }
        n3 = string.indexOf("-", n2);
        if (n3 == -1) {
            return string.substring(n2);
        }
        return string.substring(n2, n3);
    }

    protected void registerFontPath(String string) {
        final File file = new File(string + File.separator + "fonts.dir");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    X11GraphicsEnvironment.this.parseFontDir(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private native String[] getNativeFonts();

    protected String getPropString(String string) {
        if (this.xlfdMap == null) {
            return string;
        }
        String string2 = (String)this.xlfdMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected void registerNative(String string) {
        Vector vector = new Vector(5, 5);
        vector.addElement(string);
        this.registeredFonts.put(string, string);
        NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5);
    }

    private void initNativeFonts() {
        if (this.nativeFonts != null) {
            return;
        }
        String[] stringArray = this.getNativeFonts();
        if (stringArray != null) {
            this.nativeFonts = new Vector();
            if (this.fontNameMap == null) {
                this.fontNameMap = new Hashtable();
            }
            if (this.xlfdMap == null) {
                this.xlfdMap = new Hashtable();
            }
            int n = 0;
            while (n < stringArray.length) {
                String string = this.FontIDForName(stringArray[n]);
                String string2 = (String)this.fontNameMap.get(string);
                if (string2 == null) {
                    this.nativeFonts.addElement(stringArray[n]);
                    this.fontNameMap.put(string, stringArray[n]);
                    this.xlfdMap.put(stringArray[n], stringArray[n]);
                }
                ++n;
            }
        }
    }

    protected boolean registerNativeFonts() {
        return false;
    }

    private void initFontNameMap(String string) {
        if (this.fontNameMap != null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.registerFontPath(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        if (this.loadNativeFonts) {
            this.initNativeFonts();
        }
    }

    private void parseFontDir(File file) throws FileNotFoundException, IOException {
        String string = file.getParent();
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize(fileInputStream), 8192);
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedInputStream);
            streamTokenizer.eolIsSignificant(true);
            int n = streamTokenizer.nextToken();
            if (n == -2) {
                int n2 = (int)streamTokenizer.nval;
                n = streamTokenizer.nextToken();
                if (n == 10) {
                    if (this.fontNameMap == null) {
                        this.fontNameMap = new Hashtable();
                    }
                    if (this.xlfdMap == null) {
                        this.xlfdMap = new Hashtable();
                    }
                    streamTokenizer.resetSyntax();
                    streamTokenizer.wordChars(32, 127);
                    streamTokenizer.wordChars(160, 255);
                    streamTokenizer.whitespaceChars(0, 31);
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4;
                        n = streamTokenizer.nextToken();
                        if (n == -1 || n != -3 || (n4 = streamTokenizer.sval.indexOf(" ")) <= 0) break;
                        String string2 = streamTokenizer.sval.substring(0, n4);
                        int n5 = string2.lastIndexOf(58);
                        if (n5 >= 0) {
                            string2 = string2.substring(n5 + 1);
                        }
                        String string3 = streamTokenizer.sval.substring(n4 + 1);
                        String string4 = this.FontIDForName(string3);
                        String string5 = (String)this.fontNameMap.get(string4);
                        String string6 = string + File.separator + string2;
                        String string7 = (String)this.xlfdMap.get(string6);
                        if (string5 == null) {
                            this.fontNameMap.put(string4, string2);
                            this.xlfdMap.put(string6, string3);
                        }
                        if ((n = streamTokenizer.nextToken()) != 10) break;
                        ++n3;
                    }
                }
            }
        }
    }

    protected native void setX11FontPath(String var1);

    protected void initCompositeFonts() {
        this.setX11FontPath(this.fontPath);
        super.initCompositeFonts();
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        X11GraphicsEnvironment.initDisplay();
    }
}

