/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import sun.awt.font.Utilities;

public final class Bidi {
    private boolean ltr;
    private byte[] dirs;
    private byte[] levels;
    private int[] l2vMap;
    private int[] v2lMap;
    public static final byte L = 0;
    public static final byte LRE = 1;
    public static final byte LRO = 2;
    public static final byte R = 3;
    public static final byte AL = 4;
    public static final byte RLE = 5;
    public static final byte RLO = 6;
    public static final byte PDF = 7;
    public static final byte EN = 8;
    public static final byte ES = 9;
    public static final byte ET = 10;
    public static final byte AN = 11;
    public static final byte CS = 12;
    public static final byte NSM = 13;
    public static final byte BN = 14;
    public static final byte B = 15;
    public static final byte S = 16;
    public static final byte WS = 17;
    public static final byte ON = 18;
    static final char NUMLEVELS = '>';
    static final long FLAG_RTL = 0x40000000L;
    static final long FLAG_EXTERNAL_EMBS = 0x20000000L;
    static final long FLAG_L = 1L;
    static final long FLAG_LRE = 2L;
    static final long FLAG_LRO = 4L;
    static final long FLAG_R = 8L;
    static final long FLAG_AL = 16L;
    static final long FLAG_RLE = 32L;
    static final long FLAG_RLO = 64L;
    static final long FLAG_PDF = 128L;
    static final long FLAG_EN = 256L;
    static final long FLAG_ES = 512L;
    static final long FLAG_ET = 1024L;
    static final long FLAG_AN = 2048L;
    static final long FLAG_CS = 4096L;
    static final long FLAG_NSM = 8192L;
    static final long FLAG_BN = 16384L;
    static final long FLAG_B = 32768L;
    static final long FLAG_S = 65536L;
    static final long FLAG_WS = 131072L;
    static final long FLAG_ON = 262144L;
    static final long MASK_EMBS = 230L;
    static final long MASK_R = 1073743992L;
    static final long MASK_NUM = 2304L;
    static final long MASK_SEP = 4608L;
    private static byte[] dirIndices = new byte[]{41, 0, 1, 2, 2, 3, 4, 5, 6, 2, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, -125, 2, 6, 38, 39, 14, 40, 41, 42, -118, 14, 22, 2, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 14, 59, 60, 56, 56, -117, 14, 11, 61, 56, 62, 63, 64, 65, 66, 67, 68, 69, 70, -77, 2, 1, 71, -2, 2, -91, 2, 1, 72, -119, 2, 1, 73, -114, 14, -41, 2, 1, 74, -60, 2, 12, 75, 14, 76, 77, 78, 78, 79, 80, 81, 82, 83, 84};
    private static byte[] dirValues = new byte[]{-119, 14, 5, 16, 15, 16, 17, 15, -114, 14, -125, 15, 4, 16, 17, 18, 18, -125, 10, -123, 18, 5, 10, 12, 10, 12, 9, -118, 8, 1, 12, -122, 18, -102, 0, -122, 18, -102, 0, -124, 18, -122, 14, 1, 15, -102, 14, 2, 12, 18, -124, 10, -124, 18, 1, 0, -123, 18, 6, 10, 10, 8, 8, 18, 0, -125, 18, 2, 8, 0, -123, 18, -105, 0, 1, 18, -97, 0, 1, 18, -2, 0, -86, 0, 2, 16, 16, -110, 0, -100, 16, -34, 0, 2, 16, 16, -119, 0, 2, 18, 18, -121, 0, -114, 18, 2, 0, 0, -114, 18, -123, 0, -119, 18, 1, 0, -111, 16, -49, 13, -111, 16, -125, 13, -111, 16, 2, 18, 18, -124, 16, 1, 0, -125, 16, 1, 18, -123, 16, 4, 18, 18, 0, 18, -125, 0, 3, 16, 0, 16, -108, 0, 1, 16, -84, 0, 1, 16, -120, 0, 2, 16, 16, -102, 0, -116, 16, -125, 0, -124, 13, 5, 16, 13, 13, 16, 16, -71, 0, 8, 16, 16, 0, 0, 16, 16, 0, 0, -125, 16, -90, 0, 4, 16, 16, 0, 0, -73, 16, -90, 0, 2, 16, 16, -121, 0, 1, 16, -89, 0, 3, 16, 0, 18, -122, 16, -111, 13, 1, 16, -105, 13, 1, 16, -125, 13, 7, 3, 13, 3, 13, 13, 3, 13, -117, 16, -101, 3, -123, 16, -123, 3, -105, 16, 1, 12, -114, 16, 1, 4, -125, 16, 2, 4, 16, -102, 4, -123, 16, -117, 4, -117, 13, -118, 16, -118, 11, 7, 10, 11, 11, 4, 16, 16, 13, -27, 4, -113, 13, 5, 4, 4, 13, 13, 18, -124, 13, 2, 16, 16, -118, 8, -123, 4, 1, 16, -114, 4, 4, 16, 14, 4, 13, -101, 4, -125, 16, -101, 13, -75, 16, -90, 4, -117, 13, -2, 16, -46, 16, 4, 13, 13, 0, 16, -75, 0, 3, 16, 16, 13, -124, 0, -120, 13, -124, 0, 4, 13, 16, 16, 0, -124, 13, -125, 16, -118, 0, 2, 13, 13, -115, 0, -112, 16, 4, 13, 0, 0, 16, -120, 0, 6, 16, 16, 0, 0, 16, 16, -106, 0, 1, 16, -121, 0, 2, 16, 0, -125, 16, -124, 0, 4, 16, 16, 13, 16, -125, 0, -124, 13, 9, 16, 16, 0, 0, 16, 16, 0, 0, 13, -119, 16, 1, 0, -124, 16, 3, 0, 0, 16, -125, 0, 4, 13, 13, 16, 16, -116, 0, 2, 10, 10, -121, 0, -121, 16, 3, 13, 16, 16, -122, 0, -124, 16, 4, 0, 0, 16, 16, -106, 0, 1, 16, -121, 0, 13, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 16, 13, 16, -125, 0, 2, 13, 13, -124, 16, 4, 13, 13, 16, 16, -125, 13, -117, 16, -124, 0, 2, 16, 0, -121, 16, -118, 0, 2, 13, 13, -125, 0, -116, 16, 4, 13, 13, 0, 16, -121, 0, 3, 16, 0, 16, -125, 0, 1, 16, -106, 0, 1, 16, -121, 0, 4, 16, 0, 0, 16, -123, 0, 3, 16, 16, 13, -124, 0, -123, 13, 11, 16, 13, 13, 0, 16, 0, 0, 13, 16, 16, 0, -113, 16, 1, 0, -123, 16, -118, 0, -111, 16, 4, 13, 0, 0, 16, -120, 0, 6, 16, 16, 0, 0, 16, 16, -106, 0, 1, 16, -121, 0, 5, 16, 0, 0, 16, 16, -124, 0, 7, 16, 16, 13, 0, 0, 13, 0, -125, 13, -125, 16, 7, 0, 0, 16, 16, 0, 0, 13, -120, 16, 2, 13, 0, -124, 16, 3, 0, 0, 16, -125, 0, -124, 16, -117, 0, -111, 16, 3, 13, 0, 16, -122, 0, -125, 16, -125, 0, 1, 16, -124, 0, -125, 16, 7, 0, 0, 16, 0, 16, 0, 0, -125, 16, 2, 0, 0, -125, 16, -125, 0, -125, 16, -120, 0, 1, 16, -125, 0, -124, 16, 5, 0, 0, 13, 0, 0, -125, 16, -125, 0, 1, 16, -125, 0, 1, 13, -119, 16, 1, 0, -113, 16, -116, 0, -114, 16, -125, 0, 1, 16, -120, 0, 1, 16, -125, 0, 1, 16, -105, 0, 1, 16, -118, 0, 1, 16, -123, 0, -124, 16, -125, 13, -124, 0, 1, 16, -125, 13, 1, 16, -124, 13, -121, 16, 2, 13, 13, -119, 16, 2, 0, 0, -124, 16, -118, 0, -110, 16, 3, 0, 0, 16, -120, 0, 1, 16, -125, 0, 1, 16, -105, 0, 1, 16, -118, 0, 1, 16, -123, 0, -124, 16, 2, 0, 13, -123, 0, 9, 16, 13, 0, 0, 16, 0, 0, 13, 13, -121, 16, 2, 0, 0, -121, 16, 4, 0, 16, 0, 0, -124, 16, -118, 0, -110, 16, 3, 0, 0, 16, -120, 0, 1, 16, -125, 0, 1, 16, -105, 0, 1, 16, -112, 0, -124, 16, -125, 0, -125, 13, 2, 16, 16, -125, 0, 1, 16, -125, 0, 1, 13, -119, 16, 1, 0, -120, 16, 2, 0, 0, -124, 16, -118, 0, -110, 16, 3, 0, 0, 16, -110, 0, -125, 16, -104, 0, 1, 16, -119, 0, 4, 16, 0, 16, 16, -121, 0, -125, 16, 1, 13, -124, 16, -125, 0, -125, 13, 3, 16, 13, 16, -120, 0, -110, 16, -125, 0, -116, 16, -80, 0, 3, 13, 0, 0, -121, 13, -124, 16, 1, 10, -121, 0, -120, 13, -115, 0, -91, 16, 13, 0, 0, 16, 0, 16, 16, 0, 0, 16, 0, 16, 16, 0, -122, 16, -124, 0, 1, 16, -121, 0, 1, 16, -125, 0, 9, 16, 0, 16, 0, 16, 16, 0, 0, 16, -124, 0, 3, 13, 0, 0, -122, 13, 6, 16, 13, 13, 0, 16, 16, -123, 0, 3, 16, 0, 16, -122, 13, 2, 16, 16, -118, 0, 4, 16, 16, 0, 0, -94, 16, -104, 0, 2, 13, 13, -101, 0, 5, 13, 0, 13, 0, 13, -124, 18, -118, 0, 1, 16, -94, 0, -122, 16, -114, 13, 1, 0, -123, 13, 3, 0, 13, 13, -124, 0, -124, 16, -120, 13, 1, 16, -92, 13, 1, 16, -120, 0, 1, 13, -122, 0, 3, 16, 16, 0, -80, 16, -94, 0, 1, 16, -123, 0, 5, 16, 0, 0, 16, 0, -124, 13, 2, 0, 13, -125, 16, 4, 13, 13, 0, 13, -122, 16, -104, 0, 2, 13, 13, -58, 16, -90, 0, -118, 16, -89, 0, -124, 16, 1, 0, -124, 16, -38, 0, -123, 16, -60, 0, -123, 16, -46, 0, -122, 16, -121, 0, 1, 16, -65, 0, 3, 16, 0, 16, -124, 0, 2, 16, 16, -121, 0, 3, 16, 0, 16, -124, 0, 2, 16, 16, -89, 0, 3, 16, 0, 16, -124, 0, 2, 16, 16, -97, 0, 3, 16, 0, 16, -124, 0, 2, 16, 16, -121, 0, 3, 16, 0, 16, -124, 0, 2, 16, 16, -121, 0, 1, 16, -121, 0, 1, 16, -105, 0, 1, 16, -97, 0, 3, 16, 0, 16, -124, 0, 2, 16, 16, -121, 0, 1, 16, -89, 0, 1, 16, -109, 0, -122, 16, -100, 0, -93, 16, -43, 0, -116, 16, -2, 0, -8, 0, -119, 16, 1, 17, -102, 0, 2, 18, 18, -125, 16, -47, 0, -113, 16, -73, 0, -121, 13, -120, 0, 3, 13, 0, 0, -117, 13, -121, 0, 2, 10, 0, -125, 16, -118, 0, -106, 16, -117, 18, -124, 14, 1, 16, -118, 0, -122, 16, -40, 0, -120, 16, -87, 0, 1, 13, -42, 16, -100, 0, -124, 16, -38, 0, -122, 16, -106, 0, 2, 16, 16, -122, 0, 2, 16, 16, -90, 0, 2, 16, 16, -122, 0, 2, 16, 16, -120, 0, 7, 16, 0, 16, 0, 16, 0, 16, -97, 0, 2, 16, 16, -75, 0, 1, 16, -121, 0, 2, 18, 0, -125, 18, -125, 0, 1, 16, -121, 0, -125, 18, -124, 0, 2, 16, 16, -122, 0, 1, 16, -125, 18, -115, 0, -125, 18, 2, 16, 16, -125, 0, 1, 16, -121, 0, 3, 18, 18, 16, -117, 17, -125, 14, 2, 0, 3, -104, 18, 8, 17, 15, 1, 5, 7, 2, 6, 17, -123, 10, -110, 18, 1, 16, -122, 18, -100, 16, -122, 14, 1, 8, -125, 16, -122, 8, 2, 10, 10, -125, 18, 1, 0, -118, 8, 2, 10, 10, -125, 18, -111, 16, -112, 10, -96, 16, -108, 13, -100, 16, 3, 18, 18, 0, -124, 18, 3, 0, 18, 18, -118, 0, 2, 18, 0, -125, 18, -123, 0, -122, 18, 6, 0, 18, 0, 18, 0, 18, -124, 0, 1, 10, -125, 0, 1, 18, -121, 0, 1, 18, -104, 16, -115, 18, -92, 0, -116, 16, -28, 18, -116, 16, -110, 18, 2, 10, 10, -2, 18, -32, 18, -114, 16, -74, 18, -59, 0, 2, 18, 16, -104, 18, 1, 0, -123, 18, -27, 16, -89, 18, -103, 16, -117, 18, -107, 16, -68, 8, -50, 0, 1, 8, -107, 16, -2, 18, -104, 18, -118, 16, -40, 18, -120, 16, -108, 18, -123, 16, -39, 18, -113, 16, -124, 18, 1, 16, -124, 18, 2, 16, 16, -100, 18, 1, 16, -93, 18, 3, 16, 18, 16, -124, 18, -125, 16, 2, 18, 16, -121, 18, 2, 16, 16, -121, 18, -114, 16, -97, 18, -125, 16, -104, 18, 1, 16, -114, 18, -63, 16, -102, 18, 1, 16, -39, 18, -116, 16, -42, 18, -102, 16, -116, 18, -124, 16, 1, 17, -124, 18, -125, 0, -103, 18, -119, 0, -122, 13, 1, 18, -123, 0, 2, 18, 18, -125, 0, -125, 16, 3, 18, 18, 16, -44, 0, -124, 16, 8, 13, 13, 18, 18, 0, 0, 16, 16, -38, 0, 1, 18, -125, 0, -122, 16, -88, 0, -124, 16, -34, 0, 1, 16, -88, 0, -56, 16, -99, 0, -125, 16, -92, 0, -100, 16, -100, 0, -125, 16, -78, 0, -113, 16, -116, 0, -124, 16, -81, 0, 1, 16, -9, 0, -124, 16, -29, 0, 2, 16, 16, -97, 0, 1, 16, -74, 0, -54, 16, -90, 0, -38, 16, -115, 0, -125, 16, -110, 18, 2, 16, 16, -112, 18, 1, 16, -116, 18, 1, 16, -125, 18, 2, 16, 18, -71, 16, -92, 0, -36, 16, -82, 0, -46, 16, -121, 0, -116, 16, -123, 0, -123, 16, 2, 3, 13, -118, 3, 1, 10, -115, 3, 1, 16, -123, 3, 9, 16, 3, 16, 3, 3, 16, 3, 3, 16, -118, 3, -30, 4, -95, 16, -2, 4, -19, 4, 2, 18, 18, -112, 16, -64, 4, 2, 16, 16, -74, 4, -88, 16, -116, 4, -92, 16, -124, 13, -116, 16, -107, 18, -124, 16, -121, 18, 6, 12, 18, 12, 16, 18, 12, -119, 18, 5, 10, 18, 18, 10, 10, -125, 18, 5, 16, 18, 10, 10, 18, -124, 16, -125, 4, 3, 16, 4, 16, -2, 4, -119, 4, 6, 16, 16, 14, 16, 18, 18, -125, 10, -123, 18, 5, 10, 12, 10, 12, 9, -118, 8, 1, 12, -122, 18, -102, 0, -122, 18, -102, 0, -124, 18, 2, 16, 16, -123, 18, -39, 0, -125, 16, -122, 0, 2, 16, 16, -122, 0, 2, 16, 16, -122, 0, 2, 16, 16, -125, 0, -125, 16, 2, 10, 10, -125, 18, 3, 10, 10, 16, -121, 18, -118, 16, -125, 14, 4, 18, 18, 16, 16};

    public int getLength() {
        return this.levels.length;
    }

    public boolean isDirectionLTR() {
        return this.ltr;
    }

    public int[] getLogicalToVisualMap() {
        if (this.l2vMap == null) {
            this.l2vMap = Bidi.getInverseOrder(this.getVisualToLogicalMap());
        }
        return this.l2vMap;
    }

    public int[] getVisualToLogicalMap() {
        if (this.v2lMap == null) {
            this.v2lMap = Bidi.createVisualToLogicalMap(this.levels);
        }
        return this.v2lMap;
    }

    public byte[] getLevels() {
        return this.levels;
    }

    public Bidi createLineBidi(int n, int n2) {
        byte[] byArray = new byte[n2 - n];
        System.arraycopy(this.levels, n, byArray, 0, byArray.length);
        if (this.dirs != null) {
            int n3 = this.ltr ? 0 : 1;
            int n4 = byArray.length;
            block3: while (--n4 >= 0) {
                if (byArray[n4] % 2 == n3) break;
                switch (this.dirs[n + n4]) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 17: {
                        byArray[n4] = n3;
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
            }
        }
        return new Bidi(byArray, this.ltr);
    }

    public int getLevelAt(int n) {
        return this.levels[n];
    }

    public int getLevelLimit(int n) {
        byte by = this.levels[n];
        while (++n < this.levels.length && this.levels[n] == by) {
        }
        return n;
    }

    public Bidi(char[] cArray) {
        this(Bidi.getDirectionCodeArray(cArray), null, Bidi.defaultIsLTR(cArray, 0, cArray.length, true));
    }

    public Bidi(char[] cArray, boolean bl) {
        this(Bidi.getDirectionCodeArray(cArray), null, bl);
    }

    public Bidi(char[] cArray, byte[] byArray, boolean bl) {
        this(Bidi.getDirectionCodeArray(cArray), byArray, bl);
    }

    public Bidi(byte[] byArray, byte[] byArray2, boolean bl) {
        long l = Bidi.getFlags(byArray);
        if (!bl) {
            l |= 0x40000000L;
        }
        if (byArray2 != null) {
            l |= 0x20000000L;
        } else {
            byArray2 = new byte[byArray.length];
        }
        Bidi.applyBidiRules(byArray, byArray2, l);
        this.ltr = bl;
        this.dirs = byArray;
        this.levels = byArray2;
    }

    public Bidi(byte[] byArray, boolean bl) {
        this.ltr = bl;
        this.dirs = null;
        this.levels = byArray;
    }

    public static void applyBidiRules(byte[] byArray, byte[] byArray2, long l) {
        byte[] byArray3 = null;
        if ((l & 0x20000000L) != 0L) {
            byArray3 = (byte[])byArray.clone();
            l = Bidi.processEmbeddingArray(byArray3, byArray2, l);
        } else if ((l & 0xE6L) != 0L) {
            byArray3 = (byte[])byArray.clone();
            l = Bidi.getLevelArray(byArray3, byArray2, l);
        } else {
            byte by = (l & 0x40000000L) == 0L ? (byte)0 : 1;
            int n = 0;
            while (n < byArray2.length) {
                byArray2[n] = by;
                ++n;
            }
        }
        if ((l & 0x40000878L) != 0L) {
            if (byArray3 == null) {
                byArray3 = (byte[])byArray.clone();
            }
            Bidi.resolveWeakTypes(byArray3, byArray2, l);
            Bidi.resolveNeutralTypes(byArray3, byArray2, l);
            Bidi.resolveImplicitLevels(byArray3, byArray2, l);
            Bidi.resolveLineLevels(byArray, byArray2, l);
        }
    }

    public static long getFlags(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < byArray.length) {
            l |= (long)(1 << byArray[n]);
            ++n;
        }
        return l;
    }

    private static void resolveWeakTypes(byte[] byArray, byte[] byArray2, long l) {
        int n = 0;
        int n2 = (l & 0x40000000L) == 0L ? 0 : 3;
        while (n < byArray.length) {
            int n3;
            int n4;
            int n5;
            byte by = byArray2[n];
            int n6 = n;
            if ((l & 0x20000000L) == 0L) {
                n6 = byArray.length;
            } else {
                while (++n6 < byArray.length && byArray2[n6] == by) {
                }
            }
            if ((l & 0x2000L) != 0L) {
                n4 = n > 0 ? ((Math.max(by, n5 = byArray2[n - 1]) & 1) == 0 ? 0 : 3) : ((by & 1) == 0 ? 0 : 3);
                n5 = n;
                while (n5 < n6) {
                    if (byArray[n5] == 13) {
                        byArray[n5] = n4;
                    } else if (byArray[n5] != 14) {
                        n4 = byArray[n5];
                    }
                    ++n5;
                }
            }
            if ((l & 0x10L) != 0L) {
                n4 = 0;
                n5 = n;
                while (n5 < n6) {
                    switch (byArray[n5]) {
                        case 0: 
                        case 3: {
                            n4 = 0;
                            break;
                        }
                        case 4: {
                            n4 = 1;
                            byArray[n5] = 3;
                            break;
                        }
                        case 8: {
                            if (n4 == 0) break;
                            byArray[n5] = 11;
                        }
                    }
                    ++n5;
                }
            }
            if ((l & 0x900L) != 0L) {
                int n7;
                if ((l & 0x4000L) != 0L) {
                    n4 = n;
                    while (n4 < n6) {
                        if (byArray[n4] == 14) {
                            n5 = n4 + 1;
                            while (n5 < n6 && byArray[n5] == 14) {
                                ++n5;
                            }
                            n3 = n4 > n ? byArray[n4 - 1] : 18;
                            n7 = n5 < n6 ? byArray[n5] : 18;
                            int n8 = 18;
                            if (n3 == 8 || n7 == 8) {
                                n8 = 8;
                            } else if (n3 == 10 || n7 == 10) {
                                n8 = 10;
                            } else if (n3 == 11 || n7 == 11) {
                                n8 = 11;
                            } else {
                                l |= 0x40000L;
                            }
                            while (n4 < n5) {
                                byArray[n4++] = n8;
                            }
                            continue;
                        }
                        ++n4;
                    }
                }
                if ((l & 0x1200L) != 0L && n + 2 < n6) {
                    n4 = byArray[n];
                    n5 = byArray[n + 1];
                    n3 = n + 2;
                    while (n3 < n6) {
                        n7 = byArray[n3];
                        switch (n7) {
                            case 11: {
                                if (n4 != 11 || n5 != 12) break;
                                byArray[n3 - 1] = 11;
                                break;
                            }
                            case 8: {
                                if (n4 != 8 || n5 != 12 && n5 != 9) break;
                                byArray[n3 - 1] = 8;
                            }
                        }
                        n4 = n5;
                        n5 = n7;
                        ++n3;
                    }
                }
                if ((l & 0x400L) != 0L) {
                    n4 = n;
                    while (n4 < n6) {
                        if (byArray[n4] == 10) {
                            n5 = n4 + 1;
                            while (n5 < n6 && byArray[n5] == 10) {
                                ++n5;
                            }
                            n3 = 18;
                            if (n4 > n && byArray[n4 - 1] == 8) {
                                n3 = 8;
                                l |= 8L;
                            } else if (n5 < n6 && byArray[n5] == 8) {
                                n3 = 8;
                                l |= 8L;
                            } else {
                                l |= 0x12L;
                            }
                            while (n4 < n5) {
                                byArray[n4++] = n3;
                            }
                            continue;
                        }
                        ++n4;
                    }
                }
            }
            n4 = n;
            while (n4 < n6) {
                switch (byArray[n4]) {
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        l |= 0x12L;
                        byArray[n4] = 18;
                    }
                }
                ++n4;
            }
            if ((l & 0x100L) != 0L) {
                n5 = 0;
                n5 = n == 0 ? ((by & 1) == 0 ? 1 : 0) : ((Math.max(by, byArray2[n - 1]) & 1) == 0 ? 1 : 0);
                n3 = n;
                while (n3 < n6) {
                    switch (byArray[n3]) {
                        case 0: {
                            n5 = 1;
                            break;
                        }
                        case 3: {
                            n5 = 0;
                            break;
                        }
                        case 8: {
                            if (n5 == 0) break;
                            l |= 0L;
                            byArray[n3] = 0;
                        }
                    }
                    ++n3;
                }
            }
            n = n6;
        }
    }

    private static void resolveNeutralTypes(byte[] byArray, byte[] byArray2, long l) {
        int n = byArray.length;
        boolean bl = (l & 0x20000000L) != 0L;
        byte by = (l & 0x40000000L) == 0L ? (byte)0 : 1;
        int n2 = !(by & true) ? 0 : 3;
        byte by2 = by;
        byte by3 = by;
        int n3 = n2;
        int n4 = n2;
        int n5 = 0;
        while (n5 < n) {
            int n6;
            by3 = byArray2[n5];
            if (by3 != by2) {
                int n7 = n6 = (by3 & 1) == 0 ? 0 : 3;
                if (bl) {
                    n4 = by3 > by2 ? n6 : n3;
                }
                n3 = n6;
            }
            switch (byArray[n5]) {
                case 18: {
                    if (n4 == n3) {
                        byArray[n5++] = n3;
                        break;
                    }
                    n6 = n3;
                    int n8 = n5;
                    if (bl) {
                        while (++n8 < n && byArray[n8] == 18 && byArray2[n8] == by3) {
                        }
                        if (n8 < n) {
                            byte by4 = byArray2[n8];
                            if (by4 != by3) {
                                if (by3 < by4) {
                                    n6 = (by4 & 1) == 0 ? 0 : 3;
                                }
                            } else {
                                n6 = byArray[n8] == 0 ? 0 : 3;
                            }
                        }
                    } else {
                        while (++n8 < n && byArray[n8] == 18) {
                        }
                        if (n8 < n) {
                            n6 = byArray[n8] == 0 ? 0 : 3;
                        }
                    }
                    while (n5 < n8) {
                        byArray[n5++] = n6;
                    }
                    break;
                }
                case 0: {
                    n4 = 0;
                    ++n5;
                    break;
                }
                default: {
                    n4 = 3;
                    ++n5;
                }
            }
            by2 = by3;
        }
    }

    private static void resolveImplicitLevels(byte[] byArray, byte[] byArray2, long l) {
        int n = 0;
        while (n < byArray.length) {
            boolean bl = (byArray2[n] & 1) != 0;
            switch (byArray[n]) {
                case 0: {
                    if (!bl) break;
                    int n2 = n;
                    byArray2[n2] = (byte)(byArray2[n2] + 1);
                    break;
                }
                case 3: {
                    if (bl) break;
                    int n3 = n;
                    byArray2[n3] = (byte)(byArray2[n3] + 1);
                    break;
                }
                case 8: 
                case 11: {
                    int n4 = n;
                    byArray2[n4] = (byte)(byArray2[n4] + (bl ? 1 : 2));
                }
            }
            ++n;
        }
    }

    private static void resolveLineLevels(byte[] byArray, byte[] byArray2, long l) {
        byte by = (l & 0x40000000L) == 0L ? (byte)0 : 1;
        boolean bl = true;
        int n = byArray.length - 1;
        while (n >= 0) {
            switch (byArray[n]) {
                case 17: {
                    if (!bl) break;
                    byArray2[n] = by;
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 14: {
                    if (bl) {
                        byArray2[n] = by;
                        break;
                    }
                    byArray2[n] = byArray2[n + 1];
                    break;
                }
                case 15: 
                case 16: {
                    byArray2[n] = by;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            --n;
        }
    }

    public Bidi(Bidi bidi, int n, int n2) {
        byte[] byArray = bidi.dirs;
        byte[] byArray2 = Bidi.createLineLevels(byArray, bidi.levels, bidi.ltr, n, n2);
        this.ltr = bidi.ltr;
        this.dirs = null;
        this.levels = byArray2;
    }

    public static byte[] createLineLevels(byte[] byArray, byte[] byArray2, boolean bl, int n, int n2) {
        byte[] byArray3 = new byte[n2 - n];
        System.arraycopy(byArray2, n, byArray3, 0, byArray3.length);
        byte by = bl ? (byte)0 : 1;
        int n3 = n2 - n - 1;
        while (n3 >= 0) {
            if (byArray3[n3] == by || byArray[n + n3] != 17) break;
            byArray3[n3] = by;
            --n3;
        }
        return byArray3;
    }

    public static boolean defaultIsLTR(char[] cArray, int n, int n2) {
        return Bidi.defaultIsLTR(cArray, n, n2, true);
    }

    public static boolean defaultIsLTR(char[] cArray, int n, int n2, boolean bl) {
        while (n < n2) {
            char c = cArray[n++];
            byte by = Bidi.getDirectionCode(c);
            switch (by) {
                case 0: {
                    return true;
                }
                case 3: 
                case 4: {
                    return false;
                }
            }
        }
        return bl;
    }

    public static boolean defaultIsLTR(byte[] byArray, int n, int n2, boolean bl) {
        while (n < n2) {
            byte by = byArray[n++];
            switch (by) {
                case 0: {
                    return true;
                }
                case 3: 
                case 4: {
                    return false;
                }
            }
        }
        return bl;
    }

    public static boolean requiresBidi(char c) {
        if (c < '\u0591') {
            return false;
        }
        if (c > '\u202e') {
            return false;
        }
        byte by = Bidi.getDirectionCode(c);
        return (0x40000878L & (long)(1 << by)) != 0L;
    }

    public static byte getDirectionCode(char c) {
        return dirValues[(dirIndices[c >> 7] << 7) + (c & 0x7F)];
    }

    public static byte[] getDirectionCodeArray(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = Bidi.getDirectionCode(cArray[n]);
            ++n;
        }
        return byArray;
    }

    private static long processEmbeddingArray(byte[] byArray, byte[] byArray2, long l) {
        if (byArray2.length != byArray.length) {
            throw new IllegalArgumentException("embedding length != direction types length");
        }
        byte by = (l & 0x40000000L) == 0L ? (byte)0 : 1;
        int n = 0;
        while (n < byArray2.length) {
            if ((byArray2[n] & 0x80) != 0) {
                int n2 = n;
                byArray2[n2] = (byte)(byArray2[n2] & 0x7F);
                if ((byArray2[n] & 1) == 0) {
                    byArray[n] = 0;
                    l |= 4L;
                } else {
                    byArray[n] = 3;
                    l |= 0x40L;
                }
            } else if (byArray2[n] > by) {
                l = (byArray2[n] & 1) == 0 ? (l |= 2L) : (l |= 0x20L);
            }
            if (byArray2[n] < by || byArray2[n] >= 62) {
                throw new IllegalArgumentException("bad embedding level (" + byArray2[n] + ") at index " + n);
            }
            ++n;
        }
        return l;
    }

    public static long getLevelArray(byte[] byArray, byte[] byArray2, long l) {
        int n;
        int n2 = n = (l & 0x40000000L) == 0L ? 0 : 1;
        if ((l & 0xE6L) == 0L) {
            int n3 = 0;
            while (n3 < byArray2.length) {
                byArray2[n3] = n;
                ++n3;
            }
            return l;
        }
        int n4 = byArray.length;
        byte[] byArray3 = new byte[62];
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        int n8 = n;
        int n9 = n7;
        int n10 = n8;
        int n11 = 0;
        while (n11 < n4) {
            byte by = byArray[n11];
            block0 : switch (by) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    int n12;
                    byArray2[n11] = n10;
                    byArray[n11] = 14;
                    if (n6 == 0 && (n12 = by == 5 || by == 6 ? (int)((byte)(n8 + 1 | 1)) : (int)((byte)(n8 + 2 & 0xFFFFFFFE))) < 62) {
                        byArray3[n5] = n7;
                        ++n5;
                        n8 = n12;
                        switch (by) {
                            case 2: 
                            case 6: {
                                n7 = (byte)(n12 | 0x80);
                                break block0;
                            }
                        }
                        n7 = n12;
                        break;
                    }
                    ++n6;
                    break;
                }
                case 7: {
                    byArray2[n11] = n10;
                    byArray[n11] = 14;
                    if (n6 == 0) {
                        if (n5 <= 0) break;
                        n7 = byArray3[--n5];
                        n8 = (byte)(n7 & 0x7F);
                        break;
                    }
                    --n6;
                    break;
                }
                case 15: {
                    n5 = 0;
                    n6 = 0;
                    n7 = n;
                    n8 = n;
                    n9 = n7;
                    byArray2[n11] = n10 = n8;
                    break;
                }
                case 14: {
                    byArray2[n11] = n10;
                    break;
                }
                default: {
                    int n12;
                    if (n9 != n7) {
                        if (n10 != n8) {
                            int n13;
                            n12 = Math.max(n10, n8);
                            byArray[n11 - 1] = n13 = (n12 & 1) == 0 ? 0 : 3;
                        }
                        n9 = n7;
                        n10 = (byte)(n9 & 0x7F);
                    }
                    byArray2[n11] = n10;
                    if (n10 == n9) break;
                    if ((n10 & 1) == 0) {
                        byArray[n11] = 0;
                        l |= 1L;
                        break;
                    }
                    byArray[n11] = 3;
                    l |= 8L;
                }
            }
            ++n11;
        }
        return l |= 0x4000L;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] createVisualToLogicalMap(byte[] var0) {
        var1_1 = var0.length;
        var2_2 = new int[var1_1];
        var3_3 = 63;
        var4_4 = 0;
        var5_5 = 0;
        while (var5_5 < var1_1) {
            var2_2[var5_5] = var5_5;
            var6_6 = var0[var5_5];
            if (var6_6 > var4_4) {
                var4_4 = var6_6;
            }
            if ((var6_6 & 1) != 0 && var6_6 < var3_3) {
                var3_3 = var6_6;
            }
            ++var5_5;
        }
        while (var4_4 >= var3_3) {
            var6_6 = 0;
            block2: while (true) {
                if (var6_6 < var1_1 && var0[var6_6] < var4_4) {
                    ++var6_6;
                    continue;
                }
                if ((var7_7 = var6_6++) != var0.length) ** GOTO lbl24
                break;
lbl-1000:
                // 1 sources

                {
                    ++var6_6;
lbl24:
                    // 2 sources

                    ** while (var6_6 < var1_1 && var0[var6_6] >= var4_4)
                }
lbl25:
                // 1 sources

                var8_8 = var6_6 - 1;
                while (true) {
                    if (var7_7 < var8_8) ** break;
                    continue block2;
                    var9_9 = var2_2[var7_7];
                    var2_2[var7_7] = var2_2[var8_8];
                    var2_2[var8_8] = var9_9;
                    ++var7_7;
                    --var8_8;
                }
                break;
            }
            var4_4 = (byte)(var4_4 - 1);
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] var0, Object[] var1_1) {
        var2_2 = var0.length;
        var3_3 = 63;
        var4_4 = 0;
        var5_5 = 0;
        while (var5_5 < var2_2) {
            var6_6 = var0[var5_5];
            if (var6_6 > var4_4) {
                var4_4 = var6_6;
            }
            if ((var6_6 & 1) != 0 && var6_6 < var3_3) {
                var3_3 = var6_6;
            }
            ++var5_5;
        }
        while (var4_4 >= var3_3) {
            var6_6 = 0;
            block2: while (true) {
                if (var6_6 < var2_2 && var0[var6_6] < var4_4) {
                    ++var6_6;
                    continue;
                }
                if ((var7_7 = var6_6++) != var0.length) ** GOTO lbl22
                break;
lbl-1000:
                // 1 sources

                {
                    ++var6_6;
lbl22:
                    // 2 sources

                    ** while (var6_6 < var2_2 && var0[var6_6] >= var4_4)
                }
lbl23:
                // 1 sources

                var8_8 = var6_6 - 1;
                while (true) {
                    if (var7_7 < var8_8) ** break;
                    continue block2;
                    var9_9 = var1_1[var7_7];
                    var1_1[var7_7] = var1_1[var8_8];
                    var1_1[var8_8] = var9_9;
                    ++var7_7;
                    --var8_8;
                }
                break;
            }
            var4_4 = (byte)(var4_4 - 1);
        }
    }

    public static int[] getInverseOrder(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[nArray[n]] = n;
            ++n;
        }
        return nArray2;
    }

    private static int[] computeContiguousOrder(int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[n2 - n];
        int n4 = 0;
        while (n4 < nArray2.length) {
            nArray2[n4] = n4 + n;
            ++n4;
        }
        int n5 = 0;
        while (n5 < nArray2.length - 1) {
            n3 = n5;
            int n6 = nArray[nArray2[n3]];
            int n7 = n5;
            while (n7 < nArray2.length) {
                if (nArray[nArray2[n7]] < n6) {
                    n3 = n7;
                    n6 = nArray[nArray2[n3]];
                }
                ++n7;
            }
            int n8 = nArray2[n5];
            nArray2[n5] = nArray2[n3];
            nArray2[n3] = n8;
            ++n5;
        }
        if (n != 0) {
            n3 = 0;
            while (n3 < nArray2.length) {
                int n9 = n3++;
                nArray2[n9] = nArray2[n9] - n;
            }
        }
        n3 = 0;
        while (n3 < nArray2.length) {
            if (nArray2[n3] != n3) break;
            ++n3;
        }
        if (n3 == nArray2.length) {
            return null;
        }
        return Bidi.getInverseOrder(nArray2);
    }

    public static int[] getContiguousOrder(int[] nArray) {
        if (nArray != null) {
            return Bidi.computeContiguousOrder(nArray, 0, nArray.length);
        }
        return null;
    }

    public static int[] getNormalizedOrder(int[] nArray, byte[] byArray, int n, int n2) {
        if (nArray != null) {
            if (n != 0 || n2 != nArray.length) {
                boolean bl;
                boolean bl2;
                byte by;
                if (byArray == null) {
                    by = 0;
                    bl2 = true;
                    bl = true;
                } else if (byArray[n] == byArray[n2 - 1]) {
                    by = byArray[n];
                    bl = (by & 1) == 0;
                    int n3 = n;
                    while (n3 < n2) {
                        if (byArray[n3] < by) break;
                        if (bl) {
                            bl = byArray[n3] == by;
                        }
                        ++n3;
                    }
                    bl2 = n3 == n2;
                } else {
                    bl2 = false;
                    by = 0;
                    bl = false;
                }
                if (bl2) {
                    if (bl) {
                        return null;
                    }
                    int[] nArray2 = new int[n2 - n];
                    int n4 = (by & 1) != 0 ? nArray[n2 - 1] : nArray[n];
                    if (n4 == 0) {
                        System.arraycopy(nArray, n, nArray2, 0, n2 - n);
                    } else {
                        int n5 = 0;
                        while (n5 < nArray2.length) {
                            nArray2[n5] = nArray[n5 + n] - n4;
                            ++n5;
                        }
                    }
                    return nArray2;
                }
                return Bidi.computeContiguousOrder(nArray, n, n2);
            }
            return nArray;
        }
        return null;
    }

    public static Bidi createBidi(char[] cArray) {
        return new Bidi(cArray);
    }

    static {
        dirIndices = Utilities.readRLE(dirIndices);
        dirValues = Utilities.readRLE(dirValues);
    }
}

