/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sun.awt.font.NativeFontWrapper;

public final class FontDesignMetrics
extends FontMetrics {
    static final long serialVersionUID = 4480069578560887773L;
    private static final float UNKNOWN_WIDTH = -1.0f;
    private static final int CURRENT_VERSION = 1;
    private Font font;
    private float ascent;
    private float descent;
    private float leading;
    private float maxAdvance;
    private double[] matrix;
    private int[] cache;
    private int serVersion = 0;
    private boolean isAntiAliased;
    private boolean usesFractionalMetrics;
    private AffineTransform frcTx;
    private transient float[] advCache;
    private transient int height = -1;
    private static FontRenderContext DEFAULT_FRC = null;

    private static FontRenderContext createDefaultFrc() {
        if (DEFAULT_FRC == null) {
            AffineTransform affineTransform = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
            DEFAULT_FRC = new FontRenderContext(affineTransform, false, false);
        }
        return DEFAULT_FRC;
    }

    public FontDesignMetrics(Font font) {
        this(font, FontDesignMetrics.createDefaultFrc());
    }

    public FontDesignMetrics(Font font, FontRenderContext fontRenderContext) {
        super(font);
        this.font = font;
        this.isAntiAliased = fontRenderContext.isAntiAliased();
        this.usesFractionalMetrics = fontRenderContext.usesFractionalMetrics();
        this.frcTx = fontRenderContext.getTransform();
        this.matrix = new double[4];
        this.initMatrixAndMetrics(fontRenderContext);
        this.initAdvCache();
    }

    private void initMatrixAndMetrics(FontRenderContext fontRenderContext) {
        float f = this.font.getSize2D();
        AffineTransform affineTransform = this.font.getTransform();
        affineTransform.scale(f, f);
        affineTransform.getMatrix(this.matrix);
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(this.font, this.matrix, this.isAntiAliased, this.usesFractionalMetrics, fArray);
        this.ascent = fArray[0];
        this.descent = fArray[1];
        this.leading = fArray[2];
        this.maxAdvance = fArray[3];
    }

    private void initAdvCache() {
        this.advCache = new float[256];
        int n = 32;
        while (n < 256) {
            this.advCache[n] = -1.0f;
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        FontRenderContext fontRenderContext;
        objectInputStream.defaultReadObject();
        if (this.serVersion != 1) {
            fontRenderContext = FontDesignMetrics.createDefaultFrc();
            this.isAntiAliased = fontRenderContext.isAntiAliased();
            this.usesFractionalMetrics = fontRenderContext.usesFractionalMetrics();
            this.frcTx = fontRenderContext.getTransform();
        } else {
            fontRenderContext = this.getFrc();
        }
        this.cache = null;
        this.initMatrixAndMetrics(fontRenderContext);
        this.initAdvCache();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.cache = new int[256];
        int n = 0;
        while (n < 256) {
            this.cache[n] = -1;
            ++n;
        }
        this.serVersion = 1;
        objectOutputStream.defaultWriteObject();
        this.cache = null;
    }

    private float handleCharWidth(char c) {
        return NativeFontWrapper.getAdvance(this.font, c, this.matrix, this.isAntiAliased, this.usesFractionalMetrics);
    }

    private float getLatinCharWidth(char c) {
        float f = this.advCache[c];
        if (f == -1.0f) {
            this.advCache[c] = f = this.handleCharWidth(c);
        }
        return f;
    }

    private FontRenderContext getFrc() {
        return new FontRenderContext(this.frcTx, this.isAntiAliased, this.usesFractionalMetrics);
    }

    public int charWidth(char c) {
        float f = (c & 0xFF) == c ? this.getLatinCharWidth(c) : this.handleCharWidth(c);
        return (int)(0.5 + (double)f);
    }

    public int stringWidth(String string) {
        int n = string.length();
        float f = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if ((c & 0xFF) == c) {
                f += this.getLatinCharWidth(c);
            } else {
                if (c >= '\u0600' && c < '\u0e80') {
                    f = new TextLayout(string, this.font, this.getFrc()).getAdvance();
                    break;
                }
                f += this.handleCharWidth(c);
            }
            ++n2;
        }
        return (int)(0.5 + (double)f);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        float f = 0.0f;
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if ((c & 0xFF) == c) {
                f += this.getLatinCharWidth(c);
            } else {
                if (c >= '\u0600' && c < '\u0e80') {
                    String string = new String(cArray, n, n2);
                    f = new TextLayout(string, this.font, this.getFrc()).getAdvance();
                    break;
                }
                f += this.handleCharWidth(c);
            }
            ++n4;
        }
        return (int)(0.5 + (double)f);
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        char c = '\u0000';
        while (c < '\u0100') {
            float f = this.advCache[c];
            if (f == -1.0f) {
                f = this.advCache[c] = this.handleCharWidth(c);
            }
            nArray[c] = (int)(0.5 + (double)f);
            c = (char)(c + '\u0001');
        }
        return nArray;
    }

    public int getMaxAdvance() {
        return (int)(0.9999 + (double)this.maxAdvance);
    }

    public int getAscent() {
        return (int)(0.9999 + (double)this.ascent);
    }

    public int getDescent() {
        return (int)(0.9999 + (double)this.descent);
    }

    public int getLeading() {
        return (int)(0.9999 + (double)this.leading);
    }

    public int getHeight() {
        if (this.height < 0) {
            this.height = this.getAscent() + this.getDescent() + this.getLeading();
        }
        return this.height;
    }
}

