/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

public final class ScriptRun {
    static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999 - All Rights Reserved";
    private char[] charArray;
    private int charStart;
    private int charLimit;
    private int scriptStart;
    private int scriptEnd;
    private int scriptCode;
    static final int UNASSIGNED = -1;
    static final int NEUTRAL = 0;
    static final int LATIN = 1;
    static final int GREEK = 2;
    static final int CYRILLIC = 3;
    static final int ARMENIAN = 4;
    static final int HEBREW = 5;
    static final int ARABIC = 6;
    static final int DEVANAGARI = 7;
    static final int BENGALI = 8;
    static final int GURMUKHI = 9;
    static final int GUJARATI = 10;
    static final int ORIYA = 11;
    static final int TAMIL = 12;
    static final int TELUGU = 13;
    static final int KANNADA = 14;
    static final int MALAYALAM = 15;
    static final int THAI = 16;
    static final int LAO = 17;
    static final int TIBETAN = 18;
    static final int GEORGIAN = 19;
    static final int HANGUL = 20;
    static final int KANA = 21;
    static final int BOPOMOFO = 22;
    static final int KANBUN = 23;
    static final int HAN_IDEOGRAPHS = 24;
    static final int SURROGATES = 25;
    static final int PRIVATE_USE = 26;
    static final int SPECIALS = 27;
    static final int N_SCRIPTS = 28;
    private static final char[] blockStarts = new char[]{'\u0000', '\u0080', '\u0100', '\u0180', '\u0250', '\u02b0', '\u0300', '\u0370', '\u0400', '\u0500', '\u0530', '\u0590', '\u0600', '\u0700', '\u0900', '\u0980', '\u0a00', '\u0a80', '\u0b00', '\u0b80', '\u0c00', '\u0c80', '\u0d00', '\u0d80', '\u0e00', '\u0e80', '\u0f00', '\u0fc0', '\u10a0', '\u1100', '\u1200', '\u1e00', '\u1f00', '\u2000', '\u2070', '\u20a0', '\u20d0', '\u2100', '\u2150', '\u2190', '\u2200', '\u2300', '\u2400', '\u2440', '\u2460', '\u2500', '\u2580', '\u25a0', '\u2600', '\u2700', '\u27c0', '\u3000', '\u3040', '\u30a0', '\u3100', '\u3130', '\u3190', '\u3200', '\u3300', '\u3400', '\u4e00', '\ua000', '\uac00', '\ud7a4', '\ud800', '\ue000', '\uf900', '\ufb00', '\ufb50', '\ufe00', '\ufe20', '\ufe30', '\ufe50', '\ufe70', '\ufeff', '\uff00', '\uff60', '\uff65', '\uffa0', '\uffe0', '\ufff0'};
    private static final int[] blockScripts = new int[]{1, 1, 1, 1, 1, 0, 0, 2, 3, -1, 4, 5, 6, -1, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, 16, 17, 18, -1, 19, 20, -1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 21, 21, 22, 20, 23, 24, 24, -1, 24, -1, 20, -1, 25, 26, 24, 0, 6, -1, 0, 24, 0, 6, 27, 1, 0, 21, 20, 0, 27};
    private static final int blockStartsPower = 1 << ScriptRun.highBit(blockStarts.length);
    private static final int blockStartsExtra = blockStarts.length - blockStartsPower;
    private static String[] scriptNames = new String[]{"NEUT", "latn", "grek", "cyrl", "armn", "hebr", "arab", "deva", "beng", "punj", "gujr", "orya", "taml", "telu", "knda", "mlym", "thai", "lao ", "tibt", "grgn", "hang", "kana", "bpmf", "knbn", "hani", "SURR", "PUSE", "SPCL"};

    private static final byte highBit(int n) {
        if (n <= 0) {
            return -32;
        }
        byte by = 0;
        if (n >= 65536) {
            n >>= 16;
            by = (byte)(by + 16);
        }
        if (n >= 256) {
            n >>= 8;
            by = (byte)(by + 8);
        }
        if (n >= 16) {
            n >>= 4;
            by = (byte)(by + 4);
        }
        if (n >= 4) {
            n >>= 2;
            by = (byte)(by + 2);
        }
        if (n >= 2) {
            n >>= 1;
            by = (byte)(by + 1);
        }
        return by;
    }

    private static int getScriptCode(char c) {
        int n = blockStartsPower;
        int n2 = 0;
        if (c >= blockStarts[blockStartsExtra]) {
            n2 = blockStartsExtra;
        }
        while (n > 1) {
            if (c < blockStarts[n2 + (n >>= 1)]) continue;
            n2 += n;
        }
        return blockScripts[n2];
    }

    private static boolean isNeutral(char c, int n) {
        int n2 = Character.getType(c);
        switch (n2) {
            case 6: 
            case 7: 
            case 8: {
                return n == 1 || n == 0;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    private boolean charInSameScript(int n, boolean bl) {
        return n == 0 || n == -1 || this.scriptCode == 0 || this.scriptCode == -1 || this.scriptCode == n || bl;
    }

    public ScriptRun() {
        this.reset(null, 0, 0);
    }

    public ScriptRun(char[] cArray) {
        this.reset(cArray, 0, cArray.length);
    }

    public ScriptRun(char[] cArray, int n, int n2) {
        this.reset(cArray, n, n2);
    }

    public final int getCharStart() {
        return this.charStart;
    }

    public final int getCharCount() {
        return this.charLimit - this.charStart;
    }

    public final char[] getCharArray() {
        return this.charArray;
    }

    public final int getScriptStart() {
        return this.scriptStart;
    }

    public final int getScriptEnd() {
        return this.scriptEnd;
    }

    public final int getScriptTag() {
        return this.scriptCode;
    }

    public final void reset() {
        this.scriptStart = this.charStart;
        this.scriptEnd = this.charStart;
        this.scriptCode = -1;
    }

    public final void reset(int n, int n2) {
        this.charStart = n;
        this.charLimit = n + n2;
        this.reset();
    }

    public final void reset(char[] cArray, int n, int n2) {
        this.charArray = cArray;
        this.reset(n, n2);
    }

    public boolean next() {
        if (this.scriptEnd >= this.charLimit) {
            return false;
        }
        int n = -1;
        this.scriptCode = -1;
        this.scriptStart = this.scriptEnd;
        while (this.scriptEnd < this.charLimit) {
            boolean bl;
            char c = this.charArray[this.scriptEnd];
            int n2 = ScriptRun.getScriptCode(c);
            if (!this.charInSameScript(n2, bl = ScriptRun.isNeutral(c, n2))) break;
            if (this.scriptCode == 0 || this.scriptCode == -1) {
                if (bl) {
                    if (n2 != 0 && n2 != -1 && n == -1) {
                        n = n2;
                    }
                } else {
                    this.scriptCode = n2;
                }
            }
            ++this.scriptEnd;
        }
        if (this.scriptCode == -1 && n != -1) {
            this.scriptCode = n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        String string = " \u0946\u0939\u093f\u0928\u094d\u0926\u0940 \u0645\u0627\u0643\u0646\u062a\u0648\u0634 \u0420\u0443\u0441\u0441\u043a\u0438\u0439 English \u6f22\u5b75\u3068\u3072\u3089\u304c\u306a\u3068\u30ab\u30bf\u30ab\u30ca";
        char[] cArray = string.toCharArray();
        ScriptRun scriptRun = new ScriptRun(cArray, 0, cArray.length);
        while (scriptRun.next()) {
            int n = scriptRun.getScriptStart();
            int n2 = scriptRun.getScriptEnd();
            String string2 = scriptNames[scriptRun.getScriptTag()];
            System.out.println("Script '" + string2 + "' from " + n + " to " + n2);
        }
    }
}

