/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.im.spi.InputMethod;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import sun.awt.im.CompositionArea;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.awt.im.InputMethodWindow;

public class InputContext
extends java.awt.im.InputContext
implements ComponentListener,
WindowListener {
    private InputMethodLocator inputMethodLocator;
    private InputMethod inputMethod;
    private boolean inputMethodCreationFailed;
    private HashMap usedInputMethods;
    private Component currentClientComponent;
    private Component awtFocussedComponent;
    private boolean isInputMethodActive;
    private Character.Subset[] characterSubsets = null;
    private int suppressDeactivateCount;
    private static InputContext inputMethodWindowContext;
    private static InputMethod previousInputMethod;
    private boolean clientWindowNotificationEnabled = false;
    private Window clientWindowListened;
    private Rectangle clientWindowLocation = null;
    private HashMap perInputMethodState;

    protected InputContext() {
        this.selectInputMethod(Locale.getDefault());
    }

    public synchronized boolean selectInputMethod(Locale locale) {
        InputMethodLocator inputMethodLocator;
        if (locale == null) {
            throw new NullPointerException();
        }
        if (this.inputMethod != null) {
            if (this.inputMethod.setLocale(locale)) {
                return true;
            }
        } else if (this.inputMethodLocator != null && this.inputMethodLocator.isLocaleAvailable(locale)) {
            this.inputMethodLocator = this.inputMethodLocator.deriveLocator(locale);
            return true;
        }
        if ((inputMethodLocator = InputMethodManager.getInstance().findInputMethod(locale)) != null) {
            this.changeInputMethod(inputMethodLocator);
            return true;
        }
        if (this.inputMethod == null && this.inputMethodLocator != null) {
            this.inputMethod = this.getInputMethod();
            if (this.inputMethod != null) {
                return this.inputMethod.setLocale(locale);
            }
        }
        return false;
    }

    public Locale getLocale() {
        if (this.inputMethod != null) {
            return this.inputMethod.getLocale();
        }
        if (this.inputMethodLocator != null) {
            return this.inputMethodLocator.getLocale();
        }
        return null;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        if (subsetArray == null) {
            this.characterSubsets = null;
        } else {
            this.characterSubsets = new Character.Subset[subsetArray.length];
            System.arraycopy(subsetArray, 0, this.characterSubsets, 0, this.characterSubsets.length);
        }
        if (this.inputMethod != null) {
            this.inputMethod.setCharacterSubsets(subsetArray);
        }
    }

    public synchronized void reconvert() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            throw new UnsupportedOperationException();
        }
        inputMethod.reconvert();
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputMethodEvent) {
            return;
        }
        InputMethod inputMethod = this.getInputMethod();
        int n = aWTEvent.getID();
        switch (n) {
            case 1004: {
                this.focusGained((Component)aWTEvent.getSource());
                break;
            }
            case 1005: {
                this.focusLost((Component)aWTEvent.getSource(), ((FocusEvent)aWTEvent).isTemporary());
                break;
            }
            default: {
                if (inputMethod == null || !(aWTEvent instanceof InputEvent)) break;
                inputMethod.dispatchEvent(aWTEvent);
            }
        }
    }

    private void focusGained(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            InputContext inputContext = this;
            synchronized (inputContext) {
                if (!(component instanceof CompositionArea) && !(InputContext.getComponentWindow(component) instanceof InputMethodWindow)) {
                    if (this.inputMethod != null && this.currentClientComponent != null && this.currentClientComponent != component) {
                        if (!this.isInputMethodActive) {
                            this.activateInputMethod(false);
                        }
                        this.endComposition();
                        this.deactivateInputMethod(false);
                    }
                    this.currentClientComponent = component;
                }
                this.awtFocussedComponent = component;
                if (this.inputMethod instanceof InputMethodAdapter) {
                    ((InputMethodAdapter)this.inputMethod).setAWTFocussedComponent(component);
                }
                if (!this.isInputMethodActive) {
                    this.activateInputMethod(true);
                }
            }
        }
    }

    private void activateInputMethod(boolean bl) {
        if (inputMethodWindowContext != null && inputMethodWindowContext != this && InputContext.inputMethodWindowContext.inputMethodLocator != null && !InputContext.inputMethodWindowContext.inputMethodLocator.sameInputMethod(this.inputMethodLocator) && InputContext.inputMethodWindowContext.inputMethod != null) {
            InputContext.inputMethodWindowContext.inputMethod.hideWindows();
        }
        inputMethodWindowContext = this;
        if (this.inputMethod != null) {
            Boolean bl2;
            if (previousInputMethod != this.inputMethod && previousInputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)previousInputMethod).stopListening();
            }
            previousInputMethod = null;
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setClientComponent(this.currentClientComponent);
            }
            this.inputMethod.activate();
            this.isInputMethodActive = true;
            if (this.perInputMethodState != null && (bl2 = (Boolean)this.perInputMethodState.remove(this.inputMethod)) != null) {
                this.clientWindowNotificationEnabled = bl2;
            }
            if (this.clientWindowNotificationEnabled) {
                if (!this.addedClientWindowListeners()) {
                    this.addClientWindowListeners();
                }
                this.notifyClientWindowChange(this.clientWindowListened);
            } else if (this.addedClientWindowListeners()) {
                this.removeClientWindowListeners();
            }
        }
        InputMethodManager.getInstance().setInputContext(this);
        ((InputMethodContext)this).grabCompositionArea(bl);
    }

    static Window getComponentWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private void focusLost(Component component, boolean bl) {
        Object object = component.getTreeLock();
        synchronized (object) {
            InputContext inputContext = this;
            synchronized (inputContext) {
                boolean bl2;
                boolean bl3 = bl2 = this.suppressDeactivateCount > 0;
                if (bl2) {
                    --this.suppressDeactivateCount;
                }
                if (this.isInputMethodActive && !bl2) {
                    this.deactivateInputMethod(bl);
                }
                this.awtFocussedComponent = null;
                if (this.inputMethod instanceof InputMethodAdapter) {
                    ((InputMethodAdapter)this.inputMethod).setAWTFocussedComponent(null);
                }
            }
        }
    }

    private void deactivateInputMethod(boolean bl) {
        InputMethodManager.getInstance().setInputContext(null);
        if (this.inputMethod != null) {
            this.isInputMethodActive = false;
            this.inputMethod.deactivate(bl);
            previousInputMethod = this.inputMethod;
        }
    }

    synchronized void changeInputMethod(InputMethodLocator inputMethodLocator) {
        if (this.inputMethodLocator == null) {
            this.inputMethodLocator = inputMethodLocator;
            this.inputMethodCreationFailed = false;
            return;
        }
        if (this.inputMethodLocator.sameInputMethod(inputMethodLocator)) {
            Locale locale = inputMethodLocator.getLocale();
            if (locale != null && this.inputMethodLocator.getLocale() != locale) {
                if (this.inputMethod != null) {
                    this.inputMethod.setLocale(locale);
                }
                this.inputMethodLocator = inputMethodLocator;
            }
            return;
        }
        Locale locale = this.inputMethodLocator.getLocale();
        boolean bl = this.isInputMethodActive;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.inputMethod != null) {
            try {
                bl3 = this.inputMethod.isCompositionEnabled();
                bl2 = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (this.currentClientComponent != null) {
                if (!this.isInputMethodActive) {
                    this.activateInputMethod(false);
                }
                this.endComposition();
                this.deactivateInputMethod(false);
                if (this.inputMethod instanceof InputMethodAdapter) {
                    ((InputMethodAdapter)this.inputMethod).setClientComponent(null);
                }
            }
            locale = this.inputMethod.getLocale();
            if (this.usedInputMethods == null) {
                this.usedInputMethods = new HashMap(5);
            }
            if (this.perInputMethodState == null) {
                this.perInputMethodState = new HashMap(5);
            }
            this.usedInputMethods.put(this.inputMethodLocator.deriveLocator(null), this.inputMethod);
            this.perInputMethodState.put(this.inputMethod, new Boolean(this.clientWindowNotificationEnabled));
            this.enableClientWindowNotification(this.inputMethod, false);
            if (this == inputMethodWindowContext) {
                this.inputMethod.hideWindows();
                inputMethodWindowContext = null;
            }
            this.inputMethodLocator = null;
            this.inputMethod = null;
            this.inputMethodCreationFailed = false;
        }
        if (inputMethodLocator.getLocale() == null && locale != null && inputMethodLocator.isLocaleAvailable(locale)) {
            inputMethodLocator = inputMethodLocator.deriveLocator(locale);
        }
        this.inputMethodLocator = inputMethodLocator;
        this.inputMethodCreationFailed = false;
        if (bl) {
            this.inputMethod = this.getInputMethodInstance();
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setAWTFocussedComponent(this.awtFocussedComponent);
            }
            this.activateInputMethod(true);
        }
        if (bl2) {
            this.inputMethod = this.getInputMethod();
            if (this.inputMethod != null) {
                try {
                    this.inputMethod.setCompositionEnabled(bl3);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    Component getClientComponent() {
        return this.currentClientComponent;
    }

    public synchronized void removeNotify(Component component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (this.inputMethod == null) {
            if (component == this.currentClientComponent) {
                this.currentClientComponent = null;
            }
            return;
        }
        if (component == this.awtFocussedComponent) {
            this.focusLost(component, false);
        }
        if (component == this.currentClientComponent) {
            if (this.isInputMethodActive) {
                this.deactivateInputMethod(false);
            }
            this.inputMethod.removeNotify();
            if (this.clientWindowNotificationEnabled && this.addedClientWindowListeners()) {
                this.removeClientWindowListeners();
            }
            this.currentClientComponent = null;
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setClientComponent(null);
            }
            ((InputMethodContext)this).releaseCompositionArea();
        }
    }

    public void dispose() {
        if (this.currentClientComponent != null) {
            this.removeNotify(this.currentClientComponent);
        }
        if (this.currentClientComponent != null) {
            throw new IllegalStateException("Can't dispose InputContext while it's active");
        }
        if (this.inputMethod != null) {
            if (this == inputMethodWindowContext) {
                this.inputMethod.hideWindows();
                inputMethodWindowContext = null;
            }
            if (this.inputMethod == previousInputMethod) {
                previousInputMethod = null;
            }
            if (this.clientWindowNotificationEnabled) {
                if (this.addedClientWindowListeners()) {
                    this.removeClientWindowListeners();
                }
                this.clientWindowNotificationEnabled = false;
            }
            this.inputMethod.dispose();
            if (this.clientWindowNotificationEnabled) {
                this.enableClientWindowNotification(this.inputMethod, false);
            }
            this.inputMethod = null;
        }
        this.inputMethodLocator = null;
        if (this.usedInputMethods != null && !this.usedInputMethods.isEmpty()) {
            Iterator iterator = this.usedInputMethods.values().iterator();
            this.usedInputMethods = null;
            while (iterator.hasNext()) {
                ((InputMethod)iterator.next()).dispose();
            }
        }
        this.clientWindowNotificationEnabled = false;
        this.clientWindowListened = null;
        this.perInputMethodState = null;
    }

    public synchronized Object getInputMethodControlObject() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod != null) {
            return inputMethod.getControlObject();
        }
        return null;
    }

    public void setCompositionEnabled(boolean bl) {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            throw new UnsupportedOperationException();
        }
        inputMethod.setCompositionEnabled(bl);
    }

    public boolean isCompositionEnabled() {
        InputMethod inputMethod = this.getInputMethod();
        if (inputMethod == null) {
            throw new UnsupportedOperationException();
        }
        return inputMethod.isCompositionEnabled();
    }

    private synchronized InputMethod getInputMethod() {
        if (this.inputMethod != null) {
            return this.inputMethod;
        }
        if (this.inputMethodCreationFailed) {
            return null;
        }
        this.inputMethod = this.getInputMethodInstance();
        return this.inputMethod;
    }

    private InputMethod getInputMethodInstance() {
        InputMethodLocator inputMethodLocator = this.inputMethodLocator;
        if (inputMethodLocator == null) {
            this.inputMethodCreationFailed = true;
            return null;
        }
        Locale locale = inputMethodLocator.getLocale();
        InputMethod inputMethod = null;
        if (this.usedInputMethods != null && (inputMethod = (InputMethod)this.usedInputMethods.remove(inputMethodLocator.deriveLocator(null))) != null) {
            if (locale != null) {
                inputMethod.setLocale(locale);
            }
            inputMethod.setCharacterSubsets(this.characterSubsets);
            Boolean bl = (Boolean)this.perInputMethodState.remove(inputMethod);
            if (bl != null) {
                this.enableClientWindowNotification(inputMethod, bl);
            }
            ((InputMethodContext)this).setInputMethodSupportsBelowTheSpot(!(inputMethod instanceof InputMethodAdapter) || ((InputMethodAdapter)inputMethod).supportsBelowTheSpot());
            return inputMethod;
        }
        try {
            inputMethod = inputMethodLocator.getDescriptor().createInputMethod();
            if (locale != null) {
                inputMethod.setLocale(locale);
            }
            inputMethod.setInputMethodContext((InputMethodContext)this);
            inputMethod.setCharacterSubsets(this.characterSubsets);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.inputMethodCreationFailed = true;
            if (inputMethod != null) {
                inputMethod = null;
            }
        }
        catch (LinkageError linkageError) {
            linkageError.printStackTrace();
            this.inputMethodCreationFailed = true;
        }
        ((InputMethodContext)this).setInputMethodSupportsBelowTheSpot(!(inputMethod instanceof InputMethodAdapter) || ((InputMethodAdapter)inputMethod).supportsBelowTheSpot());
        return inputMethod;
    }

    InputMethodLocator getInputMethodLocator() {
        if (this.inputMethod != null) {
            return this.inputMethodLocator.deriveLocator(this.inputMethod.getLocale());
        }
        return this.inputMethodLocator;
    }

    public synchronized void suppressFocusChange() {
        ++this.suppressDeactivateCount;
    }

    public synchronized void endComposition() {
        if (this.inputMethod != null) {
            this.inputMethod.endComposition();
        }
    }

    synchronized void enableClientWindowNotification(InputMethod inputMethod, boolean bl) {
        if (inputMethod != this.inputMethod) {
            if (this.perInputMethodState == null) {
                this.perInputMethodState = new HashMap(5);
            }
            this.perInputMethodState.put(inputMethod, new Boolean(bl));
            return;
        }
        if (this.clientWindowNotificationEnabled != bl) {
            this.clientWindowLocation = null;
            this.clientWindowNotificationEnabled = bl;
        }
        if (this.clientWindowNotificationEnabled) {
            if (!this.addedClientWindowListeners()) {
                this.addClientWindowListeners();
            }
            if (this.clientWindowListened != null) {
                this.clientWindowLocation = null;
                this.notifyClientWindowChange(this.clientWindowListened);
            }
        } else if (this.addedClientWindowListeners()) {
            this.removeClientWindowListeners();
        }
    }

    private synchronized void notifyClientWindowChange(Window window) {
        if (this.inputMethod == null) {
            return;
        }
        if (!window.isVisible() || window instanceof Frame && ((Frame)window).getState() == 1) {
            this.clientWindowLocation = null;
            this.inputMethod.notifyClientWindowChange(null);
            return;
        }
        Rectangle rectangle = window.getBounds();
        if (this.clientWindowLocation == null || !this.clientWindowLocation.equals(rectangle)) {
            this.clientWindowLocation = rectangle;
            this.inputMethod.notifyClientWindowChange(this.clientWindowLocation);
        }
    }

    private synchronized void addClientWindowListeners() {
        Component component = this.getClientComponent();
        if (component == null) {
            return;
        }
        Window window = InputContext.getComponentWindow(component);
        if (window == null) {
            return;
        }
        window.addComponentListener(this);
        window.addWindowListener(this);
        this.clientWindowListened = window;
    }

    private synchronized void removeClientWindowListeners() {
        this.clientWindowListened.removeComponentListener(this);
        this.clientWindowListened.removeWindowListener(this);
        this.clientWindowListened = null;
    }

    private boolean addedClientWindowListeners() {
        return this.clientWindowListened != null;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.notifyClientWindowChange((Window)componentEvent.getComponent());
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.notifyClientWindowChange(windowEvent.getWindow());
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.notifyClientWindowChange(windowEvent.getWindow());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static {
        previousInputMethod = null;
    }
}

