/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.image.GifImageDecoder;
import sun.awt.image.ImageConsumerQueue;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetchable;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.JPEGImageDecoder;
import sun.awt.image.PNGImageDecoder;
import sun.awt.image.PixelStore;
import sun.awt.image.XbmImageDecoder;

public abstract class InputStreamImageSource
implements ImageProducer,
ImageFetchable {
    PixelStore pixelstore;
    ImageConsumerQueue consumers;
    ImageDecoder decoder;
    ImageDecoder decoders;
    boolean awaitingFetch = false;

    abstract boolean checkSecurity(Object var1, boolean var2);

    int countConsumers(ImageConsumerQueue imageConsumerQueue) {
        int n = 0;
        while (imageConsumerQueue != null) {
            ++n;
            imageConsumerQueue = imageConsumerQueue.next;
        }
        return n;
    }

    synchronized int countConsumers() {
        ImageDecoder imageDecoder = this.decoders;
        int n = this.countConsumers(this.consumers);
        while (imageDecoder != null) {
            n += this.countConsumers(imageDecoder.queue);
            imageDecoder = imageDecoder.next;
        }
        return n;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, false);
    }

    synchronized void printQueue(ImageConsumerQueue imageConsumerQueue, String string) {
        while (imageConsumerQueue != null) {
            System.out.println(string + imageConsumerQueue);
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    synchronized void printQueues(String string) {
        System.out.println(string + "[ -----------");
        this.printQueue(this.consumers, "  ");
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            System.out.println("    " + imageDecoder);
            this.printQueue(imageDecoder.queue, "      ");
            imageDecoder = imageDecoder.next;
        }
        System.out.println("----------- ]" + string);
    }

    synchronized void addConsumer(ImageConsumer imageConsumer, boolean bl) {
        this.checkSecurity(null, false);
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                return;
            }
            imageDecoder = imageDecoder.next;
        }
        ImageConsumerQueue imageConsumerQueue = this.consumers;
        while (imageConsumerQueue != null && imageConsumerQueue.consumer != imageConsumer) {
            imageConsumerQueue = imageConsumerQueue.next;
        }
        if (imageConsumerQueue == null) {
            imageConsumerQueue = new ImageConsumerQueue(this, imageConsumer);
            imageConsumerQueue.next = this.consumers;
            this.consumers = imageConsumerQueue;
        } else {
            if (!imageConsumerQueue.secure) {
                Object object = null;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    object = securityManager.getSecurityContext();
                }
                if (imageConsumerQueue.securityContext == null) {
                    imageConsumerQueue.securityContext = object;
                } else if (!imageConsumerQueue.securityContext.equals(object)) {
                    this.errorConsumer(imageConsumerQueue);
                    throw new SecurityException("Applets are trading image data!");
                }
            }
            imageConsumerQueue.interested = true;
        }
        if (bl && this.decoder == null) {
            this.startProduction();
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                return true;
            }
            imageDecoder = imageDecoder.next;
        }
        return ImageConsumerQueue.isConsumer(this.consumers, imageConsumer);
    }

    private void errorAllConsumers(ImageConsumerQueue imageConsumerQueue) {
        while (imageConsumerQueue != null) {
            if (imageConsumerQueue.interested) {
                this.errorConsumer(imageConsumerQueue);
            }
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    private void errorConsumer(ImageConsumerQueue imageConsumerQueue) {
        imageConsumerQueue.consumer.imageComplete(1);
        this.removeConsumer(imageConsumerQueue.consumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            imageDecoder.removeConsumer(imageConsumer);
            imageDecoder = imageDecoder.next;
        }
        this.consumers = ImageConsumerQueue.removeConsumer(this.consumers, imageConsumer, false);
        if (this.consumers == null) {
            this.stopProduction();
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, true);
    }

    private synchronized void startProduction() {
        if (!this.awaitingFetch) {
            ImageFetcher.add(this);
            this.awaitingFetch = true;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void stopProduction() {
        if (this.awaitingFetch) {
            ImageFetcher.remove(this);
            this.awaitingFetch = false;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                imageDecoder.replayConsumer(imageConsumer);
            }
            imageDecoder = imageDecoder.next;
        }
    }

    protected abstract ImageDecoder getDecoder();

    protected ImageDecoder decoderForType(InputStream inputStream, String string) {
        return null;
    }

    protected ImageDecoder getDecoder(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(8);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            inputStream.reset();
            inputStream.mark(-1);
            if (n == 71 && n2 == 73 && n3 == 70 && n4 == 56) {
                return new GifImageDecoder(this, inputStream);
            }
            if (n == 255 && n2 == 216 && n3 == 255) {
                return new JPEGImageDecoder(this, inputStream);
            }
            if (n == 35 && n2 == 100 && n3 == 101 && n4 == 102) {
                return new XbmImageDecoder(this, inputStream);
            }
            if (n == 137 && n2 == 80 && n3 == 78 && n4 == 71 && n5 == 13 && n6 == 10 && n7 == 26 && n8 == 10) {
                return new PNGImageDecoder(this, inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void doFetch() {
        block11: {
            this.updateFromStore();
            InputStreamImageSource inputStreamImageSource = this;
            synchronized (inputStreamImageSource) {
                if (this.consumers == null) {
                    this.awaitingFetch = false;
                    return;
                }
            }
            ImageDecoder imageDecoder = this.getDecoder();
            if (imageDecoder == null) {
                this.badDecoder();
            } else {
                this.setDecoder(imageDecoder);
                try {
                    try {
                        imageDecoder.produceImage();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var6_5 = null;
                        this.removeDecoder(imageDecoder);
                        this.errorAllConsumers(imageDecoder.queue);
                        break block11;
                    }
                    catch (ImageFormatException imageFormatException) {
                        imageFormatException.printStackTrace();
                        Object var6_6 = null;
                        this.removeDecoder(imageDecoder);
                        this.errorAllConsumers(imageDecoder.queue);
                    }
                    Object var6_4 = null;
                    this.removeDecoder(imageDecoder);
                    this.errorAllConsumers(imageDecoder.queue);
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.removeDecoder(imageDecoder);
                    this.errorAllConsumers(imageDecoder.queue);
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean updateFromStore() {
        InputStreamImageSource inputStreamImageSource = this;
        // MONITORENTER : inputStreamImageSource
        PixelStore pixelStore = this.pixelstore;
        if (pixelStore == null) {
            boolean bl = false;
            // MONITOREXIT : inputStreamImageSource
            return bl;
        }
        ImageConsumerQueue imageConsumerQueue = this.consumers;
        // MONITOREXIT : inputStreamImageSource
        while (imageConsumerQueue != null) {
            InputStreamImageSource inputStreamImageSource2 = this;
            // MONITORENTER : inputStreamImageSource2
            if (!imageConsumerQueue.interested) {
                imageConsumerQueue = imageConsumerQueue.next;
                // MONITOREXIT : inputStreamImageSource2
                continue;
            }
            boolean bl = this.checkSecurity(imageConsumerQueue.securityContext, true);
            // MONITOREXIT : inputStreamImageSource2
            if (bl) {
                if (!pixelStore.replay(this, imageConsumerQueue.consumer)) {
                    return false;
                }
            } else {
                this.errorConsumer(imageConsumerQueue);
            }
            InputStreamImageSource inputStreamImageSource3 = this;
            // MONITORENTER : inputStreamImageSource3
            imageConsumerQueue = imageConsumerQueue.next;
            // MONITOREXIT : inputStreamImageSource3
        }
        return true;
    }

    private void badDecoder() {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            imageConsumerQueue = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
        }
        this.errorAllConsumers(imageConsumerQueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDecoder(ImageDecoder imageDecoder) {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            imageDecoder.next = this.decoders;
            this.decoders = imageDecoder;
            this.decoder = imageDecoder;
            imageDecoder.queue = imageConsumerQueue = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
        }
        while (imageConsumerQueue != null) {
            if (imageConsumerQueue.interested && !this.checkSecurity(imageConsumerQueue.securityContext, true)) {
                this.errorConsumer(imageConsumerQueue);
            }
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    private synchronized void removeDecoder(ImageDecoder imageDecoder) {
        this.doneDecoding(imageDecoder);
        ImageDecoder imageDecoder2 = null;
        ImageDecoder imageDecoder3 = this.decoders;
        while (imageDecoder3 != null) {
            if (imageDecoder3 == imageDecoder) {
                if (imageDecoder2 == null) {
                    this.decoders = imageDecoder3.next;
                    break;
                }
                imageDecoder2.next = imageDecoder3.next;
                break;
            }
            imageDecoder2 = imageDecoder3;
            imageDecoder3 = imageDecoder3.next;
        }
    }

    synchronized void doneDecoding(ImageDecoder imageDecoder) {
        if (this.decoder == imageDecoder) {
            this.decoder = null;
            if (this.consumers != null) {
                this.startProduction();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void latchConsumers(ImageDecoder imageDecoder) {
        InputStreamImageSource inputStreamImageSource = this;
        // MONITORENTER : inputStreamImageSource
        if (imageDecoder != this.decoder) {
            // MONITOREXIT : inputStreamImageSource
            return;
        }
        ImageConsumerQueue imageConsumerQueue = this.consumers;
        // MONITOREXIT : inputStreamImageSource
        while (imageConsumerQueue != null) {
            InputStreamImageSource inputStreamImageSource2;
            InputStreamImageSource inputStreamImageSource3 = this;
            // MONITORENTER : inputStreamImageSource3
            if (!imageConsumerQueue.interested) {
                imageConsumerQueue = imageConsumerQueue.next;
                // MONITOREXIT : inputStreamImageSource3
                continue;
            }
            // MONITOREXIT : inputStreamImageSource3
            if (!imageDecoder.catchupConsumer(this, imageConsumerQueue.consumer)) {
                inputStreamImageSource2 = this;
                // MONITORENTER : inputStreamImageSource2
                this.doneDecoding(imageDecoder);
                // MONITOREXIT : inputStreamImageSource2
                return;
            }
            inputStreamImageSource2 = this;
            // MONITORENTER : inputStreamImageSource2
            ImageConsumerQueue imageConsumerQueue2 = imageConsumerQueue.next;
            if (imageConsumerQueue.interested) {
                this.consumers = ImageConsumerQueue.removeConsumer(this.consumers, imageConsumerQueue.consumer, true);
                imageConsumerQueue.next = imageDecoder.queue;
                imageDecoder.queue = imageConsumerQueue;
            }
            imageConsumerQueue = imageConsumerQueue2;
            // MONITOREXIT : inputStreamImageSource2
        }
    }

    synchronized void flush() {
        this.pixelstore = null;
        this.decoder = null;
    }

    synchronized void setPixelStore(ImageDecoder imageDecoder, PixelStore pixelStore) {
        if (imageDecoder == this.decoder) {
            this.pixelstore = pixelStore;
        }
    }
}

