/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.peer.CheckboxPeer;
import sun.awt.SunToolkit;
import sun.awt.motif.MComponentPeer;

public class MCheckboxPeer
extends MComponentPeer
implements CheckboxPeer {
    static final int SIZE = 19;
    static final int BORDER = 4;
    static final int SIZ = 10;

    native void create(MComponentPeer var1);

    public native void setLabel(String var1);

    void initialize() {
        Checkbox checkbox = (Checkbox)this.target;
        this.setState(checkbox.getState());
        this.setCheckboxGroup(checkbox.getCheckboxGroup());
        super.initialize();
    }

    public MCheckboxPeer(Checkbox checkbox) {
        super(checkbox);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public native void setState(boolean var1);

    public native void setCheckboxGroup(CheckboxGroup var1);

    public Dimension getMinimumSize() {
        String string = ((Checkbox)this.target).getLabel();
        if (string != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
            return new Dimension(30 + fontMetrics.stringWidth(string), Math.max(fontMetrics.getHeight() + 8, 15));
        }
        return new Dimension(20, 15);
    }

    void action(boolean bl) {
        final Checkbox checkbox = (Checkbox)this.target;
        final boolean bl2 = bl;
        SunToolkit.executeOnEventHandlerThread(checkbox, new Runnable(){

            public void run() {
                CheckboxGroup checkboxGroup = checkbox.getCheckboxGroup();
                if (checkboxGroup != null && checkboxGroup.getSelectedCheckbox() == checkbox && checkbox.getState()) {
                    checkbox.setState(true);
                    return;
                }
                checkbox.setState(bl2);
                MCheckboxPeer.this.postEvent(new ItemEvent(checkbox, 701, checkbox.getLabel(), bl2 ? 1 : 2));
            }
        });
    }

    public void print(Graphics graphics) {
        Checkbox checkbox = (Checkbox)this.target;
        Dimension dimension = checkbox.size();
        Color color = checkbox.getBackground();
        Color color2 = checkbox.getForeground();
        Color color3 = color.darker();
        int n = 4;
        int n2 = (dimension.height - 19) / 2 + 4;
        graphics.setColor(checkbox.getState() ? color3 : color);
        if (checkbox.getCheckboxGroup() != null) {
            graphics.fillOval(n, n2, 10, 10);
            this.draw3DOval(graphics, color, n, n2, 10, 10, !checkbox.getState());
            if (checkbox.getState()) {
                graphics.setColor(color2);
                graphics.fillOval(n + 3, n2 + 3, 4, 4);
            }
        } else {
            graphics.fillRect(n, n2, 10, 10);
            this.draw3DRect(graphics, color, n, n2, 10, 10, !checkbox.getState());
            if (checkbox.getState()) {
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2 + 1, n + 10 - 1, n2 + 10 - 1);
                graphics.drawLine(n + 1, n2 + 10 - 1, n + 10 - 1, n2 + 1);
            }
        }
        graphics.setColor(color2);
        String string = checkbox.getLabel();
        if (string != null) {
            graphics.setFont(checkbox.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(string, 19, (dimension.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
        }
        this.target.print(graphics);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

