/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import sun.awt.motif.MDropTargetContextPeer;

final class MDropTargetContextPeerDispatcher
implements Runnable {
    private static final int NONE = 0;
    private static final int ENTER = 1;
    private static final int OVER = 2;
    private static final int CHANGED = 3;
    private static final int EXIT = 4;
    private static final int DROP = 5;
    private MDropTargetContextPeer dtPeer;
    private DropTargetListener dtListener;
    private DropTargetEvent dtEvent;
    private int dispatchType = 0;

    MDropTargetContextPeerDispatcher() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                switch (this.dispatchType) {
                    case 1: {
                        this.dtListener.dragEnter((DropTargetDragEvent)this.dtEvent);
                        break;
                    }
                    case 2: {
                        this.dtListener.dragOver((DropTargetDragEvent)this.dtEvent);
                        break;
                    }
                    case 3: {
                        this.dtListener.dropActionChanged((DropTargetDragEvent)this.dtEvent);
                        break;
                    }
                    case 4: {
                        this.dtListener.dragExit(this.dtEvent);
                        break;
                    }
                    case 5: {
                        this.dtListener.drop((DropTargetDropEvent)this.dtEvent);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var3_2 = null;
                if (this.dispatchType == 5) {
                    if (this.dtPeer.getDropStatus() != 1) return;
                    this.dtPeer.rejectDrop();
                    throw new InvalidDnDOperationException("Drop rejected; DropTargetListener drop() method must either acceptDrop() or rejectDrop()");
                }
                this.dispatched();
                return;
            }
            {
            }
            Object var3_1 = null;
            if (this.dispatchType == 5) {
                if (this.dtPeer.getDropStatus() != 1) return;
                this.dtPeer.rejectDrop();
                throw new InvalidDnDOperationException("Drop rejected; DropTargetListener drop() method must either acceptDrop() or rejectDrop()");
            }
            this.dispatched();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.dispatchType == 5) {
                if (this.dtPeer.getDropStatus() != 1) throw throwable;
                this.dtPeer.rejectDrop();
                throw new InvalidDnDOperationException("Drop rejected; DropTargetListener drop() method must either acceptDrop() or rejectDrop()");
            }
            this.dispatched();
            throw throwable;
        }
    }

    public synchronized void dispatched() {
        if (this.dispatchType != 0) {
            this.dispatchType = 0;
            this.notify();
        }
    }

    public void dispatchEnter(MDropTargetContextPeer mDropTargetContextPeer, DropTargetListener dropTargetListener, DropTargetEvent dropTargetEvent) {
        this.dispatch(mDropTargetContextPeer, dropTargetListener, dropTargetEvent, 1);
    }

    public void dispatchOver(MDropTargetContextPeer mDropTargetContextPeer, DropTargetListener dropTargetListener, DropTargetEvent dropTargetEvent, boolean bl) {
        this.dispatch(mDropTargetContextPeer, dropTargetListener, dropTargetEvent, bl ? 3 : 2);
    }

    public void dispatchExit(MDropTargetContextPeer mDropTargetContextPeer, DropTargetListener dropTargetListener, DropTargetEvent dropTargetEvent) {
        this.dispatch(mDropTargetContextPeer, dropTargetListener, dropTargetEvent, 4);
    }

    public void dispatchDrop(MDropTargetContextPeer mDropTargetContextPeer, DropTargetListener dropTargetListener, DropTargetEvent dropTargetEvent, Object object) {
        Object object2 = object;
        synchronized (object2) {
            MDropTargetContextPeerDispatcher mDropTargetContextPeerDispatcher = this;
            synchronized (mDropTargetContextPeerDispatcher) {
                this.dispatchType = 5;
                this.dtPeer = mDropTargetContextPeer;
                this.dtListener = dropTargetListener;
                this.dtEvent = dropTargetEvent;
                SwingUtilities.invokeLater(this);
                while (this.dispatchType != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatch(MDropTargetContextPeer mDropTargetContextPeer, DropTargetListener dropTargetListener, DropTargetEvent dropTargetEvent, int n) {
        boolean bl = false;
        MDropTargetContextPeerDispatcher mDropTargetContextPeerDispatcher = this;
        synchronized (mDropTargetContextPeerDispatcher) {
            this.dispatchType = n;
            this.dtPeer = mDropTargetContextPeer;
            this.dtListener = dropTargetListener;
            this.dtEvent = dropTargetEvent;
        }
        while (!bl) {
            try {
                SwingUtilities.invokeAndWait(this);
                return;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return;
            }
        }
    }
}

