/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.motif.PSPrinterJob;
import sun.awt.motif.X11Image;
import sun.java2d.PathGraphics;
import sun.java2d.ProxyGraphics2D;

class PSPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;

    PSPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        super(graphics2D, printerJob, printable, pageFormat, n);
    }

    public Graphics create() {
        return new PSPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex());
    }

    public void fill(Shape shape, Color color) {
        this.deviceFill(shape.getPathIterator(new AffineTransform()), color);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        PSPrinterJob pSPrinterJob;
        boolean bl = false;
        boolean bl2 = this.getFont().getTransform().isIdentity();
        if (!PSPrinterJob.shapeTextProp && bl2 && (pSPrinterJob = (PSPrinterJob)this.getPrinterJob()).setFont(this.getFont())) {
            try {
                pSPrinterJob.setColor((Color)this.getPaint());
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Expected a Color instance");
            }
            pSPrinterJob.setTransform(this.getTransform());
            pSPrinterJob.setClip(this.getClip());
            bl = pSPrinterJob.textOut(string, f, f2);
        }
        if (!bl) {
            super.drawString(string, f, f2);
        }
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        boolean bl = n3 <= 0 || n4 <= 0 ? false : this.drawImage(image, n, n2, n3, n4, color, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        boolean bl = n5 <= 0 || n6 <= 0 ? false : this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n5, n6, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        if (n9 <= 0 || n10 <= 0) {
            return false;
        }
        AffineTransform affineTransform = new AffineTransform((float)(n3 - n) / (float)n9, 0.0f, 0.0f, (float)(n4 - n2) / (float)n10, n - n5, n2 - n6);
        return this.drawImageToPS(image, affineTransform, null, color, n5, n6, n9, n10);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        boolean bl = n <= 0 || n2 <= 0 ? false : this.drawImageToPS(image, affineTransform, null, null, 0, 0, n, n2);
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        if (n3 <= 0 || n4 <= 0) {
            boolean bl = false;
        } else {
            AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2);
            boolean bl = this.drawImageToPS(bufferedImage, affineTransform, null, null, 0, 0, n3, n4);
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = null;
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        this.drawImageToPS(bufferedImage, affineTransform, null, null, 0, 0, n, n2);
    }

    private boolean drawImageToPS(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n, int n2, int n3, int n4) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d = float_.distance(float_3);
        double d2 = float_2.distance(float_3);
        double d3 = affineTransform2.getScaleX();
        double d4 = affineTransform2.getScaleX();
        if (d != 0.0 && d2 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d, dArray[1] / d2, dArray[2] / d, dArray[3] / d2, dArray[4] / d, dArray[5] / d2);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n, n2, n3, n4);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            int n5 = (int)rectangle2D.getWidth();
            int n6 = (int)rectangle2D.getHeight();
            if (n5 > 0 && n6 > 0) {
                if (this.hasTransparentPixels(image)) {
                    pSPrinterJob.saveState(this.getTransform(), this.getClip(), rectangle2D, d, d2, float_4, affineTransform);
                    return true;
                }
                BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(image, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, color, null);
                Shape shape2 = this.getClip();
                pSPrinterJob.setClip(this.getTransform().createTransformedShape(shape2));
                Rectangle2D.Float float_5 = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
                ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
                pSPrinterJob.drawImageBGR(byteInterleavedRaster.getDataStorage(), float_5.x, float_5.y, float_5.width, float_5.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.dispose();
            }
        }
        return true;
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d, double d2, Rectangle2D rectangle2D2, AffineTransform affineTransform) throws PrinterException {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, pSPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f = (float)(pSPrinterJob.getXRes() / d);
        float f2 = (float)(pSPrinterJob.getYRes() / d2);
        proxyGraphics2D.scale(f / 72.0f, f2 / 72.0f);
        proxyGraphics2D.translate(-pSPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / pSPrinterJob.getXRes() * 72.0, -pSPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / pSPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n);
        graphics2D.dispose();
        Shape shape = this.getClip();
        pSPrinterJob.setClip(this.getTransform().createTransformedShape(shape));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
        pSPrinterJob.drawImageBGR(byteInterleavedRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    private boolean hasTransparentPixels(Image image) {
        ColorModel colorModel;
        boolean bl = true;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof X11Image) {
            X11Image x11Image = (X11Image)image;
            colorModel = x11Image.getColorModel();
        } else {
            colorModel = null;
        }
        bl = colorModel == null ? true : colorModel.getTransparency() != 1;
        return bl;
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        pSPrinterJob.setTransform(this.getTransform());
        pSPrinterJob.setClip(this.getClip());
        pSPrinterJob.setColor(color);
        this.convertToPSPath(pathIterator);
        pSPrinterJob.fillPath();
    }

    protected void deviceClip(PathIterator pathIterator) {
    }

    private void convertToPSPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        pSPrinterJob.setFillMode(n);
        pSPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    pSPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pSPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    float f = pSPrinterJob.getPenX();
                    float f2 = pSPrinterJob.getPenY();
                    float f3 = f + (fArray[0] - f) * 2.0f / 3.0f;
                    float f4 = f2 + (fArray[1] - f2) * 2.0f / 3.0f;
                    float f5 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f6 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    pSPrinterJob.bezierTo(f3, f4, f5, f6, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pSPrinterJob.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pSPrinterJob.closeSubpath();
                }
            }
            pathIterator.next();
        }
    }
}

