/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import com.ibm.jvm.io.LocalizedInputStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import sun.awt.PlatformFont;
import sun.awt.motif.PSGraphics;
import sun.awt.motif.PSPaperSize;
import sun.awt.motif.PSPrintJob;
import sun.io.CharToByteConverter;

class PSPrintStream {
    PrintStream ps;
    PSPrintJob job;
    public String title;
    public Dimension paperDim;
    Properties fontProps;
    int curPage = -1;
    Rectangle curClip;
    Color curColor;
    Font curFont;
    int[] curColormap;
    boolean prologSent = false;
    boolean lastFirst = false;
    boolean mono;
    private static final String SetColorName = "SC";
    private static final String SetFontName = "SF";
    private static final String RectClipName = "RC";
    private static final String InitClipName = "IC";
    private static final String RectFillName = "RF";
    private static final String RectStrokeName = "RS";
    private static final String RRectFillName = "RRF";
    private static final String RRectStrokeName = "RRS";
    private static final String ArcFillName = "AF";
    private static final String ArcStrokeName = "AS";
    private static final String PolygonFillName = "PYF";
    private static final String PolygonStrokeName = "PYS";
    private static final String DrawStringName = "DS";
    private static final String DrawLineName = "DL";
    private static final String ScaleName = "S";
    private static final String StartPageName = "SP";
    private static final String EndPageName = "EP";
    private static final String GsaveName = "GS";
    private static final String GrestoreName = "GR";
    private static final String SetColormapName = "CM";
    private static final String DrawImageName = "DI";
    private static final String DrawIndexImageName = "DII";
    private static final String testString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890";
    private static final int MARGIN = 18;
    private CharToByteConverter[] converter;
    private String[] convname;
    private int convcount = 0;
    private static Font oldfont = null;
    private static int oldcharset = 0;
    private static int oldpsfont = 0;
    private static byte[] hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    PSPrintStream(PSPrintJob pSPrintJob, PrintStream printStream, String string, Dimension dimension, boolean bl) {
        this.job = pSPrintJob;
        this.ps = printStream;
        this.title = string;
        this.paperDim = dimension;
        this.lastFirst = bl;
        this.mono = pSPrintJob.control.getColorAttrib() == PageAttributes.ColorType.MONOCHROME;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PSPrintStream.this.fontProps = PSPrintStream.this.initProps();
                return null;
            }
        });
        this.initConverters(this.fontProps);
    }

    private Properties initProps() {
        String string = System.getProperty("java.home");
        Properties properties = new Properties();
        if (string != null) {
            String string2 = System.getProperty("user.language", "en");
            try {
                File file = new File(string + File.separator + "lib" + File.separator + "psfont.properties." + string2);
                if (!file.canRead() && !(file = new File(string + File.separator + "lib" + File.separator + "psfont.properties")).canRead()) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize(new FileInputStream(file.getPath())));
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        properties.setProperty("charset.0", "Cp1252");
        properties.setProperty("Courier", "0");
        properties.setProperty("Courier-Bold", "1");
        properties.setProperty("Courier-BoldOblique", "2");
        properties.setProperty("Courier-Oblique", "3");
        properties.setProperty("Helvetica", "4");
        properties.setProperty("Helvetica-Bold", "5");
        properties.setProperty("Helvetica-BoldOblique", "6");
        properties.setProperty("Helvetica-Oblique", "7");
        properties.setProperty("Times-Bold", "8");
        properties.setProperty("Times-BoldItalic", "9");
        properties.setProperty("Times-Italic", "10");
        properties.setProperty("Times-Roman", "11");
        properties.setProperty("font.num", "12");
        properties.setProperty("font.0", "Courier Cp1252");
        properties.setProperty("font.1", "Courier-Bold Cp1252");
        properties.setProperty("font.2", "Courier-BoldOblique Cp1252");
        properties.setProperty("font.3", "Courier-Oblique Cp1252");
        properties.setProperty("font.4", "Helvetica Cp1252");
        properties.setProperty("font.5", "Helvetica-Bold Cp1252");
        properties.setProperty("font.6", "Helvetica-BoldOblique Cp1252");
        properties.setProperty("font.7", "Helvetica-Oblique Cp1252");
        properties.setProperty("font.8", "Times-Bold Cp1252");
        properties.setProperty("font.9", "Times-BoldItalic Cp1252");
        properties.setProperty("font.10", "Times-Italic Cp1252");
        properties.setProperty("font.11", "Times-Roman Cp1252");
        properties.setProperty("serif", "serif");
        properties.setProperty("times", "serif");
        properties.setProperty("timesroman", "serif");
        properties.setProperty("sansserif", "sansserif");
        properties.setProperty("helvetica", "sansserif");
        properties.setProperty("dialog", "sansserif");
        properties.setProperty("dialoginput", "monospaced");
        properties.setProperty("monospaced", "monospaced");
        properties.setProperty("courier", "monospaced");
        properties.setProperty("sansserif.Cp1252.plain", "Helvetica");
        properties.setProperty("sansserif.Cp1252.bold", "Helvetica-Bold");
        properties.setProperty("sansserif.Cp1252.italic", "Helvetica-Oblique");
        properties.setProperty("sansserif.Cp1252.bolditalic", "Helvetica-BoldOblique");
        properties.setProperty("serif.Cp1252.plain", "Times-Roman");
        properties.setProperty("serif.Cp1252.bold", "Times-Bold");
        properties.setProperty("serif.Cp1252.italic", "Times-Italic");
        properties.setProperty("serif.Cp1252.bolditalic", "Times-BoldItalic");
        properties.setProperty("monospaced.Cp1252.plain", "Courier");
        properties.setProperty("monospaced.Cp1252.bold", "Courier-Bold");
        properties.setProperty("monospaced.Cp1252.italic", "Courier-Oblique");
        properties.setProperty("monospaced.Cp1252.bolditalic", "Courier-BoldOblique");
        return properties;
    }

    private int rgbToGray(int n, int n2, int n3) {
        return (int)(0.3 * (double)n + 0.59 * (double)n2 + 0.11 * (double)n3);
    }

    private int argbToAGGG(int n) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n >>> 0 & 0xFF;
        int n6 = this.rgbToGray(n3, n4, n5);
        return n2 << 24 | n6 << 16 | n6 << 8 | n6;
    }

    void startPage(int n) {
        this.curClip = null;
        this.curColor = null;
        this.curFont = null;
        this.curColormap = null;
        this.curPage = n;
        this.ps.println("\n%%Page:  " + n + " " + n);
        this.ps.println(StartPageName);
    }

    void endPage() {
        this.ps.println(EndPageName);
        this.curPage = -1;
        this.ps.flush();
    }

    void close(int n) {
        this.ps.println("%%Trailer");
        this.ps.println("%%Pages: " + n);
        this.ps.println("%%EOF");
        this.ps.flush();
    }

    private void outPoint(PSGraphics pSGraphics, int n, int n2) {
        this.ps.print(pSGraphics.adjustX + n + " " + (pSGraphics.adjustY - n2) + " ");
    }

    private void outRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4) {
        this.outPoint(pSGraphics, n, n2);
        this.ps.print(n3 + " " + -n4 + " ");
    }

    private void outClip(PSGraphics pSGraphics) {
        Rectangle rectangle = pSGraphics.clipRect;
        if (this.curClip != rectangle) {
            this.ps.println(InitClipName);
            if (rectangle != null) {
                this.outRect(pSGraphics, rectangle.x - pSGraphics.originX, rectangle.y - pSGraphics.originY, rectangle.width, rectangle.height);
                this.ps.println(RectClipName);
            }
            this.curClip = rectangle;
        }
    }

    private void outColor(Color color) {
        if (this.curColor != color) {
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            if (this.mono) {
                n2 = n3 = this.rgbToGray(n, n2, n3);
                n = n3;
            }
            this.ps.println(n + " " + n2 + " " + n3 + " " + SetColorName);
            this.curColor = color;
        }
    }

    synchronized void sendLine(PSGraphics pSGraphics, int n, int n2, int n3, int n4) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.outPoint(pSGraphics, n, n2);
        this.outPoint(pSGraphics, n3, n4);
        this.ps.println(DrawLineName);
    }

    synchronized void sendRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, Color color, boolean bl) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(color);
        this.outRect(pSGraphics, n, n2, n3, n4);
        this.ps.println(bl ? RectFillName : RectStrokeName);
    }

    void sendRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, boolean bl) {
        this.sendRect(pSGraphics, n, n2, n3, n4, pSGraphics.foreground, bl);
    }

    void fillRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, Color color) {
        this.sendRect(pSGraphics, n, n2, n3, n4, color, true);
    }

    synchronized void sendRoundRect(PSGraphics pSGraphics, int n, int n2, int n3, int n4, float f, float f2, boolean bl) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.outRect(pSGraphics, n, n2, -n3, -n4);
        this.ps.print(f + " " + f2 + " ");
        this.ps.println(bl ? RRectFillName : RRectStrokeName);
    }

    synchronized void sendArc(PSGraphics pSGraphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.outPoint(pSGraphics, n, n2);
        this.ps.print(n3 + " " + n4 + " " + n5 + " " + n6 + " ");
        this.ps.println(bl ? ArcFillName : ArcStrokeName);
    }

    synchronized void sendPolygon(PSGraphics pSGraphics, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        this.ps.print(bl + " ");
        int n2 = 0;
        while (n2 < n) {
            this.outPoint(pSGraphics, nArray[n2], nArray2[n2]);
            ++n2;
        }
        this.ps.print(n + " ");
        this.ps.println(bl2 ? PolygonFillName : PolygonStrokeName);
    }

    private void initConverters(Properties properties) {
        String string;
        int n = 0;
        while (n < 120) {
            string = properties.getProperty("charset." + n, null);
            if (string == null) break;
            ++n;
        }
        this.convcount = 0;
        if (n > 0) {
            this.converter = new CharToByteConverter[n];
            this.convname = new String[n];
            int n2 = 0;
            while (n2 < n) {
                string = properties.getProperty("charset." + n2, "");
                CharToByteConverter charToByteConverter = this.getConverter(string);
                if (charToByteConverter != null) {
                    this.converter[this.convcount] = charToByteConverter;
                    this.convname[this.convcount] = string;
                    ++this.convcount;
                }
                ++n2;
            }
        }
    }

    private CharToByteConverter getConverter(String string) {
        CharToByteConverter charToByteConverter;
        Class clazz;
        try {
            clazz = Class.forName("sun.io.CharToByte" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            charToByteConverter = (CharToByteConverter)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        return charToByteConverter;
    }

    private int getPsFontIndex(Font font, int n, int n2) {
        int n3 = n2;
        if (font != null && font == oldfont && n == oldcharset) {
            return oldpsfont;
        }
        String string = PlatformFont.styleStr(font.getStyle());
        String string2 = font.getName().toLowerCase();
        String string3 = this.fontProps.getProperty(string2 = string2.replace(' ', '_'), "");
        String string4 = this.fontProps.getProperty(string3 + "." + this.convname[n] + "." + string, null);
        if (string4 == null && n != 0) {
            string4 = this.fontProps.getProperty("monospaced." + this.convname[n] + ".plain", null);
        }
        if (string4 != null) {
            try {
                n3 = Integer.parseInt(this.fontProps.getProperty(string4));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n3;
    }

    private void GetCharsetArray(char[] cArray, byte[] byArray) {
        int n = cArray.length;
        if (this.convcount < 2) {
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = 0;
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < this.convcount) {
                if (this.converter[n4].canConvert(cArray[n3])) {
                    byArray[n3] = (byte)n4;
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                byArray[n3] = 0;
            }
            ++n3;
        }
    }

    synchronized void sendString(PSGraphics pSGraphics, String string, int n, int n2) {
        if (string.length() <= 0) {
            return;
        }
        int n3 = string.length();
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pSGraphics);
        this.outColor(pSGraphics.foreground);
        Font font = pSGraphics.font;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n3];
        this.GetCharsetArray(cArray, byArray);
        AffineTransform affineTransform = font.getTransform();
        affineTransform.scale(10.0, 10.0);
        Font font2 = font.deriveFont(affineTransform);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font2);
        byte by = byArray[0];
        int n4 = 0;
        int n5 = 0;
        while (n5 <= n3) {
            if (n5 == n3 || byArray[n5] != by) {
                int n6 = this.getPsFontIndex(font, by, 0);
                String string2 = string.substring(n4, n5);
                int n7 = fontMetrics.charsWidth(cArray, n4, n5);
                byte[] byArray2 = new byte[4 * n5 - n4];
                this.converter[by].setSubstitutionMode(true);
                int n8 = 0;
                try {
                    n8 = this.converter[by].convert(cArray, n4, n5, byArray2, 0, byArray2.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.converter[by].setSubstitutionMode(false);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('(');
                int n9 = 0;
                while (n9 < n8) {
                    char c = (char)(byArray2[n9] & 0xFF);
                    if (c < ' ' || c > '\u007f') {
                        stringBuffer.append('\\');
                        stringBuffer.append((char)(48 + (c / 64 & 7)));
                        stringBuffer.append((char)(48 + (c / 8 & 7)));
                        stringBuffer.append((char)(48 + (c & 7)));
                    } else {
                        if (c == '(' || c == ')' || c == '\\') {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append(c);
                    }
                    ++n9;
                }
                stringBuffer.append(')');
                this.ps.println("/TS " + stringBuffer.toString() + " D");
                this.ps.println(n7 + " " + font.getSize() + " " + n6 + " SF");
                float f = (float)n7 / 10.0f;
                this.ps.println("TS " + f + " " + (pSGraphics.adjustX + n) + " " + (pSGraphics.adjustY - n2) + " DS");
                n = (int)((float)n + f);
                n4 = n5;
            }
            ++n5;
        }
    }

    private static final int blend(int n, int n2, int n3) {
        return (n * n2 + (255 - n) * n3) / 255;
    }

    private int sendColors(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        while (n2-- > 0) {
            if (n3 + 3 > byArray2.length) {
                byArray2[n3++] = 10;
                this.ps.write(byArray2, 0, n3);
                n3 = 0;
            }
            byte by = byArray[n++];
            byArray2[n3++] = hexDigits[by >>> 4 & 0xF];
            byArray2[n3++] = hexDigits[by >>> 0 & 0xF];
        }
        return n3;
    }

    private int sendColors(int[] nArray, int n, int n2, byte[] byArray, int n3) {
        while (n2-- > 0) {
            if (n3 + 7 > byArray.length) {
                byArray[n3++] = 10;
                this.ps.write(byArray, 0, n3);
                n3 = 0;
            }
            int n4 = nArray[n++];
            byArray[n3++] = hexDigits[n4 >>> 20 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 16 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 12 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 8 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 4 & 0xF];
            byArray[n3++] = hexDigits[n4 >>> 0 & 0xF];
        }
        return n3;
    }

    private void sendsubPixels(PSGraphics pSGraphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2) {
        int n8 = n4 - n2;
        int n9 = n5 - n3;
        int n10 = n3 * n + n2;
        int n11 = 0;
        byte[] byArray2 = new byte[73];
        this.ps.print(n2 + " " + n3 + " ");
        this.ps.print(n8 + " " + n9 + " ");
        this.ps.print(f * (float)n8 + " " + f2 * (float)n9 + " ");
        this.outPoint(pSGraphics, n6, n7);
        this.ps.println(DrawIndexImageName);
        int n12 = n3;
        while (n12 < n5) {
            n11 = this.sendColors(byArray, n10, n8, byArray2, n11);
            n10 += n;
            ++n12;
        }
        if (n11 > 0) {
            byArray2[n11++] = 10;
            this.ps.write(byArray2, 0, n11);
        }
    }

    private void sendsubPixels(PSGraphics pSGraphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2) {
        int n8 = n4 - n2;
        int n9 = n5 - n3;
        int n10 = n3 * n + n2;
        int n11 = 0;
        byte[] byArray = new byte[73];
        this.ps.print(n2 + " " + n3 + " ");
        this.ps.print(n8 + " " + n9 + " ");
        this.ps.print(f * (float)n8 + " " + f2 * (float)n9 + " ");
        this.outPoint(pSGraphics, n6, n7);
        this.ps.println(DrawImageName);
        int n12 = n3;
        while (n12 < n5) {
            n11 = this.sendColors(nArray, n10, n8, byArray, n11);
            n10 += n;
            ++n12;
        }
        if (n11 > 0) {
            byArray[n11++] = 10;
            this.ps.write(byArray, 0, n11);
        }
    }

    private void sendColormap(PSGraphics pSGraphics, int[] nArray, int n) {
        int n2;
        if (this.curColormap != null) {
            boolean bl = true;
            n2 = 0;
            while (n2 < n) {
                if (nArray[n2] != this.curColormap[n2]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                return;
            }
        }
        this.curColormap = nArray;
        byte[] byArray = new byte[73];
        this.ps.println(n + " " + SetColormapName);
        n2 = this.sendColors(nArray, 0, n, byArray, 0);
        if (n2 > 0) {
            byArray[n2++] = 10;
            this.ps.write(byArray, 0, n2);
        }
    }

    synchronized void sendPixels(PSGraphics pSGraphics, byte[] byArray, IndexColorModel indexColorModel, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        int[] nArray = new int[256];
        int n15 = indexColorModel.getMapSize();
        boolean[] blArray = new boolean[256];
        boolean bl = false;
        if (color != null) {
            n14 = color.getRed();
            n13 = color.getGreen();
            n12 = color.getBlue();
            if (this.mono) {
                n13 = n12 = this.rgbToGray(n14, n13, n12);
                n14 = n12;
            }
        } else {
            n12 = 0;
            n13 = 0;
            n14 = 0;
        }
        while (--n15 >= 0) {
            n11 = indexColorModel.getRGB(n15);
            if (this.mono) {
                n11 = this.argbToAGGG(n11);
            }
            if ((n10 = n11 >>> 24) != 255) {
                if (color != null) {
                    int n16 = PSPrintStream.blend(n10, n11 >>> 16 & 0xFF, n14);
                    int n17 = PSPrintStream.blend(n10, n11 >>> 8 & 0xFF, n13);
                    n9 = PSPrintStream.blend(n10, n11 >>> 0 & 0xFF, n12);
                    n11 = n16 << 16 | n17 << 8 | n9;
                } else if (n10 < 128) {
                    blArray[n15] = true;
                    bl = true;
                }
            }
            nArray[n15] = n11;
        }
        this.outClip(pSGraphics);
        this.sendColormap(pSGraphics, nArray, indexColorModel.getMapSize());
        n11 = n7 - n5;
        n10 = n8 - n6;
        float f = (float)(n3 - n) / (float)n11;
        float f2 = (float)(n4 - n2) / (float)n10;
        if (bl) {
            n15 = 0;
            n9 = 0;
            while (n9 < n10) {
                int n18 = -1;
                int n19 = 0;
                while (n19 < n11) {
                    if (blArray[byArray[n15++] & 0xFF]) {
                        if (n18 >= 0) {
                            this.sendsubPixels(pSGraphics, byArray, n11, n18, n9, n19, n9 + 1, n, n2, f, f2);
                            n18 = -1;
                        }
                    } else if (n18 < 0) {
                        n18 = n19;
                    }
                    ++n19;
                }
                if (n18 >= 0) {
                    this.sendsubPixels(pSGraphics, byArray, n11, n18, n9, n11, n9 + 1, n, n2, f, f2);
                }
                ++n9;
            }
        } else {
            this.sendsubPixels(pSGraphics, byArray, n11, 0, 0, n11, n10, n, n2, f, f2);
        }
    }

    synchronized void sendPixels(PSGraphics pSGraphics, int[] nArray, ColorModel colorModel, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9;
        int n10;
        int n11;
        if (pSGraphics.pageNumber != this.curPage) {
            return;
        }
        int n12 = n7 - n5;
        int n13 = n8 - n6;
        float f = (float)(n3 - n) / (float)n12;
        float f2 = (float)(n4 - n2) / (float)n13;
        if (color != null) {
            n11 = color.getRed();
            n10 = color.getGreen();
            n9 = color.getBlue();
            if (this.mono) {
                n10 = n9 = this.rgbToGray(n11, n10, n9);
                n11 = n9;
            }
        } else {
            n9 = 0;
            n10 = 0;
            n11 = 0;
        }
        this.outClip(pSGraphics);
        int n14 = 0;
        int n15 = -1;
        int n16 = 0;
        while (n16 < n13) {
            int n17 = -1;
            int n18 = 0;
            while (n18 < n12) {
                int n19;
                int n20 = colorModel.getRGB(nArray[n14]);
                if (this.mono) {
                    n20 = this.argbToAGGG(n20);
                }
                if ((n19 = n20 >>> 24) != 255) {
                    if (color != null) {
                        int n21 = PSPrintStream.blend(n19, n20 >>> 16 & 0xFF, n11);
                        int n22 = PSPrintStream.blend(n19, n20 >>> 8 & 0xFF, n10);
                        int n23 = PSPrintStream.blend(n19, n20 >>> 0 & 0xFF, n9);
                        nArray[n14] = n21 << 16 | n22 << 8 | n23;
                        if (n17 < 0) {
                            n17 = n18;
                        }
                    } else if (n17 >= 0) {
                        if (n15 >= 0) {
                            this.sendsubPixels(pSGraphics, nArray, n12, 0, n15, n12, n16, n, n2, f, f2);
                            n15 = -1;
                        }
                        this.sendsubPixels(pSGraphics, nArray, n12, n17, n16, n18, n16 + 1, n, n2, f, f2);
                        n17 = -1;
                    }
                } else {
                    nArray[n14] = n20;
                    if (n17 < 0) {
                        n17 = n18;
                    }
                }
                ++n14;
                ++n18;
            }
            if (n17 == 0) {
                if (n15 < 0) {
                    n15 = n16;
                }
            } else if (n17 > 0) {
                this.sendsubPixels(pSGraphics, nArray, n12, n17, n16, n12, n16 + 1, n, n2, f, f2);
            }
            ++n16;
        }
        if (n15 >= 0) {
            this.sendsubPixels(pSGraphics, nArray, n12, 0, n15, n12, n13, n, n2, f, f2);
        }
    }

    void sendProlog() {
        if (this.prologSent) {
            return;
        }
        PSPaperSize pSPaperSize = PSPaperSize.find(this.paperDim.width, this.paperDim.height, 1);
        if (pSPaperSize == null) {
            pSPaperSize = PSPaperSize.find(this.paperDim.height, this.paperDim.width, 1);
        }
        this.ps.println("%!Ps-Adobe-3.0");
        this.ps.println("%%Title: " + this.title);
        this.ps.println("%%Pages: (atend)");
        this.ps.println("%%PageOrder: " + (this.lastFirst ? "special" : "Ascend"));
        this.ps.println("%%DocumentFonts: Helvetica Helvetica-Bold");
        this.ps.println("%%+Helvetica-Oblique Helvetica-BoldOblique");
        this.ps.println("%%+Times-Roman Times-Bold Times-Italic Times-BoldItalic");
        this.ps.println("%%+Courier Courier-Bold Courier-Oblique Courier-BoldOblique");
        this.ps.println("%%EndComments");
        this.ps.println("%%BeginProlog");
        this.ps.println("/BD {bind def} bind def");
        this.ps.println("/D {def} BD");
        this.ps.println("/Cp1252 {Cp1252Encoding recode} D");
        this.ps.println("/IsOF   {Cp1252} D");
        this.ps.println("/recode {");
        this.ps.println("  /encode exch def");
        this.ps.println("  dup /fname exch def findfont");
        this.ps.println("  dup maxlength dict /nf exch def");
        this.ps.println("  {  1 index /FID ne 2 index /Encoding ne and");
        this.ps.println("     {nf 3 1 roll put} {pop pop} ifelse");
        this.ps.println("  } forall");
        this.ps.println("  nf /Encoding encode put fname nf definefont");
        this.ps.println("} BD");
        this.ps.println("/Cp1252Encoding [");
        this.ps.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.ps.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.ps.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.ps.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.ps.println("/space/exclam/quotedbl/numbersign/dollar/percent/ampersand/quotesingle");
        this.ps.println("/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash");
        this.ps.println("/zero/one/two/three/four/five/six/seven");
        this.ps.println("/eight/nine/colon/semicolon/less/equal/greater/question");
        this.ps.println("/at/A/B/C/D/E/F/G");
        this.ps.println("/H/I/J/K/L/M/N/O");
        this.ps.println("/P/Q/R/s/T/U/V/W");
        this.ps.println("/X/Y/Z/bracketleft/backslash/bracketright/asciicircum/underscore");
        this.ps.println("/grave/a/b/c/d/e/f/g");
        this.ps.println("/h/i/j/k/l/m/n/o");
        this.ps.println("/p/q/r/s/t/u/v/w");
        this.ps.println("/x/y/z/braceleft/bar/braceright/asciitilde/.notdef");
        this.ps.println("/euro/.notdef/quotesinglbase/florin/quotedblbase/ellipsis/dagger/daggerdbl");
        this.ps.println("/circumflex/perthousand/scaron/guilsinglleft/OE/.notdef/Zcaron/.notdef");
        this.ps.println("/.notdef/quoteleft/quoteright/quotedblleft/quotedblright/bullet/endash/emdash");
        this.ps.println("/tilde/trademark/scaron/guilsinglright/oe/.notdef/zcaron/Ydieresis");
        this.ps.println("/space/exclamdown/cent/sterling/currency/yen/brokenbar/section");
        this.ps.println("/dieresis/copyright/ordfeminine/guillemotleft/logicalnot/hyphen/registered/macron");
        this.ps.println("/degree/plusminus/twosuperior/threesuperior/acute/mu/paragraph/periodcentered");
        this.ps.println("/cedilla/onesuperior/ordmasculine/guillemotright/onequarter/onehalf/threequarters/questiondown");
        this.ps.println("/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla");
        this.ps.println("/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex/Idieresis");
        this.ps.println("/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/multiply");
        this.ps.println("/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/germandbls");
        this.ps.println("/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla");
        this.ps.println("/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis");
        this.ps.println("/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/divide");
        this.ps.println("/oslash/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/ydieresis");
        this.ps.println("] def");
        this.ps.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.ps.println("/F [");
        int n = Integer.parseInt(this.fontProps.getProperty("font.num", "9"));
        int n2 = 0;
        while (n2 < n) {
            this.ps.println("    /" + this.fontProps.getProperty("font." + String.valueOf(n2), "Courier IsOF"));
            ++n2;
        }
        this.ps.println("] D");
        this.ps.println("/R {4 2 roll moveto 1 index 0 rlineto");
        this.ps.println("    0 exch rlineto neg 0 rlineto closepath} BD");
        this.ps.println("/Adict 8 dict D");
        this.ps.println("Adict /mtrx matrix put");
        this.ps.println("/A { Adict begin");
        this.ps.println("    /endangle exch D /startangle exch D");
        this.ps.println("    /yrad exch D /xrad exch D");
        this.ps.println("    /y exch D /x exch D");
        this.ps.println("    /savematrix mtrx currentmatrix D");
        this.ps.println("    x y translate xrad yrad scale");
        this.ps.println("    0 0 1 startangle endangle arc");
        this.ps.println("    savematrix setmatrix");
        this.ps.println("    end } BD");
        this.ps.println("/PY {");
        this.ps.println("    dup 1 ge {3 1 roll moveto} if");
        this.ps.println("    -1 2 {pop lineto} for");
        this.ps.println("    {closepath} if");
        this.ps.println("} BD");
        this.ps.println("/CL { dup 0 exch -1 1 arct} BD");
        this.ps.println("/RCL { dup 0 exch 1 1 arct} BD");
        this.ps.println("/RRdict 8 dict D");
        this.ps.println("RRdict /mtrx matrix put");
        this.ps.println("/RR {RRdict begin");
        this.ps.println("    /yrad exch D /xrad exch D");
        this.ps.println("    /height exch D /width exch D");
        this.ps.println("    /y exch D /x exch D");
        this.ps.println("    /width width xrad div D /height height yrad div D");
        this.ps.println("    /savematrix mtrx currentmatrix D");
        this.ps.println("    x y translate xrad yrad scale -90 rotate");
        this.ps.println("    1 0 moveto height RCL height 0 translate -90 rotate");
        this.ps.println("    width CL width 0 translate -90 rotate");
        this.ps.println("    height RCL height 0 translate -90 rotate width CL closepath");
        this.ps.println("    savematrix setmatrix");
        this.ps.println("    end } BD");
        this.ps.println("/SC {3 {255 div 3 1 roll} repeat setrgbcolor} BD");
        this.ps.println("/SF {");
        this.ps.println("  F exch get exch scalefont setfont");
        this.ps.println("  TS dup length 2 lt {pop 0}{stringwidth pop} ifelse");
        this.ps.println("  dup 0 eq {pop 1}{10 mul div} ifelse");
        this.ps.println("  20 mul round 20 div");
        this.ps.println("  currentfont exch [1 0 0 1 0 0] dup 3 -1 roll 0 exch put makefont setfont");
        this.ps.println("} BD");
        this.ps.println("/RC {R clip newpath} BD");
        this.ps.println("/RF {R fill} BD");
        this.ps.println("/RS {R stroke} BD");
        this.ps.println("/RRF {RR fill} BD");
        this.ps.println("/RRS {RR stroke} BD");
        this.ps.println("/AS {A stroke} BD");
        this.ps.println("/AF {6 -2 roll 2 copy moveto 6 2 roll A fill} BD");
        this.ps.println("/PYS {PY stroke} BD");
        this.ps.println("/PYF {PY eofill} BD");
        this.ps.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.ps.println("/DS {");
        this.ps.println("    moveto 1 index stringwidth pop NZ sub");
        this.ps.println("    1 index length 1 sub NZ div 0");
        this.ps.println("    3 2 roll ashow newpath} BD");
        this.ps.println("/DL {moveto lineto stroke} BD");
        this.ps.println("/S {scale} BD");
        this.ps.println("/SP {/P save D} BD");
        this.ps.println("/EP {showpage P restore} BD");
        this.ps.println("/GS {gsave} BD");
        this.ps.println("/GR {grestore} BD");
        this.ps.println("/CM {");
        this.ps.println("    /cmapr 256 array D");
        this.ps.println("    /cmapg 256 array D");
        this.ps.println("    /cmapb 256 array D");
        this.ps.println("    /cmapgray null D");
        this.ps.println("    3 string exch 0 exch 1 exch 1 sub {");
        this.ps.println("            currentfile 2 index readhexstring pop");
        this.ps.println("            cmapr 2 index 2 index 0 get put");
        this.ps.println("            cmapg 2 index 2 index 1 get put");
        this.ps.println("            cmapb 2 index 2 index 2 get put");
        this.ps.println("    pop pop } for pop");
        this.ps.println("} BD");
        this.ps.println("/DII {");
        this.ps.println("    GS");
        this.ps.println("    /imgsave save D");
        this.ps.println("    translate scale");
        this.ps.println("    /imgh exch D");
        this.ps.println("    /imgw exch D");
        this.ps.println("    /imgy exch neg D");
        this.ps.println("    /imgx exch neg D");
        this.ps.println("    /imgstr imgw string D");
        this.ps.println("    /colorimage where {");
        this.ps.println("            pop");
        this.ps.println("            /cimgstr imgw 3 mul string D");
        this.ps.println("            imgw imgh 8 [imgw 0 0 imgh neg imgx imgy] {");
        this.ps.println("                    currentfile imgstr readhexstring pop");
        this.ps.println("                    0 1 imgw 1 sub {");
        this.ps.println("                            2 copy get");
        this.ps.println("                            cmapr 1 index get");
        this.ps.println("                            cimgstr exch 3 index");
        this.ps.println("                            3 mul exch put");
        this.ps.println("                            cmapg 1 index get");
        this.ps.println("                            cimgstr exch 3 index");
        this.ps.println("                            3 mul 1 add exch put");
        this.ps.println("                            cmapb 1 index get");
        this.ps.println("                            cimgstr exch 3 index");
        this.ps.println("                            3 mul 2 add exch put");
        this.ps.println("                    pop pop } for pop cimgstr");
        this.ps.println("            } false 3 colorimage");
        this.ps.println("    } {");
        this.ps.println("            cmapgray null eq {");
        this.ps.println("                    /cmapgray cmapr length array D");
        this.ps.println("                    0 1 cmapr length 1 sub {");
        this.ps.println("                            cmapgray exch");
        this.ps.println("                            cmapr 1 index get .299 mul");
        this.ps.println("                            cmapg 2 index get .587 mul");
        this.ps.println("                            cmapb 3 index get .114 mul");
        this.ps.println("                            add add cvi put");
        this.ps.println("                    } for");
        this.ps.println("            } if");
        this.ps.println("            imgw imgh 8 [imgw 0 0 imgh neg 0 0] {");
        this.ps.println("                    currentfile imgstr readhexstring pop");
        this.ps.println("                    0 1 imgw 1 sub {");
        this.ps.println("                            imgstr exch 2 copy get");
        this.ps.println("                            cmapgray exch get put");
        this.ps.println("                    } for");
        this.ps.println("            } image");
        this.ps.println("    } ifelse");
        this.ps.println("    imgsave restore");
        this.ps.println("    GR");
        this.ps.println("} BD");
        this.ps.println("/DI {");
        this.ps.println("    GS");
        this.ps.println("    /imgsave save D");
        this.ps.println("    translate scale");
        this.ps.println("    /imgh exch D");
        this.ps.println("    /imgw exch D");
        this.ps.println("    /imgy exch neg D");
        this.ps.println("    /imgx exch neg D");
        this.ps.println("    /imgstr imgw 3 mul string D");
        this.ps.println("    imgw imgh 8 [imgw 0 0 imgh neg imgx imgy] {");
        this.ps.println("            currentfile imgstr readhexstring pop");
        this.ps.println("    } bind false 3 colorimage");
        this.ps.println("    imgsave restore");
        this.ps.println("    GR");
        this.ps.println("} BD");
        this.ps.println("%%EndProlog");
        this.ps.println("%%Beginsetup");
        if (this.job.control.getDestAttrib() == JobAttributes.DestinationType.PRINTER) {
            JobAttributes.SidesType sidesType = this.job.control.getSidesAttrib();
            boolean bl = sidesType == JobAttributes.SidesType.TWO_SIDED_LONG_EDGE || sidesType == JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE;
            this.ps.println("mark {");
            this.ps.println("%%BeginFeature: *Duplex " + (bl ? "Duplex" : "simplex"));
            this.ps.println("2 dict begin");
            this.ps.println("  /Duplex " + bl + " def");
            this.ps.println("  /Policies");
            this.ps.println("    1 dict begin");
            this.ps.println("      /Duplex 1 def");
            this.ps.println("    currentdict end def");
            this.ps.println("currentdict end setpagedevice");
            this.ps.println("%%EndFeature");
            this.ps.println("} stopped cleartomark");
            if (bl) {
                boolean bl2 = sidesType == JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE;
                this.ps.println("mark {");
                this.ps.println("%%BeginFeature: *Tumble " + (bl2 ? "True" : "False"));
                this.ps.println("2 dict begin");
                this.ps.println("  /Tumble " + bl2 + " def");
                this.ps.println("  /Policies");
                this.ps.println("    1 dict begin");
                this.ps.println("      /Tumble 1 def");
                this.ps.println("    currentdict end def");
                this.ps.println("currentdict end setpagedevice");
                this.ps.println("%%EndFeature");
                this.ps.println("} stopped cleartomark");
            }
        }
        if (pSPaperSize != null) {
            this.ps.println(pSPaperSize.toPostScriptCode());
        }
        if (this.paperDim.width > this.paperDim.height) {
            this.ps.println("90 rotate 0 " + -this.paperDim.height + " translate");
        }
        if (this.job.control.getOriginAttrib() == PageAttributes.OriginType.PRINTABLE) {
            this.ps.println(pSPaperSize.toInitClip(InitClipName, 18));
            this.ps.println("18 -18 translate");
        } else {
            this.ps.println("/IC {initclip} BD");
        }
        int n3 = this.job.control.getResAttrib();
        if (n3 != 72) {
            this.ps.println(72.0 / (double)n3 + " " + 72.0 / (double)n3 + " scale");
            this.ps.println(this.paperDim.height + " dup " + (double)n3 / 72.0);
            this.ps.println("mul exch sub 0 exch translate");
        }
        this.ps.println("%%Endsetup");
        this.ps.flush();
        this.prologSent = true;
    }
}

