/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.robot.probe;

import java.util.Vector;
import sun.awt.robot.RobotPeer;
import sun.awt.robot.probe.EVKey;
import sun.awt.robot.probe.EVMouseButton;
import sun.awt.robot.probe.EVMouseMove;
import sun.awt.robot.probe.EVObject;
import sun.awt.robot.probe.EVWait;
import sun.awt.robot.probe.EventPlayerEvent;
import sun.awt.robot.probe.EventPlayerListener;

public class EventPlayer
extends Thread {
    private Vector evQueue = new Vector();
    private boolean dispatching = false;
    private boolean keepAlive = true;
    private Vector listeners = new Vector();
    private int inactivePauseTime = 10000;
    private RobotPeer peer;
    private static int counter = 0;

    public EventPlayer(RobotPeer robotPeer) {
        this.setName("EventPlayer-" + new Integer(++counter).toString());
        this.setDaemon(true);
        this.peer = robotPeer;
        this.dispatching = true;
        this.start();
    }

    public void run() {
        while (this.keepAlive) {
            try {
                Object object;
                if (!this.dispatching) {
                    try {
                        object = this;
                        synchronized (object) {
                            this.wait(this.inactivePauseTime);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                if (this.evQueue.size() <= 0) {
                    this.tellListeners(new EventPlayerEvent(this, 1));
                    try {
                        object = this;
                        synchronized (object) {
                            this.wait(this.inactivePauseTime);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                Vector vector = this.evQueue;
                synchronized (vector) {
                    object = (EVObject)this.evQueue.remove(0);
                }
                if (((EVObject)object).getDelay() > 0) {
                    try {
                        Thread.sleep(((EVObject)object).getDelay());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.dispatch((EVObject)object);
                if (this.evQueue.size() > 0) continue;
                this.tellListeners(new EventPlayerEvent(this, 1));
            }
            catch (Exception exception) {
                System.out.println("Caught exception in EventPlayer.run: " + exception);
                exception.printStackTrace();
            }
        }
        this.tellListeners(new EventPlayerEvent(this, 3));
        while (this.evQueue.size() > 0) {
            this.evQueue.remove(0);
        }
        this.dispatching = false;
    }

    protected void finalize() {
        this.clear();
        this.listeners.removeAllElements();
    }

    public void clear() {
        this.evQueue.removeAllElements();
    }

    public int getPauseTime() {
        return this.inactivePauseTime;
    }

    public void setPauseTime(int n) {
        this.inactivePauseTime = n;
    }

    public void post(EVObject eVObject) {
        if (this.keepAlive) {
            Vector vector = this.evQueue;
            synchronized (vector) {
                this.evQueue.addElement(eVObject);
            }
            EventPlayer eventPlayer = this;
            synchronized (eventPlayer) {
                this.notify();
            }
        }
    }

    public void startDispatching() {
        if (this.keepAlive) {
            this.dispatching = true;
            EventPlayer eventPlayer = this;
            synchronized (eventPlayer) {
                this.notify();
            }
        }
    }

    public void stopDispatching() {
        if (this.keepAlive) {
            this.dispatching = false;
            EventPlayer eventPlayer = this;
            synchronized (eventPlayer) {
                this.notify();
            }
        }
    }

    public boolean dispatching() {
        return this.dispatching;
    }

    public void die() {
        this.keepAlive = false;
    }

    public boolean alive() {
        return this.keepAlive;
    }

    public int size() {
        return this.evQueue.size();
    }

    public void addEventPlayerListener(EventPlayerListener eventPlayerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(eventPlayerListener)) {
                return;
            }
            this.listeners.addElement(eventPlayerListener);
        }
    }

    public void removeEventPlayerListener(EventPlayerListener eventPlayerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(eventPlayerListener);
        }
    }

    private void tellListeners(EventPlayerEvent eventPlayerEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            EventPlayerListener eventPlayerListener = (EventPlayerListener)vector.elementAt(n2);
            switch (eventPlayerEvent.getID()) {
                case 1: {
                    eventPlayerListener.queueEmpty(eventPlayerEvent);
                    break;
                }
                case 2: {
                    eventPlayerListener.dispatched(eventPlayerEvent);
                    break;
                }
                case 3: {
                    eventPlayerListener.died(eventPlayerEvent);
                }
            }
            ++n2;
        }
    }

    private void dispatch(EVObject eVObject) throws IllegalArgumentException {
        if (eVObject instanceof EVMouseMove) {
            EVMouseMove eVMouseMove = (EVMouseMove)eVObject;
            this.peer.mouseMove(eVMouseMove.getX(), eVMouseMove.getY());
            this.tellListeners(new EventPlayerEvent(this, eVMouseMove));
        } else if (eVObject instanceof EVMouseButton) {
            EVMouseButton eVMouseButton = (EVMouseButton)eVObject;
            long l = eVMouseButton.getButton();
            if (eVMouseButton.getPress()) {
                this.peer.mousePress(l);
            } else {
                this.peer.mouseRelease(l);
            }
            this.tellListeners(new EventPlayerEvent(this, eVMouseButton));
        } else if (eVObject instanceof EVKey) {
            EVKey eVKey = (EVKey)eVObject;
            if (eVKey.getPress()) {
                this.peer.keyPress(eVKey.getKeycode());
            } else {
                this.peer.keyRelease(eVKey.getKeycode());
            }
            this.tellListeners(new EventPlayerEvent(this, eVKey));
        } else if (!(eVObject instanceof EVWait)) {
            throw new IllegalArgumentException("Unknown type of event " + eVObject.toString());
        }
    }
}

