/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import com.ibm.jvm.io.LocalizedInputStream;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.BufferedImageGraphics2D;
import sun.io.CharacterEncoding;
import sun.java2d.loops.RasterOutputManager;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment {
    private int debugMapping = 0;
    private Properties fprops;
    private TreeMap terminalNames;
    private boolean loadedAllFonts = false;
    protected String fontPath;
    protected TreeMap registeredFonts;
    protected String osVersion;
    private Hashtable mapFamilyCache;
    protected boolean loadNativeFonts = false;
    GraphicsDevice[] screens;
    private Font[] allFonts;
    private static boolean usesPlatformFont = false;
    private static final String systemBundle = "java.text.resources.LocaleElements";

    public SunGraphicsEnvironment() {
        try {
            String string = System.getProperty("sun.java2d.debugMapping", "0");
            this.debugMapping = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registeredFonts = new TreeMap();
        this.osVersion = this.getOsVersion();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SunGraphicsEnvironment.this.fontPath = System.getProperty("java.awt.fonts");
                if (SunGraphicsEnvironment.this.fontPath.length() == 0) {
                    boolean bl = false;
                    String string = System.getProperty("sun.java2d.noType1Font");
                    if (string == null) {
                        bl = NativeFontWrapper.getType1FontVar();
                    }
                    if ("true".equals(string)) {
                        bl = true;
                    }
                    SunGraphicsEnvironment.this.fontPath = NativeFontWrapper.getFontPath(bl);
                    SunGraphicsEnvironment.this.appendJavaDefaultFontPath();
                    SunGraphicsEnvironment.this.loadNativeFonts = true;
                } else {
                    System.out.println("Fontpath already set =" + SunGraphicsEnvironment.this.fontPath);
                }
                try {
                    usesPlatformFont = RasterOutputManager.usesPlatformFont();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SunGraphicsEnvironment.this.initializeProps();
                SunGraphicsEnvironment.this.initCompositeFonts();
                SunGraphicsEnvironment.this.setSubstitutes();
                return null;
            }
        });
    }

    protected String getOsVersion() {
        return System.getProperty("os.version");
    }

    protected synchronized void loadFonts() {
        if (this.loadedAllFonts) {
            return;
        }
        if (this.debugMapping > 0) {
            System.out.println("Load all fonts");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl;
                if (SunGraphicsEnvironment.this.fontPath == null) {
                    SunGraphicsEnvironment.this.fontPath = System.getProperty("java.awt.fonts");
                    if (SunGraphicsEnvironment.this.fontPath.length() == 0) {
                        bl = false;
                        String string = System.getProperty("sun.java2d.noType1Font");
                        if (string == null) {
                            bl = NativeFontWrapper.getType1FontVar();
                        }
                        if ("true".equals(string)) {
                            bl = true;
                        }
                        SunGraphicsEnvironment.this.fontPath = NativeFontWrapper.getFontPath(bl);
                        SunGraphicsEnvironment.this.appendJavaDefaultFontPath();
                        SunGraphicsEnvironment.this.loadNativeFonts = true;
                    }
                }
                bl = SunGraphicsEnvironment.this.registerFonts(SunGraphicsEnvironment.this.fontPath);
                boolean bl2 = false;
                if (SunGraphicsEnvironment.this.loadNativeFonts) {
                    bl2 = SunGraphicsEnvironment.this.registerNativeFonts();
                }
                if (!bl && !bl2) {
                    System.out.println("\nNo fonts were found in '" + SunGraphicsEnvironment.this.fontPath + "'.\n");
                    System.exit(2);
                }
                SunGraphicsEnvironment.this.loadedAllFonts = true;
                return null;
            }
        });
    }

    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        if (graphicsDeviceArray == null) {
            int n = this.getNumScreens();
            graphicsDeviceArray = new GraphicsDevice[n];
            int n2 = 0;
            while (n2 < n) {
                graphicsDeviceArray[n2] = this.makeScreenDevice(n2);
                ++n2;
            }
            this.screens = graphicsDeviceArray;
        }
        return graphicsDeviceArray;
    }

    protected abstract int getNumScreens();

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        return new BufferedImageGraphics2D(bufferedImage, null);
    }

    public Font[] getAllFonts() {
        if (this.allFonts != null) {
            return this.allFonts;
        }
        this.loadFonts();
        Font[] fontArray = null;
        String[] stringArray = null;
        int n = NativeFontWrapper.getNumFonts();
        if (n > 0) {
            Object[] objectArray;
            TreeMap treeMap = new TreeMap();
            int n2 = 0;
            while (n2 < n) {
                objectArray = NativeFontWrapper.getFullNameByIndex(n2);
                treeMap.put(objectArray, null);
                ++n2;
            }
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                objectArray = treeMap.keySet().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    stringArray[n3] = (String)objectArray[n3];
                    ++n3;
                }
            }
        }
        if (stringArray != null) {
            fontArray = new Font[stringArray.length];
            int n4 = 0;
            while (n4 < stringArray.length) {
                fontArray[n4] = new Font(stringArray[n4], 0, 1);
                ++n4;
            }
        }
        this.allFonts = fontArray;
        return this.allFonts;
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        this.loadFonts();
        String[] stringArray = null;
        int n = NativeFontWrapper.getNumFonts();
        short s = SunGraphicsEnvironment.getLcidFromLocale(locale);
        if (n > 0) {
            Object[] objectArray;
            String string;
            TreeMap treeMap = new TreeMap();
            int n2 = 0;
            while (n2 < n) {
                string = NativeFontWrapper.getFamilyNameByIndex(n2, s);
                objectArray = string.toLowerCase();
                if (!(objectArray.endsWith(".bold") || objectArray.endsWith(".bolditalic") || objectArray.endsWith(".italic"))) {
                    treeMap.put(objectArray, string);
                }
                ++n2;
            }
            string = "Serif";
            treeMap.put(string.toLowerCase(), string);
            string = "SansSerif";
            treeMap.put(string.toLowerCase(), string);
            string = "Monospaced";
            treeMap.put(string.toLowerCase(), string);
            string = "Dialog";
            treeMap.put(string.toLowerCase(), string);
            string = "DialogInput";
            treeMap.put(string.toLowerCase(), string);
            string = "Default";
            treeMap.put(string.toLowerCase(), string);
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                objectArray = treeMap.keySet().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    stringArray[n3] = (String)treeMap.get(objectArray[n3]);
                    ++n3;
                }
            }
        }
        return stringArray;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    public String mapFamilyName(String string, int n) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (!this.terminalNames.containsKey(string2)) {
            this.loadFonts();
        }
        String string3 = this.mapFamilyNameAll(string, n);
        return string3;
    }

    public String mapFamilyNameAll(String string, int n) {
        String string2;
        String string3 = string.toLowerCase();
        if (null != this.mapFamilyCache && null != (string2 = (String)this.mapFamilyCache.get(string3 + SunGraphicsEnvironment.styleStr(n)))) {
            return string2;
        }
        if (this.fprops == null) {
            return string;
        }
        if (this.debugMapping == 2) {
            System.out.println("Originalname[" + string + "." + SunGraphicsEnvironment.styleStr(n) + "]");
        }
        if ((string2 = this.fprops.getProperty("alias." + string3)) == null) {
            string2 = string;
        }
        Object[] objectArray = this.fprops.keySet().toArray();
        int n2 = objectArray.length;
        int n3 = 0;
        do {
            String string4;
            if (this.terminalNames.containsKey((string4 = string2.toLowerCase()) + "." + SunGraphicsEnvironment.styleStr(n))) {
                string2 = string4 + "." + SunGraphicsEnvironment.styleStr(n);
                break;
            }
            if (n == 0 && this.terminalNames.containsKey(string4)) break;
            String string5 = string4 + "." + SunGraphicsEnvironment.styleStr(n) + ".0";
            String string6 = this.fprops.getProperty(string5);
            if (this.debugMapping == 2) {
                System.out.println("  trying [" + string5 + "]");
            }
            if (string6 == null) {
                string5 = string4 + ".0";
                string6 = this.fprops.getProperty(string5);
                if (this.debugMapping == 2) {
                    System.out.println("  trying [" + string5 + "]");
                }
            }
            if (string6 == null) break;
            if (this.debugMapping == 2) {
                System.out.println("  found [" + string6 + "]");
            }
            string2 = this.parseFamilyNameProperty(string6);
        } while (++n3 < n2);
        if (this.debugMapping == 2) {
            System.out.println("    resolved to [" + string2 + "]");
        }
        if (null == this.mapFamilyCache) {
            this.mapFamilyCache = new Hashtable(5, 0.9f);
        }
        if (null != this.mapFamilyCache) {
            this.mapFamilyCache.put(string3 + SunGraphicsEnvironment.styleStr(n), string2);
        }
        return string2;
    }

    protected String parseFamilyNameProperty(String string) {
        int n = string.indexOf(",");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    protected String getFontPropertyFD(String string) {
        return this.parseFamilyNameProperty(string);
    }

    protected String getFileNameFromPlatformName(String string) {
        if (this.fprops == null) {
            return null;
        }
        string = string.replace(' ', '_');
        return this.fprops.getProperty("filename." + string);
    }

    public PrinterJob getPrinterJob() {
        new Exception().printStackTrace();
        return null;
    }

    private boolean registerFonts(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.registerFontPath(string2);
                bl |= this.addPathFonts(string2, new TTFilter(), 0);
                bl |= this.addPathFonts(string2, new T1Filter(), 1);
                bl |= this.addPathFonts(string2, new T2KFilter(), 2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        return bl;
    }

    private void registerFontFile(String string, String string2) {
        int n;
        if (this.registeredFonts.containsKey(string)) {
            if (this.debugMapping > 0) {
                System.out.println("Font already registered: " + string);
            }
            return;
        }
        if (this.debugMapping > 0) {
            System.out.println("Registering: " + string + " = [" + string2 + "]");
        }
        if (new TTFilter().accept(null, string)) {
            n = 0;
        } else if (new T1Filter().accept(null, string)) {
            n = 1;
        } else if (new T2KFilter().accept(null, string)) {
            n = 2;
        } else {
            this.registerNative(string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fontPath, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                File file = new File(string3, string);
                if (!file.canRead()) continue;
                Vector vector = new Vector(20, 10);
                Vector vector2 = new Vector(20, 10);
                vector2.addElement(string2);
                vector.addElement(file.getAbsolutePath());
                this.registeredFonts.put(string, file.getAbsolutePath());
                NativeFontWrapper.registerFonts(vector, vector.size(), vector2, n);
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
    }

    protected void registerFontPath(String string) {
    }

    protected void registerNative(String string) {
    }

    protected String getPropString(String string) {
        return string;
    }

    protected boolean registerNativeFonts() {
        return false;
    }

    private boolean addPathFonts(String string, FilenameFilter filenameFilter, int n) {
        boolean bl = false;
        Vector vector = new Vector(20, 10);
        Vector vector2 = new Vector(20, 10);
        File file = new File(string);
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return bl;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2 = new File(file, stringArray[n2]);
            if (!this.registeredFonts.containsKey(stringArray[n2])) {
                String string2 = file2.getAbsolutePath();
                this.registeredFonts.put(stringArray[n2], string2);
                vector.addElement(string2);
                vector2.addElement(this.getPropString(string2));
                bl = true;
            }
            ++n2;
        }
        NativeFontWrapper.registerFonts(vector, vector.size(), vector2, n);
        return bl;
    }

    public static Font getBestFontFor(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        char c = attributedCharacterIterator.setIndex(n);
        Map map = attributedCharacterIterator.getAttributes();
        Font font = Font.getFont(map);
        while (!font.canDisplay(c) && attributedCharacterIterator.getRunLimit() < n2) {
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            font = Font.getFont(attributedCharacterIterator.getAttributes());
        }
        if (!font.canDisplay(c)) {
            attributedCharacterIterator.setIndex(n);
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int n3 = 0;
            while (n3 < stringArray.length) {
                Hashtable hashtable = new Hashtable();
                hashtable.putAll(map);
                hashtable.put(TextAttribute.FAMILY, stringArray[n3]);
                font = Font.getFont(hashtable);
                if (font.canDisplay(c)) break;
                ++n3;
            }
            if (!font.canDisplay(c)) {
                font = Font.getFont(map);
            }
        }
        return font;
    }

    protected boolean platformReady() {
        return true;
    }

    private File tryOpeningFontProp(File file, Properties properties, String string, String string2, String string3, String string4, String string5) {
        File file2 = null;
        if (file != null) {
            file2 = file;
        } else {
            String string6 = usesPlatformFont ? "native" + File.separator : "";
            String string7 = "font.properties";
            String string8 = null;
            string8 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("ibm.jvm.fontproperties.dir");
                }
            });
            String string9 = string8 != null ? string8 + "/" : string + File.separator + "lib" + File.separator + string6;
            string7 = this.getPropsFilename(string7, string2, string3, string4, string5);
            if (properties != null) {
                string7 = properties.getProperty(string7);
            }
            if (string7 != null && (file = new File(string9 + string7)).canRead()) {
                file2 = file;
            }
        }
        return file2;
    }

    private void appendJavaDefaultFontPath() {
        String string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "fonts";
        if (string != null) {
            this.fontPath = this.fontPath + File.pathSeparator + string;
        }
    }

    private void initializeProps() {
        Object object;
        if (!this.platformReady()) {
            return;
        }
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        if (string2 == null) {
            throw new Error("java.home property not set");
        }
        String string3 = System.getProperty("user.language", "en");
        string3 = string3.toLowerCase();
        String string4 = System.getProperty("user.region");
        String string5 = System.getProperty("file.encoding");
        String string6 = CharacterEncoding.aliasName(string5);
        if (string6 == null) {
            string6 = string5;
        }
        if (this.osVersion == null) {
            this.osVersion = this.getOsVersion();
        }
        String string7 = usesPlatformFont ? "native" + File.separator : "";
        String string8 = string2 + File.separator + "lib" + File.separator + string7 + "fprop.dir";
        File file = new File(string8);
        Properties properties = null;
        if (file.exists()) {
            properties = new Properties();
            try {
                object = new BufferedInputStream(LocalizedInputStream.localize(new FileInputStream(file.getPath())));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            object = null;
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, string6, this.osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, null, this.osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, string6, this.osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, null, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, null, this.osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, string6, this.osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, null, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, null, this.osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, null, null);
            Properties properties2 = new Properties();
            properties2.put("serif.0", "unknown");
            properties2.put("sansserif.0", "unknown");
            properties2.put("monospaced.0", "unknown");
            properties2.put("dialog.0", "unknown");
            properties2.put("dialoginput.0", "unknown");
            properties2.put("default.0", "sansserif");
            properties2.put("timesroman.0", "serif");
            properties2.put("helvetica.0", "sansserif");
            properties2.put("courier.0", "monospaced");
            properties2.put("zapfdingbats.0", "unknown");
            this.fprops = new Properties(properties2);
            if (object != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize(new FileInputStream(((File)object).getPath())));
                this.fprops.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getPropsFilename(String string, String string2, String string3, String string4, String string5) {
        if (string2 != null) {
            string = string + "." + string2;
            if (string3 != null) {
                string = string + "_" + string3;
                if (string4 != null) {
                    string = string + "_" + string4;
                    if (string5 != null) {
                        string = string + "." + string5;
                    }
                } else if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string4 != null) {
                string = string + "_" + string4;
                if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string5 != null) {
                string = string + "." + string5;
            }
        } else if (string4 != null) {
            string = string + "." + string4;
            if (string5 != null) {
                string = string + "." + string5;
            }
        } else if (string5 != null) {
            string = string + "." + string5;
        }
        return string;
    }

    protected void initCompositeFonts() {
        String string;
        if (!this.platformReady()) {
            return;
        }
        this.initTerminalNames();
        Object[] objectArray = this.terminalNames.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            string = (String)objectArray[n];
            Integer n2 = (Integer)this.terminalNames.get(objectArray[n]);
            int n3 = n2;
            String[] stringArray = new String[n3];
            int[] nArray = new int[n3];
            int[] nArray2 = new int[]{};
            int n4 = 0;
            while (n4 < n3) {
                stringArray[n4] = this.parseFamilyNameProperty(this.fprops.getProperty(string + "." + n4));
                nArray2 = this.appendExclusions(string, n4, nArray2);
                nArray[n4] = nArray2.length;
                ++n4;
            }
            if (this.debugMapping == 2) {
                System.out.println("initCompositeFonts compositeFontName=" + string);
            }
            NativeFontWrapper.registerCompositeFont(string, stringArray, nArray2, nArray);
            ++n;
        }
        this.terminalNames.put("default", new Integer(0));
        string = this.fprops.getProperty("ibm.java2d.useawtfonts", "?");
        if (string.equals("0") || string.equals("1")) {
            NativeFontWrapper.setUsePlatformFont(string.equals("1"));
        }
    }

    private int[] appendExclusions(String string, int n, int[] nArray) {
        String string2;
        int n2;
        String string3 = "exclusion." + string + "." + n;
        if (this.fprops.containsKey(string3) && (n2 = ((string2 = this.fprops.getProperty(string3)).length() + 1) / 10) > 0) {
            Object object;
            int[] nArray2 = new int[n2 * 2];
            int n3 = 0;
            while (n3 < n2) {
                String string4 = string2.substring(n3 * 10, n3 * 10 + 4);
                object = string2.substring(n3 * 10 + 5, n3 * 10 + 9);
                nArray2[n3 * 2] = Integer.parseInt(string4, 16);
                nArray2[n3 * 2 + 1] = Integer.parseInt((String)object, 16);
                ++n3;
            }
            int n4 = nArray.length + nArray2.length;
            object = new int[n4];
            System.arraycopy(nArray, 0, object, 0, nArray.length);
            System.arraycopy(nArray2, 0, object, nArray.length, nArray2.length);
            nArray = object;
        }
        return nArray;
    }

    private void initTerminalNames() {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        this.terminalNames = new TreeMap();
        String string = "Serif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "SansSerif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Monospaced";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Dialog";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "DialogInput";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        Object[] objectArray = this.fprops.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            String string2;
            String string3;
            String string4 = (String)objectArray[n];
            int n2 = string4.indexOf(".");
            if (n2 == -1) {
                n2 = string4.length();
            }
            if ((treeMap.containsKey(string3 = string4.substring(0, n2)) || string3.equals("register")) && (n2 = string4.lastIndexOf(".")) != -1 && !this.terminalNames.containsKey(string2 = string4.substring(0, n2)) && this.fprops.containsKey(string2 + ".0")) {
                int n3 = 0;
                while (this.fprops.containsKey(string2 + "." + n3)) {
                    ++n3;
                }
                if (n3 != 0) {
                    if (!string3.equals("register")) {
                        this.terminalNames.put(string2, new Integer(n3));
                    }
                    if (this.debugMapping == 2) {
                        System.out.println("FamilyStyle: " + string2);
                        System.out.println("NumSlots: " + n3);
                        System.out.println("Key: " + (String)objectArray[n]);
                    }
                    int n4 = 0;
                    while (n4 < n3) {
                        String string5 = this.getFontPropertyFD(this.fprops.getProperty(string2 + "." + n4));
                        String string6 = this.getFileNameFromPlatformName(string5);
                        if (this.debugMapping == 2) {
                            System.out.println("FS: [" + string2 + "." + n4 + "] PN: [" + string5 + "] FN: [" + string6 + "]");
                        }
                        if (string6 == null) {
                            if (this.debugMapping == 1 || this.debugMapping == 2) {
                                System.out.println("Font specified in font.properties not found [" + string5 + "]");
                            }
                            this.loadFonts();
                            break;
                        }
                        if (!treeMap2.containsKey(string6)) {
                            if (this.debugMapping == 2) {
                                System.out.println("PN: [" + string5 + "] FN: [" + string6 + "]");
                            }
                            treeMap2.put(string6, null);
                            this.registerFontFile(string6, string5);
                        }
                        ++n4;
                    }
                }
            }
            ++n;
        }
    }

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    public static String createFont(File file) {
        String string = NativeFontWrapper.createFont(file.getAbsolutePath(), 0);
        return string;
    }

    private void setSubstitutes() {
        int n = 0;
        while (this.fprops.containsKey("substitute." + n)) {
            ++n;
        }
        if (n > 0) {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.fprops.getProperty("substitute." + n2);
                if (this.debugMapping > 0) {
                    System.out.println("Substitute " + n2 + " [" + stringArray[n2] + "]");
                }
                ++n2;
            }
            NativeFontWrapper.setSubstitutes(stringArray);
            NativeFontWrapper.setSubstitutes2(stringArray);
        }
    }

    private static short getLcidFromLocale(Locale locale) {
        String string;
        short s = 1033;
        if (locale.equals(Locale.US)) {
            return s;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(systemBundle, locale);
            string = resourceBundle.getString("LocaleID");
        }
        catch (MissingResourceException missingResourceException) {
            return s;
        }
        try {
            s = (short)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return s;
    }

    protected class T1Filter
    implements FilenameFilter {
        protected T1Filter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".ps") || string.endsWith(".PS") || string.endsWith(".pfb") || string.endsWith(".PFB") || string.endsWith(".pfa") || string.endsWith(".PFA");
        }
    }

    protected class T2KFilter
    implements FilenameFilter {
        protected T2KFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".t2k") || string.endsWith(".T2K");
        }
    }

    protected class TTFilter
    implements FilenameFilter {
        protected TTFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".ttc") || string.endsWith(".TTC");
        }
    }
}

