/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcLimits;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbcCallableStatement
extends JdbcOdbcPreparedStatement
implements CallableStatement {
    public byte[] scalez = new byte[200];
    private boolean lastParameterNull = false;

    public JdbcOdbcCallableStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        int n4;
        this.setSqlType(n, n2);
        if (n <= 200) {
            this.scalez[n] = (byte)n3;
        }
        this.setOutputParameter(n, true);
        switch (n2) {
            case 91: {
                n4 = 10;
                break;
            }
            case 92: {
                n4 = 8;
                break;
            }
            case 93: {
                n4 = 19;
                if (n3 <= 0) break;
                n4 += n3 + 1;
                break;
            }
            case -7: {
                n4 = 1;
                break;
            }
            case -6: {
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 6;
                break;
            }
            case 4: {
                n4 = 11;
                break;
            }
            case -5: {
                n4 = 20;
                break;
            }
            case 7: {
                n4 = 13;
                break;
            }
            case 6: 
            case 8: {
                n4 = 22;
                break;
            }
            case 2: 
            case 3: {
                n4 = 38;
                break;
            }
            default: {
                n4 = this.getPrecision(n2);
                if (n4 > 0 && n4 <= JdbcOdbcLimits.DEFAULT_IN_PRECISION) break;
                n4 = JdbcOdbcLimits.DEFAULT_IN_PRECISION;
            }
        }
        byte[] byArray = this.getLengthBuf(n);
        n2 = OdbcDef.jdbcTypeToOdbc(n2);
        int[] nArray = new int[]{0, 0, 0, 0};
        Object object = null;
        object = this.boundParams[n - 1].isInOutParameter() && this.boundParams[n - 1].boundValue == null ? null : this.allocBindBuf(n, n4 + 1);
        if (this.boundParams[n - 1].isInOutParameter()) {
            if (this.boundParams[n - 1].boundValue == null) {
                this.OdbcApi.SQLBindInOutParameterNull(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, byArray, nArray);
            } else if (n2 == 8) {
                if (this.boundParams[n - 1].boundType == 8) {
                    double d = (Double)this.boundParams[n - 1].boundValue;
                    String string = Double.toString(d);
                    try {
                        object = this.CharsToBytes(this.OdbcApi.charSet, string.toCharArray());
                        this.boundParams[n - 1].resetBindDataBuffer((byte[])object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, (byte[])object, byArray, nArray);
                }
            } else if (n2 == -2 || n2 == -4 && ((byte[])this.boundParams[n - 1].boundValue).length < JdbcOdbcLimits.DEFAULT_IN_PRECISION || n2 == -3 && ((byte[])this.boundParams[n - 1].boundValue).length < JdbcOdbcLimits.DEFAULT_IN_PRECISION) {
                if (this.boundParams[n - 1].boundType == -2 || this.boundParams[n - 1].boundType == -3 || this.boundParams[n - 1].boundType == -4) {
                    this.OdbcApi.SQLBindInOutParameterBinary(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, (byte[])object, byArray, nArray);
                }
            } else if (n2 == 11) {
                if (this.boundParams[n - 1].boundType == 93) {
                    Timestamp timestamp = (Timestamp)this.boundParams[n - 1].boundValue;
                    String string = timestamp.toString();
                    try {
                        object = this.CharsToBytes(this.OdbcApi.charSet, string.toCharArray());
                        this.boundParams[n - 1].resetBindDataBuffer((byte[])object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, (byte[])object, byArray, nArray);
                }
            } else {
                this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n, n2, n4, this.boundParams[n - 1].scale, (byte[])object, byArray, nArray);
            }
        } else {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n, n2, n3, (byte[])object, byArray, nArray);
        }
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
    }

    public boolean wasNull() throws SQLException {
        return this.lastParameterNull;
    }

    public String getString(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        int n2 = this.getSqlType(n);
        String string = null;
        try {
            byte[] byArray = this.getDataBuf(n);
            if (byArray != null) {
                string = this.BytesToChars(this.OdbcApi.charSet, byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("String value for OUT parameter " + n + "=" + string);
        }
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.isNull(n)) {
            return false;
        }
        boolean bl = false;
        String string = this.getString(n).trim();
        if (string.equals("1")) {
            bl = true;
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public int getInt(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0;
        }
        Integer n2 = new Integer(this.getString(n).trim());
        return n2;
    }

    public long getLong(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0L;
        }
        Long l = new Long(this.getString(n).trim());
        return l;
    }

    public float getFloat(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0f;
        }
        Float f = new Float(this.getString(n).trim());
        return f.floatValue();
    }

    public double getDouble(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0;
        }
        Double d = new Double(this.getString(n).trim());
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n).trim());
        return bigDecimal.setScale(n2, 6);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        if (this.boundParams[n - 1].isInOutParameter()) {
            byte[] byArray;
            int n2 = this.getParamLength(n);
            if (n2 < (byArray = this.getDataBuf(n)).length) {
                byte[] byArray2 = new byte[n2];
                int n3 = 0;
                while (n3 < this.getParamLength(n)) {
                    byArray2[n3] = byArray[n3];
                    ++n3;
                }
                this.boundParams[n - 1].resetBindDataBuffer(byArray2);
                return byArray2;
            }
            return byArray;
        }
        return JdbcOdbcObject.hexStringToByteArray(this.getString(n).trim());
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n).trim();
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n).trim();
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n).trim();
        if (string == null) {
            return null;
        }
        if (string.length() == 10) {
            string = string + " 00:00:00";
        }
        return Timestamp.valueOf(string);
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        int n2 = this.getSqlType(n);
        if (this.isNull(n)) {
            return null;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                if (n <= 200) {
                    object = this.getBigDecimal(n, this.scalez[n]);
                    break;
                }
                object = this.getBigDecimal(n, JdbcOdbcLimits.DEFAULT_OUT_SCALE);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: {
                object = new Integer(this.getByte(n));
                break;
            }
            case 5: {
                object = new Integer(this.getShort(n));
                break;
            }
            case 4: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 6: 
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
            }
        }
        return object;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n).trim());
        return bigDecimal;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        return null;
    }

    public Blob getBlob(int n) throws SQLException {
        return null;
    }

    public Clob getClob(int n) throws SQLException {
        return null;
    }

    public Array getArray(int n) throws SQLException {
        return null;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        long l = 0L;
        Date date = null;
        String string = this.getString(n).trim();
        if (string != null) {
            date = Date.valueOf(string);
            calendar.setTime(date);
            l = calendar.getTime().getTime();
        } else if (string == null) {
            return null;
        }
        if (l == 0L) {
            return null;
        }
        return new Date(l);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        long l = 0L;
        Time time = null;
        String string = this.getString(n).trim();
        if (string != null) {
            try {
                time = Time.valueOf(string);
                calendar.setTime(time);
                l = calendar.getTime().getTime();
            }
            catch (Exception exception) {}
        } else if (string == null) {
            return null;
        }
        if (l == 0L) {
            return null;
        }
        return new Time(l);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        long l = 0L;
        Timestamp timestamp = null;
        String string = this.getString(n).trim();
        if (string != null) {
            if (string.length() == 10) {
                string = string + " 00:00:00";
            }
            try {
                timestamp = Timestamp.valueOf(string);
                calendar.setTime(timestamp);
                l = calendar.getTime().getTime();
            }
            catch (Exception exception) {}
        } else if (string == null) {
            return null;
        }
        if (l == 0L) {
            return null;
        }
        return new Timestamp(l);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
    }

    protected boolean isNull(int n) throws SQLException {
        if (!this.isOutputParameter(n)) {
            throw new SQLException("Parameter " + n + " is not an OUTPUT parameter");
        }
        boolean bl = false;
        boolean bl2 = bl = this.getParamLength(n) == -1;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Output Parameter " + n + " null: " + bl);
        }
        this.lastParameterNull = bl;
        return bl;
    }

    protected void setOutputParameter(int n, boolean bl) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setOutputParameter(bl);
        }
    }

    protected boolean isOutputParameter(int n) {
        boolean bl = false;
        if (n >= 1 && n <= this.numParams) {
            bl = this.boundParams[n - 1].isOutputParameter();
        }
        return bl;
    }

    public void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0;
                this.FreeParams();
                int n = 1;
                while (this.boundParams != null && n <= this.boundParams.length) {
                    this.boundParams[n - 1].binaryData = null;
                    this.boundParams[n - 1].initialize();
                    this.boundParams[n - 1].paramInputStream = null;
                    this.boundParams[n - 1].inputParameter = false;
                    ++n;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.myConnection.deregisterStatement(this);
    }

    public void FreeParams() throws NullPointerException {
        try {
            int n = 1;
            while (n <= this.boundParams.length) {
                if (this.boundParams[n - 1].pA1 != 0) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pA1, this.boundParams[n - 1].pA2);
                    this.boundParams[n - 1].pA1 = 0;
                    this.boundParams[n - 1].pA2 = 0;
                }
                if (this.boundParams[n - 1].pB1 != 0) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pB1, this.boundParams[n - 1].pB2);
                    this.boundParams[n - 1].pB1 = 0;
                    this.boundParams[n - 1].pB2 = 0;
                }
                if (this.boundParams[n - 1].pC1 != 0) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pC1, this.boundParams[n - 1].pC2);
                    this.boundParams[n - 1].pC1 = 0;
                    this.boundParams[n - 1].pC2 = 0;
                }
                if (this.boundParams[n - 1].pS1 != 0) {
                    JdbcOdbc.ReleaseStoredChars(this.boundParams[n - 1].pS1, this.boundParams[n - 1].pS2);
                    this.boundParams[n - 1].pS1 = 0;
                    this.boundParams[n - 1].pS2 = 0;
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

