/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.TransferProtocolClient;
import sun.net.ftp.FtpInputStream;
import sun.net.ftp.FtpLoginException;
import sun.net.ftp.FtpProtocolException;

public class FtpClient
extends TransferProtocolClient {
    public static final int FTP_PORT = 21;
    static int FTP_SUCCESS = 1;
    static int FTP_TRY_AGAIN = 2;
    static int FTP_ERROR = 3;
    private Socket dataSocket = null;
    private boolean replyPending = false;
    private boolean binaryMode = false;
    String user = null;
    String password = null;
    String command;
    int lastReplyCode;
    public String welcomeMsg;
    public static boolean useFtpProxy;
    public static String ftpProxyHost;
    public static int ftpProxyPort;

    public static boolean getUseFtpProxy() {
        return FtpClient.getFtpProxyHost() != null;
    }

    public static String getFtpProxyHost() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("ftp.proxyHost");
                if (string == null) {
                    string = System.getProperty("ftpProxyHost");
                }
                if (string == null && Boolean.getBoolean("ftp.useProxy")) {
                    string = System.getProperty("proxyHost");
                }
                return string;
            }
        });
    }

    public static int getFtpProxyPort() {
        final int[] nArray = new int[]{80};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("ftp.proxyPort");
                if (string == null) {
                    string = System.getProperty("ftpProxyPort");
                }
                if (string == null && Boolean.getBoolean("ftp.useProxy")) {
                    string = System.getProperty("proxyPort");
                }
                if (string != null) {
                    nArray[0] = Integer.parseInt(string);
                }
                return null;
            }
        });
        return nArray[0];
    }

    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.issueCommand("QUIT");
            super.closeServer();
        }
    }

    protected int issueCommand(String string) throws IOException {
        int n;
        this.command = string;
        if (this.replyPending && this.readReply() == FTP_ERROR) {
            System.out.print("Error reading FTP pending reply\n");
        }
        this.replyPending = false;
        do {
            this.sendServer(string + "\r\n");
        } while ((n = this.readReply()) == FTP_TRY_AGAIN);
        return n;
    }

    protected void issueCommandCheck(String string) throws IOException {
        if (this.issueCommand(string) != FTP_SUCCESS) {
            throw new FtpProtocolException(string);
        }
    }

    protected int readReply() throws IOException {
        this.lastReplyCode = this.readServerResponse();
        switch (this.lastReplyCode / 100) {
            case 1: {
                this.replyPending = true;
            }
            case 2: 
            case 3: {
                return FTP_SUCCESS;
            }
            case 5: {
                if (this.lastReplyCode == 530) {
                    if (this.user == null) {
                        throw new FtpLoginException("Not logged in");
                    }
                    return FTP_ERROR;
                }
                if (this.lastReplyCode != 550) break;
                throw new FileNotFoundException(this.command + ": " + this.getResponseString());
            }
        }
        return FTP_ERROR;
    }

    protected Socket openDataConnection(String string) throws IOException {
        InetAddress inetAddress = this.serverSocket.getLocalAddress();
        byte[] byArray = inetAddress.getAddress();
        ServerSocket serverSocket = new ServerSocket(0, 1, inetAddress);
        String string2 = "PORT ";
        int n = 0;
        while (n < byArray.length) {
            string2 = string2 + (byArray[n] & 0xFF) + ",";
            ++n;
        }
        if (this.issueCommand(string2 = string2 + (serverSocket.getLocalPort() >>> 8 & 0xFF) + "," + (serverSocket.getLocalPort() & 0xFF)) == FTP_ERROR) {
            FtpProtocolException ftpProtocolException = new FtpProtocolException("PORT");
            serverSocket.close();
            throw ftpProtocolException;
        }
        if (this.issueCommand(string) == FTP_ERROR) {
            FtpProtocolException ftpProtocolException = new FtpProtocolException(string);
            serverSocket.close();
            throw ftpProtocolException;
        }
        this.dataSocket = serverSocket.accept();
        serverSocket.close();
        return this.dataSocket;
    }

    public void openServer(String string) throws IOException {
        int n = 21;
        this.openServer(string, n);
    }

    public void openServer(String string, int n) throws IOException {
        super.openServer(string, n);
        if (this.readReply() == FTP_ERROR) {
            throw new FtpProtocolException("Welcome message");
        }
    }

    public void login(String string, String string2) throws IOException {
        if (!this.serverIsOpen()) {
            throw new FtpLoginException("not connected to host");
        }
        this.user = string;
        this.password = string2;
        if (this.issueCommand("USER " + string) == FTP_ERROR) {
            throw new FtpLoginException("user");
        }
        if (string2 != null && this.issueCommand("PASS " + string2) == FTP_ERROR) {
            throw new FtpLoginException("password");
        }
        int n = 0;
        while (n < this.serverResponse.size()) {
            String string3 = (String)this.serverResponse.elementAt(n);
            if (string3 != null) {
                if (string3.charAt(3) != '-') break;
                string3 = string3.substring(4);
                this.welcomeMsg = this.welcomeMsg == null ? string3 : this.welcomeMsg + string3;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public TelnetInputStream get(String var1_1) throws IOException {
        block7: {
            try {
                var2_2 = this.openDataConnection("RETR " + var1_1);
                break block7;
            }
            catch (FileNotFoundException var3_3) {
                var4_4 = new StringTokenizer(var1_1, "/");
                var5_5 = null;
                ** while (var4_4.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = var4_4.nextToken();
                if (!var4_4.hasMoreElements()) break;
                try {
                    this.cd(var5_5);
                    continue;
                }
                catch (FtpProtocolException var6_6) {
                    throw var3_3;
                }
            }
lbl15:
            // 2 sources

            if (var5_5 != null) {
                var2_2 = this.openDataConnection("RETR " + var5_5);
            } else {
                throw var3_3;
            }
        }
        return new FtpInputStream(this, var2_2.getInputStream(), this.binaryMode);
    }

    public TelnetOutputStream put(String string) throws IOException {
        Socket socket = this.openDataConnection("STOR " + string);
        return new TelnetOutputStream(socket.getOutputStream(), this.binaryMode);
    }

    public TelnetInputStream list() throws IOException {
        Socket socket = this.openDataConnection("LIST");
        return new TelnetInputStream(socket.getInputStream(), this.binaryMode);
    }

    public void cd(String string) throws IOException {
        this.issueCommandCheck("CWD " + string);
    }

    public void binary() throws IOException {
        this.issueCommandCheck("TYPE I");
        this.binaryMode = true;
    }

    public void ascii() throws IOException {
        this.issueCommandCheck("TYPE A");
        this.binaryMode = false;
    }

    public FtpClient(String string) throws IOException {
        this.openServer(string, 21);
    }

    public FtpClient(String string, int n) throws IOException {
        this.openServer(string, n);
    }

    public FtpClient() {
    }
}

