/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.file;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.file.FileURLConnection;

public class Handler
extends URLStreamHandler {
    static final int ABSOLUTE_SPEC = -1;
    static final int ABSOLUTE_PATH = 0;
    static final int RELATIVE_PATH = 1;

    private String getHost(URL uRL) {
        String string = uRL.getHost();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private int detectSpecType(String string, int n) {
        int n2 = -1;
        n2 = string.substring(0, n).equalsIgnoreCase("file:") ? -1 : (string.charAt(n) == '/' || string.indexOf(":/") == 1 ? 0 : 1);
        return n2;
    }

    private void parseRelativePath(URL uRL, String string) {
        String string2 = uRL.getFile();
        if (!(string2 = this.normalize(string2, 0, string2.length(), -1)).endsWith("/")) {
            int n = string2.lastIndexOf(47);
            string2 = n != -1 ? string2.substring(0, n + 1) : "";
        }
        string2 = new String(string2 + string);
        ParseUtil parseUtil = new ParseUtil();
        string2 = parseUtil.canonizeString(string2);
        this.setURL(uRL, "file", this.getHost(uRL), -1, string2, uRL.getRef());
    }

    private void parseAbsoluteSpec(URL uRL, String string) {
        String string2 = "";
        String string3 = "";
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        if (string.startsWith("//")) {
            n2 = string.indexOf(47, 2);
            if (n2 == -1) {
                n2 = n;
            }
            string2 = string.substring(2, n2);
        }
        if (n2 < n) {
            string3 = string.substring(n2);
            ParseUtil parseUtil = new ParseUtil();
            string3 = parseUtil.canonizeString(string3);
        }
        this.setURL(uRL, "file", string2, -1, string3, uRL.getRef());
    }

    private void parseAbsolutePath(URL uRL, String string) {
        ParseUtil parseUtil = new ParseUtil();
        string = parseUtil.canonizeString(string);
        this.setURL(uRL, "file", this.getHost(uRL), -1, string, uRL.getRef());
    }

    private String normalize(String string, int n, int n2, int n3) {
        string = string.substring(n, n2);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n4 = 0;
        if (File.separatorChar != '/') {
            n4 = string.indexOf(File.separatorChar);
            while (n4 != -1) {
                stringBuffer.setCharAt(n4, '/');
                n4 = string.indexOf(File.separatorChar, n4 + 1);
            }
            string = stringBuffer.toString();
        }
        if ((n4 = string.indexOf("//")) == 0) {
            if (string.length() > 2 && string.charAt(2) == '/') {
                stringBuffer.delete(0, 2);
                string = stringBuffer.toString();
                n4 = string.indexOf("//");
            } else if (n3 == -1) {
                n4 = string.indexOf("//", 2);
            }
        }
        while (n4 != -1) {
            stringBuffer.deleteCharAt(n4);
            string = stringBuffer.toString();
            n4 = string.indexOf("//", n4);
        }
        return string;
    }

    protected void parseURL(URL uRL, String string, int n, int n2) {
        int n3 = this.detectSpecType(string, n);
        String string2 = this.normalize(string, n, n2, n3);
        switch (n3) {
            case -1: {
                this.parseAbsoluteSpec(uRL, string2);
                break;
            }
            case 0: {
                this.parseAbsolutePath(uRL, string2);
                break;
            }
            case 1: {
                this.parseRelativePath(uRL, string2);
                break;
            }
            default: {
                throw new InternalError("invalid file type");
            }
        }
    }

    public synchronized URLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection;
        String string = uRL.getHost();
        if (string == null || string.equals("") || string.equals("~") || string.equals("localhost")) {
            return new FileURLConnection(uRL);
        }
        try {
            URL uRL2 = new URL("ftp", string, uRL.getFile() + (uRL.getRef() == null ? "" : "#" + uRL.getRef()));
            uRLConnection = uRL2.openConnection();
        }
        catch (IOException iOException) {
            uRLConnection = null;
        }
        if (uRLConnection == null) {
            throw new IOException("Unable to connect to: " + uRL.toExternalForm());
        }
        return uRLConnection;
    }
}

