/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarFile;

class JarFileFactory {
    private static Map cache = new Hashtable();
    private static int BUF_SIZE = 2048;
    private HashMap permissions = new HashMap();
    private HashMap connections = new HashMap();
    private HashMap fileCache = new HashMap();

    JarFileFactory() {
    }

    private boolean isFileURL(URL uRL) {
        return uRL.getProtocol().equalsIgnoreCase("file");
    }

    public URLConnection getConnection(JarFile jarFile) {
        return (URLConnection)this.connections.get(jarFile);
    }

    public void cacheConnection(JarFile jarFile, URLConnection uRLConnection) {
        this.connections.put(jarFile, uRLConnection);
    }

    public Permission getPermission(JarFile jarFile) {
        return (Permission)this.permissions.get(jarFile);
    }

    public void cachePermission(JarFile jarFile, Permission permission) {
        this.permissions.put(jarFile, permission);
    }

    public synchronized JarFile get(URL uRL) throws IOException {
        JarFile jarFile = null;
        if (this.isFileURL(uRL)) {
            jarFile = (JarFile)this.fileCache.get(uRL);
            if (jarFile == null) {
                jarFile = new JarFile(uRL.getFile());
                this.fileCache.put(uRL, jarFile);
            }
            URLConnection uRLConnection = uRL.openConnection();
            Permission permission = uRLConnection.getPermission();
            this.cachePermission(jarFile, permission);
            this.cacheConnection(jarFile, uRLConnection);
        } else {
            jarFile = this.getCachedJarFile(uRL);
            if (jarFile == null) {
                jarFile = this.retrieve(uRL);
                this.cacheJarFile(uRL, jarFile);
            }
            if (jarFile == null) {
                throw new FileNotFoundException(uRL.toString());
            }
        }
        return jarFile;
    }

    void cacheJarFile(URL uRL, JarFile jarFile) {
        cache.put(uRL, jarFile);
    }

    JarFile getCachedJarFile(URL uRL) {
        SecurityManager securityManager;
        Permission permission;
        JarFile jarFile = (JarFile)cache.get(uRL);
        if (jarFile != null && (permission = this.getPermission(jarFile)) != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
        return jarFile;
    }

    public JarFile retrieve(URL uRL) throws IOException {
        JarFile jarFile = null;
        final URLConnection uRLConnection = uRL.openConnection();
        Permission permission = null;
        permission = uRLConnection.getPermission();
        int n = uRLConnection.getContentLength();
        try {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() throws IOException {
                    JarFile jarFile;
                    OutputStream outputStream;
                    block4: {
                        InputStream inputStream = null;
                        outputStream = null;
                        try {
                            inputStream = uRLConnection.getInputStream();
                            File file = File.createTempFile("jar_cache", null);
                            file.deleteOnExit();
                            outputStream = new FileOutputStream(file);
                            int n = 0;
                            byte[] byArray = new byte[BUF_SIZE];
                            while ((n = inputStream.read(byArray)) != -1) {
                                outputStream.write(byArray, 0, n);
                            }
                            jarFile = new JarFile(file);
                            Object var8_7 = null;
                            if (inputStream == null) break block4;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (outputStream == null) throw throwable;
                            outputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    if (outputStream == null) return jarFile;
                    outputStream.close();
                    return jarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        if (jarFile != null) {
            this.cachePermission(jarFile, permission);
            this.cacheConnection(jarFile, uRLConnection);
        }
        return jarFile;
    }
}

