/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cachescheme;

import sun.plugin.cachescheme.PluginMutexException;
import sun.plugin.cachescheme.SyncObject;

public class PluginMutex {
    String m_name = null;
    Object m_obj;
    boolean cv = false;

    public PluginMutex(String string) {
        this.m_name = string;
        this.m_obj = SyncObject.create(string);
        this.cv = true;
    }

    public boolean release() throws PluginMutexException {
        boolean bl = false;
        if (this.m_obj != null) {
            Object object = this.m_obj;
            synchronized (object) {
                this.cv = true;
                this.m_obj.notify();
            }
            bl = true;
        }
        return bl;
    }

    public boolean waitForLock() throws PluginMutexException {
        boolean bl = false;
        if (this.m_obj != null) {
            try {
                Object object = this.m_obj;
                synchronized (object) {
                    while (!this.cv) {
                        this.m_obj.wait(0L);
                        Thread.currentThread();
                        Thread.yield();
                    }
                    this.cv = false;
                }
                bl = true;
            }
            catch (Exception exception) {
                throw new PluginMutexException("Unable to wait for mutex \"" + this.m_name + "\"");
            }
        }
        return bl;
    }

    public void finalize() throws PluginMutexException {
        this.release();
    }
}

