/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class StringWriter
extends Writer {
    private StringBuffer buf;
    private boolean isClosed = false;

    private void ensureOpen() {
    }

    public StringWriter() {
        this.buf = new StringBuffer();
        this.lock = this.buf;
    }

    public StringWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new StringBuffer(n);
        this.lock = this.buf;
    }

    public void write(int n) {
        this.ensureOpen();
        this.buf.append((char)n);
    }

    public void write(char[] cArray, int n, int n2) {
        this.ensureOpen();
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.buf.append(cArray, n, n2);
    }

    public void write(String string) {
        this.ensureOpen();
        this.buf.append(string);
    }

    public void write(String string, int n, int n2) {
        this.ensureOpen();
        this.buf.append(string.substring(n, n + n2));
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringBuffer getBuffer() {
        return this.buf;
    }

    public void flush() {
        this.ensureOpen();
    }

    public void close() throws IOException {
        this.isClosed = true;
    }
}

