/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static StyleContext defaultContext;
    public static final String DEFAULT_STYLE = "default";
    private static Hashtable freezeKeyMap;
    private static Hashtable thawKeyMap;
    private Style styles;
    private transient FontKey fontSearch = new FontKey(null, 0, 0);
    private transient Hashtable fontTable = new Hashtable();
    private transient Hashtable attributesPool = new Hashtable();
    private transient MutableAttributeSet search = new SimpleAttributeSet();
    private int unusedSets;
    static final int THRESHOLD = 9;

    public static final StyleContext getDefaultStyleContext() {
        if (defaultContext == null) {
            defaultContext = new StyleContext();
        }
        return defaultContext;
    }

    public StyleContext() {
        this.styles = new NamedStyle(null);
        this.addStyle(DEFAULT_STYLE, null);
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(string, style);
        if (string != null) {
            this.styles.addAttribute(string, namedStyle);
        }
        return namedStyle;
    }

    public void removeStyle(String string) {
        this.styles.removeAttribute(string);
    }

    public Style getStyle(String string) {
        return (Style)this.styles.getAttribute(string);
    }

    public Enumeration getStyleNames() {
        return this.styles.getAttributeNames();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.styles.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.styles.removeChangeListener(changeListener);
    }

    public Font getFont(AttributeSet attributeSet) {
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n2 = StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            n2 -= 2;
        }
        return this.getFont(string, n, n2);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground(AttributeSet attributeSet) {
        return StyleConstants.getBackground(attributeSet);
    }

    public Font getFont(String string, int n, int n2) {
        this.fontSearch.setValue(string, n, n2);
        Font font = (Font)this.fontTable.get(this.fontSearch);
        if (font == null) {
            font = new Font(string, n, n2);
            FontKey fontKey = new FontKey(string, n, n2);
            this.fontTable.put(fontKey, font);
        }
        return font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public synchronized AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (attributeSet.getAttributeCount() + 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttribute(object, object2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttribute(object, object2);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() + attributeSet2.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.addAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.addAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (attributeSet.getAttributeCount() - 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttribute(object);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttribute(object);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration enumeration) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(enumeration);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(enumeration);
        return mutableAttributeSet;
    }

    public synchronized AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(attributeSet);
            this.search.removeAttributes(attributeSet2);
            this.reclaim(attributeSet);
            return this.getImmutableUniqueSet();
        }
        MutableAttributeSet mutableAttributeSet = this.getMutableAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(attributeSet2);
        return mutableAttributeSet;
    }

    public AttributeSet getEmptySet() {
        return SimpleAttributeSet.EMPTY;
    }

    public void reclaim(AttributeSet attributeSet) {
        if (attributeSet instanceof SmallAttributeSet) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)attributeSet;
            --smallAttributeSet.nrefs;
            if (smallAttributeSet.nrefs <= 0) {
                ++this.unusedSets;
                if (this.unusedSets > 10 && this.unusedSets > this.attributesPool.size() / 10) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.removeUnusedSets();
                    } else {
                        Runnable runnable = new Runnable(){

                            public void run() {
                                StyleContext.this.removeUnusedSets();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            }
        }
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallAttributeSet(attributeSet);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new SimpleAttributeSet(attributeSet);
    }

    synchronized void removeUnusedSets() {
        Vector vector = new Vector();
        Enumeration enumeration = this.attributesPool.keys();
        while (enumeration.hasMoreElements()) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)enumeration.nextElement();
            if (smallAttributeSet.nrefs > 0) continue;
            vector.addElement(smallAttributeSet);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.attributesPool.remove(enumeration.nextElement());
        }
        this.unusedSets = 0;
    }

    AttributeSet getImmutableUniqueSet() {
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(this.search);
        SmallAttributeSet smallAttributeSet2 = (SmallAttributeSet)this.attributesPool.get(smallAttributeSet);
        if (smallAttributeSet2 == null) {
            smallAttributeSet2 = smallAttributeSet;
            this.attributesPool.put(smallAttributeSet2, smallAttributeSet2);
        }
        ++smallAttributeSet2.nrefs;
        return smallAttributeSet2;
    }

    MutableAttributeSet getMutableAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof MutableAttributeSet && attributeSet != SimpleAttributeSet.EMPTY) {
            return (MutableAttributeSet)attributeSet;
        }
        return this.createLargeAttributeSet(attributeSet);
    }

    public String toString() {
        this.removeUnusedSets();
        String string = "";
        Enumeration enumeration = this.attributesPool.keys();
        while (enumeration.hasMoreElements()) {
            SmallAttributeSet smallAttributeSet = (SmallAttributeSet)enumeration.nextElement();
            string = string + smallAttributeSet + "\n";
        }
        return string;
    }

    public void writeAttributes(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        StyleContext.writeAttributeSet(objectOutputStream, attributeSet);
    }

    public void readAttributes(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        StyleContext.readAttributeSet(objectInputStream, mutableAttributeSet);
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        int n = attributeSet.getAttributeCount();
        objectOutputStream.writeInt(n);
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2 = enumeration.nextElement();
            if (object2 instanceof Serializable) {
                objectOutputStream.writeObject(object2);
            } else {
                object = freezeKeyMap.get(object2);
                if (object == null) {
                    throw new NotSerializableException(object2.getClass().getName() + " is not serializable as a key in an AttributeSet");
                }
                objectOutputStream.writeObject(object);
            }
            object = attributeSet.getAttribute(object2);
            if (object instanceof Serializable) {
                objectOutputStream.writeObject(object);
                continue;
            }
            Object object3 = freezeKeyMap.get(object);
            if (object3 == null) {
                throw new NotSerializableException(object.getClass().getName() + " is not serializable as a value in an AttributeSet");
            }
            objectOutputStream.writeObject(object3);
        }
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (thawKeyMap != null) {
                Object object3;
                Object object4 = thawKeyMap.get(object);
                if (object4 != null) {
                    object = object4;
                }
                if ((object3 = thawKeyMap.get(object2)) != null) {
                    object2 = object3;
                }
            }
            mutableAttributeSet.addAttribute(object, object2);
            ++n2;
        }
    }

    public static void registerStaticAttributeKey(Object object) {
        String string = object.getClass().getName() + "." + object.toString();
        if (freezeKeyMap == null) {
            freezeKeyMap = new Hashtable();
            thawKeyMap = new Hashtable();
        }
        freezeKeyMap.put(object, string);
        thawKeyMap.put(string, object);
    }

    public static Object getStaticAttribute(Object object) {
        if (thawKeyMap == null || object == null) {
            return null;
        }
        return thawKeyMap.get(object);
    }

    public static Object getStaticAttributeKey(Object object) {
        return object.getClass().getName() + "." + object.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.removeUnusedSets();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.fontSearch = new FontKey(null, 0, 0);
        this.fontTable = new Hashtable();
        this.search = new SimpleAttributeSet();
        this.attributesPool = new Hashtable();
        objectInputStream.defaultReadObject();
    }

    static {
        try {
            int n = StyleConstants.keys.length;
            int n2 = 0;
            while (n2 < n) {
                StyleContext.registerStaticAttributeKey(StyleConstants.keys[n2]);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public class NamedStyle
    implements Style,
    Serializable {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        private transient AttributeSet attributes;
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        public NamedStyle(String string, Style style) {
            this.attributes = StyleContext.this.getEmptySet();
            if (string != null) {
                this.setName(string);
            }
            if (style != null) {
                this.setResolveParent(style);
            }
        }

        public NamedStyle(Style style) {
            this(null, style);
        }

        public NamedStyle() {
            this.attributes = StyleContext.this.getEmptySet();
        }

        public String toString() {
            return "NamedStyle:" + this.getName() + " " + this.attributes;
        }

        public String getName() {
            if (this.isDefined(StyleConstants.NameAttribute)) {
                return (String)this.getAttribute(StyleConstants.NameAttribute);
            }
            return null;
        }

        public void setName(String string) {
            if (string != null) {
                this.addAttribute(StyleConstants.NameAttribute, string);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NamedStyle.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NamedStyle.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        protected void fireStateChanged() {
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? NamedStyle.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
                }
                n -= 2;
            }
        }

        public EventListener[] getListeners(Class clazz) {
            return this.listenerList.getListeners(clazz);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public AttributeSet copyAttributes() {
            NamedStyle namedStyle = new NamedStyle();
            namedStyle.attributes = this.attributes.copyAttributes();
            return namedStyle;
        }

        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public void addAttribute(Object object, Object object2) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        public void addAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void removeAttribute(Object object) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        public void removeAttributes(Enumeration enumeration) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = styleContext.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        public void removeAttributes(AttributeSet attributeSet) {
            StyleContext styleContext = StyleContext.this;
            this.attributes = attributeSet == this ? styleContext.getEmptySet() : styleContext.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
            } else {
                this.removeAttribute(StyleConstants.ResolveAttribute);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            StyleContext.writeAttributeSet(objectOutputStream, this.attributes);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.attributes = SimpleAttributeSet.EMPTY;
            StyleContext.readAttributeSet(objectInputStream, this);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class FontKey {
        private String family;
        private int style;
        private int size;

        public FontKey(String string, int n, int n2) {
            this.setValue(string, n, n2);
        }

        public void setValue(String string, int n, int n2) {
            this.family = string != null ? string.intern() : null;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            return this.family.hashCode() ^ this.style ^ this.size;
        }

        public boolean equals(Object object) {
            if (object instanceof FontKey) {
                FontKey fontKey = (FontKey)object;
                return this.size == fontKey.size && this.style == fontKey.style && this.family == fontKey.family;
            }
            return false;
        }
    }

    class KeyBuilder {
        private Vector keys = new Vector();
        private Vector data = new Vector();

        KeyBuilder() {
        }

        public void initialize(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                this.initialize(((SmallAttributeSet)attributeSet).attributes);
            } else {
                this.keys.removeAllElements();
                this.data.removeAllElements();
                Enumeration enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    this.addAttribute(object, attributeSet.getAttribute(object));
                }
            }
        }

        private void initialize(Object[] objectArray) {
            this.keys.removeAllElements();
            this.data.removeAllElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.keys.addElement(objectArray[n2]);
                this.data.addElement(objectArray[n2 + 1]);
                n2 += 2;
            }
        }

        public Object[] createTable() {
            int n = this.keys.size();
            Object[] objectArray = new Object[2 * n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = 2 * n2;
                objectArray[n3] = this.keys.elementAt(n2);
                objectArray[n3 + 1] = this.data.elementAt(n2);
                ++n2;
            }
            return objectArray;
        }

        int getCount() {
            return this.keys.size();
        }

        public void addAttribute(Object object, Object object2) {
            this.keys.addElement(object);
            this.data.addElement(object2);
        }

        public void addAttributes(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                Object[] objectArray = ((SmallAttributeSet)attributeSet).attributes;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    this.addAttribute(objectArray[n2], objectArray[n2 + 1]);
                    n2 += 2;
                }
            } else {
                Enumeration enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    this.addAttribute(object, attributeSet.getAttribute(object));
                }
            }
        }

        public void removeAttribute(Object object) {
            int n = this.keys.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.keys.elementAt(n2).equals(object)) {
                    this.keys.removeElementAt(n2);
                    this.data.removeElementAt(n2);
                    return;
                }
                ++n2;
            }
        }

        public void removeAttributes(Enumeration enumeration) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                this.removeAttribute(object);
            }
        }

        public void removeAttributes(AttributeSet attributeSet) {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = attributeSet.getAttribute(object);
                this.removeSearchAttribute(object, object2);
            }
        }

        private void removeSearchAttribute(Object object, Object object2) {
            int n = this.keys.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.keys.elementAt(n2).equals(object)) {
                    if (this.data.elementAt(n2).equals(object2)) {
                        this.keys.removeElementAt(n2);
                        this.data.removeElementAt(n2);
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    class KeyEnumeration
    implements Enumeration {
        Object[] attr;
        int i;

        KeyEnumeration(Object[] objectArray) {
            this.attr = objectArray;
            this.i = 0;
        }

        public boolean hasMoreElements() {
            return this.i < this.attr.length;
        }

        public Object nextElement() {
            if (this.i < this.attr.length) {
                Object object = this.attr[this.i];
                this.i += 2;
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    public class SmallAttributeSet
    implements AttributeSet {
        Object[] attributes;
        int nrefs;
        AttributeSet resolveParent;

        public SmallAttributeSet(Object[] objectArray) {
            this.attributes = objectArray;
            this.updateResolveParent();
        }

        public SmallAttributeSet(AttributeSet attributeSet) {
            int n = attributeSet.getAttributeCount();
            Object[] objectArray = new Object[2 * n];
            Enumeration enumeration = attributeSet.getAttributeNames();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n2] = enumeration.nextElement();
                objectArray[n2 + 1] = attributeSet.getAttribute(objectArray[n2]);
                n2 += 2;
            }
            this.attributes = objectArray;
            this.updateResolveParent();
        }

        private void updateResolveParent() {
            this.resolveParent = null;
            Object[] objectArray = this.attributes;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == StyleConstants.ResolveAttribute) {
                    this.resolveParent = (AttributeSet)objectArray[n + 1];
                    break;
                }
                n += 2;
            }
        }

        Object getLocalAttribute(Object object) {
            if (object == StyleConstants.ResolveAttribute) {
                return this.resolveParent;
            }
            Object[] objectArray = this.attributes;
            int n = 0;
            while (n < objectArray.length) {
                if (object.equals(objectArray[n])) {
                    return objectArray[n + 1];
                }
                n += 2;
            }
            return null;
        }

        public String toString() {
            String string = "{";
            Object[] objectArray = this.attributes;
            int n = 0;
            while (n < objectArray.length) {
                string = objectArray[n + 1] instanceof AttributeSet ? string + objectArray[n] + "=" + "AttributeSet" + "," : string + objectArray[n] + "=" + objectArray[n + 1] + ",";
                n += 2;
            }
            string = string + "nrefs=" + this.nrefs + "}";
            return string;
        }

        public int hashCode() {
            int n = 0;
            Object[] objectArray = this.attributes;
            int n2 = 1;
            while (n2 < objectArray.length) {
                n ^= objectArray[n2].hashCode();
                n2 += 2;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof AttributeSet) {
                AttributeSet attributeSet = (AttributeSet)object;
                return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
            }
            return false;
        }

        public Object clone() {
            return this;
        }

        public int getAttributeCount() {
            return this.attributes.length / 2;
        }

        public boolean isDefined(Object object) {
            Object[] objectArray = this.attributes;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (object.equals(objectArray[n2])) {
                    return true;
                }
                n2 += 2;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            if (attributeSet instanceof SmallAttributeSet) {
                return attributeSet == this;
            }
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this;
        }

        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = this.getLocalAttribute(object);
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        public Enumeration getAttributeNames() {
            return new KeyEnumeration(this.attributes);
        }

        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl = true;
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (bl && enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                bl = attributeSet.getAttribute(object).equals(this.getAttribute(object));
            }
            return bl;
        }

        public AttributeSet getResolveParent() {
            return this.resolveParent;
        }
    }
}

