/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethodAdapter;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11InputMethodDescriptor;

public class X11InputMethod
extends InputMethodAdapter {
    private static final int XIMReverse = 1;
    private static final int XIMUnderline = 2;
    private static final int XIMHighlight = 4;
    private static final int XIMPrimary = 32;
    private static final int XIMSecondary = 64;
    private static final int XIMTertiary = 128;
    private static final int XIMVisibleToForward = 256;
    private static final int XIMVisibleToBackward = 512;
    private static final int XIMVisibleCenter = 1024;
    private static final int XIMVisibleMask = 1792;
    private Locale locale = X11InputMethodDescriptor.getSupportedLocale();
    private static boolean isXIMOpened = false;
    private Container clientComponentWindow = null;
    private boolean createXICFailed = false;
    private Component awtFocussedComponent = null;
    private Component xicFocussedComponent = null;
    private boolean isActive = false;
    private boolean isActiveClient = false;
    private static Map[] highlightStyles;
    private boolean disposed = false;
    private boolean needResetXIC = false;
    private Component needResetXICClient = null;
    private boolean needPreeditEnable = false;
    private String committedText = null;
    private StringBuffer composedText = null;
    private IntBuffer rawFeedbacks;
    private transient long pData = 0L;
    private boolean waitingPreeditCompletion = false;
    private static final int INITIAL_SIZE = 64;

    private static native void initIDs();

    public X11InputMethod() throws AWTException {
        if (!this.initXIM()) {
            throw new AWTException("cannot open XIM");
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private synchronized boolean initXIM() {
        if (!isXIMOpened) {
            isXIMOpened = this.openXIM();
        }
        return isXIMOpened;
    }

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
    }

    public boolean setLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return true;
        }
        return this.locale.equals(Locale.JAPAN) && locale.equals(Locale.JAPANESE) || this.locale.equals(Locale.KOREA) && locale.equals(Locale.KOREAN);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    private final void resetXICifneeded() {
        if (this.needResetXIC) {
            if (this.pData != 0L && this.getClientComponent() != this.needResetXICClient) {
                this.resetXIC(this.pData);
            }
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    public synchronized void activate() {
        if (this.createXICFailed || this.awtFocussedComponent == null) {
            return;
        }
        this.resetXICifneeded();
        this.clientComponentWindow = this.getClientComponentWindow();
        if (this.clientComponentWindow == null) {
            return;
        }
        if (this.xicFocussedComponent != null) {
            if (this.xicFocussedComponent != this.awtFocussedComponent && this.pData != 0L) {
                this.setXICFocus(this.getPeer(this.xicFocussedComponent), false, this.isActiveClient, this.pData);
            }
            this.xicFocussedComponent = null;
        }
        if (this.pData == 0L) {
            MComponentPeer mComponentPeer = this.getPeer(this.clientComponentWindow);
            boolean bl = false;
            if (mComponentPeer instanceof MInputMethodControl) {
                bl = ((MInputMethodControl)((Object)mComponentPeer)).hasTextComponents();
            }
            this.pData = this.createXICNative(mComponentPeer, bl);
            if (this.pData == 0L) {
                this.createXICFailed = true;
                return;
            }
            this.disposed = false;
            if (mComponentPeer instanceof MInputMethodControl) {
                ((MInputMethodControl)((Object)mComponentPeer)).addInputMethod(this);
            }
        }
        this.setXICFocus(this.getPeer(this.awtFocussedComponent), true, this.haveActiveClient(), this.pData);
        this.isActive = true;
        if (this.needPreeditEnable) {
            try {
                this.setCompositionEnabled(true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.needPreeditEnable = false;
        }
    }

    public synchronized void deactivate(boolean bl) {
        if (this.pData != 0L) {
            boolean bl2 = this.haveActiveClient();
            if (bl) {
                this.xicFocussedComponent = this.awtFocussedComponent;
                this.isActiveClient = bl2;
                this.turnoffStatusWindow();
            } else {
                if (this.awtFocussedComponent == null) {
                    return;
                }
                if (this.composedText != null || this.committedText != null) {
                    this.deleteComposedText();
                }
                this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, bl2, this.pData);
                this.xicFocussedComponent = null;
            }
        }
        this.isActive = false;
    }

    public void hideWindows() {
    }

    static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n;
        int n2 = inputMethodHighlight.getState();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            n = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n;
        }
        return highlightStyles[n];
    }

    protected void setAWTFocussedComponent(Component component) {
        if (this.isActive && this.pData != 0L) {
            boolean bl = this.haveActiveClient();
            if (this.awtFocussedComponent != null) {
                this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, bl, this.pData);
            }
            if (component != null) {
                this.setXICFocus(this.getPeer(component), true, bl, this.pData);
            }
        }
        this.awtFocussedComponent = component;
    }

    protected void stopListening() {
        if (this.pData != 0L) {
            this.endComposition();
            if (this.needResetXIC) {
                this.resetXIC(this.pData);
                this.needResetXICClient = null;
                this.needResetXIC = false;
            }
        }
    }

    private Window getClientComponentWindow() {
        Component component = this.getClientComponent();
        Container container = component instanceof Container ? (Container)component : MComponentPeer.getParent_NoClientCode(component);
        while (container != null && !(container instanceof Window)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        return (Window)container;
    }

    private MComponentPeer getPeer(Component component) {
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
        if (mComponentPeer != null) {
            return mComponentPeer;
        }
        Container container = MToolkit.getNativeContainer(component);
        mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        return mComponentPeer;
    }

    void configureStatus() {
        if (this.pData == 0L) {
            return;
        }
        MComponentPeer mComponentPeer = this.getPeer((Window)this.clientComponentWindow);
        if (((MInputMethodControl)((Object)mComponentPeer)).hasTextComponents()) {
            this.configureStatusAreaNative(this.pData);
        }
    }

    private void postInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        Component component = this.getClientComponent();
        InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(component), inputMethodEvent);
    }

    synchronized void dispatchCommittedText(String string) {
        if (string == null) {
            return;
        }
        if (this.composedText == null) {
            AttributedString attributedString = new AttributedString(string);
            this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null);
        } else {
            this.committedText = string;
        }
    }

    void dispatchComposedText(String string, int[] nArray, int n, int n2, int n3) {
        if (this.pData == 0L) {
            return;
        }
        if (string == null && nArray == null && n == 0 && n2 == 0 && n3 == 0 && this.composedText == null && this.committedText == null) {
            return;
        }
        X11InputMethod x11InputMethod = this;
        synchronized (x11InputMethod) {
            int n4;
            int n5;
            AttributedString attributedString;
            int n6;
            if (this.composedText == null) {
                this.composedText = new StringBuffer(64);
                this.rawFeedbacks = new IntBuffer(64);
            }
            if (n2 > 0) {
                if (string == null && nArray != null) {
                    this.rawFeedbacks.replace(n, nArray);
                } else if (n2 == this.composedText.length()) {
                    this.composedText = new StringBuffer(64);
                    this.rawFeedbacks = new IntBuffer(64);
                } else if (this.composedText.length() > 0) {
                    if (n + n2 < this.composedText.length()) {
                        String string2 = this.composedText.toString().substring(n + n2, this.composedText.length());
                        this.composedText.setLength(n);
                        this.composedText.append(string2);
                    } else {
                        this.composedText.setLength(n);
                    }
                    this.rawFeedbacks.remove(n, n2);
                }
            }
            if (string != null) {
                this.composedText.insert(n, string);
                if (nArray != null) {
                    this.rawFeedbacks.insert(n, nArray);
                }
            }
            if (this.composedText.length() == 0) {
                this.composedText = null;
                this.rawFeedbacks = null;
                if (this.committedText != null) {
                    this.dispatchCommittedText(this.committedText);
                    this.committedText = null;
                    return;
                }
                this.postInputMethodEvent(1100, null, 0, null, null);
                this.notifyPreeditCompletion();
                return;
            }
            if (this.committedText != null) {
                n6 = this.committedText.length();
                attributedString = new AttributedString(this.committedText + this.composedText);
                this.committedText = null;
            } else {
                n6 = 0;
                attributedString = new AttributedString(this.composedText.toString());
            }
            int n7 = 0;
            int n8 = 0;
            TextHitInfo textHitInfo = null;
            this.rawFeedbacks.rewind();
            int n9 = this.rawFeedbacks.getNext();
            this.rawFeedbacks.unget();
            while ((n5 = this.rawFeedbacks.getNext()) != -1) {
                if (n8 == 0 && (n8 = n5 & 0x700) != 0) {
                    int n10 = this.rawFeedbacks.getOffset() - 1;
                    textHitInfo = n8 == 512 ? TextHitInfo.leading(n10) : TextHitInfo.trailing(n10);
                }
                if (n9 == (n5 &= 0xFFFFF8FF)) continue;
                this.rawFeedbacks.unget();
                n4 = this.rawFeedbacks.getOffset();
                attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n9), n6 + n7, n6 + n4);
                n7 = n4;
                n9 = n5;
            }
            n4 = this.rawFeedbacks.getOffset();
            if (n4 >= 0) {
                attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n9), n6 + n7, n6 + n4);
            }
            this.postInputMethodEvent(1100, attributedString.getIterator(), n6, TextHitInfo.leading(n3), textHitInfo);
            this.notifyPreeditCompletion();
        }
    }

    private synchronized void deleteComposedText() {
        this.composedText = null;
        this.committedText = null;
        this.postInputMethodEvent(1100, null, 0, null, null);
    }

    protected synchronized void disposeImpl() {
        if (this.pData != 0L) {
            long l = this.pData;
            this.pData = 0L;
            if (this.clientComponentWindow != null) {
                MComponentPeer mComponentPeer = this.getPeer(this.clientComponentWindow);
                if (mComponentPeer instanceof MInputMethodControl) {
                    ((MInputMethodControl)((Object)mComponentPeer)).removeInputMethod(this);
                }
                this.clientComponentWindow = null;
            }
            this.disposeXIC(l);
            this.composedText = null;
            this.committedText = null;
            this.rawFeedbacks = null;
            this.awtFocussedComponent = null;
            this.xicFocussedComponent = null;
        }
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11InputMethod x11InputMethod = this;
            synchronized (x11InputMethod) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public Object getControlObject() {
        return null;
    }

    public synchronized void removeNotify() {
        this.dispose();
    }

    public void setCompositionEnabled(boolean bl) {
        if (this.pData == 0L) {
            throw new UnsupportedOperationException();
        }
        this.setCompositionEnabledNative(bl, this.pData);
    }

    public boolean isCompositionEnabled() {
        if (this.pData == 0L) {
            throw new UnsupportedOperationException();
        }
        return this.isCompositionEnabledNative(this.pData);
    }

    public void endComposition() {
        if (this.pData == 0L) {
            return;
        }
        boolean bl = false;
        try {
            bl = this.isCompositionEnabled();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (this.haveActiveClient() && this.composedText == null && this.committedText == null) {
            this.needResetXIC = true;
            this.needResetXICClient = this.getClientComponent();
            this.needPreeditEnable = bl;
            return;
        }
        if (this.awtFocussedComponent == null) {
            return;
        }
        String string = this.resetXIC(this.pData);
        this.needResetXIC = false;
        this.waitForPreeditCompletion();
        if (string != null && string.length() > 0) {
            this.dispatchCommittedText(string);
        }
        if (bl) {
            try {
                this.setCompositionEnabled(true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    synchronized void reconfigureXIC(MInputMethodControl mInputMethodControl) {
        if (this.pData != 0L) {
            this.endComposition();
            this.resetXICifneeded();
            this.pData = this.reconfigureXICNative((MComponentPeer)((Object)mInputMethodControl), mInputMethodControl.hasTextComponents(), this.pData);
        }
    }

    private synchronized void waitForPreeditCompletion() {
        if (this.composedText != null) {
            this.waitingPreeditCompletion = true;
            try {
                while (this.waitingPreeditCompletion) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.composedText = null;
            }
        }
    }

    private synchronized void notifyPreeditCompletion() {
        if (this.waitingPreeditCompletion) {
            this.waitingPreeditCompletion = false;
            this.notify();
        }
    }

    private InputMethodHighlight convertVisualFeedbackToHighlight(int n) {
        InputMethodHighlight inputMethodHighlight;
        switch (n) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 32: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 128: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return inputMethodHighlight;
    }

    private native boolean openXIM();

    private native long createXICNative(MComponentPeer var1, boolean var2);

    private native long reconfigureXICNative(MComponentPeer var1, boolean var2, long var3);

    private native void setXICFocus(MComponentPeer var1, boolean var2, boolean var3, long var4);

    private native String resetXIC(long var1);

    private native void disposeXIC(long var1);

    private native void closeXIM();

    private native void configureStatusAreaNative(long var1);

    private native void setCompositionEnabledNative(boolean var1, long var2);

    private native boolean isCompositionEnabledNative(long var1);

    private native void turnoffStatusWindow();

    static {
        Map[] mapArray = new Map[4];
        HashMap hashMap = new HashMap(1);
        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        highlightStyles = mapArray;
        X11InputMethod.initIDs();
    }

    private final class IntBuffer {
        private int[] intArray;
        private int size;
        private int index;

        IntBuffer(int n) {
            this.intArray = new int[n];
            this.size = 0;
            this.index = 0;
        }

        void insert(int n, int[] nArray) {
            int n2 = this.size + nArray.length;
            if (this.intArray.length < n2) {
                int[] nArray2 = new int[n2 * 2];
                System.arraycopy(this.intArray, 0, nArray2, 0, this.size);
                this.intArray = nArray2;
            }
            System.arraycopy(this.intArray, n, this.intArray, n + nArray.length, this.size - n);
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
            this.size += nArray.length;
            if (this.index > n) {
                this.index = n;
            }
        }

        void remove(int n, int n2) {
            if (n + n2 != this.size) {
                System.arraycopy(this.intArray, n + n2, this.intArray, n, this.size - n - n2);
            }
            this.size -= n2;
            if (this.index > n) {
                this.index = n;
            }
        }

        void replace(int n, int[] nArray) {
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
        }

        void removeAll() {
            this.size = 0;
            this.index = 0;
        }

        void rewind() {
            this.index = 0;
        }

        int getNext() {
            if (this.index == this.size) {
                return -1;
            }
            return this.intArray[this.index++];
        }

        void unget() {
            if (this.index != 0) {
                --this.index;
            }
        }

        int getOffset() {
            return this.index;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.intArray[n++]);
                if (n >= this.size) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
    }
}

