/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class UlawCodec
extends SunCodec {
    static final byte[] ULAW_TABH = new byte[256];
    static final byte[] ULAW_TABL = new byte[256];
    private static final boolean ulawEncodes = true;
    private static final boolean ulawDecodes = true;
    private static final AudioFormat.Encoding[] ulawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public UlawCodec() {
        super(ulawEncodings, ulawEncodings);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW) || encoding.equals(AudioFormat.Encoding.ULAW) && audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(audioFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat.getEncoding();
        if (encoding2.equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat2 = null;
        if (!this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        if (encoding2.equals(AudioFormat.Encoding.ULAW) && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        } else if (encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.ULAW)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() / 2, audioFormat.getChannels(), audioFormat.getFrameSize() / 2, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new UlawCodecStream(audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat audioFormat2;
        Vector vector = new Vector();
        if (audioFormat.getSampleSizeInBits() == 16 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.ULAW, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getFrameSize() / 2, audioFormat.getFrameRate(), false);
            vector.addElement(audioFormat2);
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), false);
            vector.addElement(audioFormat2);
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true);
            vector.addElement(audioFormat2);
        }
        AudioFormat[] audioFormatArray = new AudioFormat[vector.size()];
        int n = 0;
        while (n < audioFormatArray.length) {
            audioFormatArray[n] = (AudioFormat)vector.elementAt(n);
            ++n;
        }
        return audioFormatArray;
    }

    static {
        int n = 0;
        while (n < 256) {
            int n2 = ~n;
            int n3 = (((n2 &= 0xFF) & 0xF) << 3) + 132;
            n3 = (n2 & 0x80) != 0 ? 132 - n3 : (n3 <<= (n2 & 0x70) >> 4) - 132;
            UlawCodec.ULAW_TABL[n] = (byte)(n3 & 0xFF);
            UlawCodec.ULAW_TABH[n] = (byte)(n3 >> 8 & 0xFF);
            ++n;
        }
    }

    class UlawCodecStream
    extends AudioInputStream {
        boolean encode = false;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1 = null;
        byte[] tabByte2 = null;
        int highByte = 0;
        int lowByte = 1;

        UlawCodecStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            super(audioInputStream, audioFormat, -1L);
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!UlawCodec.this.isConversionSupported(audioFormat, audioFormat2)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            if (audioFormat2.getEncoding() == AudioFormat.Encoding.ULAW) {
                this.encode = false;
                this.encodeFormat = audioFormat2;
                this.decodeFormat = audioFormat;
            } else {
                this.encode = true;
                this.encodeFormat = audioFormat;
                this.decodeFormat = audioFormat2;
            }
            if (this.decodeFormat.isBigEndian()) {
                this.tabByte1 = ULAW_TABH;
                this.tabByte2 = ULAW_TABL;
            } else {
                this.tabByte1 = ULAW_TABL;
                this.tabByte2 = ULAW_TABH;
            }
            if (this.encodeFormat.isBigEndian()) {
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (audioInputStream instanceof AudioInputStream) {
                long l;
                this.frameLength = l = audioInputStream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }

        private short search(short s, short[] sArray, short s2) {
            short s3 = 0;
            while (s3 < s2) {
                if (s <= sArray[s3]) {
                    return s3;
                }
                s3 = (short)(s3 + 1);
            }
            return s2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 % this.frameSize != 0) {
                n2 -= n2 % this.frameSize;
            }
            if (this.encode) {
                int n3 = 132;
                int n4 = 0;
                int n5 = n;
                int n6 = n2 * 2;
                int n7 = n6 > 64 ? 64 : n6;
                while ((n4 = super.read(UlawCodec.this.tempBuffer, 0, n7)) > 0) {
                    int n8 = 0;
                    while (n8 < n4) {
                        byte by;
                        int n9;
                        short s = (short)(UlawCodec.this.tempBuffer[n8 + this.highByte] << 8 & 0xFF00);
                        if ((s = (short)(s | (short)((short)UlawCodec.this.tempBuffer[n8 + this.lowByte] & 0xFF))) < 0) {
                            s = (short)(n3 - s);
                            n9 = 127;
                        } else {
                            s = (short)(s + n3);
                            n9 = 255;
                        }
                        short s2 = this.search(s, seg_end, (short)8);
                        if (s2 >= 8) {
                            by = (byte)(0x7F ^ n9);
                        } else {
                            by = (byte)(s2 << 4 | s >> s2 + 3 & 0xF);
                            by = (byte)(by ^ n9);
                        }
                        byArray[n5] = by;
                        ++n5;
                        n8 += 2;
                    }
                    int n10 = n7 = (n6 -= n4) > 64 ? 64 : n6;
                }
                if (n5 == n && n4 < 0) {
                    return n4;
                }
                return n5 - n;
            }
            int n11 = n + n2 / 2;
            int n12 = n2 / 2;
            int n13 = super.read(byArray, n11, n12);
            if (n13 < 0) {
                return n13;
            }
            int n14 = n;
            while (n14 < n + n13 * 2) {
                byArray[n14] = this.tabByte1[byArray[n11] & 0xFF];
                byArray[n14 + 1] = this.tabByte2[byArray[n11] & 0xFF];
                ++n11;
                n14 += 2;
            }
            return n14 - n;
        }
    }
}

