/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilePermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

final class FilePermissionCollection
extends PermissionCollection
implements Serializable {
    private Vector permissions = new Vector();

    public void add(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.permissions.addElement(permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        int n = filePermission.getMask();
        int n2 = 0;
        int n3 = n;
        Enumeration enumeration = this.permissions.elements();
        while (enumeration.hasMoreElements()) {
            FilePermission filePermission2 = (FilePermission)enumeration.nextElement();
            if ((n3 & filePermission2.getMask()) == 0 || !filePermission2.impliesIgnoreMask(filePermission)) continue;
            if (((n2 |= filePermission2.getMask()) & n) == n) {
                return true;
            }
            n3 = n ^ n2;
        }
        return false;
    }
}

