/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    boolean closedByWriter = false;
    boolean closedByReader = false;
    boolean connected = false;
    boolean waiting = false;
    boolean responsiveMode = false;
    Thread readSide;
    Thread writeSide;
    protected static final int PIPE_SIZE = 1024;
    protected byte[] buffer = new byte[1024];
    protected int in = -1;
    protected int out = 0;

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this.connect(pipedOutputStream);
    }

    public PipedInputStream() {
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        pipedOutputStream.connect(this);
    }

    void pipeNotify() {
        this.waiting = false;
        this.notifyAll();
    }

    protected synchronized void receive(int n) throws IOException {
        if (this.closedByWriter || this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        this.writeSide = Thread.currentThread();
        if (this.in == this.out) {
            this.pipeNotify();
            do {
                if (this.readSide != null && !this.readSide.isAlive()) {
                    throw new IOException("Pipe broken");
                }
                try {
                    this.waiting = true;
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                if (this.waiting && this.in == this.out) {
                    this.notifyAll();
                }
                if (!this.closedByWriter && !this.closedByReader) continue;
                throw new IOException("Pipe closed");
            } while (this.in == this.out);
        }
        if (this.in < 0) {
            this.buffer[0] = (byte)(n & 0xFF);
            this.in = 1;
            this.out = 0;
            if (this.responsiveMode) {
                this.pipeNotify();
            }
        } else {
            this.buffer[this.in++] = (byte)(n & 0xFF);
            if (this.in >= this.buffer.length) {
                this.in = 0;
            }
        }
    }

    synchronized void receive(byte[] byArray, int n, int n2) throws IOException {
        while (--n2 >= 0) {
            this.receive(byArray[n++]);
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        this.pipeNotify();
    }

    public synchronized int read() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        this.readSide = Thread.currentThread();
        int n = 2;
        if (this.in < 0) {
            this.pipeNotify();
            do {
                if (this.closedByWriter) {
                    return -1;
                }
                if (this.writeSide != null && !this.writeSide.isAlive() && --n < 0) {
                    throw new IOException("Pipe broken");
                }
                try {
                    this.waiting = true;
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                if (this.waiting && this.in < 0) {
                    this.notifyAll();
                }
                if (!this.closedByReader) continue;
                return -1;
            } while (this.in < 0);
            if (this.waiting && this.in != this.out) {
                this.responsiveMode = true;
            }
        }
        int n2 = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        if (this.in == this.out) {
            this.in = -1;
        }
        return n2;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 < 0) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        int n5 = this.buffer.length;
        while (this.in >= 0 && --n2 > 0) {
            byArray[n + n4] = this.buffer[this.out++];
            ++n4;
            if (this.out >= n5) {
                this.out = 0;
            }
            if (this.in != this.out) continue;
            this.in = -1;
        }
        return n4;
    }

    public synchronized int available() throws IOException {
        if (this.closedByReader || this.in < 0) {
            return 0;
        }
        if (this.in == this.out) {
            return this.buffer.length;
        }
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.in + this.buffer.length - this.out;
    }

    public void close() throws IOException {
        this.closedByReader = true;
    }
}

