/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Character
implements Serializable,
Comparable {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class TYPE = Class.getPrimitiveClass("char");
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    private char value;
    private static final long serialVersionUID = 3786198910865385080L;
    private static final byte[] X = new byte[1024];
    private static final short[] Y = new short[4032];
    private static final int[] A = new int[632];

    static {
        Character.initStaticArrays();
    }

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    public int compareTo(Character c) {
        return this.value - c.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Character)object);
    }

    public static int digit(char c, int n) {
        int n2 = -1;
        if (n >= 2 && n <= 36) {
            int n3 = A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'];
            int n4 = n3 & 0x1F;
            if (n4 == 9) {
                n2 = c + (n3 >> 9) & 0x1F;
            } else if ((n3 & 0xC000) == 49152) {
                n2 = (c + (n3 >> 9) & 0x1F) + 10;
            }
        }
        return n2 < n ? n2 : -1;
    }

    public boolean equals(Object object) {
        if (object instanceof Character) {
            return this.value == ((Character)object).charValue();
        }
        return false;
    }

    public static char forDigit(int n, int n2) {
        if (n >= n2 || n < 0) {
            return '\u0000';
        }
        if (n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(87 + n);
    }

    public static int getNumericValue(char c) {
        int n = A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'];
        switch (n >> 14 & 3) {
            default: {
                return -1;
            }
            case 1: {
                return c + (n >> 9) & 0x1F;
            }
            case 2: {
                switch (c) {
                    case '\u0bf1': {
                        return 100;
                    }
                    case '\u0bf2': {
                        return 1000;
                    }
                    case '\u216c': {
                        return 50;
                    }
                    case '\u216d': {
                        return 100;
                    }
                    case '\u216e': {
                        return 500;
                    }
                    case '\u216f': {
                        return 1000;
                    }
                    case '\u217c': {
                        return 50;
                    }
                    case '\u217d': {
                        return 100;
                    }
                    case '\u217e': {
                        return 500;
                    }
                    case '\u217f': {
                        return 1000;
                    }
                    case '\u2180': {
                        return 1000;
                    }
                    case '\u2181': {
                        return 5000;
                    }
                    case '\u2182': {
                        return 10000;
                    }
                }
                return -2;
            }
            case 3: 
        }
        return (c + (n >> 9) & 0x1F) + 10;
    }

    public static int getType(char c) {
        return A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F;
    }

    public int hashCode() {
        return this.value;
    }

    private static native void initStaticArrays();

    public static boolean isDefined(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) != 0;
    }

    public static boolean isDigit(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) == 9;
    }

    public static boolean isISOControl(char c) {
        return c <= '\u009f' && (c <= '\u001f' || c >= '\u007f');
    }

    public static boolean isIdentifierIgnorable(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x70000) == 65536;
    }

    public static boolean isJavaIdentifierPart(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x30000) != 0;
    }

    public static boolean isJavaIdentifierStart(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x70000) >= 327680;
    }

    public static boolean isJavaLetter(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x70000) >= 327680;
    }

    public static boolean isJavaLetterOrDigit(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x30000) != 0;
    }

    public static boolean isLetter(char c) {
        return (62 >> (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) & 1) != 0;
    }

    public static boolean isLetterOrDigit(char c) {
        return (574 >> (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) & 1) != 0;
    }

    public static boolean isLowerCase(char c) {
        return c < '\u00aa' ? c >= 'a' && c <= 'z' : (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) == 2;
    }

    public static boolean isSpace(char c) {
        return c <= ' ' && (4294981120L >> c & 1L) != 0L;
    }

    public static boolean isSpaceChar(char c) {
        return (28672 >> (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) & 1) != 0;
    }

    public static boolean isTitleCase(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) == 3;
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x10000) != 0;
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x70000) == 458752;
    }

    public static boolean isUpperCase(char c) {
        return c < '\u00c0' ? c >= 'A' && c <= 'Z' : (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x1F) == 1;
    }

    public static boolean isWhitespace(char c) {
        return (A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'] & 0x70000) == 262144;
    }

    public static char toLowerCase(char c) {
        if (c < '\u00c0') {
            return c < 'A' || c > 'Z' ? c : (char)(c + 32);
        }
        int n = A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'];
        if ((n & 0x200000) != 0) {
            return (char)(c + (n >> 22));
        }
        return c;
    }

    public String toString() {
        char[] cArray = new char[]{this.value};
        return String.valueOf(cArray);
    }

    public static char toTitleCase(char c) {
        int n = A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'];
        if ((n & 0x80000) != 0) {
            if ((n & 0x100000) == 0) {
                return (char)(c + '\u0001');
            }
            if ((n & 0x200000) == 0) {
                return (char)(c - '\u0001');
            }
            return c;
        }
        if ((n & 0x100000) != 0) {
            return (char)(c - (n >> 22));
        }
        return c;
    }

    public static char toUpperCase(char c) {
        if (c < '\u00e0') {
            return c < 'a' || c > 'z' ? c : (char)(c - 32);
        }
        int n = A[Y[X[c >> 6] << 5 | c >> 1 & 0x1F] | c & '\u0001'];
        if ((n & 0x100000) != 0) {
            return (char)(c - (n >> 22));
        }
        return c;
    }

    public static class Subset {
        private String name;

        protected Subset(String string) {
            this.name = string;
        }

        public final boolean equals(Object object) {
            return this == object;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }

    public static final class UnicodeBlock
    extends Subset {
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("BASIC_LATIN");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS");
        public static final UnicodeBlock GREEK = new UnicodeBlock("GREEK");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("CYRILLIC");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("ARMENIAN");
        public static final UnicodeBlock HEBREW = new UnicodeBlock("HEBREW");
        public static final UnicodeBlock ARABIC = new UnicodeBlock("ARABIC");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("DEVANAGARI");
        public static final UnicodeBlock BENGALI = new UnicodeBlock("BENGALI");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("GURMUKHI");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("GUJARATI");
        public static final UnicodeBlock ORIYA = new UnicodeBlock("ORIYA");
        public static final UnicodeBlock TAMIL = new UnicodeBlock("TAMIL");
        public static final UnicodeBlock TELUGU = new UnicodeBlock("TELUGU");
        public static final UnicodeBlock KANNADA = new UnicodeBlock("KANNADA");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("MALAYALAM");
        public static final UnicodeBlock THAI = new UnicodeBlock("THAI");
        public static final UnicodeBlock LAO = new UnicodeBlock("LAO");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("TIBETAN");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("GEORGIAN");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS");
        public static final UnicodeBlock ARROWS = new UnicodeBlock("ARROWS");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("BOX_DRAWING");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("DINGBATS");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("HIRAGANA");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("KATAKANA");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("BOPOMOFO");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO");
        public static final UnicodeBlock KANBUN = new UnicodeBlock("KANBUN");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES");
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock("SURROGATES_AREA");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS");
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock("SPECIALS");
        private static final char[] blockStarts;
        private static final UnicodeBlock[] blocks;

        static {
            char[] cArray = new char[77];
            cArray[1] = 128;
            cArray[2] = 256;
            cArray[3] = 384;
            cArray[4] = 592;
            cArray[5] = 688;
            cArray[6] = 768;
            cArray[7] = 880;
            cArray[8] = 1024;
            cArray[9] = 1280;
            cArray[10] = 1328;
            cArray[11] = 1424;
            cArray[12] = 1536;
            cArray[13] = 1792;
            cArray[14] = 2304;
            cArray[15] = 2432;
            cArray[16] = 2560;
            cArray[17] = 2688;
            cArray[18] = 2816;
            cArray[19] = 2944;
            cArray[20] = 3072;
            cArray[21] = 3200;
            cArray[22] = 3328;
            cArray[23] = 3456;
            cArray[24] = 3584;
            cArray[25] = 3712;
            cArray[26] = 3840;
            cArray[27] = 4032;
            cArray[28] = 4256;
            cArray[29] = 4352;
            cArray[30] = 4608;
            cArray[31] = 7680;
            cArray[32] = 7936;
            cArray[33] = 8192;
            cArray[34] = 8304;
            cArray[35] = 8352;
            cArray[36] = 8400;
            cArray[37] = 8448;
            cArray[38] = 8528;
            cArray[39] = 8592;
            cArray[40] = 8704;
            cArray[41] = 8960;
            cArray[42] = 9216;
            cArray[43] = 9280;
            cArray[44] = 9312;
            cArray[45] = 9472;
            cArray[46] = 9600;
            cArray[47] = 9632;
            cArray[48] = 9728;
            cArray[49] = 9984;
            cArray[50] = 10176;
            cArray[51] = 12288;
            cArray[52] = 12352;
            cArray[53] = 12448;
            cArray[54] = 12544;
            cArray[55] = 12592;
            cArray[56] = 12688;
            cArray[57] = 12800;
            cArray[58] = 13056;
            cArray[59] = 13312;
            cArray[60] = 19968;
            cArray[61] = 40960;
            cArray[62] = 44032;
            cArray[63] = 55204;
            cArray[64] = 55296;
            cArray[65] = 57344;
            cArray[66] = 63744;
            cArray[67] = 64256;
            cArray[68] = 64336;
            cArray[69] = 65024;
            cArray[70] = 65056;
            cArray[71] = 65072;
            cArray[72] = 65104;
            cArray[73] = 65136;
            cArray[74] = 65279;
            cArray[75] = 65280;
            cArray[76] = 65520;
            blockStarts = cArray;
            blocks = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, null, ARMENIAN, HEBREW, ARABIC, null, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, null, THAI, LAO, TIBETAN, null, GEORGIAN, HANGUL_JAMO, null, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, null, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, null, CJK_UNIFIED_IDEOGRAPHS, null, HANGUL_SYLLABLES, null, SURROGATES_AREA, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, null, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, SPECIALS, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS};
        }

        private UnicodeBlock(String string) {
            super(string);
        }

        public static UnicodeBlock of(char c) {
            int n = 0;
            int n2 = blockStarts.length;
            int n3 = n2 / 2;
            while (n2 - n > 1) {
                if (c >= blockStarts[n3]) {
                    n = n3;
                } else {
                    n2 = n3;
                }
                n3 = (n2 + n) / 2;
            }
            return blocks[n3];
        }
    }
}

