/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final Class TYPE = Class.getPrimitiveClass("float");
    private float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(float f) {
        this.value = f;
    }

    public Float(String string) throws NumberFormatException {
        this(Float.valueOf(string).floatValue());
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public int compareTo(Float f) {
        int n;
        float f2 = this.value;
        float f3 = f.value;
        if (f2 < f3) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        int n2 = Float.floatToIntBits(f2);
        return n2 == (n = Float.floatToIntBits(f3)) ? 0 : (n2 < n ? -1 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((Float)object);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Float && Float.floatToIntBits(((Float)object).value) == Float.floatToIntBits(this.value);
    }

    public static native int floatToIntBits(float var0);

    public static native int floatToRawIntBits(float var0);

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public static native float intBitsToFloat(int var0);

    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    public long longValue() {
        return (long)this.value;
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).floatValue();
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(float f) {
        return new FloatingDecimal(f).toJavaFormatString();
    }

    public static Float valueOf(String string) throws NumberFormatException {
        return new Float(FloatingDecimal.readJavaFormatString(string).floatValue());
    }
}

