/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();

    private Runtime() {
    }

    public void addShutdownHook(Thread thread) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        Shutdown.add(thread);
    }

    public Process exec(String string) throws IOException {
        return this.exec(string, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        stringTokenizer = new StringTokenizer(string);
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n++] = stringTokenizer.nextToken();
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        SecurityManager securityManager;
        stringArray = (String[])stringArray.clone();
        String[] stringArray3 = stringArray2 = stringArray2 != null ? (String[])stringArray2.clone() : null;
        if (stringArray.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new NullPointerException();
            }
            ++n;
        }
        if (stringArray2 != null) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2] == null) {
                    throw new NullPointerException();
                }
                ++n2;
            }
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkExec(stringArray[0]);
        }
        String string = file == null ? null : file.getPath();
        return this.execInternal(stringArray, stringArray2, string);
    }

    private native Process execInternal(String[] var1, String[] var2, String var3) throws IOException;

    public void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        Shutdown.exit(n);
    }

    public native long freeMemory();

    public native void gc();

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    public void halt(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        Shutdown.halt(n);
    }

    public void load(String string) {
        this.load0(System.getCallerClass(), string);
    }

    synchronized void load0(Class clazz, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (!new File(string).isAbsolute()) {
            throw new UnsatisfiedLinkError("Expecting an absolute path of the library: " + string);
        }
        ClassLoader.loadLibrary(clazz, string, true);
    }

    public void loadLibrary(String string) {
        this.loadLibrary0(System.getCallerClass(), string);
    }

    synchronized void loadLibrary0(Class clazz, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (string.indexOf(File.separatorChar) != -1) {
            throw new UnsatisfiedLinkError("Directory separator should not appear in library name: " + string);
        }
        ClassLoader.loadLibrary(clazz, string, false);
    }

    public boolean removeShutdownHook(Thread thread) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        return Shutdown.remove(thread);
    }

    public void runFinalization() {
        Runtime.runFinalization0();
    }

    private static native void runFinalization0();

    public static void runFinalizersOnExit(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkExit(0);
            }
            catch (SecurityException securityException) {
                throw new SecurityException("runFinalizersOnExit");
            }
        }
        Shutdown.setRunFinalizersOnExit(bl);
    }

    public native long totalMemory();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);
}

