/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.StringTokenizer;

public class SecurityManager {
    protected boolean inCheck;
    private boolean initialized = false;
    private static RuntimePermission createClassLoaderPermission;
    private static AWTPermission topLevelWindowPermission;
    private static AWTPermission accessClipboardPermission;
    private static AWTPermission checkAwtEventQueuePermission;
    private static RuntimePermission checkMemberAccessPermission;
    private static AllPermission allPermission;
    private static RuntimePermission threadPermission;
    private static RuntimePermission threadGroupPermission;
    private static ThreadGroup rootGroup;
    private static SocketPermission localListenPermission;
    private static boolean packageAccessValid;
    private static String[] packageAccess;
    private static boolean packageDefinitionValid;
    private static String[] packageDefinition;
    static /* synthetic */ Class class$java$lang$SecurityManager;

    static {
        rootGroup = SecurityManager.getRootGroup();
        packageAccessValid = false;
        packageAccess = new String[0];
        packageDefinitionValid = false;
        packageDefinition = new String[0];
    }

    public SecurityManager() {
        Class clazz = class$java$lang$SecurityManager != null ? class$java$lang$SecurityManager : (class$java$lang$SecurityManager = SecurityManager.class$("java.lang.SecurityManager"));
        synchronized (clazz) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("createSecurityManager"));
            }
            this.initialized = true;
        }
    }

    public void checkAccept(String string, int n) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        this.checkPermission(new SocketPermission(String.valueOf(string) + ":" + n, "accept"));
    }

    public void checkAccess(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("thread can't be null");
        }
        if (thread.getThreadGroup() == rootGroup) {
            if (threadPermission == null) {
                threadPermission = new RuntimePermission("modifyThread");
            }
            this.checkPermission(threadPermission);
        }
    }

    public void checkAccess(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException("thread group can't be null");
        }
        if (threadGroup == rootGroup) {
            if (threadGroupPermission == null) {
                threadGroupPermission = new RuntimePermission("modifyThreadGroup");
            }
            this.checkPermission(threadGroupPermission);
        }
    }

    public void checkAwtEventQueueAccess() {
        if (checkAwtEventQueuePermission == null) {
            checkAwtEventQueuePermission = new AWTPermission("accessEventQueue");
        }
        this.checkPermission(checkAwtEventQueuePermission);
    }

    public void checkConnect(String string, int n) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(String.valueOf(string) + ":" + n, "connect"));
        }
    }

    public void checkConnect(String string, int n, Object object) {
        if (string == null) {
            throw new NullPointerException("host can't be null");
        }
        if (n == -1) {
            this.checkPermission(new SocketPermission(string, "resolve"), object);
        } else {
            this.checkPermission(new SocketPermission(String.valueOf(string) + ":" + n, "connect"), object);
        }
    }

    public void checkCreateClassLoader() {
        if (createClassLoaderPermission == null) {
            createClassLoaderPermission = new RuntimePermission("createClassLoader");
        }
        this.checkPermission(createClassLoaderPermission);
    }

    public void checkDelete(String string) {
        this.checkPermission(new FilePermission(string, "delete"));
    }

    public void checkExec(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            this.checkPermission(new FilePermission(string, "execute"));
        } else {
            this.checkPermission(new FilePermission("<<ALL FILES>>", "execute"));
        }
    }

    public void checkExit(int n) {
        this.checkPermission(new RuntimePermission("exitVM"));
    }

    public void checkLink(String string) {
        if (string == null) {
            throw new NullPointerException("library can't be null");
        }
        this.checkPermission(new RuntimePermission("loadLibrary." + string));
    }

    public void checkListen(int n) {
        if (n == 0) {
            if (localListenPermission == null) {
                localListenPermission = new SocketPermission("localhost:1024-", "listen");
            }
            this.checkPermission(localListenPermission);
        } else {
            this.checkPermission(new SocketPermission("localhost:" + n, "listen"));
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        Class[] classArray;
        if (clazz == null) {
            throw new NullPointerException("class can't be null");
        }
        if (n != 0 && ((classArray = this.getClassContext()).length < 4 || classArray[3].getClassLoader() != clazz.getClassLoader())) {
            if (checkMemberAccessPermission == null) {
                checkMemberAccessPermission = new RuntimePermission("accessDeclaredMembers");
            }
            this.checkPermission(checkMemberAccessPermission);
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        this.checkPermission(new SocketPermission(inetAddress.getHostAddress(), "accept,connect"));
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        this.checkPermission(new SocketPermission(inetAddress.getHostAddress(), "accept,connect"));
    }

    public void checkPackageAccess(String string) {
        if (string == null) {
            throw new NullPointerException("package name can't be null");
        }
        String[] stringArray = packageAccess;
        synchronized (stringArray) {
            if (!packageAccessValid) {
                String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Security.getProperty("package.access");
                    }
                });
                packageAccess = SecurityManager.getPackages(string2);
                packageAccessValid = true;
            }
            int n = 0;
            while (n < packageAccess.length) {
                if (string.startsWith(packageAccess[n]) || string.equals(packageAccess[n])) {
                    this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
                }
                ++n;
            }
        }
    }

    public void checkPackageDefinition(String string) {
        if (string == null) {
            throw new NullPointerException("package name can't be null");
        }
        String[] stringArray = packageDefinition;
        synchronized (stringArray) {
            if (!packageDefinitionValid) {
                String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Security.getProperty("package.definition");
                    }
                });
                packageDefinition = SecurityManager.getPackages(string2);
                packageDefinitionValid = true;
            }
            int n = 0;
            while (n < packageDefinition.length) {
                if (string.startsWith(packageDefinition[n]) || string.equals(packageDefinition[n])) {
                    this.checkPermission(new RuntimePermission("defineClassInPackage." + string));
                }
                ++n;
            }
        }
    }

    public void checkPermission(Permission permission) {
        AccessController.checkPermission(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException();
        }
        ((AccessControlContext)object).checkPermission(permission);
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkPropertyAccess(String string) {
        this.checkPermission(new PropertyPermission(string, "read"));
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkRead(String string) {
        this.checkPermission(new FilePermission(string, "read"));
    }

    public void checkRead(String string, Object object) {
        this.checkPermission(new FilePermission(string, "read"), object);
    }

    public void checkSecurityAccess(String string) {
        this.checkPermission(new SecurityPermission(string));
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    public void checkSystemClipboardAccess() {
        if (accessClipboardPermission == null) {
            accessClipboardPermission = new AWTPermission("accessClipboard");
        }
        this.checkPermission(accessClipboardPermission);
    }

    public boolean checkTopLevelWindow(Object object) {
        if (object == null) {
            throw new NullPointerException("window can't be null");
        }
        try {
            if (topLevelWindowPermission == null) {
                topLevelWindowPermission = new AWTPermission("showWindowWithoutWarningBanner");
            }
            this.checkPermission(topLevelWindowPermission);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    public void checkWrite(String string) {
        this.checkPermission(new FilePermission(string, "write"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected native int classDepth(String var1);

    protected int classLoaderDepth() {
        int n = this.classLoaderDepth0();
        if (n != -1) {
            n = this.hasAllPermission() ? -1 : --n;
        }
        return n;
    }

    private native int classLoaderDepth0();

    protected ClassLoader currentClassLoader() {
        ClassLoader classLoader = this.currentClassLoader0();
        if (classLoader != null && this.hasAllPermission()) {
            classLoader = null;
        }
        return classLoader;
    }

    private native ClassLoader currentClassLoader0();

    protected Class currentLoadedClass() {
        Class clazz = this.currentLoadedClass0();
        if (clazz != null && this.hasAllPermission()) {
            clazz = null;
        }
        return clazz;
    }

    private native Class currentLoadedClass0();

    protected native Class[] getClassContext();

    public boolean getInCheck() {
        return this.inCheck;
    }

    private static String[] getPackages(String string) {
        StringTokenizer stringTokenizer;
        int n;
        String[] stringArray = null;
        if (string != null && !string.equals("") && (n = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) > 0) {
            stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                stringArray[n2++] = string2;
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private static ThreadGroup getRootGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    private boolean hasAllPermission() {
        if (allPermission == null) {
            allPermission = new AllPermission();
        }
        try {
            this.checkPermission(allPermission);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    protected boolean inClass(String string) {
        return this.classDepth(string) >= 0;
    }

    protected boolean inClassLoader() {
        return this.currentClassLoader() != null;
    }
}

