/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.HashSet;
import java.util.Iterator;

class Shutdown {
    private static final int RUNNING = 0;
    private static final int HOOKS = 1;
    private static final int FINALIZERS = 2;
    private static int state = 0;
    private static boolean runFinalizersOnExit = false;
    private static HashSet hooks = null;
    private static Object lock = new Lock();
    static /* synthetic */ Class class$java$lang$Shutdown;

    Shutdown() {
    }

    static void add(Thread thread) {
        Object object = lock;
        synchronized (object) {
            if (state > 0) {
                throw new IllegalStateException("Shutdown in progress");
            }
            if (thread.isAlive()) {
                throw new IllegalArgumentException("Hook already running");
            }
            if (hooks == null) {
                hooks = new HashSet(11);
                hooks.add(new WrappedHook(thread));
                Terminator.setup();
            } else {
                WrappedHook wrappedHook = new WrappedHook(thread);
                if (hooks.contains(wrappedHook)) {
                    throw new IllegalArgumentException("Hook previously registered");
                }
                hooks.add(wrappedHook);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static void exit(int n) {
        boolean bl = false;
        Object object = lock;
        synchronized (object) {
            if (n != 0) {
                runFinalizersOnExit = false;
            }
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
                case 2: {
                    if (n != 0) {
                        Shutdown.halt(n);
                        break;
                    }
                    bl = runFinalizersOnExit;
                    break;
                }
            }
        }
        if (bl) {
            Shutdown.runAllFinalizers();
            Shutdown.halt(n);
        }
        object = class$java$lang$Shutdown != null ? class$java$lang$Shutdown : (class$java$lang$Shutdown = Shutdown.class$("java.lang.Shutdown"));
        synchronized (object) {
            Shutdown.sequence();
            Shutdown.halt(n);
        }
    }

    static native void halt(int var0);

    static boolean remove(Thread thread) {
        Object object = lock;
        synchronized (object) {
            if (state > 0) {
                throw new IllegalStateException("Shutdown in progress");
            }
            if (thread == null) {
                throw new NullPointerException();
            }
            if (hooks == null) {
                boolean bl = false;
                Object var3_4 = null;
                return bl;
            }
            boolean bl = hooks.remove(new WrappedHook(thread));
            if (bl && hooks.isEmpty()) {
                hooks = null;
                Terminator.teardown();
            }
            boolean bl2 = bl;
            Object var3_5 = null;
            return bl2;
        }
    }

    private static native void runAllFinalizers();

    private static void runHooks() {
        if (hooks == null) {
            return;
        }
        Iterator iterator = hooks.iterator();
        while (iterator.hasNext()) {
            ((WrappedHook)iterator.next()).hook.start();
        }
        Iterator iterator2 = hooks.iterator();
        while (iterator2.hasNext()) {
            try {
                ((WrappedHook)iterator2.next()).hook.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void sequence() {
        boolean bl;
        Object object = lock;
        synchronized (object) {
            if (state != 1) {
                Object var1_2 = null;
                return;
            }
        }
        Shutdown.runHooks();
        Object object2 = lock;
        synchronized (object2) {
            state = 2;
            bl = runFinalizersOnExit;
        }
        if (bl) {
            Shutdown.runAllFinalizers();
        }
    }

    static void setRunFinalizersOnExit(boolean bl) {
        Object object = lock;
        synchronized (object) {
            runFinalizersOnExit = bl;
        }
    }

    static void shutdown() {
        Object object = lock;
        synchronized (object) {
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
            }
        }
        object = class$java$lang$Shutdown != null ? class$java$lang$Shutdown : (class$java$lang$Shutdown = Shutdown.class$("java.lang.Shutdown"));
        synchronized (object) {
            Shutdown.sequence();
        }
    }

    private static class WrappedHook {
        private Thread hook;

        WrappedHook(Thread thread) {
            this.hook = thread;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WrappedHook)) {
                return false;
            }
            return ((WrappedHook)object).hook == this.hook;
        }

        public int hashCode() {
            return System.identityHashCode(this.hook);
        }
    }

    private static class Lock {
        Lock() {
        }
    }
}

