/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class StringBuffer
implements Serializable {
    private char[] value;
    private int count;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.value = new char[n];
    }

    public StringBuffer(String string) {
        int n = string.length();
        this.value = new char[n + 16];
        string.getChars0(0, n, this.value, 0);
        this.count = n;
    }

    public synchronized StringBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public synchronized StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized StringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        string.getChars0(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized StringBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        StringBuffer.arraycopy(cArray, 0, this.value, this.count, n);
        this.count = n2;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    private static void arraycopy(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        if (n3 <= 23) {
            int n4 = 0;
            while (n4 < n3) {
                cArray2[n2 + n4] = cArray[n + n4];
                ++n4;
            }
        } else {
            System.arraycopy(cArray, n, cArray2, n2, n3);
        }
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    private final void copy() {
        this.value = (char[])this.value.clone();
        this.shared = false;
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (this.shared) {
                this.copy();
            }
            System.arraycopy(this.value, n + n3, this.value, n, this.count - n2);
            this.count -= n3;
        }
        return this;
    }

    public synchronized StringBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        --this.count;
        return this;
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    private void expandCapacity(int n) {
        int n2 = (this.value.length + 5) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
        this.shared = false;
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        int n4 = n2 - n;
        if (n3 < 0 || n3 > cArray.length - n4) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        StringBuffer.arraycopy(this.value, n, cArray, n3, n4);
    }

    final char[] getValue() {
        return this.value;
    }

    public synchronized StringBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        int n2;
        int n3;
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars0(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count = n3;
        return this;
    }

    public synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count = n4;
        return this;
    }

    public int length() {
        return this.count;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.value = (char[])this.value.clone();
        this.shared = false;
    }

    public synchronized StringBuffer replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = string.length();
        int n4 = this.count + n3 - (n2 - n);
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, n2, this.value, n + n3, this.count - n2);
        string.getChars0(0, n3, this.value, n);
        this.count = n4;
        return this;
    }

    public synchronized StringBuffer reverse() {
        if (this.shared) {
            this.copy();
        }
        int n = this.count - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.value[n2];
            this.value[n2] = this.value[n - n2];
            this.value[n - n2] = c;
            --n2;
        }
        return this;
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.shared) {
            this.copy();
        }
        this.value[n] = c;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        if (this.count <= n) {
            int n2 = this.count;
            while (n2 < n) {
                this.value[n2++] = '\u0000';
            }
            this.count = n;
        } else {
            if (this.shared) {
                char[] cArray = new char[n + 16];
                if (n != 0) {
                    System.arraycopy(this.value, 0, cArray, 0, n);
                }
                this.value = cArray;
                this.shared = false;
            }
            this.count = n;
        }
    }

    final void setShared() {
        this.shared = true;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public synchronized String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return new String(this.value, n, n2 - n);
    }

    public synchronized String toString() {
        this.shared = true;
        return new String(0, this.count, this.value);
    }
}

