/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public final class DatagramPacket {
    byte[] buf;
    int offset;
    int length;
    InetAddress address;
    int port;
    int receivedAddress;

    public DatagramPacket(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n2 + n > byArray.length) {
            throw new IllegalArgumentException("illegal length or offset");
        }
        this.buf = byArray;
        this.length = n2;
        this.offset = n;
        this.receivedAddress = -1;
        this.port = -1;
    }

    public DatagramPacket(byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    public DatagramPacket(byte[] byArray, int n, int n2, InetAddress inetAddress, int n3) {
        if (n2 < 0 || n < 0 || n2 + n > byArray.length) {
            throw new IllegalArgumentException("illegal length or offset");
        }
        if (n3 < 0 || n3 > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n3);
        }
        this.buf = byArray;
        this.length = n2;
        this.offset = n;
        this.address = inetAddress;
        this.port = n3;
        this.receivedAddress = -1;
    }

    public DatagramPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        this(byArray, 0, n, inetAddress, n2);
    }

    public synchronized InetAddress getAddress() {
        InetAddress inetAddress = this.address;
        if (inetAddress == null && this.receivedAddress != -1) {
            inetAddress = new InetAddress();
            inetAddress.address = this.receivedAddress;
            this.address = inetAddress;
        }
        return inetAddress;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buf;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setData(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n2 + n > byArray.length) {
            throw new IllegalArgumentException("illegal length or offset");
        }
        this.buf = byArray;
        this.length = n2;
        this.offset = n;
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
        this.receivedAddress = -1;
    }

    public synchronized void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n);
        }
        this.port = n;
    }

    public synchronized void setData(byte[] byArray) {
        if (this.length > byArray.length) {
            this.length = byArray.length;
        }
        this.buf = byArray;
    }

    public synchronized void setLength(int n) {
        if (n > this.buf.length || n < 0) {
            throw new IllegalArgumentException("illegal length");
        }
        this.length = n;
    }

    private static native void init();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        DatagramPacket.init();
    }
}

