/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.PlainSocketImpl;
import java.net.SocketException;

class SocketInputStream
extends FileInputStream {
    private boolean eof;
    private PlainSocketImpl impl;
    private byte[] temp;

    static {
        SocketInputStream.init();
    }

    SocketInputStream(PlainSocketImpl plainSocketImpl) throws IOException {
        super(plainSocketImpl.getFileDescriptor());
        this.impl = plainSocketImpl;
    }

    public int available() throws IOException {
        return this.impl.available();
    }

    public void close() throws IOException {
        this.impl.close();
    }

    protected void finalize() {
    }

    private static native void init();

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.eof) {
            return -1;
        }
        if (n2 <= 0 || n < 0 || n + n2 > byArray.length) {
            if (n2 == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        FileDescriptor fileDescriptor = this.impl.acquireFD();
        try {
            n3 = this.socketRead(byArray, n, n2);
        }
        finally {
            Object var7_6 = null;
            this.impl.releaseFD();
        }
        if (n3 <= 0) {
            if (this.impl.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            this.eof = true;
            return -1;
        }
        return n3;
    }

    void setEOF(boolean bl) {
        this.eof = bl;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        long l2 = l;
        int n = (int)Math.min(1024L, l2);
        byte[] byArray = new byte[n];
        while (l2 > 0L) {
            int n2 = this.read(byArray, 0, (int)Math.min((long)n, l2));
            if (n2 < 0) break;
            l2 -= (long)n2;
        }
        return l - l2;
    }

    private native int socketRead(byte[] var1, int var2, int var3) throws IOException;
}

