/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public final class URL
implements Serializable {
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private transient String query;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private String ref;
    transient InetAddress hostAddress;
    transient URLStreamHandler handler;
    private int hashCode = -1;
    private static NetPermission specifyHandlerPerm;
    static URLStreamHandlerFactory factory;
    static Hashtable handlers;
    private static Object streamHandlerLock;

    static {
        handlers = new Hashtable();
        streamHandlerLock = new Object();
    }

    public URL(String string) throws MalformedURLException {
        this(null, string);
    }

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        this(string, string2, n, string3, null);
    }

    public URL(String string, String string2, int n, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        SecurityManager securityManager;
        if (uRLStreamHandler != null && (securityManager = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler(securityManager);
        }
        this.protocol = string;
        this.host = string2;
        int n2 = string3.indexOf(35);
        this.file = n2 < 0 ? string3 : string3.substring(0, n2);
        this.ref = n2 < 0 ? null : string3.substring(n2 + 1);
        int n3 = string3.lastIndexOf(63);
        if (n3 != -1) {
            this.query = string3.substring(n3 + 1);
            this.path = string3.substring(0, n3);
        } else {
            this.path = string3;
        }
        if (uRLStreamHandler == null && (uRLStreamHandler = URL.getURLStreamHandler(string)) == null) {
            throw new MalformedURLException("unknown protocol: " + string);
        }
        this.handler = uRLStreamHandler;
        this.port = n;
        if (string2 != null && string2.length() > 0) {
            this.authority = n == -1 ? string2 : String.valueOf(string2) + ":" + n;
        }
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(uRL, string, null);
    }

    public URL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        Object object;
        String string2 = string;
        int n = 0;
        Object object2 = null;
        boolean bl = false;
        if (uRLStreamHandler != null && (object = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler((SecurityManager)object);
        }
        try {
            char c;
            int n2 = string.length();
            while (n2 > 0 && string.charAt(n2 - 1) <= ' ') {
                --n2;
            }
            while (n < n2 && string.charAt(n) <= ' ') {
                ++n;
            }
            if (string.regionMatches(true, n, "url:", 0, 4)) {
                n += 4;
            }
            if (n < string.length() && string.charAt(n) == '#') {
                bl = true;
            }
            int n3 = n;
            while (!bl && n3 < n2 && (c = string.charAt(n3)) != '/') {
                if (c == ':') {
                    object = string.substring(n, n3).toLowerCase();
                    if (!this.isValidProtocol((String)object)) break;
                    object2 = object;
                    n = n3 + 1;
                    break;
                }
                ++n3;
            }
            this.protocol = object2;
            if (uRL != null && (object2 == null || ((String)object2).equalsIgnoreCase(uRL.protocol))) {
                if (uRLStreamHandler == null) {
                    uRLStreamHandler = uRL.handler;
                }
                if (uRL.path != null && uRL.path.startsWith("/")) {
                    object2 = null;
                }
                if (object2 == null) {
                    this.protocol = uRL.protocol;
                    this.authority = uRL.authority;
                    this.userInfo = uRL.userInfo;
                    this.host = uRL.host;
                    this.port = uRL.port;
                    this.file = uRL.file;
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + string2);
            }
            if (uRLStreamHandler == null && (uRLStreamHandler = URL.getURLStreamHandler(this.protocol)) == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            this.handler = uRLStreamHandler;
            n3 = string.indexOf(35, n);
            if (n3 >= 0) {
                this.ref = string.substring(n3 + 1, n2);
                n2 = n3;
            }
            uRLStreamHandler.parseURL(this, string, n, n2);
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (Exception exception) {
            throw new MalformedURLException(exception.toString());
        }
    }

    private void checkSpecifyHandler(SecurityManager securityManager) {
        if (specifyHandlerPerm == null) {
            specifyHandlerPerm = new NetPermission("specifyStreamHandler");
        }
        securityManager.checkPermission(specifyHandlerPerm);
    }

    public boolean equals(Object object) {
        if (!(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        return this.handler.equals(this, uRL);
    }

    public String getAuthority() {
        return this.authority;
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classArray) throws IOException {
        return this.openConnection().getContent(classArray);
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRef() {
        return this.ref;
    }

    static URLStreamHandler getURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler = (URLStreamHandler)handlers.get(string);
        if (uRLStreamHandler == null) {
            Object object;
            String string2;
            Object object2;
            Object object3;
            boolean bl = false;
            if (factory != null) {
                uRLStreamHandler = factory.createURLStreamHandler(string);
                bl = true;
            }
            if (uRLStreamHandler == null) {
                object3 = null;
                object3 = (String)AccessController.doPrivileged(new GetPropertyAction(protocolPathProp, ""));
                if (object3 != "") {
                    object3 = String.valueOf(object3) + "|";
                }
                object3 = String.valueOf(object3) + "sun.net.www.protocol";
                object2 = new StringTokenizer((String)object3, "|");
                while (uRLStreamHandler == null && ((StringTokenizer)object2).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object2).nextToken().trim();
                    try {
                        Class clazz;
                        block16: {
                            object = String.valueOf(string2) + "." + string + ".Handler";
                            clazz = null;
                            try {
                                clazz = Class.forName((String)object);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                if (classLoader == null) break block16;
                                clazz = classLoader.loadClass((String)object);
                            }
                        }
                        if (clazz == null) continue;
                        uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                    }
                    catch (Exception exception) {}
                }
            }
            object2 = streamHandlerLock;
            synchronized (object2) {
                object = null;
                object = (URLStreamHandler)handlers.get(string);
                if (object != null) {
                    object3 = object;
                    string2 = null;
                    return object3;
                }
                if (!bl && factory != null) {
                    object = factory.createURLStreamHandler(string);
                }
                if (object != null) {
                    uRLStreamHandler = object;
                }
                if (uRLStreamHandler != null) {
                    handlers.put(string, uRLStreamHandler);
                }
            }
        }
        return uRLStreamHandler;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public synchronized int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.handler.hashCode(this);
        return this.hashCode;
    }

    private boolean isValidProtocol(String string) {
        int n = string.length();
        if (n < 1) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        this.handler = URL.getURLStreamHandler(this.protocol);
        if (this.handler == null) {
            throw new IOException("unknown protocol: " + this.protocol);
        }
        if (this.authority == null && (this.host != null && this.host.length() > 0 || this.port != -1)) {
            if (this.host == null) {
                this.host = "";
            }
            this.authority = this.port == -1 ? this.host : String.valueOf(this.host) + ":" + this.port;
            n = this.host.lastIndexOf(64);
            if (n != -1) {
                this.userInfo = this.host.substring(0, n);
                this.host = this.host.substring(n + 1);
            }
        } else if (this.authority != null && (n = this.authority.indexOf(64)) != -1) {
            this.userInfo = this.authority.substring(0, n);
        }
        String string = null;
        String string2 = null;
        if (this.file != null) {
            int n2 = this.file.lastIndexOf(63);
            if (n2 != -1) {
                string2 = this.file.substring(n2 + 1);
                string = this.file.substring(0, n2);
            } else {
                string = this.file;
            }
        }
    }

    public boolean sameFile(URL uRL) {
        return this.handler.sameFile(this, uRL);
    }

    protected void set(String string, String string2, int n, String string3, String string4) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = string;
            this.host = string2;
            this.authority = n == -1 ? string2 : String.valueOf(string2) + ":" + n;
            this.port = n;
            this.file = string3;
            this.ref = string4;
            this.hashCode = -1;
            this.hostAddress = null;
            int n2 = string3.lastIndexOf(63);
            if (n2 != -1) {
                this.query = string3.substring(n2 + 1);
                this.path = string3.substring(0, n2);
            } else {
                this.path = string3;
            }
        }
    }

    protected void set(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = string;
            this.host = string2;
            this.port = n;
            this.file = string6 == null ? string5 : String.valueOf(string5) + "?" + string6;
            this.userInfo = string4;
            this.path = string5;
            this.ref = string7;
            this.hashCode = -1;
            this.hostAddress = null;
            this.query = string6;
            this.authority = string3;
        }
    }

    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        Object object = streamHandlerLock;
        synchronized (object) {
            if (factory != null) {
                throw new Error("factory already defined");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSetFactory();
            }
            handlers.clear();
            factory = uRLStreamHandlerFactory;
        }
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public String toString() {
        return this.toExternalForm();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

