/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public abstract class URLStreamHandler {
    protected boolean equals(URL uRL, URL uRL2) {
        String string = uRL.getRef();
        String string2 = uRL2.getRef();
        return this.sameFile(uRL, uRL2) && (string == string2 || string != null && string.equals(string2));
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected synchronized InetAddress getHostAddress(URL uRL) {
        if (uRL.hostAddress != null) {
            return uRL.hostAddress;
        }
        String string = uRL.getHost();
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            uRL.hostAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        return uRL.hostAddress;
    }

    protected int hashCode(URL uRL) {
        String string;
        InetAddress inetAddress;
        int n = 0;
        String string2 = uRL.getProtocol();
        if (string2 != null) {
            n += string2.hashCode();
        }
        if ((inetAddress = this.getHostAddress(uRL)) != null) {
            n += inetAddress.hashCode();
        } else {
            string = uRL.getHost();
            if (string != null) {
                n += string.toLowerCase().hashCode();
            }
        }
        string = uRL.getFile();
        if (string != null) {
            n += string.hashCode();
        }
        n = uRL.getPort() == -1 ? (n += this.getDefaultPort()) : (n += uRL.getPort());
        String string3 = uRL.getRef();
        if (string3 != null) {
            n += string3.hashCode();
        }
        return n;
    }

    protected boolean hostsEqual(URL uRL, URL uRL2) {
        InetAddress inetAddress = this.getHostAddress(uRL);
        InetAddress inetAddress2 = this.getHostAddress(uRL2);
        if (inetAddress != null && inetAddress2 != null) {
            return inetAddress.equals(inetAddress2);
        }
        if (uRL.getHost() != null && uRL2.getHost() != null) {
            return uRL.getHost().equalsIgnoreCase(uRL2.getHost());
        }
        return uRL.getHost() == null && uRL2.getHost() == null;
    }

    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected void parseURL(URL uRL, String string, int n, int n2) {
        int n3;
        int n4;
        String string2 = uRL.getProtocol();
        String string3 = uRL.getAuthority();
        String string4 = uRL.getUserInfo();
        String string5 = uRL.getHost();
        int n5 = uRL.getPort();
        String string6 = uRL.getFile();
        String string7 = uRL.getRef();
        String string8 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (n < n2) {
            n4 = string.indexOf(63);
            boolean bl3 = bl2 = n4 == n;
            if (n4 != -1) {
                string8 = string.substring(n4 + 1, n2);
                if (n2 > n4) {
                    n2 = n4;
                }
                string = string.substring(0, n4);
            }
        }
        n4 = 0;
        if (n <= n2 - 2 && string.charAt(n) == '/' && string.charAt(n + 1) == '/') {
            n4 = string.indexOf(47, n += 2);
            if (n4 < 0 && (n4 = string.indexOf(63, n)) < 0) {
                n4 = n2;
            }
            string5 = string3 = string.substring(n, n4);
            n3 = string3.indexOf(64);
            if (n3 != -1) {
                string4 = string3.substring(0, n3);
                string5 = string3.substring(n3 + 1);
            }
            n3 = string5.indexOf(58);
            n5 = -1;
            if (n3 >= 0) {
                if (string5.length() > n3 + 1) {
                    n5 = Integer.parseInt(string5.substring(n3 + 1));
                }
                string5 = string5.substring(0, n3);
            }
            n = n4;
            if (string3 != null && string3.length() > 0) {
                string6 = "";
            }
        }
        if (string5 == null) {
            string5 = "";
        }
        if (n < n2) {
            if (string.charAt(n) == '/') {
                string6 = string.substring(n, n2);
            } else if (string6 != null && string6.length() > 0) {
                bl = true;
                n3 = string6.lastIndexOf(47);
                String string9 = "";
                if (n3 == -1 && string3 != null) {
                    string9 = "/";
                }
                string6 = String.valueOf(string6.substring(0, n3 + 1)) + string9 + string.substring(n, n2);
            } else {
                String string10 = string3 != null ? "/" : "";
                string6 = String.valueOf(string10) + string.substring(n, n2);
            }
        } else if (bl2 && string6 != null) {
            n3 = string6.lastIndexOf(47);
            if (n3 < 0) {
                n3 = 0;
            }
            string6 = String.valueOf(string6.substring(0, n3)) + "/";
        }
        if (string6 == null) {
            string6 = "";
        }
        if (bl) {
            while ((n4 = string6.indexOf("/./")) >= 0) {
                string6 = String.valueOf(string6.substring(0, n4)) + string6.substring(n4 + 2);
            }
            while ((n4 = string6.indexOf("/../")) >= 0) {
                n2 = string6.lastIndexOf(47, n4 - 1);
                string6 = n2 >= 0 ? String.valueOf(string6.substring(0, n2)) + string6.substring(n4 + 3) : string6.substring(n4 + 3);
            }
            while (string6.endsWith("/..")) {
                n4 = string6.indexOf("/..");
                n2 = string6.lastIndexOf(47, n4 - 1);
                string6 = n2 >= 0 ? string6.substring(0, n2 + 1) : string6.substring(0, n4);
            }
            if (string6.endsWith("/.")) {
                string6 = string6.substring(0, string6.length() - 1);
            }
        }
        this.setURL(uRL, string2, string5, n5, string3, string4, string6, string8, string7);
    }

    protected boolean sameFile(URL uRL, URL uRL2) {
        int n;
        if (!(uRL.getProtocol() == uRL2.getProtocol() || uRL.getProtocol() != null && uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()))) {
            return false;
        }
        if (!this.hostsEqual(uRL, uRL2)) {
            return false;
        }
        if (!(uRL.getFile() == uRL2.getFile() || uRL.getFile() != null && uRL.getFile().equals(uRL2.getFile()))) {
            return false;
        }
        int n2 = uRL.getPort() != -1 ? uRL.getPort() : uRL.handler.getDefaultPort();
        int n3 = n = uRL2.getPort() != -1 ? uRL2.getPort() : uRL2.handler.getDefaultPort();
        return n2 == n;
    }

    protected void setURL(URL uRL, String string, String string2, int n, String string3, String string4) {
        String string5 = null;
        String string6 = null;
        if (string2 != null && string2.length() != 0) {
            string5 = n == -1 ? string2 : String.valueOf(string2) + ":" + n;
            int n2 = string2.lastIndexOf(64);
            if (n2 != -1) {
                string6 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            }
        }
        String string7 = null;
        String string8 = null;
        if (string3 != null) {
            int n3 = string3.lastIndexOf(63);
            if (n3 != -1) {
                string8 = string3.substring(n3 + 1);
                string7 = string3.substring(0, n3);
            } else {
                string7 = string3;
            }
        }
        this.setURL(uRL, string, string2, n, string5, string6, string7, string8, string4);
    }

    protected void setURL(URL uRL, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        if (this != uRL.handler) {
            throw new SecurityException("handler for url different from this handler");
        }
        uRL.set(uRL.getProtocol(), string2, n, string3, string4, string5, string6, string7);
    }

    protected String toExternalForm(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer(uRL.getProtocol());
        stringBuffer.append(":");
        if (uRL.getAuthority() != null && uRL.getAuthority().length() > 0) {
            stringBuffer.append("//");
            stringBuffer.append(uRL.getAuthority());
        }
        if (uRL.getFile() != null) {
            stringBuffer.append(uRL.getFile());
        }
        if (uRL.getRef() != null) {
            stringBuffer.append("#");
            stringBuffer.append(uRL.getRef());
        }
        return stringBuffer.toString();
    }
}

