/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public abstract class Certificate
implements Serializable {
    private String type;

    protected Certificate(String string) {
        this.type = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Certificate)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((Certificate)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public final String getType() {
        return this.type;
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
            return n;
        }
        catch (CertificateException certificateException) {
            return n;
        }
    }

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw new NotSerializableException("java.security.cert.Certificate: " + this.type + ": " + certificateException.getMessage());
        }
    }

    protected static class CertificateRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected CertificateRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertificate(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                throw new NotSerializableException("java.security.cert.Certificate: " + this.type + ": " + certificateException.getMessage());
            }
        }
    }
}

