/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final int EPOCH_YEAR = 1970;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;
    private static final int[] MONTH_LENGTH;
    private static final int[] LEAP_MONTH_LENGTH;
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final int[] MIN_VALUES;
    private static final int[] LEAST_MAX_VALUES;
    private static final int[] MAX_VALUES;
    private long gregorianCutover;
    private transient long normalizedGregorianCutover;
    private transient int gregorianCutoverYear;
    static final long serialVersionUID = -8125100834729963327L;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        NUM_DAYS = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        LEAP_NUM_DAYS = nArray2;
        MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] nArray3 = new int[17];
        nArray3[1] = 1;
        nArray3[3] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = -1;
        nArray3[15] = -43200000;
        MIN_VALUES = nArray3;
        LEAST_MAX_VALUES = new int[]{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
        MAX_VALUES = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.normalizedGregorianCutover = this.gregorianCutover = -12219292800000L;
        this.gregorianCutoverYear = 1582;
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.complete();
        if (n == 1) {
            int n3 = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                } else {
                    this.set(1, 1 - n3);
                    this.set(0, 0);
                }
            } else if ((n3 -= n2) > 0) {
                this.set(1, n3);
            } else {
                this.set(1, 1 - n3);
                this.set(0, 1);
            }
            this.pinDayOfMonth();
        } else if (n == 2) {
            int n4 = this.internalGet(2) + n2;
            if (n4 >= 0) {
                this.set(1, this.internalGet(1) + n4 / 12);
                this.set(2, n4 % 12);
            } else {
                this.set(1, this.internalGet(1) + (n4 + 1) / 12 - 1);
                if ((n4 %= 12) < 0) {
                    n4 += 12;
                }
                this.set(2, n4);
            }
            this.pinDayOfMonth();
        } else if (n == 0) {
            int n5 = this.internalGet(0) + n2;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > 1) {
                n5 = 1;
            }
            this.set(0, n5);
        } else {
            long l = n2;
            boolean bl = true;
            switch (n) {
                case 3: 
                case 4: 
                case 8: {
                    l *= 604800000L;
                    break;
                }
                case 9: {
                    l *= 43200000L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    l *= 86400000L;
                    break;
                }
                case 10: 
                case 11: {
                    l *= 3600000L;
                    bl = false;
                    break;
                }
                case 12: {
                    l *= 60000L;
                    bl = false;
                    break;
                }
                case 13: {
                    l *= 1000L;
                    bl = false;
                    break;
                }
                case 14: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            long l2 = 0L;
            if (bl) {
                l2 = this.internalGet(16);
            }
            this.setTimeInMillis(this.time + l);
            if (bl) {
                l2 -= (long)this.internalGet(16);
                if (l != 0L) {
                    this.setTimeInMillis(this.time + l2);
                }
            }
        }
    }

    private static final int aggregateStamp(int n, int n2) {
        return n != 0 && n2 != 0 ? Math.max(n, n2) : 0;
    }

    private final boolean boundsCheck(int n, int n2) {
        return n >= this.getMinimum(n2) && n <= this.getMaximum(n2);
    }

    protected void computeFields() {
        int n;
        int n2 = this.getTimeZone().getRawOffset();
        long l = this.time + (long)n2;
        if (this.time > 0L && l < 0L && n2 > 0) {
            l = Long.MAX_VALUE;
        } else if (this.time < 0L && l > 0L && n2 < 0) {
            l = Long.MIN_VALUE;
        }
        this.timeToFields(l, false);
        int n3 = this.fields[2];
        long l2 = l / 86400000L;
        int n4 = (int)(l - l2 * 86400000L);
        if (n4 < 0) {
            n4 = (int)((long)n4 + 86400000L);
        }
        if ((long)(n4 += (n = this.getTimeZone().getOffset(this.internalGetEra(), this.fields[1], n3, this.fields[5], this.fields[7], n4, this.monthLength(n3), this.prevMonthLength(n3)) - n2)) >= 86400000L) {
            long l3 = l + (long)n;
            n4 = (int)((long)n4 - 86400000L);
            if (l > 0L && l3 < 0L && n > 0) {
                l3 = Long.MAX_VALUE;
            } else if (l < 0L && l3 > 0L && n < 0) {
                l3 = Long.MIN_VALUE;
            }
            this.timeToFields(l3, false);
        }
        this.fields[14] = n4 % 1000;
        this.fields[13] = (n4 /= 1000) % 60;
        this.fields[12] = (n4 /= 60) % 60;
        this.fields[11] = n4 /= 60;
        this.fields[9] = n4 / 12;
        this.fields[10] = n4 % 12;
        this.fields[15] = n2;
        this.fields[16] = n;
        int n5 = 17;
        while (--n5 >= 0) {
            this.stamp[n5] = 1;
            this.isSet[n5] = true;
        }
    }

    private final long computeJulianDay(boolean bl, int n) {
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        int n4 = this.stamp[7];
        int n5 = this.stamp[2];
        int n6 = this.stamp[5];
        int n7 = GregorianCalendar.aggregateStamp(this.stamp[4], n4);
        int n8 = GregorianCalendar.aggregateStamp(this.stamp[8], n4);
        int n9 = this.stamp[6];
        int n10 = GregorianCalendar.aggregateStamp(this.stamp[3], n4);
        int n11 = n6;
        if (n7 > n11) {
            n11 = n7;
        }
        if (n8 > n11) {
            n11 = n8;
        }
        if (n9 > n11) {
            n11 = n9;
        }
        if (n10 > n11) {
            n11 = n10;
        }
        if (n11 == 0) {
            n7 = this.stamp[4];
            n8 = Math.max(this.stamp[8], n4);
            n10 = this.stamp[3];
            n11 = Math.max(Math.max(n7, n8), n10);
            if (n11 == 0) {
                n11 = n6 = n5;
            }
        }
        boolean bl2 = false;
        if (n11 == n6 || n11 == n7 || n11 == n8) {
            bl2 = true;
            int n12 = n2 = n5 != 0 ? this.internalGet(2) : 0;
            if (n2 < 0 || n2 > 11) {
                int[] nArray = new int[1];
                n += GregorianCalendar.floorDivide(n2, 12, nArray);
                n2 = nArray[0];
            }
        }
        boolean bl3 = n % 4 == 0;
        int n13 = n - 1;
        long l2 = 365L * (long)n13 + (long)GregorianCalendar.floorDivide(n13, 4) + 1721423L;
        if (bl) {
            bl3 = bl3 && (n % 100 != 0 || n % 400 == 0);
            l2 += (long)(GregorianCalendar.floorDivide(n13, 400) - GregorianCalendar.floorDivide(n13, 100) + 2);
        }
        if (bl2) {
            l2 += (long)(bl3 ? LEAP_NUM_DAYS[n2] : NUM_DAYS[n2]);
            if (n11 == n6) {
                n3 = this.stamp[5] != 0 ? this.internalGet(5) : 1;
            } else {
                int n14 = GregorianCalendar.julianDayToDayOfWeek(l2 + 1L) - this.getFirstDayOfWeek();
                if (n14 < 0) {
                    n14 += 7;
                }
                n3 = 1 - n14 + (n4 != 0 ? this.internalGet(7) - this.getFirstDayOfWeek() : 0);
                if (n11 == n7) {
                    if (7 - n14 < this.getMinimalDaysInFirstWeek()) {
                        n3 += 7;
                    }
                    n3 += 7 * (this.internalGet(4) - 1);
                } else {
                    int n15;
                    if (n3 < 1) {
                        n3 += 7;
                    }
                    int n16 = n15 = this.stamp[8] != 0 ? this.internalGet(8) : 1;
                    n3 = n15 >= 0 ? (n3 += 7 * (n15 - 1)) : (n3 += ((this.monthLength(this.internalGet(2), n) - n3) / 7 + n15 + 1) * 7);
                }
            }
            l2 += (long)n3;
        } else if (n11 == n9) {
            l2 += (long)this.internalGet(6);
        } else {
            int n17 = GregorianCalendar.julianDayToDayOfWeek(l2 + 1L) - this.getFirstDayOfWeek();
            if (n17 < 0) {
                n17 += 7;
            }
            n3 = 1 - n17 + (n4 != 0 ? this.internalGet(7) - this.getFirstDayOfWeek() : 0);
            if (7 - n17 < this.getMinimalDaysInFirstWeek()) {
                n3 += 7;
            }
            l2 += (long)(n3 += 7 * (this.internalGet(3) - 1));
        }
        return l2;
    }

    protected void computeTime() {
        int n;
        long l;
        long l2;
        boolean bl;
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        int n2 = this.stamp[1] != 0 ? this.internalGet(1) : 1970;
        int n3 = 1;
        if (this.stamp[0] != 0) {
            n3 = this.internalGet(0);
            if (n3 == 0) {
                n2 = 1 - n2;
            } else if (n3 != 1) {
                throw new IllegalArgumentException("Invalid era");
            }
        }
        if ((bl = n2 >= this.gregorianCutoverYear) != (l2 = GregorianCalendar.julianDayToMillis(l = this.computeJulianDay(bl, n2))) >= this.normalizedGregorianCutover && l != -106749550580L) {
            l = this.computeJulianDay(bl ^ true, n2);
            l2 = GregorianCalendar.julianDayToMillis(l);
        }
        int n4 = 0;
        int n5 = this.stamp[10];
        int n6 = this.stamp[11];
        int n7 = n = n5 > n6 ? n5 : n6;
        if (n != 0) {
            if (n == n6) {
                n4 += this.internalGet(11);
            } else {
                n4 += this.internalGet(10);
                n4 += 12 * this.internalGet(9);
            }
        }
        n4 *= 60;
        n4 += this.internalGet(12);
        n4 *= 60;
        n4 += this.internalGet(13);
        n4 *= 1000;
        TimeZone timeZone = this.getTimeZone();
        int n8 = this.stamp[15] >= 2 ? this.internalGet(15) : timeZone.getRawOffset();
        l2 += (long)(n4 += this.internalGet(14));
        int n9 = 0;
        if (this.stamp[15] >= 2) {
            n9 = this.internalGet(16);
        } else {
            int n10;
            int[] nArray = new int[1];
            GregorianCalendar.floorDivide(l2, 86400000, nArray);
            if (this.isLenient() || this.stamp[2] == 0 || this.stamp[5] == 0 || n4 != nArray[0]) {
                this.timeToFields(l2, true);
                n10 = this.internalGet(7);
            } else {
                n10 = GregorianCalendar.julianDayToDayOfWeek(l);
            }
            n9 = timeZone.getOffset(n3, this.internalGet(1), this.internalGet(2), this.internalGet(5), n10, nArray[0], this.monthLength(this.internalGet(2)), this.prevMonthLength(this.internalGet(2))) - n8;
        }
        this.time = l2 - (long)n8 - (long)n9;
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof GregorianCalendar && this.gregorianCutover == ((GregorianCalendar)object).gregorianCutover;
    }

    private static final int floorDivide(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }

    private static final int floorDivide(int n, int n2, int[] nArray) {
        if (n >= 0) {
            nArray[0] = n % n2;
            return n / n2;
        }
        int n3 = (n + 1) / n2 - 1;
        nArray[0] = n - n3 * n2;
        return n3;
    }

    private static final int floorDivide(long l, int n, int[] nArray) {
        if (l >= 0L) {
            nArray[0] = (int)(l % (long)n);
            return (int)(l / (long)n);
        }
        int n2 = (int)((l + 1L) / (long)n - 1L);
        nArray[0] = (int)(l - (long)(n2 * n));
        return n2;
    }

    private static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    public int getActualMaximum(int n) {
        switch (n) {
            case 5: {
                return this.monthLength(this.get(2));
            }
            case 6: {
                return this.yearLength();
            }
            case 3: 
            case 4: 
            case 8: {
                return super.getActualMaximum(n);
            }
            case 1: {
                Calendar calendar = (Calendar)this.clone();
                calendar.setLenient(true);
                int n2 = calendar.get(0);
                Date date = calendar.getTime();
                int n3 = LEAST_MAX_VALUES[1];
                int n4 = MAX_VALUES[1] + 1;
                while (n3 + 1 < n4) {
                    int n5 = (n3 + n4) / 2;
                    calendar.set(1, n5);
                    if (calendar.get(1) == n5 && calendar.get(0) == n2) {
                        n3 = n5;
                        continue;
                    }
                    n4 = n5;
                    calendar.setTime(date);
                }
                return n3;
            }
        }
        return this.getMaximum(n);
    }

    public int getActualMinimum(int n) {
        return this.getMinimum(n);
    }

    private final long getEpochDay() {
        this.complete();
        long l = this.time / 1000L + (long)((this.internalGet(15) + this.internalGet(16)) / 1000);
        return GregorianCalendar.floorDivide(l, 86400L);
    }

    public int getGreatestMinimum(int n) {
        return MIN_VALUES[n];
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    int getISOYear() {
        this.complete();
        int n = this.internalGet(3);
        int n2 = this.internalGet(1);
        if (this.internalGet(2) == 0) {
            if (n >= 52) {
                --n2;
            }
        } else if (n == 1) {
            ++n2;
        }
        return n2;
    }

    public int getLeastMaximum(int n) {
        return LEAST_MAX_VALUES[n];
    }

    public int getMaximum(int n) {
        return MAX_VALUES[n];
    }

    public int getMinimum(int n) {
        return MIN_VALUES[n];
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.gregorianCutover;
    }

    boolean inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.internalGet(16) != 0;
    }

    private final int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : 1;
    }

    public boolean isLeapYear(int n) {
        return n >= this.gregorianCutoverYear ? n % 4 == 0 && (n % 100 != 0 || n % 400 == 0) : n % 4 == 0;
    }

    private static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    private static final long millisToJulianDay(long l) {
        return 2440588L + GregorianCalendar.floorDivide(l, 86400000L);
    }

    private final int monthLength(int n) {
        int n2 = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n2 = 1 - n2;
        }
        return this.monthLength(n, n2);
    }

    private final int monthLength(int n, int n2) {
        return this.isLeapYear(n2) ? LEAP_MONTH_LENGTH[n] : MONTH_LENGTH[n];
    }

    private final void pinDayOfMonth() {
        int n = this.monthLength(this.internalGet(2));
        int n2 = this.internalGet(5);
        if (n2 > n) {
            this.set(5, n);
        }
    }

    private final int prevMonthLength(int n) {
        return n > 1 ? this.monthLength(n - 1) : 31;
    }

    public void roll(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        if (n >= 0 && n < 17) {
            this.complete();
            n3 = this.getMinimum(n);
            n4 = this.getMaximum(n);
        }
        switch (n) {
            case 10: 
            case 11: {
                Date date = this.getTime();
                int n5 = this.internalGet(n);
                int n6 = (n5 + n2) % (n4 + 1);
                if (n6 < 0) {
                    n6 += n4 + 1;
                }
                this.setTime(new Date(date.getTime() + (long)(3600000 * (n6 - n5))));
                return;
            }
            case 2: {
                int n7 = (this.internalGet(2) + n2) % 12;
                if (n7 < 0) {
                    n7 += 12;
                }
                this.set(2, n7);
                int n8 = this.monthLength(n7);
                int n9 = this.internalGet(5);
                if (n9 > n8) {
                    this.set(5, n8);
                }
                return;
            }
            case 3: {
                int n10 = this.internalGet(3);
                int n11 = this.internalGet(1);
                int n12 = this.internalGet(6);
                if (this.internalGet(2) == 0) {
                    if (n10 >= 52) {
                        n12 += this.yearLength(--n11);
                    }
                } else if (n10 == 1) {
                    n12 -= this.yearLength(n11);
                    ++n11;
                }
                if ((n10 += n2) < 1 || n10 > 52) {
                    int n13 = this.yearLength(n11);
                    int n14 = (n13 - n12 + this.internalGet(7) - this.getFirstDayOfWeek()) % 7;
                    if (n14 < 0) {
                        n14 += 7;
                    }
                    if (6 - n14 >= this.getMinimalDaysInFirstWeek()) {
                        n13 -= 7;
                    }
                    int n15 = this.weekNumber(n13, n14 + 1);
                    n10 = (n10 + n15 - 1) % n15 + 1;
                }
                this.set(3, n10);
                this.set(1, n11);
                return;
            }
            case 4: {
                int n16;
                int n17 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n17 < 0) {
                    n17 += 7;
                }
                if ((n16 = (n17 - this.internalGet(5) + 1) % 7) < 0) {
                    n16 += 7;
                }
                int n18 = 7 - n16 < this.getMinimalDaysInFirstWeek() ? 8 - n16 : 1 - n16;
                int n19 = this.monthLength(this.internalGet(2));
                int n20 = (n19 - this.internalGet(5) + n17) % 7;
                int n21 = n19 + 7 - n20;
                int n22 = n21 - n18;
                int n23 = (this.internalGet(5) + n2 * 7 - n18) % n22;
                if (n23 < 0) {
                    n23 += n22;
                }
                if ((n23 += n18) < 1) {
                    n23 = 1;
                }
                if (n23 > n19) {
                    n23 = n19;
                }
                this.set(5, n23);
                return;
            }
            case 5: {
                n4 = this.monthLength(this.internalGet(2));
                break;
            }
            case 6: {
                long l = (long)n2 * 86400000L;
                long l2 = this.time - (long)(this.internalGet(6) - 1) * 86400000L;
                int n24 = this.yearLength();
                this.time = (this.time + l - l2) % ((long)n24 * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)n24 * 86400000L;
                }
                this.setTimeInMillis(this.time + l2);
                return;
            }
            case 7: {
                long l = (long)n2 * 86400000L;
                int n25 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n25 < 0) {
                    n25 += 7;
                }
                long l3 = this.time - (long)n25 * 86400000L;
                this.time = (this.time + l - l3) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                this.setTimeInMillis(this.time + l3);
                return;
            }
            case 8: {
                long l = (long)n2 * 604800000L;
                int n26 = (this.internalGet(5) - 1) / 7;
                int n27 = (this.monthLength(this.internalGet(2)) - this.internalGet(5)) / 7;
                long l4 = this.time - (long)n26 * 604800000L;
                long l5 = 604800000L * (long)(n26 + n27 + 1);
                this.time = (this.time + l - l4) % l5;
                if (this.time < 0L) {
                    this.time += l5;
                }
                this.setTimeInMillis(this.time + l4);
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
        }
        int n28 = n4 - n3 + 1;
        int n29 = this.internalGet(n) + n2;
        n29 = (n29 - n3) % n28;
        if (n29 < 0) {
            n29 += n28;
        }
        this.set(n, n29 += n3);
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
        long l = GregorianCalendar.floorDivide(this.gregorianCutover, 86400000L);
        this.normalizedGregorianCutover = l * 86400000L;
        if (l < 0L && this.normalizedGregorianCutover > 0L) {
            this.normalizedGregorianCutover = (l + 1L) * 86400000L;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setTime(date);
        this.gregorianCutoverYear = gregorianCalendar.get(1);
        if (gregorianCalendar.get(0) == 0) {
            this.gregorianCutoverYear = 1 - this.gregorianCutoverYear;
        }
    }

    private final void timeToFields(long l, boolean bl) {
        int n;
        boolean bl2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        long l2;
        if (l >= this.normalizedGregorianCutover) {
            l2 = GregorianCalendar.millisToJulianDay(l) - 1721426L;
            n9 = (int)((l2 + 1L) % 7L);
            n8 = (int)GregorianCalendar.floorDivide(l2, 146097L);
            n7 = (int)(l2 -= 146097L * (long)n8);
            n6 = n7 / 36524;
            n5 = (n7 %= 36524) / 1461;
            n4 = (n7 %= 1461) / 365;
            n3 = n7 % 365;
            n2 = 400 * n8 + 100 * n6 + 4 * n5 + n4;
            if (n6 == 4 || n4 == 4) {
                n3 = 365;
            } else {
                ++n2;
            }
            bl2 = (n2 & 3) == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
        } else {
            l2 = GregorianCalendar.millisToJulianDay(l) - 1721424L;
            n2 = (int)GregorianCalendar.floorDivide(4L * l2 + 1464L, 1461L);
            long l3 = 365 * (n2 - 1) + GregorianCalendar.floorDivide(n2 - 1, 4);
            n3 = (int)(l2 - l3);
            bl2 = (n2 & 3) == 0;
            n9 = (int)((l2 - 1L) % 7L);
        }
        int n10 = 0;
        int n11 = n = bl2 ? 60 : 59;
        if (n3 >= n) {
            n10 = bl2 ? 1 : 2;
        }
        this.fields[2] = n8 = (12 * (n3 + n10) + 6) / 367;
        n7 = n3 - (bl2 ? LEAP_NUM_DAYS[n8] : NUM_DAYS[n8]) + 1;
        n9 += n9 < 0 ? 8 : 1;
        if (n2 < 1) {
            this.fields[0] = 0;
            this.fields[1] = 1 - n2;
        } else {
            this.fields[0] = 1;
            this.fields[1] = n2;
        }
        this.fields[5] = n7;
        this.fields[7] = n9;
        this.fields[6] = ++n3;
        if (!bl) {
            n6 = (n9 + 7 - this.getFirstDayOfWeek()) % 7;
            n5 = (n9 - n3 + 701 - this.getFirstDayOfWeek()) % 7;
            n4 = (n3 - 1 + n5) / 7;
            if (7 - n5 >= this.getMinimalDaysInFirstWeek()) {
                ++n4;
            }
            if (n3 > 359) {
                int n12 = this.yearLength();
                int n13 = (n6 + n12 - n3) % 7;
                if (n13 < 0) {
                    n13 += 7;
                }
                if (6 - n13 >= this.getMinimalDaysInFirstWeek() && n3 + 7 - n6 > n12) {
                    n4 = 1;
                }
            } else if (n4 == 0) {
                int n14 = n3 + this.yearLength(n2 - 1);
                n4 = this.weekNumber(n14, n9);
            }
            this.fields[3] = n4;
            this.fields[4] = this.weekNumber(n7, n9);
            this.fields[8] = (n7 - 1) / 7 + 1;
        }
    }

    private boolean validateFields() {
        int n;
        int n2 = 0;
        while (n2 < 17) {
            if (n2 != 5 && n2 != 6 && this.isSet(n2) && !this.boundsCheck(this.internalGet(n2), n2)) {
                return false;
            }
            ++n2;
        }
        if (this.isSet(5) && ((n = this.internalGet(5)) < this.getMinimum(5) || n > this.monthLength(this.internalGet(2)))) {
            return false;
        }
        if (this.isSet(6) && ((n = this.internalGet(6)) < 1 || n > this.yearLength())) {
            return false;
        }
        return !this.isSet(8) || this.internalGet(8) != 0;
    }

    private final int weekNumber(int n, int n2) {
        int n3 = (n2 - this.getFirstDayOfWeek() - n + 1) % 7;
        if (n3 < 0) {
            n3 += 7;
        }
        int n4 = (n + n3 - 1) / 7;
        if (7 - n3 >= this.getMinimalDaysInFirstWeek()) {
            ++n4;
        }
        return n4;
    }

    private final int yearLength() {
        return this.isLeapYear(this.internalGet(1)) ? 366 : 365;
    }

    private final int yearLength(int n) {
        return this.isLeapYear(n) ? 366 : 365;
    }
}

