/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.text.resources.LocaleData;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public final class Locale
implements Cloneable,
Serializable {
    public static final Locale ENGLISH = new Locale("en", "", "");
    public static final Locale FRENCH = new Locale("fr", "", "");
    public static final Locale GERMAN = new Locale("de", "", "");
    public static final Locale ITALIAN = new Locale("it", "", "");
    public static final Locale JAPANESE = new Locale("ja", "", "");
    public static final Locale KOREAN = new Locale("ko", "", "");
    public static final Locale CHINESE = new Locale("zh", "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN", "");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW", "");
    public static final Locale FRANCE = new Locale("fr", "FR", "");
    public static final Locale GERMANY = new Locale("de", "DE", "");
    public static final Locale ITALY = new Locale("it", "IT", "");
    public static final Locale JAPAN = new Locale("ja", "JP", "");
    public static final Locale KOREA = new Locale("ko", "KR", "");
    public static final Locale CHINA = new Locale("zh", "CN", "");
    public static final Locale PRC = new Locale("zh", "CN", "");
    public static final Locale TAIWAN = new Locale("zh", "TW", "");
    public static final Locale UK = new Locale("en", "GB", "");
    public static final Locale US = new Locale("en", "US", "");
    public static final Locale CANADA = new Locale("en", "CA", "");
    public static final Locale CANADA_FRENCH = new Locale("fr", "CA", "");
    static final long serialVersionUID = 9149081749638150636L;
    private String language = "";
    private String country = "";
    private String variant = "";
    private int hashcode = -1;
    private static Locale defaultLocale;
    private static String[] isoLanguages;
    private static final String compressedIsoLanguages = ",aaaar,ababk,afafr,amamh,arara,asasm,ayaym,azaze,babak,bebel,bgbul,bhbih,bibis,bnben,bobod,brbre,cacat,cocos,csces,cycym,dadan,dedeu,dzdzo,elell,eneng,eoepo,esspa,etest,eueus,fafas,fifin,fjfij,fofao,frfra,fyfry,gagai,gdgdh,glglg,gngrn,guguj,hahau,heheb,hihin,hrhrv,huhun,hyhye,iaina,idind,ieile,ikipk,inind,isisl,itita,iuiku,iwheb,jajpn,jiyid,jwjaw,kakat,kkkaz,klkal,kmkhm,knkan,kokor,kskas,kukur,kykir,lalat,lnlin,lolao,ltlit,lvlav,mgmlg,mimri,mkmkd,mlmal,mnmon,momol,mrmar,msmsa,mtmlt,mymya,nanau,nenep,nlnld,nonor,ococi,omorm,orori,papan,plpol,pspus,ptpor,quque,rmroh,rnrun,roron,rurus,rwkin,sasan,sdsnd,sgsag,shsrp,sisin,skslk,slslv,smsmo,snsna,sosom,sqsqi,srsrp,ssssw,stsot,susun,svswe,swswa,tatam,tetel,tgtgk,ththa,titir,tktuk,tltgl,tntsn,toton,trtur,tstso,tttat,twtwi,uguig,ukukr,ururd,uzuzb,vivie,vovol,wowol,xhxho,yiyid,yoyor,zazha,zhzho,zuzul";
    private static String[] isoCountries;
    private static final String compressedIsoCountries = ",ADAND,AEARE,AFAFG,AGATG,AIAIA,ALALB,AMARM,ANANT,AOAGO,AQATA,ARARG,ASASM,ATAUT,AUAUS,AWABW,AZAZE,BABIH,BBBRB,BDBGD,BEBEL,BFBFA,BGBGR,BHBHR,BIBDI,BJBEN,BMBMU,BNBRN,BOBOL,BRBRA,BSBHS,BTBTN,BVBVT,BWBWA,BYBLR,BZBLZ,CACAN,CCCCK,CFCAF,CGCOG,CHCHE,CICIV,CKCOK,CLCHL,CMCMR,CNCHN,COCOL,CRCRI,CUCUB,CVCPV,CXCXR,CYCYP,CZCZE,DEDEU,DJDJI,DKDNK,DMDMA,DODOM,DZDZA,ECECU,EEEST,EGEGY,EHESH,ERERI,ESESP,ETETH,FIFIN,FJFJI,FKFLK,FMFSM,FOFRO,FRFRA,FXFXX,GAGAB,GBGBR,GDGRD,GEGEO,GFGUF,GHGHA,GIGIB,GLGRL,GMGMB,GNGIN,GPGLP,GQGNQ,GRGRC,GSSGS,GTGTM,GUGUM,GWGNB,GYGUY,HKHKG,HMHMD,HNHND,HRHRV,HTHTI,HUHUN,IDIDN,IEIRL,ILISR,ININD,IOIOT,IQIRQ,IRIRN,ISISL,ITITA,JMJAM,JOJOR,JPJPN,KEKEN,KGKGZ,KHKHM,KIKIR,KMCOM,KNKNA,KPPRK,KRKOR,KWKWT,KYCYM,KZKAZ,LALAO,LBLBN,LCLCA,LILIE,LKLKA,LRLBR,LSLSO,LTLTU,LULUX,LVLVA,LYLBY,MAMAR,MCMCO,MDMDA,MGMDG,MHMHL,MKMKD,MLMLI,MMMMR,MNMNG,MOMAC,MPMNP,MQMTQ,MRMRT,MSMSR,MTMLT,MUMUS,MVMDV,MWMWI,MXMEX,MYMYS,MZMOZ,NANAM,NCNCL,NENER,NFNFK,NGNGA,NINIC,NLNLD,NONOR,NPNPL,NRNRU,NUNIU,NZNZL,OMOMN,PAPAN,PEPER,PFPYF,PGPNG,PHPHL,PKPAK,PLPOL,PMSPM,PNPCN,PRPRI,PTPRT,PWPLW,PYPRY,QAQAT,REREU,ROROM,RURUS,RWRWA,SASAU,SBSLB,SCSYC,SDSDN,SESWE,SGSGP,SHSHN,SISVN,SJSJM,SKSVK,SLSLE,SMSMR,SNSEN,SOSOM,SRSUR,STSTP,SVSLV,SYSYR,SZSWZ,TCTCA,TDTCD,TFATF,TGTGO,THTHA,TJTJK,TKTKL,TMTKM,TNTUN,TOTON,TPTMP,TRTUR,TTTTO,TVTUV,TWTWN,TZTZA,UAUKR,UGUGA,UMUMI,USUSA,UYURY,UZUZB,VAVAT,VCVCT,VEVEN,VGVGB,VIVIR,VNVNM,VUVUT,WFWLF,WSWSM,YEYEM,YTMYT,YUYUG,ZAZAF,ZMZMB,ZRZAR,ZWZWE";
    private static Hashtable ctry2LangMapping;
    private static final String compressedCtry2LangMapping = "ADfresAEarenAFpsAGenAIrnALsqAMhyruANnlenAOptAResASensmATdeAUenAWnlenAZazhyruBAsrshhrslmksqBBenBDbnhibhenBEfrnldeBFfrBGbgtrBHarenBIrnfrswBJfrBMenBNmsenzhBOesayquBRptBSenBTdzenneBVnoBWentnBYberuBZenesCAenfrCCenCFfrsgCGfrCHfrdeitrmCIfrCKmienCLesCMenfrCNzhboCOesCResCUesCVptCXenCYeltrenCZcsskDEdeDJarfrsoDKdaDMenfrDOesDZarfrECesquEEetruEGarenfrEHarfritERamtiarenitESeseucaglETamarenFIfisvFJenfjhiFKenFMenFOfodaFRfreubrcoFXfrGAfrGBengdcyGDenfrGEkahyruGFfrGHenGIenesGLdaikklGMenwoGNfrGPfrenGQesGRelGTesGUenGWptGYenhiurHKzhenHNesHRhrHTfrHUhuIDinennlIEengaILiwarjiINhienguknksmlmrneorpasatateIOenIQarkutkIRfaarkuISisITitfrdeJMenJOarJPjaKEenswKGkyKHkmKIenKMfrarKNenKPkoKRkoKWarenKYenKZkkruLAlofrLBarenfrLCenfrLIdeLKtasienLRenLSstenLTltruplLUfrdeLVlvltruLYarenitMAarfresMCfrenitMDmorobgMGmgenfrMKmkshtrMLfrMMmyMNmnruMOzhptMQfrMRarfrMSenMTmtenitMUenfrhiMWenMXesMYmsenMZptNAenafdeNEfrhaNFenNGenhayoNIesNLnlfyNOnoNPneNRnaenNUenNZenmiOMarenPAesenPEesquayPFfrPGenPHentlesPKurenpspasdPLplPMfrenPNenPResenPTptPWenPYesgnQAarenREfrtaROrohuRUruRWenfrrwSAarSBenSCenfrSDarsuSEsvSGzhenmstaSHenSIslSJnoSKskhuplshSLenSMitSNfrSOarenitsoSRnleneshiSTptSVesSYarSZenssTCenTDfrarTFfrTGfrTHthTJtgruuzTKenmiTMtkruTNarTOentoTRtrkuTTenTVenTWzhTZenswUAukruUGenswUMenUSenesUYesUZuzruVAlaitVCenVEesVGenVIenVNvizhfrVUenfrbiWFfrWSensmYEarYTfrmgswYUsrshmkhuZAafenZMenZRfrswZWensn";

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("user.language", "EN"));
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.region", ""));
        String string3 = "";
        int n = string2.indexOf(95);
        if (n >= 0) {
            string3 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        }
        defaultLocale = new Locale(string, string2, string3);
        isoLanguages = null;
        isoCountries = null;
        ctry2LangMapping = null;
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string, String string2, String string3) {
        this.language = this.convertOldISOCodes(string);
        this.country = this.toUpperCase(string2).intern();
        this.variant = this.toUpperCase(string3).intern();
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static String[] composeList(MessageFormat messageFormat, String[] stringArray) {
        if (stringArray.length <= 3) {
            return stringArray;
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        String string = messageFormat.format(stringArray2);
        String[] stringArray3 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 2, stringArray3, 1, stringArray3.length - 1);
        stringArray3[0] = string;
        return Locale.composeList(messageFormat, stringArray3);
    }

    private String convertOldISOCodes(String string) {
        if ((string = this.toLowerCase(string).intern()) == "he") {
            return "iw";
        }
        if (string == "yi") {
            return "ji";
        }
        if (string == "id") {
            return "in";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        Locale locale = (Locale)object;
        if (this.language != locale.language) {
            return false;
        }
        if (this.country != locale.country) {
            return false;
        }
        return this.variant == locale.variant;
    }

    private String findStringMatch(String[][] stringArray, String string, String string2) {
        int n;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2][0])) {
                return stringArray[n2][1];
            }
            ++n2;
        }
        if (!string2.equals(string)) {
            n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        if (!"EN".equals(string) && "EN".equals(string2)) {
            n = 0;
            while (n < stringArray.length) {
                if ("EN".equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        return "";
    }

    private static String formatList(String[] stringArray, String[] stringArray2) {
        Object object;
        if (stringArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray2.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray2[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
        if (stringArray2.length > 3) {
            object = new MessageFormat(stringArray[2]);
            stringArray2 = Locale.composeList((MessageFormat)object, stringArray2);
        }
        object = new Object[stringArray2.length + 1];
        System.arraycopy(stringArray2, 0, object, 1, stringArray2.length);
        object[0] = new Integer(stringArray2.length);
        MessageFormat messageFormat = new MessageFormat(stringArray[1]);
        return messageFormat.format(object);
    }

    public static Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("LocaleString");
    }

    public String getCountry() {
        return this.country;
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        String string = this.country;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (locale2.variant.length() == 0) {
            n = 1;
        }
        if (locale2.country.length() == 0) {
            n = 2;
        }
        while (!bl) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Countries"), string, string);
                if (string2.length() != 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) continue;
            switch (n) {
                case 0: {
                    locale2.variant = "";
                    break;
                }
                case 1: {
                    locale2.country = "";
                    break;
                }
                case 2: {
                    locale2 = Locale.getDefault();
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n;
        }
        return string2;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        String string = this.language;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (locale2.variant.length() == 0) {
            n = 1;
        }
        if (locale2.country.length() == 0) {
            n = 2;
        }
        while (!bl) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Languages"), string, string);
                if (string2.length() != 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) continue;
            switch (n) {
                case 0: {
                    locale2.variant = "";
                    break;
                }
                case 1: {
                    locale2.country = "";
                    break;
                }
                case 2: {
                    locale2 = Locale.getDefault();
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n;
        }
        return string2;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        String[] stringArray;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayCountry(locale);
        String[] stringArray2 = this.getDisplayVariantArray(resourceBundle);
        try {
            stringArray = (String[])resourceBundle.getObject("LocaleNamePatterns");
        }
        catch (MissingResourceException missingResourceException) {
            stringArray = null;
        }
        String string3 = null;
        String[] stringArray3 = null;
        if (string.length() != 0) {
            string3 = string;
            if (string2.length() != 0) {
                stringArray3 = new String[stringArray2.length + 1];
                System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
                stringArray3[0] = string2;
            } else {
                stringArray3 = stringArray2;
            }
        } else if (string2.length() != 0) {
            string3 = string2;
            stringArray3 = stringArray2;
        } else {
            return Locale.formatList(stringArray, stringArray2);
        }
        Object[] objectArray = new Object[]{new Integer(stringArray3.length != 0 ? 2 : 1), string3, stringArray3.length != 0 ? Locale.formatList(stringArray, stringArray3) : null};
        if (stringArray != null) {
            return new MessageFormat(stringArray[0]).format(objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)objectArray[1]);
        if (objectArray.length > 2) {
            stringBuffer.append(" (");
            stringBuffer.append((String)objectArray[2]);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        String[] stringArray;
        if (this.variant.length() == 0) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String[] stringArray2 = this.getDisplayVariantArray(resourceBundle);
        try {
            stringArray = (String[])resourceBundle.getObject("LocaleNamePatterns");
        }
        catch (MissingResourceException missingResourceException) {
            stringArray = null;
        }
        return Locale.formatList(stringArray, stringArray2);
    }

    private String[] getDisplayVariantArray(ResourceBundle resourceBundle) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.variant, "_");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringTokenizer.nextToken();
            try {
                stringArray[n] = (String)resourceBundle.getObject("%%" + string);
            }
            catch (MissingResourceException missingResourceException) {
                stringArray[n] = string;
            }
            ++n;
        }
        return stringArray;
    }

    public String getISO3Country() throws MissingResourceException {
        int n = this.country.length();
        if (n == 0) {
            return "";
        }
        int n2 = compressedIsoCountries.indexOf("," + this.country);
        if (n2 == -1 || n != 2) {
            throw new MissingResourceException("Couldn't find 3-letter country code for " + this.country, "LocaleElements_" + this.toString(), "ShortCountry");
        }
        return compressedIsoCountries.substring(n2 + 3, n2 + 6);
    }

    public String getISO3Language() throws MissingResourceException {
        int n = this.language.length();
        if (n == 0) {
            return "";
        }
        int n2 = compressedIsoLanguages.indexOf("," + this.language);
        if (n2 == -1 || n != 2) {
            throw new MissingResourceException("Couldn't find 3-letter language code for " + this.language, "LocaleElements_" + this.toString(), "ShortLanguage");
        }
        return compressedIsoLanguages.substring(n2 + 3, n2 + 6);
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = new String[compressedIsoCountries.length() / 6];
            int n = 0;
            while (n < isoCountries.length) {
                Locale.isoCountries[n] = compressedIsoCountries.substring(n * 6 + 1, n * 6 + 3);
                ++n;
            }
        }
        String[] stringArray = new String[isoCountries.length];
        System.arraycopy(isoCountries, 0, stringArray, 0, isoCountries.length);
        return stringArray;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = new String[compressedIsoLanguages.length() / 6];
            int n = 0;
            while (n < isoLanguages.length) {
                Locale.isoLanguages[n] = compressedIsoLanguages.substring(n * 6 + 1, n * 6 + 3);
                ++n;
            }
        }
        String[] stringArray = new String[isoLanguages.length];
        System.arraycopy(isoLanguages, 0, stringArray, 0, isoLanguages.length);
        return stringArray;
    }

    public String getLanguage() {
        return this.language;
    }

    static String[] getLanguagesForCountry(String string) {
        String[] stringArray;
        if (ctry2LangMapping == null) {
            ctry2LangMapping = new Hashtable();
            int n = 0;
            while (n < compressedCtry2LangMapping.length()) {
                String string2 = compressedCtry2LangMapping.substring(n, n + 2);
                int n2 = n += 2;
                while (n2 < compressedCtry2LangMapping.length()) {
                    if (Character.isUpperCase(compressedCtry2LangMapping.charAt(n2))) break;
                    n2 += 2;
                }
                String string3 = compressedCtry2LangMapping.substring(n, n2);
                String[] stringArray2 = new String[string3.length() / 2];
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    stringArray2[n3] = string3.substring(n3 * 2, n3 * 2 + 2);
                    ++n3;
                }
                ctry2LangMapping.put(string2, stringArray2);
                n = n2;
            }
        }
        if ((stringArray = (String[])ctry2LangMapping.get(string)) == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getVariant() {
        return this.variant;
    }

    public int hashCode() {
        return this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hashcode = -1;
        this.language = this.convertOldISOCodes(this.language);
        this.country = this.country.intern();
        this.variant = this.variant.intern();
    }

    public static synchronized void setDefault(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Can't set default locale to NULL");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.language", "write"));
        }
        defaultLocale = locale;
    }

    private String toLowerCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toLowerCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    public final String toString() {
        boolean bl = this.language.length() != 0;
        boolean bl2 = this.country.length() != 0;
        boolean bl3 = this.variant.length() != 0;
        StringBuffer stringBuffer = new StringBuffer(this.language);
        if (bl2 || bl && bl3) {
            stringBuffer.append('_').append(this.country);
        }
        if (bl3 && (bl || bl2)) {
            stringBuffer.append('_').append(this.variant);
        }
        return stringBuffer.toString();
    }

    private String toUpperCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toUpperCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.hashcode;
        this.hashcode = -1;
        objectOutputStream.defaultWriteObject();
        this.hashcode = n;
    }
}

