/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition;
    private int newPosition;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private int cacheOne;
    private int cacheTwo;
    private int cacheThree;
    private char maxDelimChar;

    public StringTokenizer(String string) {
        this(string, " \t\n\r\f", false);
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public StringTokenizer(String string, String string2, boolean bl) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimiters = string2;
        this.retDelims = bl;
        this.setMaxDelimChar();
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.currentPosition;
        while (n2 < this.maxPosition) {
            if ((n2 = this.skipDelimiters(n2)) >= this.maxPosition) break;
            n2 = this.scanToken(n2);
            ++n;
        }
        return n;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        this.currentPosition = this.newPosition > 0 ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.newPosition = 0;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(n, this.currentPosition);
    }

    public String nextToken(String string) {
        if (string != this.delimiters) {
            this.delimiters = string;
            this.newPosition = 0;
            this.setMaxDelimChar();
        }
        return this.nextToken();
    }

    private int scanToken(int n) {
        int n2 = this.cacheOne;
        int n3 = this.cacheTwo;
        int n4 = this.cacheThree;
        int n5 = this.maxPosition;
        char c = this.maxDelimChar;
        int n6 = n;
        while (n6 < n5) {
            char c2 = this.str.charAt(n6);
            if (c2 > c) {
                ++n6;
                continue;
            }
            if (c2 >= '`' && c2 <= '\u007f') {
                if ((n2 & '\u0001' << c2) != 0) break;
                ++n6;
                continue;
            }
            if (c2 >= ' ' && c2 <= '?') {
                if ((n3 & '\u0001' << c2) != 0) break;
                ++n6;
                continue;
            }
            if (c2 >= '@' && c2 <= '_') {
                if ((n4 & '\u0001' << c2) != 0) break;
                ++n6;
                continue;
            }
            if (this.delimiters.indexOf(c2) >= 0) break;
            ++n6;
        }
        if (n6 < n5 && this.retDelims && n == n6) {
            ++n6;
        }
        return n6;
    }

    private void setMaxDelimChar() {
        String string = this.delimiters;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        char c = '\u0000';
        if (string != null) {
            int n4 = string.length() - 1;
            while (n4 >= 0) {
                char c2;
                if ((c2 = string.charAt(n4--)) >= '`' && c2 <= '\u007f') {
                    n |= '\u0001' << c2;
                } else if (c2 >= ' ' && c2 <= '?') {
                    n2 |= '\u0001' << c2;
                } else if (c2 >= '@' && c2 <= '_') {
                    n3 |= '\u0001' << c2;
                }
                if (c >= c2) continue;
                c = c2;
            }
        }
        this.cacheOne = n;
        this.cacheTwo = n2;
        this.cacheThree = n3;
        this.maxDelimChar = c;
    }

    private int skipDelimiters(int n) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        if (this.retDelims) {
            return n2;
        }
        int n3 = this.cacheOne;
        int n4 = this.cacheTwo;
        int n5 = this.cacheThree;
        int n6 = this.maxPosition;
        char c = this.maxDelimChar;
        while (n2 < n6) {
            char c2 = this.str.charAt(n2);
            if (c2 > c) break;
            if (c2 >= '`' && c2 <= '\u007f') {
                if ((n3 & '\u0001' << c2) == 0) break;
                ++n2;
                continue;
            }
            if (c2 >= ' ' && c2 <= '?') {
                if ((n4 & '\u0001' << c2) == 0) break;
                ++n2;
                continue;
            }
            if (c2 >= '@' && c2 <= '_') {
                if ((n5 & '\u0001' << c2) == 0) break;
                ++n2;
                continue;
            }
            if (this.delimiters.indexOf(c2) < 0) break;
            ++n2;
        }
        return n2;
    }
}

