/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZoneData;
import sun.security.action.GetPropertyAction;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final long serialVersionUID = 3581463369166924961L;
    private String ID;
    private static TimeZone defaultZone = null;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;
    private static final String CUSTOM_ID = "Custom";
    private static NumberFormat numberFormat = null;
    private static final TimeZone GMT = new SimpleTimeZone(0, "GMT");
    static /* synthetic */ Class class$java$util$TimeZoneData;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static synchronized String[] getAvailableIDs() {
        String[] stringArray = new String[TimeZoneData.zones.length];
        int n = 0;
        while (n < TimeZoneData.zones.length) {
            stringArray[n] = TimeZoneData.zones[n].getID();
            ++n;
        }
        return stringArray;
    }

    public static synchronized String[] getAvailableIDs(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < TimeZoneData.zones.length && TimeZoneData.zones[n2].getRawOffset() < n) {
            ++n2;
        }
        int n4 = n2;
        while (n4 < TimeZoneData.zones.length && TimeZoneData.zones[n4].getRawOffset() == n) {
            ++n4;
        }
        String[] stringArray = new String[n4 - n2];
        while (n2 < n4) {
            stringArray[n3++] = TimeZoneData.zones[n2++].getID();
        }
        return stringArray;
    }

    public static synchronized TimeZone getDefault() {
        if (defaultZone == null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("user.timezone"));
            if (string == null || string.equals("")) {
                String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.region"));
                String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
                string = TimeZone.getSystemTimeZoneID(string3, string2);
                if (string == null) {
                    string = GMT_ID;
                }
                final String string4 = string;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.setProperty("user.timezone", string4);
                        return null;
                    }
                });
            }
            defaultZone = TimeZone.getTimeZone(string);
        }
        return (TimeZone)defaultZone.clone();
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl, int n) {
        return this.getDisplayName(bl, n, Locale.getDefault());
    }

    public String getDisplayName(boolean bl, int n, Locale locale) {
        SimpleTimeZone simpleTimeZone;
        SimpleDateFormat simpleDateFormat;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal style: " + n);
        }
        SoftReference softReference = (SoftReference)cachedLocaleData.get(locale);
        if (softReference == null || (simpleDateFormat = (SimpleDateFormat)softReference.get()) == null) {
            simpleDateFormat = new SimpleDateFormat(null, locale);
            cachedLocaleData.put(locale, new SoftReference(simpleDateFormat));
        }
        if (bl && this.useDaylightTime()) {
            int n2 = 3600000;
            try {
                n2 = ((SimpleTimeZone)this).getDSTSavings();
            }
            catch (ClassCastException classCastException) {}
            simpleTimeZone = new SimpleTimeZone(this.getRawOffset(), this.getID(), 0, 1, 0, 0, 1, 1, 0, 0, n2);
        } else {
            simpleTimeZone = new SimpleTimeZone(this.getRawOffset(), this.getID());
        }
        simpleDateFormat.applyPattern(n == 1 ? "zzzz" : "z");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        return simpleDateFormat.format(new Date(864000000L));
    }

    public String getID() {
        return this.ID;
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    int getOffset(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.getOffset(n, n2, n3, n4, n5, n6);
    }

    public abstract int getRawOffset();

    private static native String getSystemTimeZoneID(String var0, String var1);

    public static synchronized TimeZone getTimeZone(String string) {
        TimeZone timeZone = TimeZoneData.get(string);
        if (timeZone == null) {
            timeZone = TimeZone.parseCustomTimeZone(string);
        }
        if (timeZone == null) {
            timeZone = (TimeZone)GMT.clone();
        }
        return timeZone;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone != null && this.getRawOffset() == timeZone.getRawOffset() && this.useDaylightTime() == timeZone.useDaylightTime();
    }

    public abstract boolean inDaylightTime(Date var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final SimpleTimeZone parseCustomTimeZone(String string) {
        if (string.length() <= 3) return null;
        if (!string.regionMatches(true, 0, GMT_ID, 0, 3)) return null;
        ParsePosition parsePosition = new ParsePosition(3);
        boolean bl = false;
        if (string.charAt(parsePosition.getIndex()) == '-') {
            bl = true;
        } else if (string.charAt(parsePosition.getIndex()) != '+') {
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        Serializable serializable = class$java$util$TimeZoneData != null ? class$java$util$TimeZoneData : (class$java$util$TimeZoneData = TimeZone.class$("java.util.TimeZoneData"));
        synchronized (serializable) {
            if (numberFormat == null) {
                numberFormat = NumberFormat.getInstance();
                numberFormat.setParseIntegerOnly(true);
            }
        }
        NumberFormat numberFormat = TimeZone.numberFormat;
        synchronized (numberFormat) {
            int n = parsePosition.getIndex();
            Number number = TimeZone.numberFormat.parse(string, parsePosition);
            if (number == null) {
                return null;
            }
            int n2 = number.intValue();
            if (parsePosition.getIndex() < string.length() && string.charAt(parsePosition.getIndex()) == ':') {
                n2 *= 60;
                parsePosition.setIndex(parsePosition.getIndex() + 1);
                number = TimeZone.numberFormat.parse(string, parsePosition);
                if (number == null) {
                    return null;
                }
                n2 += number.intValue();
            } else {
                n2 = n2 < 30 && parsePosition.getIndex() - n <= 2 ? (n2 *= 60) : n2 % 100 + n2 / 100 * 60;
            }
            if (!bl) return new SimpleTimeZone(n2 * 60000, CUSTOM_ID);
            n2 = -n2;
            return new SimpleTimeZone(n2 * 60000, CUSTOM_ID);
        }
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultZone = timeZone;
    }

    public void setID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
    }

    public abstract void setRawOffset(int var1);

    public abstract boolean useDaylightTime();
}

