/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Vector
extends AbstractList
implements List,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public Vector() {
        this(10);
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(Collection collection) {
        this.elementCount = collection.size();
        this.elementData = new Object[this.elementCount * 110 / 100];
        collection.toArray(this.elementData);
    }

    public void add(int n, Object object) {
        this.insertElementAt(object, n);
    }

    public synchronized boolean add(Object object) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
        return true;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        ++this.modCount;
        if (n < 0 || n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = collection.size();
        this.ensureCapacityHelper(this.elementCount + n2);
        int n3 = this.elementCount - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        Iterator iterator = collection.iterator();
        int n4 = 0;
        while (n4 < n2) {
            this.elementData[n++] = iterator.next();
            ++n4;
        }
        this.elementCount += n2;
        return n2 != 0;
    }

    public synchronized boolean addAll(Collection collection) {
        ++this.modCount;
        int n = collection.size();
        this.ensureCapacityHelper(this.elementCount + n);
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (n2 < n) {
            this.elementData[this.elementCount++] = iterator.next();
            ++n2;
        }
        return n != 0;
    }

    public synchronized void addElement(Object object) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            vector.modCount = 0;
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public synchronized boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        return this.elementData[n];
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < Vector.this.elementCount;
            }

            public Object nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.count < Vector.this.elementCount) {
                        Object object = Vector.this.elementData[this.count++];
                        Object var3_3 = null;
                        return object;
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public synchronized void ensureCapacity(int n) {
        ++this.modCount;
        this.ensureCapacityHelper(n);
    }

    private void ensureCapacityHelper(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            Object[] objectArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public synchronized Object get(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.elementData[n];
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        int n2 = this.elementCount;
        Object[] objectArray = this.elementData;
        if (object == null) {
            int n3 = n;
            while (n3 < n2) {
                if (objectArray[n3] == null) {
                    return n3;
                }
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n2) {
                if (object.equals(objectArray[n4])) {
                    return n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(Object object, int n) {
        ++this.modCount;
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        if (object == null) {
            int n2 = n;
            while (n2 >= 0) {
                if (this.elementData[n2] == null) {
                    return n2;
                }
                --n2;
            }
        } else {
            int n3 = n;
            while (n3 >= 0) {
                if (object.equals(this.elementData[n3])) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    public synchronized Object remove(int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object object = this.elementData[n];
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.elementCount] = null;
        return object;
    }

    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    public synchronized boolean removeAll(Collection collection) {
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        int n = this.elementCount;
        Object[] objectArray = this.elementData;
        ++this.modCount;
        while (n > 0) {
            objectArray[--n] = null;
        }
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object object) {
        ++this.modCount;
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public synchronized void removeElementAt(int n) {
        ++this.modCount;
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.elementCount - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.elementCount - (n2 - n);
        while (this.elementCount != n4) {
            this.elementData[--this.elementCount] = null;
        }
    }

    public synchronized boolean retainAll(Collection collection) {
        return super.retainAll(collection);
    }

    public synchronized Object set(int n, Object object) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public synchronized void setElementAt(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.elementCount);
        }
        this.elementData[n] = object;
    }

    public synchronized void setSize(int n) {
        ++this.modCount;
        if (n > this.elementCount) {
            this.ensureCapacityHelper(n);
        } else {
            int n2 = n;
            while (n2 < this.elementCount) {
                this.elementData[n2] = null;
                ++n2;
            }
        }
        this.elementCount = n;
    }

    public int size() {
        return this.elementCount;
    }

    public List subList(int n, int n2) {
        return Collections.synchronizedList(super.subList(n, n2), this);
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        if (objectArray.length > this.elementCount) {
            objectArray[this.elementCount] = null;
        }
        return objectArray;
    }

    public synchronized String toString() {
        return super.toString();
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }
}

