/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.security.AccessController;
import java.util.zip.Checksum;
import sun.security.action.LoadLibraryAction;

public class CRC32
implements Checksum {
    private int crc;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = 0;
    }

    public void update(int n) {
        this.crc = CRC32.update(this.crc, n);
    }

    private static native int update(int var0, int var1);

    public void update(byte[] byArray) {
        this.crc = CRC32.updateBytes(this.crc, byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.crc = CRC32.updateBytes(this.crc, byArray, n, n2);
    }

    private static native int updateBytes(int var0, byte[] var1, int var2, int var3);
}

