/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private boolean closed = false;
    private boolean reachEOF = false;

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater());
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        if (inputStream == null || inflater == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.inf = inflater;
        this.buf = new byte[n];
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    public void close() throws IOException {
        this.inf.end();
        this.in.close();
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    protected void fill() throws IOException {
        this.ensureOpen();
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public int read() throws IOException {
        this.ensureOpen();
        byte[] byArray = new byte[1];
        return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3;
            while ((n3 = this.inf.inflate(byArray, n, n2)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    this.reachEOF = true;
                    return -1;
                }
                if (!this.inf.needsInput()) continue;
                this.fill();
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            throw new ZipException(string != null ? string : "Invalid ZLIB data format");
        }
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int n = (int)Math.min(l, Integer.MAX_VALUE);
        int n2 = 0;
        byte[] byArray = new byte[512];
        while (n2 < n) {
            int n3 = n - n2;
            if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            if ((n3 = this.read(byArray, 0, n3)) == -1) {
                this.reachEOF = true;
                break;
            }
            n2 += n3;
        }
        return n2;
    }
}

