/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import sun.awt.AppContext;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private Document model;
    private transient Caret caret;
    private transient Highlighter highlighter;
    private transient Keymap keymap;
    private transient MutableCaretEvent caretEvent;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private Color disabledTextColor;
    private boolean editable;
    private Insets margin;
    private char focusAccelerator;
    private boolean canAccessSystemClipboard = true;
    private static Object SandboxClipboardKey = new Object();
    private static ClipboardOwner defaultClipboardOwner = new ClipboardObserver();
    private static Hashtable keymapTable = null;
    private JTextComponent editor;
    private static JTextComponent focusedComponent;
    private InputMethodRequests inputMethodRequestsHandler;
    private AttributedString composedText;
    private String composedTextContent;
    private Position composedTextStart;
    private Position composedTextEnd;
    private ComposedTextCaret composedTextCaret;
    private transient Caret originalCaret;
    private boolean needToSendKeyTypedEvent;
    public static final String DEFAULT_KEYMAP = "default";
    static /* synthetic */ Class class$javax$swing$event$CaretListener;

    public JTextComponent() {
        this.canAccessSystemClipboard();
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        this.needToSendKeyTypedEvent = !this.isProcessInputMethodEventOverridden();
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
        this.setEditable(true);
        this.setLayout(null);
        this.updateUI();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        this.invalidate();
    }

    public void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CaretListener == null ? JTextComponent.class$("javax.swing.event.CaretListener") : class$javax$swing$event$CaretListener)) {
                ((CaretListener)objectArray[n + 1]).caretUpdate(caretEvent);
            }
            n -= 2;
        }
    }

    public void setDocument(Document document) {
        if (this.accessibleContext != null) {
            this.model.removeDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
        Document document2 = this.model;
        this.model = document;
        this.firePropertyChange("document", document2, document);
        this.revalidate();
        this.repaint();
        if (this.accessibleContext != null) {
            this.model.addDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
    }

    public Document getDocument() {
        return this.model;
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.invalidate();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.removeChangeListener(this.caretEvent);
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
            this.caret.addChangeListener(this.caretEvent);
        }
        this.firePropertyChange("caret", caret2, this.caret);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public void setKeymap(Keymap keymap) {
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, this.keymap);
        this.updateInputMap(keymap2, keymap);
    }

    void updateInputMap(Keymap keymap, Keymap keymap2) {
        Serializable serializable;
        InputMap inputMap;
        InputMap inputMap2 = inputMap = this.getInputMap(0);
        while (inputMap != null && !(inputMap instanceof KeymapWrapper)) {
            inputMap2 = inputMap;
            inputMap = inputMap.getParent();
        }
        if (inputMap != null) {
            if (keymap2 == null) {
                if (inputMap2 != inputMap) {
                    inputMap2.setParent(inputMap.getParent());
                } else {
                    inputMap2.setParent(null);
                }
            } else {
                serializable = new KeymapWrapper(keymap2);
                inputMap2.setParent((InputMap)serializable);
                if (inputMap2 != inputMap) {
                    ((InputMap)serializable).setParent(inputMap.getParent());
                }
            }
        } else if (keymap2 != null && (inputMap = this.getInputMap(0)) != null) {
            serializable = new KeymapWrapper(keymap2);
            ((InputMap)serializable).setParent(inputMap.getParent());
            inputMap.setParent((InputMap)serializable);
        }
        serializable = this.getActionMap();
        ActionMap actionMap = serializable;
        while (serializable != null && !(serializable instanceof KeymapActionMap)) {
            actionMap = serializable;
            serializable = ((ActionMap)serializable).getParent();
        }
        if (serializable != null) {
            if (keymap2 == null) {
                if (actionMap != serializable) {
                    actionMap.setParent(((ActionMap)serializable).getParent());
                } else {
                    actionMap.setParent(null);
                }
            } else {
                KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
                actionMap.setParent(keymapActionMap);
                if (actionMap != serializable) {
                    keymapActionMap.setParent(((ActionMap)serializable).getParent());
                }
            }
        } else if (keymap2 != null && (serializable = this.getActionMap()) != null) {
            KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
            keymapActionMap.setParent(((ActionMap)serializable).getParent());
            ((ActionMap)serializable).setParent(keymapActionMap);
        }
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string, keymap);
        if (string != null) {
            keymapTable.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    public static Keymap removeKeymap(String string) {
        return (Keymap)keymapTable.remove(string);
    }

    public static Keymap getKeymap(String string) {
        return (Keymap)keymapTable.get(string);
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Object object;
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            object = (String)action.getValue("Name");
            hashtable.put(object != null ? object : "", action);
            ++n;
        }
        int n2 = 0;
        while (n2 < keyBindingArray.length) {
            object = (Action)hashtable.get(keyBindingArray[n2].actionName);
            if (object != null) {
                keymap.addActionForKeyStroke(keyBindingArray[n2].key, (Action)object);
            }
            ++n2;
        }
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, this.caretColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, this.selectionColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, this.selectedTextColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, this.disabledTextColor);
    }

    public void replaceSelection(String string) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                int n = Math.min(this.caret.getDot(), this.caret.getMark());
                int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (n != n2) {
                    document.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
            }
        }
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.getDocument().getText(n, n2);
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        return this.getUI().modelToView(this, n);
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(this, point);
    }

    public void cut() {
        Clipboard clipboard;
        if (this.isEditable() && this.isEnabled() && (clipboard = this.getClipboard()) != null) {
            try {
                int n = Math.min(this.caret.getDot(), this.caret.getMark());
                int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (n != n2) {
                    Document document = this.getDocument();
                    String string = document.getText(n, n2 - n);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, defaultClipboardOwner);
                    document.remove(n, n2 - n);
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.getToolkit().beep();
        }
    }

    public void copy() {
        Clipboard clipboard = this.getClipboard();
        if (clipboard != null) {
            try {
                int n = Math.min(this.caret.getDot(), this.caret.getMark());
                int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (n != n2) {
                    Document document = this.getDocument();
                    String string = document.getText(n, n2 - n);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, defaultClipboardOwner);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void paste() {
        Clipboard clipboard;
        if (this.isEditable() && this.isEnabled() && (clipboard = this.getClipboard()) != null) {
            Transferable transferable = clipboard.getContents(this);
            if (transferable != null) {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.replaceSelection(string);
                }
                catch (Exception exception) {
                    this.getToolkit().beep();
                }
            } else {
                this.getToolkit().beep();
            }
        }
    }

    public void moveCaretPosition(int n) {
        this.caret.moveDot(n);
    }

    public void setFocusAccelerator(char c) {
        c = Character.toUpperCase(c);
        char c2 = this.focusAccelerator;
        this.focusAccelerator = c;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c2, this.focusAccelerator);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public void read(Reader reader, Object object) throws IOException {
        EditorKit editorKit = this.getUI().getEditorKit(this);
        Document document = editorKit.createDefaultDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            editorKit.read(reader, document, 0);
            this.setDocument(document);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        Document document = this.getDocument();
        try {
            this.getUI().getEditorKit(this).write(writer, document, 0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    public void setCaretPosition(int n) {
        Document document = this.getDocument();
        if (document != null) {
            if (n > document.getLength() || n < 0) {
                throw new IllegalArgumentException("bad position: " + n);
            }
            this.caret.setDot(n);
        }
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            this.getToolkit().beep();
        }
    }

    public String getText() {
        String string;
        Document document = this.getDocument();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    public String getSelectedText() {
        int n;
        String string = null;
        int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
        if (n2 != (n = Math.max(this.caret.getDot(), this.caret.getMark()))) {
            try {
                Document document = this.getDocument();
                string = document.getText(n2, n - n2);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
        return string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (bl != this.editable) {
            boolean bl2 = this.editable;
            this.editable = bl;
            if (this.editable) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.firePropertyChange("editable", new Boolean(bl2), new Boolean(this.editable));
            this.repaint();
        }
    }

    public int getSelectionStart() {
        int n = Math.min(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    public void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        int n = Math.max(this.caret.getDot(), this.caret.getMark());
        return n;
    }

    public void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public void select(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.getDocument().getLength()) {
            n2 = this.getDocument().getLength();
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n > n2) {
            n = n2;
        }
        this.setCaretPosition(n);
        this.moveCaretPosition(n2);
    }

    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(document.getLength());
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private Clipboard getClipboard() {
        if (this.canAccessSystemClipboard()) {
            return this.getToolkit().getSystemClipboard();
        }
        Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
        if (clipboard == null) {
            clipboard = new Clipboard("Sandboxed Text Component Clipboard");
            AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
        }
        return clipboard;
    }

    private boolean canAccessSystemClipboard() {
        if (this.canAccessSystemClipboard) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSystemClipboardAccess();
                    return true;
                }
                catch (SecurityException securityException) {
                    this.canAccessSystemClipboard = false;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextComponent();
        }
        return this.accessibleContext;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
    }

    protected String paramString() {
        String string = this.editable ? "true" : "false";
        String string2 = this.caretColor != null ? this.caretColor.toString() : "";
        String string3 = this.selectionColor != null ? this.selectionColor.toString() : "";
        String string4 = this.selectedTextColor != null ? this.selectedTextColor.toString() : "";
        String string5 = this.disabledTextColor != null ? this.disabledTextColor.toString() : "";
        String string6 = this.margin != null ? this.margin.toString() : "";
        return super.paramString() + ",caretColor=" + string2 + ",disabledTextColor=" + string5 + ",editable=" + string + ",margin=" + string6 + ",selectedTextColor=" + string4 + ",selectionColor=" + string3;
    }

    static final JTextComponent getFocusedComponent() {
        return focusedComponent;
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        super.processInputMethodEvent(inputMethodEvent);
        if (!inputMethodEvent.isConsumed()) {
            if (!this.isEditable()) {
                return;
            }
            switch (inputMethodEvent.getID()) {
                case 1100: {
                    this.replaceInputMethodText(inputMethodEvent);
                }
                case 1101: {
                    this.setInputMethodCaretPosition(inputMethodEvent);
                }
            }
            inputMethodEvent.consume();
        }
    }

    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodRequestsHandler == null) {
            this.inputMethodRequestsHandler = new InputMethodRequestsHandler();
        }
        return this.inputMethodRequestsHandler;
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        super.addInputMethodListener(inputMethodListener);
        if (inputMethodListener != null) {
            this.needToSendKeyTypedEvent = false;
        }
    }

    private void replaceInputMethodText(InputMethodEvent inputMethodEvent) {
        int n = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        Document document = this.getDocument();
        if (this.composedTextStart != null) {
            try {
                int c = this.composedTextStart.getOffset();
                document.remove(c, this.composedTextEnd.getOffset() - c);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.composedTextEnd = null;
            this.composedTextStart = null;
            this.composedText = null;
            this.composedTextContent = null;
        }
        if (attributedCharacterIterator != null) {
            int n2;
            attributedCharacterIterator.first();
            if (n > 0) {
                if (this.needToSendKeyTypedEvent) {
                    char stringBuffer = attributedCharacterIterator.current();
                    while (n > 0) {
                        char simpleAttributeSet;
                        KeyEvent badLocationException = new KeyEvent(this, 400, System.currentTimeMillis(), 0, 0, simpleAttributeSet);
                        this.processKeyEvent(badLocationException);
                        simpleAttributeSet = attributedCharacterIterator.next();
                        --n;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    char c = attributedCharacterIterator.current();
                    while (n > 0) {
                        stringBuffer.append(c);
                        c = attributedCharacterIterator.next();
                        --n;
                    }
                    this.mapCommittedTextToAction(new String(stringBuffer));
                }
            }
            if ((n2 = attributedCharacterIterator.getIndex()) < attributedCharacterIterator.getEndIndex()) {
                this.createComposedString(n2, attributedCharacterIterator);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(StyleConstants.ComposedTextAttribute, this.composedText);
                try {
                    this.replaceSelection(null);
                    document.insertString(this.caret.getDot(), this.composedTextContent, simpleAttributeSet);
                    this.composedTextStart = document.createPosition(this.caret.getDot() - this.composedTextContent.length());
                    this.composedTextEnd = document.createPosition(this.caret.getDot());
                }
                catch (BadLocationException badLocationException) {
                    this.composedTextEnd = null;
                    this.composedTextStart = null;
                    this.composedText = null;
                    this.composedTextContent = null;
                }
            }
        }
    }

    private void createComposedString(int n, AttributedCharacterIterator attributedCharacterIterator) {
        Document document = this.getDocument();
        StringBuffer stringBuffer = new StringBuffer();
        char c = attributedCharacterIterator.setIndex(n);
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.composedTextContent = new String(stringBuffer);
        this.composedText = new AttributedString(attributedCharacterIterator, n, attributedCharacterIterator.getEndIndex());
    }

    private void mapCommittedTextToAction(String string) {
        Keymap keymap = this.getKeymap();
        if (keymap != null) {
            Serializable serializable;
            Action action = null;
            if (string.length() == 1) {
                serializable = KeyStroke.getKeyStroke(string.charAt(0));
                action = keymap.getAction((KeyStroke)serializable);
            }
            if (action == null) {
                action = keymap.getDefaultAction();
            }
            if (action != null) {
                serializable = new ActionEvent(this, 1001, string);
                action.actionPerformed((ActionEvent)serializable);
            }
        }
    }

    private void setInputMethodCaretPosition(InputMethodEvent inputMethodEvent) {
        if (this.composedTextStart != null) {
            TextHitInfo textHitInfo;
            int n = this.composedTextStart.getOffset();
            if (!(this.caret instanceof ComposedTextCaret)) {
                if (this.composedTextCaret == null) {
                    this.composedTextCaret = new ComposedTextCaret();
                }
                this.originalCaret = this.caret;
                this.exchangeCaret(this.originalCaret, this.composedTextCaret);
            }
            if ((textHitInfo = inputMethodEvent.getCaret()) != null) {
                n += textHitInfo.getInsertionIndex();
            }
            this.caret.setDot(n);
        } else if (this.caret instanceof ComposedTextCaret) {
            int n = this.caret.getDot();
            this.exchangeCaret(this.caret, this.originalCaret);
            this.caret.setDot(n);
        }
    }

    private void exchangeCaret(Caret caret, Caret caret2) {
        int n = caret.getBlinkRate();
        this.setCaret(caret2);
        this.caret.setBlinkRate(n);
        this.caret.setVisible(this.hasFocus());
    }

    private boolean isProcessInputMethodEventOverridden() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$java$awt$event$InputMethodEvent;
            static /* synthetic */ Class class$javax$swing$text$JTextComponent;

            public Object run() {
                Class[] classArray = new Class[]{class$java$awt$event$InputMethodEvent == null ? (class$java$awt$event$InputMethodEvent = 4.class$("java.awt.event.InputMethodEvent")) : class$java$awt$event$InputMethodEvent};
                Class clazz = JTextComponent.this.getClass();
                while (clazz != (class$javax$swing$text$JTextComponent == null ? 4.class$("javax.swing.text.JTextComponent") : class$javax$swing$text$JTextComponent)) {
                    try {
                        Method method = clazz.getDeclaredMethod("processInputMethodEvent", classArray);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        clazz = clazz.getSuperclass();
                    }
                }
                return Boolean.FALSE;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            keymapTable = new Hashtable(17);
            Keymap keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class DoSetCaretPosition
    implements Runnable {
        JTextComponent host;
        Position newPos;

        DoSetCaretPosition(JTextComponent jTextComponent2, Position position) {
            this.host = jTextComponent2;
            this.newPos = position;
        }

        public void run() {
            this.host.setCaretPosition(this.newPos.getOffset());
        }
    }

    class ComposedTextCaret
    extends DefaultCaret
    implements Serializable {
        Color bg;

        ComposedTextCaret() {
        }

        public void install(JTextComponent jTextComponent) {
            super.install(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                Element element = styledDocument.getCharacterElement(jTextComponent.composedTextStart.getOffset());
                AttributeSet attributeSet = element.getAttributes();
                this.bg = styledDocument.getBackground(attributeSet);
            }
            if (this.bg == null) {
                this.bg = jTextComponent.getBackground();
            }
        }

        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    Rectangle rectangle = this.component.modelToView(this.getDot());
                    graphics.setXORMode(this.bg);
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                    graphics.setPaintMode();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected void positionCaret(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = this.component;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = jTextComponent.viewToModel(point);
            if (n < jTextComponent.composedTextStart.getOffset() || n > jTextComponent.composedTextEnd.getOffset()) {
                try {
                    Position position = jTextComponent.getDocument().createPosition(n);
                    jTextComponent.getInputContext().endComposition();
                    EventQueue.invokeLater(new DoSetCaretPosition(jTextComponent, position));
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            } else {
                super.positionCaret(mouseEvent);
            }
        }
    }

    class InputMethodRequestsHandler
    implements InputMethodRequests,
    Serializable {
        InputMethodRequestsHandler() {
        }

        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            return new AttributedString("").getIterator();
        }

        public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
            return new AttributedString("").getIterator();
        }

        public int getCommittedTextLength() {
            return 0;
        }

        public int getInsertPositionOffset() {
            return JTextComponent.this.getCaretPosition();
        }

        public TextHitInfo getLocationOffset(int n, int n2) {
            if (JTextComponent.this.composedText == null) {
                return null;
            }
            Point point = JTextComponent.this.getLocationOnScreen();
            point.x = n - point.x;
            point.y = n2 - point.y;
            int n3 = JTextComponent.this.viewToModel(point);
            if (n3 >= JTextComponent.this.composedTextStart.getOffset() && n3 <= JTextComponent.this.composedTextEnd.getOffset()) {
                return TextHitInfo.leading(n3 - JTextComponent.this.composedTextStart.getOffset());
            }
            return null;
        }

        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            Rectangle rectangle;
            try {
                rectangle = JTextComponent.this.modelToView(JTextComponent.this.getCaretPosition());
                if (rectangle != null) {
                    Point point = JTextComponent.this.getLocationOnScreen();
                    rectangle.translate(point.x, point.y);
                }
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            return rectangle;
        }

        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            String string = JTextComponent.this.getSelectedText();
            if (string != null) {
                return new AttributedString(string).getIterator();
            }
            return null;
        }
    }

    static class MutableCaretEvent
    extends CaretEvent
    implements ChangeListener,
    MouseListener,
    FocusListener {
        private boolean dragActive;
        private int dot;
        private int mark;

        MutableCaretEvent(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        final void fire() {
            JTextComponent jTextComponent = (JTextComponent)this.getSource();
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                jTextComponent.fireCaretUpdate(this);
            }
        }

        public final String toString() {
            return "dot=" + this.dot + "," + "mark=" + this.mark;
        }

        public final int getDot() {
            return this.dot;
        }

        public final int getMark() {
            return this.mark;
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (!this.dragActive) {
                this.fire();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            focusedComponent = (JTextComponent)this.getSource();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.dragActive = true;
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.dragActive = false;
            this.fire();
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }
    }

    static class KeymapActionMap
    extends ActionMap {
        private Keymap keymap;

        KeymapActionMap(Keymap keymap) {
            this.keymap = keymap;
        }

        public Object[] keys() {
            boolean bl;
            Object[] objectArray = super.keys();
            Object[] objectArray2 = this.keymap.getBoundActions();
            int n = objectArray == null ? 0 : objectArray.length;
            int n2 = objectArray2 == null ? 0 : objectArray2.length;
            boolean bl2 = bl = this.keymap.getDefaultAction() != null;
            if (bl) {
                ++n2;
            }
            if (n == 0) {
                if (bl) {
                    Object[] objectArray3 = new Object[n2];
                    if (n2 > 1) {
                        System.arraycopy(objectArray2, 0, objectArray3, 0, n2 - 1);
                    }
                    objectArray3[n2 - 1] = KeymapWrapper.DefaultActionKey;
                    return objectArray3;
                }
                return objectArray2;
            }
            if (n2 == 0) {
                return objectArray;
            }
            Object[] objectArray4 = new Object[n + n2];
            System.arraycopy(objectArray, 0, objectArray4, 0, n);
            if (bl) {
                if (n2 > 1) {
                    System.arraycopy(objectArray2, 0, objectArray4, n, n2 - 1);
                }
                objectArray4[n + n2 - 1] = KeymapWrapper.DefaultActionKey;
            } else {
                System.arraycopy(objectArray2, 0, objectArray4, n, n2);
            }
            return objectArray4;
        }

        public int size() {
            int n;
            Action[] actionArray = this.keymap.getBoundActions();
            int n2 = n = actionArray == null ? 0 : actionArray.length;
            if (this.keymap.getDefaultAction() != null) {
                ++n;
            }
            return super.size() + n;
        }

        public Action get(Object object) {
            Action action = super.get(object);
            if (action == null) {
                if (object == KeymapWrapper.DefaultActionKey) {
                    action = this.keymap.getDefaultAction();
                } else if (object instanceof Action) {
                    action = (Action)object;
                }
            }
            return action;
        }
    }

    static class KeymapWrapper
    extends InputMap {
        static final Object DefaultActionKey = new Object();
        private Keymap keymap;

        KeymapWrapper(Keymap keymap) {
            this.keymap = keymap;
        }

        public KeyStroke[] keys() {
            int n;
            KeyStroke[] keyStrokeArray = super.keys();
            KeyStroke[] keyStrokeArray2 = this.keymap.getBoundKeyStrokes();
            int n2 = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            int n3 = n = keyStrokeArray2 == null ? 0 : keyStrokeArray2.length;
            if (n2 == 0) {
                return keyStrokeArray2;
            }
            if (n == 0) {
                return keyStrokeArray;
            }
            KeyStroke[] keyStrokeArray3 = new KeyStroke[n2 + n];
            System.arraycopy(keyStrokeArray, 0, keyStrokeArray3, 0, n2);
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray3, n2, n);
            return keyStrokeArray3;
        }

        public int size() {
            KeyStroke[] keyStrokeArray = this.keymap.getBoundKeyStrokes();
            int n = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            return super.size() + n;
        }

        public Object get(KeyStroke keyStroke) {
            Object object = this.keymap.getAction(keyStroke);
            if (object == null && (object = super.get(keyStroke)) == null && keyStroke.getKeyChar() != '\u0000' && this.keymap.getDefaultAction() != null) {
                object = DefaultActionKey;
            }
            return object;
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable bindings;
        Action defaultAction;

        DefaultKeymap(String string, Keymap keymap) {
            this.nm = string;
            this.parent = keymap;
            this.bindings = new Hashtable();
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public String getName() {
            return this.nm;
        }

        public Action getAction(KeyStroke keyStroke) {
            Action action = (Action)this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.bindings.size()];
            int n = 0;
            Enumeration enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                actionArray[n++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            KeyStroke[] keyStrokeArray;
            if (action == null) {
                return null;
            }
            Object[] objectArray = null;
            Vector vector = null;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray = enumeration.nextElement();
                if (this.bindings.get(keyStrokeArray) != action) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(keyStrokeArray);
            }
            if (this.parent != null && (keyStrokeArray = this.parent.getKeyStrokesForAction(action)) != null) {
                int n = 0;
                int n2 = keyStrokeArray.length - 1;
                while (n2 >= 0) {
                    if (this.isLocallyDefined(keyStrokeArray[n2])) {
                        keyStrokeArray[n2] = null;
                        ++n;
                    }
                    --n2;
                }
                if (n > 0 && n < keyStrokeArray.length) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    int n3 = keyStrokeArray.length - 1;
                    while (n3 >= 0) {
                        if (keyStrokeArray[n3] != null) {
                            vector.addElement(keyStrokeArray[n3]);
                        }
                        --n3;
                    }
                } else if (n == 0) {
                    if (vector == null) {
                        objectArray = keyStrokeArray;
                    } else {
                        objectArray = new KeyStroke[vector.size() + keyStrokeArray.length];
                        vector.copyInto(objectArray);
                        System.arraycopy(keyStrokeArray, 0, objectArray, vector.size(), keyStrokeArray.length);
                        vector = null;
                    }
                }
            }
            if (vector != null) {
                objectArray = new KeyStroke[vector.size()];
                vector.copyInto(objectArray);
            }
            return objectArray;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        public void removeBindings() {
            this.bindings.clear();
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + this.bindings;
        }
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener {
        int caretPos;

        public AccessibleJTextComponent() {
            super(JTextComponent.this);
            Document document = JTextComponent.this.getDocument();
            if (document != null) {
                document.addDocumentListener(this);
            }
            JTextComponent.this.addCaretListener(this);
            this.caretPos = this.getCaretPosition();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = caretEvent.getDot();
            int n2 = caretEvent.getMark();
            if (this.caretPos != n) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretPos), new Integer(n));
                this.caretPos = n;
            }
            if (n2 != n) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Integer n = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n);
            } else {
                Runnable runnable = new Runnable(this, n){
                    private final /* synthetic */ Integer val$pos;
                    private final /* synthetic */ AccessibleJTextComponent this$1;
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n;
                    }

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Integer n = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n);
            } else {
                Runnable runnable = new Runnable(this, n){
                    private final /* synthetic */ Integer val$pos;
                    private final /* synthetic */ AccessibleJTextComponent this$1;
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n;
                    }

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Integer n = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n);
            } else {
                Runnable runnable = new Runnable(this, n){
                    private final /* synthetic */ Integer val$pos;
                    private final /* synthetic */ AccessibleJTextComponent this$1;
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n;
                    }

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JTextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public int getIndexAtPoint(Point point) {
            if (point == null) {
                return -1;
            }
            return JTextComponent.this.viewToModel(point);
        }

        Rectangle getRootEditorRect() {
            Rectangle rectangle = JTextComponent.this.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                rectangle.y = 0;
                rectangle.x = 0;
                Insets insets = JTextComponent.this.getInsets();
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                return rectangle;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Rectangle getCharacterBounds(int n) {
            if (n < 0) return null;
            if (n > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            TextUI textUI = JTextComponent.this.getUI();
            if (textUI == null) {
                return null;
            }
            Rectangle rectangle = null;
            Rectangle rectangle2 = this.getRootEditorRect();
            if (rectangle2 == null) {
                return null;
            }
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                block8: {
                    try {
                        View view = textUI.getRootView(JTextComponent.this);
                        if (view == null) break block8;
                        view.setSize(rectangle2.width, rectangle2.height);
                        Shape shape = view.modelToView(n, Position.Bias.Forward, n + 1, Position.Bias.Backward, rectangle2);
                        rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    }
                    catch (BadLocationException badLocationException) {
                        Object var8_9 = null;
                        if (!(JTextComponent.this.model instanceof AbstractDocument)) return rectangle;
                        ((AbstractDocument)JTextComponent.this.model).readUnlock();
                        return rectangle;
                    }
                }
                Object var8_8 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) return rectangle;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                return rectangle;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                throw throwable;
            }
        }

        public int getCharCount() {
            return JTextComponent.this.model.getLength();
        }

        public int getCaretPosition() {
            return JTextComponent.this.getCaretPosition();
        }

        public AttributeSet getCharacterAttribute(int n) {
            Element element = null;
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                element = JTextComponent.this.model.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n2 = element.getElementIndex(n);
                    element = element.getElement(n2);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (JTextComponent.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                }
                throw throwable;
            }
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
            }
            return element.getAttributes();
        }

        public int getSelectionStart() {
            return JTextComponent.this.getSelectionStart();
        }

        public int getSelectionEnd() {
            return JTextComponent.this.getSelectionEnd();
        }

        public String getSelectedText() {
            return JTextComponent.this.getSelectedText();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getAtIndex(int n, int n2) {
            if (n2 < 0) return null;
            if (n2 >= JTextComponent.this.model.getLength()) {
                return null;
            }
            String string = null;
            String string2 = null;
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                try {
                    switch (n) {
                        case 1: {
                            string = JTextComponent.this.model.getText(n2, 1);
                            break;
                        }
                        case 2: {
                            string2 = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                            BreakIterator breakIterator = BreakIterator.getWordInstance();
                            breakIterator.setText(string2);
                            int n3 = breakIterator.following(n2);
                            string = string2.substring(breakIterator.previous(), n3);
                            break;
                        }
                        case 3: {
                            string2 = JTextComponent.this.model.getText(0, JTextComponent.this.model.getLength());
                            BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                            breakIterator.setText(string2);
                            int n4 = breakIterator.following(n2);
                            string = string2.substring(breakIterator.previous(), n4);
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    Object var9_11 = null;
                    if (!(JTextComponent.this.model instanceof AbstractDocument)) return string;
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                    return string;
                }
                {
                }
                Object var9_10 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) return string;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                return string;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                throw throwable;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getAfterIndex(int var1_1, int var2_2) {
            block17: {
                block18: {
                    if (var2_2 < 0) return null;
                    if (var2_2 >= JTextComponent.access$000(JTextComponent.this).getLength()) {
                        return null;
                    }
                    var3_3 = null;
                    var4_4 = null;
                    if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readLock();
                    }
                    try {
                        try {
                            switch (var1_1) {
                                case 1: {
                                    if (var2_2 + 1 < JTextComponent.access$000(JTextComponent.this).getLength()) {
                                        var3_3 = JTextComponent.access$000(JTextComponent.this).getText(var2_2 + 1, 1);
                                        ** break;
                                    }
                                    break block17;
                                }
                                case 2: {
                                    var4_4 = JTextComponent.access$000(JTextComponent.this).getText(0, JTextComponent.access$000(JTextComponent.this).getLength());
                                    var7_5 = BreakIterator.getWordInstance();
                                    var7_5.setText(var4_4);
                                    var5_7 = var7_5.following(var2_2);
                                    if (var5_7 == -1) break block17;
                                    if (var5_7 >= var4_4.length()) break block17;
                                    var6_9 = var7_5.following(var5_7);
                                    if (var6_9 != -1) {
                                        if (var6_9 < var4_4.length()) {
                                            var3_3 = var4_4.substring(var5_7, var6_9);
                                            ** break;
                                        }
                                    }
                                    break block17;
                                }
                                case 3: {
                                    var4_4 = JTextComponent.access$000(JTextComponent.this).getText(0, JTextComponent.access$000(JTextComponent.this).getLength());
                                    var8_11 = BreakIterator.getSentenceInstance();
                                    var8_11.setText(var4_4);
                                    var5_8 = var8_11.following(var2_2);
                                    if (var5_8 == -1) break block17;
                                    if (var5_8 >= var4_4.length()) break block17;
                                    var6_10 = var8_11.following(var5_8);
                                    if (var6_10 != -1) {
                                        if (var6_10 < var4_4.length()) {
                                            var3_3 = var4_4.substring(var5_8, var6_10);
                                            ** break;
                                        }
                                    }
                                    break block17;
                                }
                                default: {
                                    var9_12 = null;
                                    var11_13 = null;
                                    break;
                                }
                            }
                            break block18;
                        }
                        catch (BadLocationException var7_6) {
                            var11_15 = null;
                            if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) return var3_3;
                            ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
                            return var3_3;
                        }
lbl54:
                        // 3 sources

                        break block17;
                    }
                    catch (Throwable var10_17) {
                        var11_16 = null;
                        if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) throw var10_17;
                        ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
                        throw var10_17;
                    }
                }
                if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) return var9_12;
                ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
                return var9_12;
            }
            var11_14 = null;
            if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) return var3_3;
            ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
            return var3_3;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getBeforeIndex(int var1_1, int var2_2) {
            block15: {
                block16: {
                    if (var2_2 < 0) return null;
                    if (var2_2 > JTextComponent.access$000(JTextComponent.this).getLength() - 1) {
                        return null;
                    }
                    var3_3 = null;
                    var4_4 = null;
                    if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument) {
                        ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readLock();
                    }
                    try {
                        try {
                            switch (var1_1) {
                                case 1: {
                                    if (var2_2 != 0) {
                                        var3_3 = JTextComponent.access$000(JTextComponent.this).getText(var2_2 - 1, 1);
                                        ** break;
                                    }
                                    break block15;
                                }
                                case 2: {
                                    var4_4 = JTextComponent.access$000(JTextComponent.this).getText(0, JTextComponent.access$000(JTextComponent.this).getLength());
                                    var7_5 = BreakIterator.getWordInstance();
                                    var7_5.setText(var4_4);
                                    var6_7 = var7_5.following(var2_2);
                                    var6_7 = var7_5.previous();
                                    var5_9 = var7_5.previous();
                                    if (var5_9 != -1) {
                                        var3_3 = var4_4.substring(var5_9, var6_7);
                                        ** break;
                                    }
                                    break block15;
                                }
                                case 3: {
                                    var4_4 = JTextComponent.access$000(JTextComponent.this).getText(0, JTextComponent.access$000(JTextComponent.this).getLength());
                                    var8_11 = BreakIterator.getSentenceInstance();
                                    var8_11.setText(var4_4);
                                    var6_8 = var8_11.following(var2_2);
                                    var6_8 = var8_11.previous();
                                    var5_10 = var8_11.previous();
                                    if (var5_10 != -1) {
                                        var3_3 = var4_4.substring(var5_10, var6_8);
                                        ** break;
                                    }
                                    break block15;
                                }
                                default: {
                                    var9_12 = null;
                                    var11_13 = null;
                                    break;
                                }
                            }
                            break block16;
                        }
                        catch (BadLocationException var7_6) {
                            var11_15 = null;
                            if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) return var3_3;
                            ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
                            return var3_3;
                        }
lbl50:
                        // 3 sources

                        break block15;
                    }
                    catch (Throwable var10_17) {
                        var11_16 = null;
                        if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) throw var10_17;
                        ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
                        throw var10_17;
                    }
                }
                if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) return var9_12;
                ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
                return var9_12;
            }
            var11_14 = null;
            if (JTextComponent.access$000(JTextComponent.this) instanceof AbstractDocument == false) return var3_3;
            ((AbstractDocument)JTextComponent.access$000(JTextComponent.this)).readUnlock();
            return var3_3;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }
}

