/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Entity;
import javax.swing.text.html.parser.TagElement;
import javax.swing.text.html.parser.TagStack;

public class Parser
implements DTDConstants {
    private char[] text = new char[1024];
    private int textpos = 0;
    private TagElement last;
    private boolean space;
    private char[] str = new char[128];
    private int strpos = 0;
    protected DTD dtd = null;
    private int ch;
    private int ln;
    private Reader in;
    private Element recent;
    private TagStack stack;
    private boolean skipTag = false;
    private TagElement lastFormSent = null;
    private SimpleAttributeSet attributes = new SimpleAttributeSet();
    private boolean seenHtml = false;
    private boolean seenHead = false;
    private boolean seenBody = false;
    protected boolean strict = false;
    private int crlfCount;
    private int crCount;
    private int lfCount;
    private int currentBlockStartPos;
    private int lastBlockStartPos;
    private char[] buf = new char[256];
    private int pos;
    private int len;
    private int currentPosition;

    public Parser(DTD dTD) {
        this.dtd = dTD;
    }

    protected int getCurrentLine() {
        return this.ln;
    }

    int getBlockStartPosition() {
        return Math.max(0, this.lastBlockStartPos - 1);
    }

    protected TagElement makeTag(Element element, boolean bl) {
        return new TagElement(element, bl);
    }

    protected TagElement makeTag(Element element) {
        return this.makeTag(element, false);
    }

    protected SimpleAttributeSet getAttributes() {
        return this.attributes;
    }

    protected void flushAttributes() {
        this.attributes.removeAttributes(this.attributes);
    }

    protected void handleText(char[] cArray) {
    }

    protected void handleTitle(char[] cArray) {
        this.handleText(cArray);
    }

    protected void handleComment(char[] cArray) {
    }

    protected void handleEOFInComment() {
        int n = this.strIndexOf('\n');
        if (n >= 0) {
            this.handleComment(this.getChars(0, n));
            try {
                this.in.close();
                this.in = new CharArrayReader(this.getChars(n + 1));
                this.ch = 62;
            }
            catch (IOException iOException) {
                this.error("ioexception");
            }
            this.resetStrBuffer();
        } else {
            this.error("eof.comment");
        }
    }

    protected void handleEmptyTag(TagElement tagElement) throws ChangedCharSetException {
    }

    protected void handleStartTag(TagElement tagElement) {
    }

    protected void handleEndTag(TagElement tagElement) {
    }

    protected void handleError(int n, String string) {
    }

    void handleText(TagElement tagElement) {
        char[] cArray;
        if (tagElement.breaksFlow()) {
            this.space = false;
        }
        if (!(this.textpos != 0 || this.space && this.stack != null && !this.last.breaksFlow() && this.stack.advance(this.dtd.pcdata))) {
            this.last = tagElement;
            this.space = false;
            this.lastBlockStartPos = this.currentBlockStartPos;
            return;
        }
        if (this.space) {
            if (this.textpos + 1 > this.text.length) {
                cArray = new char[this.text.length + 200];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            this.text[this.textpos++] = 32;
            this.space = false;
        }
        cArray = new char[this.textpos];
        System.arraycopy(this.text, 0, cArray, 0, this.textpos);
        if (tagElement.getElement().getName().equals("title")) {
            this.handleTitle(cArray);
        } else {
            this.handleText(cArray);
        }
        this.lastBlockStartPos = this.currentBlockStartPos;
        this.textpos = 0;
        this.last = tagElement;
        this.space = false;
    }

    protected void error(String string, String string2, String string3, String string4) {
        this.handleError(this.ln, string + string2 + string3 + string4);
    }

    protected void error(String string, String string2, String string3) {
        this.error(string, string2, string3, "?");
    }

    protected void error(String string, String string2) {
        this.error(string, string2, "?", "?");
    }

    protected void error(String string) {
        this.error(string, "?", "?", "?");
    }

    protected void startTag(TagElement tagElement) throws ChangedCharSetException {
        Element element = tagElement.getElement();
        if (!element.isEmpty() || this.textpos != 0) {
            this.handleText(tagElement);
        } else {
            this.last = tagElement;
            this.space = false;
        }
        this.lastBlockStartPos = this.currentBlockStartPos;
        AttributeList attributeList = element.atts;
        while (attributeList != null) {
            if (attributeList.modifier == 2 && (this.attributes.isEmpty() || !this.attributes.isDefined(attributeList.name))) {
                this.error("req.att ", attributeList.getName(), element.getName());
            }
            attributeList = attributeList.next;
        }
        if (element.isEmpty()) {
            this.handleEmptyTag(tagElement);
        } else if (element.getName().equals("form")) {
            this.handleStartTag(tagElement);
        } else {
            this.recent = element;
            this.stack = new TagStack(tagElement, this.stack);
            this.handleStartTag(tagElement);
        }
    }

    protected void endTag(boolean bl) {
        this.handleText(this.stack.tag);
        if (bl && !this.stack.elem.omitEnd()) {
            this.error("end.missing", this.stack.elem.getName());
        } else if (!this.stack.terminate()) {
            this.error("end.unexpected", this.stack.elem.getName());
        }
        this.handleEndTag(this.stack.tag);
        this.stack = this.stack.next;
        this.recent = this.stack != null ? this.stack.elem : null;
    }

    boolean ignoreElement(Element element) {
        String string = this.stack.elem.getName();
        String string2 = element.getName();
        if (string2.equals("html") && this.seenHtml || string2.equals("head") && this.seenHead || string2.equals("body") && this.seenBody) {
            return true;
        }
        if (string2.equals("dt") || string2.equals("dd")) {
            TagStack tagStack = this.stack;
            while (tagStack != null && !tagStack.elem.getName().equals("dl")) {
                tagStack = tagStack.next;
            }
            if (tagStack == null) {
                return true;
            }
        }
        return string.equals("table") && !string2.equals("#pcdata") && !string2.equals("input") || string2.equals("font") && (string.equals("ul") || string.equals("ol")) || string2.equals("meta") && this.stack != null || string2.equals("style") || string.equals("table") && string2.equals("a");
    }

    protected void markFirstTime(Element element) {
        String string = element.getName();
        if (string.equals("html")) {
            this.seenHtml = true;
        } else if (string.equals("head")) {
            this.seenHead = true;
        } else if (string.equals("body")) {
            this.seenBody = true;
        }
    }

    boolean legalElementContext(Element element) throws ChangedCharSetException {
        DTDConstants dTDConstants;
        if (this.stack == null) {
            if (element != this.dtd.html) {
                this.startTag(this.makeTag(this.dtd.html, true));
                return this.legalElementContext(element);
            }
            return true;
        }
        if (this.stack.advance(element)) {
            this.markFirstTime(element);
            return true;
        }
        boolean bl = false;
        String string = this.stack.elem.getName();
        String string2 = element.getName();
        if (!this.strict && (string.equals("table") && string2.equals("td") || string.equals("table") && string2.equals("th") || string.equals("tr") && !string2.equals("tr"))) {
            bl = true;
        }
        if (!this.strict && !bl && (this.stack.elem.getName() != element.getName() || element.getName().equals("body")) && (this.skipTag = this.ignoreElement(element))) {
            this.error("tag.ignore", element.getName());
            return this.skipTag;
        }
        if (!(this.strict || !string.equals("table") || string2.equals("tr") || string2.equals("td") || string2.equals("th") || string2.equals("caption"))) {
            Element element2 = this.dtd.getElement("tr");
            TagElement tagElement = this.makeTag(element2, true);
            this.legalTagContext(tagElement);
            this.startTag(tagElement);
            this.error("start.missing", element.getName());
            return this.legalElementContext(element);
        }
        if (!bl && this.stack.terminate() && (!this.strict || this.stack.elem.omitEnd())) {
            dTDConstants = this.stack.next;
            while (dTDConstants != null) {
                if (((TagStack)dTDConstants).advance(element)) {
                    while (this.stack != dTDConstants) {
                        this.endTag(true);
                    }
                    return true;
                }
                if (!((TagStack)dTDConstants).terminate() || this.strict && !((TagStack)dTDConstants).elem.omitEnd()) break;
                dTDConstants = ((TagStack)dTDConstants).next;
            }
        }
        if (!((dTDConstants = this.stack.first()) == null || this.strict && !((Element)dTDConstants).omitStart() || dTDConstants == this.dtd.head && element == this.dtd.pcdata)) {
            TagElement tagElement = this.makeTag((Element)dTDConstants, true);
            this.legalTagContext(tagElement);
            this.startTag(tagElement);
            if (!((Element)dTDConstants).omitStart()) {
                this.error("start.missing", element.getName());
            }
            return this.legalElementContext(element);
        }
        if (!this.strict) {
            ContentModel contentModel = this.stack.contentModel();
            Vector vector = new Vector();
            if (contentModel != null) {
                contentModel.getElements(vector);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ContentModel contentModel2;
                    Element element3 = (Element)enumeration.nextElement();
                    if (this.stack.excluded(element3.getIndex())) continue;
                    boolean bl2 = false;
                    AttributeList attributeList = element3.getAttributes();
                    while (attributeList != null) {
                        if (attributeList.modifier == 2) {
                            bl2 = true;
                            break;
                        }
                        attributeList = attributeList.next;
                    }
                    if (bl2 || (contentModel2 = element3.getContent()) == null || !contentModel2.first(element)) continue;
                    TagElement tagElement = this.makeTag(element3, true);
                    this.legalTagContext(tagElement);
                    this.startTag(tagElement);
                    this.error("start.missing", element3.getName());
                    return this.legalElementContext(element);
                }
            }
        }
        if (this.stack.terminate() && this.stack.elem != this.dtd.body && (!this.strict || this.stack.elem.omitEnd())) {
            if (!this.stack.elem.omitEnd()) {
                this.error("end.missing", element.getName());
            }
            this.endTag(true);
            return this.legalElementContext(element);
        }
        return false;
    }

    void legalTagContext(TagElement tagElement) throws ChangedCharSetException {
        if (this.legalElementContext(tagElement.getElement())) {
            this.markFirstTime(tagElement.getElement());
            return;
        }
        if (tagElement.breaksFlow() && this.stack != null && !this.stack.tag.breaksFlow()) {
            this.endTag(true);
            this.legalTagContext(tagElement);
            return;
        }
        TagStack tagStack = this.stack;
        while (tagStack != null) {
            if (tagStack.tag.getElement() == this.dtd.head) {
                while (this.stack != tagStack) {
                    this.endTag(true);
                }
                this.endTag(true);
                this.legalTagContext(tagElement);
                return;
            }
            tagStack = tagStack.next;
        }
        this.error("tag.unexpected", tagElement.getElement().getName());
    }

    void errorContext() throws ChangedCharSetException {
        while (this.stack != null && this.stack.tag.getElement() != this.dtd.body) {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
        if (this.stack == null) {
            this.legalElementContext(this.dtd.body);
            this.startTag(this.makeTag(this.dtd.body, true));
        }
    }

    void addString(int n) {
        if (this.strpos == this.str.length) {
            char[] cArray = new char[this.str.length + 128];
            System.arraycopy(this.str, 0, cArray, 0, this.str.length);
            this.str = cArray;
        }
        this.str[this.strpos++] = (char)n;
    }

    String getString(int n) {
        char[] cArray = new char[this.strpos - n];
        System.arraycopy(this.str, n, cArray, 0, this.strpos - n);
        this.strpos = n;
        return new String(cArray);
    }

    char[] getChars(int n) {
        char[] cArray = new char[this.strpos - n];
        System.arraycopy(this.str, n, cArray, 0, this.strpos - n);
        this.strpos = n;
        return cArray;
    }

    char[] getChars(int n, int n2) {
        char[] cArray = new char[n2 - n];
        System.arraycopy(this.str, n, cArray, 0, n2 - n);
        return cArray;
    }

    void resetStrBuffer() {
        this.strpos = 0;
    }

    int strIndexOf(char c) {
        int n = 0;
        while (n < this.strpos) {
            if (this.str[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void skipSpace() throws IOException {
        block5: while (true) {
            switch (this.ch) {
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    continue block5;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                        continue block5;
                    }
                    ++this.crCount;
                    continue block5;
                }
                case 9: 
                case 32: {
                    this.ch = this.readCh();
                    continue block5;
                }
            }
            break;
        }
    }

    boolean parseIdentifier(boolean bl) throws IOException {
        switch (this.ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (bl) {
                    this.ch = 97 + (this.ch - 65);
                }
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                break;
            }
            default: {
                return false;
            }
        }
        block8: while (true) {
            this.addString(this.ch);
            this.ch = this.readCh();
            switch (this.ch) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (bl) {
                        this.ch = 97 + (this.ch - 65);
                    }
                }
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    private char[] parseEntityReference() throws IOException {
        int n = this.strpos;
        this.ch = this.readCh();
        if (this.ch == 35) {
            int n2 = 0;
            this.ch = this.readCh();
            if (this.ch >= 48 && this.ch <= 57) {
                while (this.ch >= 48 && this.ch <= 57) {
                    n2 = n2 * 10 + this.ch - 48;
                    this.ch = this.readCh();
                }
                switch (this.ch) {
                    case 10: {
                        ++this.ln;
                        this.ch = this.readCh();
                        ++this.lfCount;
                        break;
                    }
                    case 13: {
                        ++this.ln;
                        this.ch = this.readCh();
                        if (this.ch == 10) {
                            this.ch = this.readCh();
                            ++this.crlfCount;
                            break;
                        }
                        ++this.crCount;
                        break;
                    }
                    case 59: {
                        this.ch = this.readCh();
                    }
                }
                char[] cArray = new char[]{(char)n2};
                return cArray;
            }
            this.addString(35);
            if (!this.parseIdentifier(false)) {
                this.error("ident.expected");
                this.strpos = n;
                char[] cArray = new char[]{'&', '#'};
                return cArray;
            }
        } else if (!this.parseIdentifier(false)) {
            char[] cArray = new char[]{'&'};
            return cArray;
        }
        switch (this.ch) {
            case 10: {
                ++this.ln;
                this.ch = this.readCh();
                ++this.lfCount;
                break;
            }
            case 13: {
                ++this.ln;
                this.ch = this.readCh();
                if (this.ch == 10) {
                    this.ch = this.readCh();
                    ++this.crlfCount;
                    break;
                }
                ++this.crCount;
                break;
            }
            case 59: {
                this.ch = this.readCh();
            }
        }
        String string = this.getString(n);
        Entity entity = this.dtd.getEntity(string);
        if (!this.strict && entity == null) {
            entity = this.dtd.getEntity(string.toLowerCase());
        }
        if (entity == null || !entity.isGeneral()) {
            if (string.length() == 0) {
                this.error("invalid.entref", string);
                return new char[0];
            }
            String string2 = "&" + string;
            char[] cArray = new char[string2.length()];
            string2.getChars(0, cArray.length, cArray, 0);
            return cArray;
        }
        return entity.getData();
    }

    void parseComment() throws IOException {
        block7: while (true) {
            int n = this.ch;
            switch (n) {
                case 45: {
                    if (!this.strict && this.strpos != 0 && this.str[this.strpos - 1] == '-') {
                        this.ch = this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        if (this.ch != 33) break;
                        this.ch = this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        this.addString(45);
                        this.addString(33);
                        continue block7;
                    }
                    this.ch = this.readCh();
                    if (this.ch != 45) break;
                    this.ch = this.readCh();
                    if (this.strict || this.ch == 62) {
                        return;
                    }
                    if (this.ch == 33) {
                        this.ch = this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        this.addString(45);
                        this.addString(33);
                        continue block7;
                    }
                    this.addString(45);
                    break;
                }
                case -1: {
                    this.handleEOFInComment();
                    return;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    break;
                }
                case 62: {
                    this.ch = this.readCh();
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                    } else {
                        ++this.crCount;
                    }
                    n = 10;
                    break;
                }
                default: {
                    this.ch = this.readCh();
                }
            }
            this.addString(n);
        }
    }

    void parseLiteral(boolean bl) throws IOException {
        block7: while (true) {
            char[] cArray;
            int n = this.ch;
            switch (n) {
                case -1: {
                    this.error("eof.literal", this.stack.elem.getName());
                    this.endTag(true);
                    return;
                }
                case 62: {
                    this.ch = this.readCh();
                    int n2 = this.textpos - (this.stack.elem.name.length() + 2);
                    int n3 = 0;
                    if (n2 < 0 || this.text[n2++] != '<' || this.text[n2] != '/') break;
                    while (++n2 < this.textpos && Character.toLowerCase(this.text[n2]) == this.stack.elem.name.charAt(n3++)) {
                    }
                    if (n2 != this.textpos) break;
                    this.textpos -= this.stack.elem.name.length() + 2;
                    if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                        --this.textpos;
                    }
                    this.endTag(false);
                    return;
                }
                case 38: {
                    char[] cArray2 = this.parseEntityReference();
                    if (this.textpos + cArray2.length > this.text.length) {
                        cArray = new char[Math.max(this.textpos + cArray2.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                        this.text = cArray;
                    }
                    System.arraycopy(cArray2, 0, this.text, this.textpos, cArray2.length);
                    this.textpos += cArray2.length;
                    continue block7;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                    } else {
                        ++this.crCount;
                    }
                    n = 10;
                    break;
                }
                default: {
                    this.ch = this.readCh();
                }
            }
            if (this.textpos == this.text.length) {
                cArray = new char[this.text.length + 128];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            this.text[this.textpos++] = (char)n;
        }
    }

    String parseAttributeValue(boolean bl) throws IOException {
        int n = -1;
        switch (this.ch) {
            case 34: 
            case 39: {
                n = this.ch;
                this.ch = this.readCh();
            }
        }
        block14: while (true) {
            int n2 = this.ch;
            switch (n2) {
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                    } else {
                        ++this.crCount;
                    }
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 9: {
                    if (n < 0) {
                        n2 = 32;
                    }
                }
                case 32: {
                    this.ch = this.readCh();
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 60: 
                case 62: {
                    if (n < 0) {
                        return this.getString(0);
                    }
                    this.ch = this.readCh();
                    break;
                }
                case 34: 
                case 39: {
                    this.ch = this.readCh();
                    if (n2 == n) {
                        return this.getString(0);
                    }
                    if (n != -1) break;
                    this.error("attvalerr");
                    if (!this.strict && this.ch != 32) continue block14;
                    return this.getString(0);
                }
                case 61: {
                    if (n < 0) {
                        this.error("attvalerr");
                        if (this.strict) {
                            return this.getString(0);
                        }
                    }
                    this.ch = this.readCh();
                    break;
                }
                case 38: {
                    if (this.strict && n < 0) {
                        this.ch = this.readCh();
                        break;
                    }
                    char[] cArray = this.parseEntityReference();
                    int n3 = 0;
                    while (true) {
                        if (n3 >= cArray.length) continue block14;
                        n2 = cArray[n3];
                        this.addString(bl && n2 >= 65 && n2 <= 90 ? 97 + n2 - 65 : n2);
                        ++n3;
                    }
                }
                case -1: {
                    return this.getString(0);
                }
                default: {
                    if (bl && n2 >= 65 && n2 <= 90) {
                        n2 = 97 + n2 - 65;
                    }
                    this.ch = this.readCh();
                }
            }
            this.addString(n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseAttributeSpecificationList(Element element) throws IOException {
        block4: while (true) {
            String string;
            String string2;
            AttributeList attributeList;
            block20: {
                block21: {
                    block22: {
                        block23: {
                            block18: {
                                block19: {
                                    this.skipSpace();
                                    switch (this.ch) {
                                        case -1: 
                                        case 47: 
                                        case 60: 
                                        case 62: {
                                            return;
                                        }
                                        case 45: {
                                            this.ch = this.readCh();
                                            if (this.ch == 45) {
                                                this.ch = this.readCh();
                                                this.parseComment();
                                                this.strpos = 0;
                                                continue block4;
                                            }
                                            this.error("invalid.tagchar", "-", element.getName());
                                            this.ch = this.readCh();
                                            continue block4;
                                        }
                                    }
                                    attributeList = null;
                                    string2 = null;
                                    string = null;
                                    if (!this.parseIdentifier(true)) break block18;
                                    string2 = this.getString(0);
                                    this.skipSpace();
                                    if (this.ch != 61) break block19;
                                    this.ch = this.readCh();
                                    this.skipSpace();
                                    attributeList = element.getAttribute(string2);
                                    string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11 && attributeList.type != 7);
                                    break block20;
                                }
                                string = string2;
                                attributeList = element.getAttributeByValue(string);
                                if (attributeList != null) break block20;
                                attributeList = element.getAttribute(string2);
                                string = attributeList != null ? attributeList.getValue() : null;
                                break block20;
                            }
                            if (!this.strict && this.ch == 44) {
                                this.ch = this.readCh();
                                continue;
                            }
                            if (this.strict || this.ch != 34) break block21;
                            this.ch = this.readCh();
                            this.skipSpace();
                            if (!this.parseIdentifier(true)) break block22;
                            string2 = this.getString(0);
                            if (this.ch == 34) {
                                this.ch = this.readCh();
                            }
                            this.skipSpace();
                            if (this.ch != 61) break block23;
                            this.ch = this.readCh();
                            this.skipSpace();
                            attributeList = element.getAttribute(string2);
                            string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11);
                            break block20;
                        }
                        string = string2;
                        attributeList = element.getAttributeByValue(string);
                        if (attributeList != null || (attributeList = element.getAttribute(string2)) == null) break block20;
                        string = attributeList.getValue();
                        break block20;
                    }
                    char[] cArray = new char[]{(char)this.ch};
                    this.error("invalid.tagchar", new String(cArray), element.getName());
                    this.ch = this.readCh();
                    continue;
                }
                if (!this.strict && this.attributes.isEmpty() && this.ch == 61) {
                    this.ch = this.readCh();
                    this.skipSpace();
                    string2 = element.getName();
                    attributeList = element.getAttribute(string2);
                    string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11);
                } else {
                    if (!this.strict && this.ch == 61) {
                        this.ch = this.readCh();
                        this.skipSpace();
                        string = this.parseAttributeValue(true);
                        this.error("attvalerr");
                        return;
                    }
                    char[] cArray = new char[]{(char)this.ch};
                    this.error("invalid.tagchar", new String(cArray), element.getName());
                    if (this.strict) return;
                    this.ch = this.readCh();
                    continue;
                }
            }
            if (attributeList != null) {
                string2 = attributeList.getName();
            } else {
                this.error("invalid.tagatt", string2, element.getName());
            }
            if (this.attributes.isDefined(string2)) {
                this.error("multi.tagatt", string2, element.getName());
            }
            if (string == null) {
                string = attributeList != null && attributeList.value != null ? attributeList.value : "#DEFAULT";
            } else if (attributeList != null && attributeList.values != null && !attributeList.values.contains(string)) {
                this.error("invalid.tagattval", string2, element.getName());
            }
            HTML.Attribute attribute = HTML.getAttributeKey(string2);
            if (attribute == null) {
                this.attributes.addAttribute(string2, string);
                continue;
            }
            this.attributes.addAttribute(attribute, string);
        }
    }

    public String parseDTDMarkup() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.ch = this.readCh();
        block7: while (true) {
            switch (this.ch) {
                case 62: {
                    this.ch = this.readCh();
                    return stringBuffer.toString();
                }
                case -1: {
                    this.error("invalid.markup");
                    return stringBuffer.toString();
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    ++this.lfCount;
                    continue block7;
                }
                case 34: {
                    this.ch = this.readCh();
                    continue block7;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                        continue block7;
                    }
                    ++this.crCount;
                    continue block7;
                }
            }
            stringBuffer.append((char)(this.ch & 0xFF));
            this.ch = this.readCh();
        }
    }

    protected boolean parseMarkupDeclarations(StringBuffer stringBuffer) throws IOException {
        if (stringBuffer.length() == "DOCTYPE".length() && stringBuffer.toString().toUpperCase().equals("DOCTYPE")) {
            this.parseDTDMarkup();
            return true;
        }
        return false;
    }

    void parseInvalidTag() throws IOException {
        while (true) {
            this.skipSpace();
            switch (this.ch) {
                case -1: 
                case 62: {
                    this.ch = this.readCh();
                    return;
                }
                case 60: {
                    return;
                }
            }
            this.ch = this.readCh();
        }
    }

    /*
     * Unable to fully structure code
     */
    void parseTag() throws IOException {
        var1_1 = null;
        var2_2 = false;
        var3_3 = false;
        var4_4 = false;
        this.ch = this.readCh();
        switch (this.ch) {
            case 33: {
                this.ch = this.readCh();
                switch (this.ch) {
                    case 45: {
                        block36: while (true) {
                            if (this.ch == 45) {
                                if (!this.strict || (this.ch = this.readCh()) == 45) {
                                    this.ch = this.readCh();
                                    if (!this.strict && this.ch == 45) {
                                        this.ch = this.readCh();
                                    }
                                    if (this.textpos != 0) {
                                        var5_5 = new char[this.textpos];
                                        System.arraycopy(this.text, 0, var5_5, 0, this.textpos);
                                        this.handleText(var5_5);
                                        this.lastBlockStartPos = this.currentBlockStartPos;
                                        this.textpos = 0;
                                    }
                                    this.parseComment();
                                    this.handleComment(this.getChars(0));
                                    continue;
                                }
                                if (!var3_3) {
                                    var3_3 = true;
                                    this.error("invalid.commentchar", "-");
                                }
                            }
                            this.skipSpace();
                            switch (this.ch) {
                                case 45: {
                                    continue block36;
                                }
                                case 62: {
                                    this.ch = this.readCh();
                                }
                                case -1: {
                                    return;
                                }
                            }
                            this.ch = this.readCh();
                            if (var3_3) continue;
                            var3_3 = true;
                            this.error("invalid.commentchar", String.valueOf((char)this.ch));
                        }
                    }
                }
                var5_6 = new StringBuffer();
                block37: while (true) {
                    var5_6.append((char)this.ch);
                    if (this.parseMarkupDeclarations(var5_6)) {
                        return;
                    }
                    switch (this.ch) {
                        case 62: {
                            this.ch = this.readCh();
                        }
                        case -1: {
                            this.error("invalid.markup");
                            return;
                        }
                        case 10: {
                            ++this.ln;
                            this.ch = this.readCh();
                            ++this.lfCount;
                            continue block37;
                        }
                        case 13: {
                            ++this.ln;
                            this.ch = this.readCh();
                            if (this.ch == 10) {
                                this.ch = this.readCh();
                                ++this.crlfCount;
                                continue block37;
                            }
                            ++this.crCount;
                            continue block37;
                        }
                    }
                    this.ch = this.readCh();
                }
            }
            case 47: {
                this.ch = this.readCh();
                switch (this.ch) {
                    case 62: {
                        this.ch = this.readCh();
                    }
                    case 60: {
                        if (this.recent == null) {
                            this.error("invalid.shortend");
                            return;
                        }
                        var1_1 = this.recent;
                        break;
                    }
                    default: {
                        if (!this.parseIdentifier(true)) {
                            this.error("expected.endtagname");
                            return;
                        }
                        this.skipSpace();
                        switch (this.ch) {
                            case 62: {
                                this.ch = this.readCh();
                            }
                            case 60: {
                                break;
                            }
                            default: {
                                this.error("expected", "'>'");
                                while (this.ch != -1 && this.ch != 10 && this.ch != 62) {
                                    this.ch = this.readCh();
                                }
                                if (this.ch != 62) break;
                                this.ch = this.readCh();
                            }
                        }
                        var6_7 = this.getString(0);
                        if (!this.dtd.elementExists(var6_7)) {
                            this.error("end.unrecognized", var6_7);
                            if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                                --this.textpos;
                            }
                            var1_1 = this.dtd.getElement("unknown");
                            var1_1.name = var6_7;
                            var4_4 = true;
                            break;
                        }
                        var1_1 = this.dtd.getElement(var6_7);
                    }
                }
                if (this.stack == null) {
                    this.error("end.extra.tag", var1_1.getName());
                    return;
                }
                if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                    if (this.stack.pre) {
                        if (this.textpos > 1 && this.text[this.textpos - 2] != '\n') {
                            --this.textpos;
                        }
                    } else {
                        --this.textpos;
                    }
                }
                if (!this.strict && var1_1.getName().equals("form")) {
                    if (this.lastFormSent != null) {
                        this.handleEndTag(this.lastFormSent);
                        return;
                    }
                    return;
                }
                if (var4_4) {
                    var7_8 = this.makeTag(var1_1);
                    this.handleText(var7_8);
                    this.attributes.addAttribute(HTML.Attribute.ENDTAG, "true");
                    this.handleEmptyTag(this.makeTag(var1_1));
                    var4_4 = false;
                    return;
                }
                if (!this.strict) {
                    var7_9 = this.stack.elem.getName();
                    if (var7_9.equals("table") && !var1_1.getName().equals(var7_9)) {
                        this.error("tag.ignore", var1_1.getName());
                        return;
                    }
                    if ((var7_9.equals("tr") || var7_9.equals("td")) && !var1_1.getName().equals("table") && !var1_1.getName().equals(var7_9)) {
                        this.error("tag.ignore", var1_1.getName());
                        return;
                    }
                }
                var7_9 = this.stack;
                while (var7_9 != null && var1_1 != var7_9.elem) {
                    var7_9 = var7_9.next;
                }
                if (var7_9 == null) {
                    this.error("unmatched.endtag", var1_1.getName());
                    return;
                }
                var8_10 = var1_1.getName();
                if (this.stack == var7_9 || !var8_10.equals("font") && !var8_10.equals("center")) ** GOTO lbl154
                if (var8_10.equals("center")) {
                    while (this.stack.elem.omitEnd() && this.stack != var7_9) {
                        this.endTag(true);
                    }
                    if (this.stack.elem == var1_1) {
                        this.endTag(false);
                    }
                }
                return;
lbl-1000:
                // 1 sources

                {
                    this.endTag(true);
lbl154:
                    // 2 sources

                    ** while (this.stack != var7_9)
                }
lbl155:
                // 1 sources

                this.endTag(false);
                return;
            }
            case -1: {
                this.error("eof");
                return;
            }
        }
        if (!this.parseIdentifier(true)) {
            var1_1 = this.recent;
            if (this.ch != 62 || var1_1 == null) {
                this.error("expected.tagname");
                return;
            }
        } else {
            var9_11 = this.getString(0);
            if (var9_11.equals("image")) {
                var9_11 = new String("img");
            }
            if (!this.dtd.elementExists((String)var9_11)) {
                this.error("tag.unrecognized ", (String)var9_11);
                var1_1 = this.dtd.getElement("unknown");
                var1_1.name = var9_11;
                var4_4 = true;
            } else {
                var1_1 = this.dtd.getElement((String)var9_11);
            }
        }
        this.parseAttributeSpecificationList(var1_1);
        switch (this.ch) {
            case 47: {
                var2_2 = true;
            }
            case 62: {
                this.ch = this.readCh();
            }
            case 60: {
                break;
            }
            default: {
                this.error("expected", "'>'");
            }
        }
        if (!this.strict && var1_1.getName().equals("script")) {
            this.error("javascript.unsupported");
        }
        if (!var1_1.isEmpty()) {
            if (this.ch == 10) {
                ++this.ln;
                ++this.lfCount;
                this.ch = this.readCh();
            } else if (this.ch == 13) {
                ++this.ln;
                this.ch = this.readCh();
                if (this.ch == 10) {
                    this.ch = this.readCh();
                    ++this.crlfCount;
                } else {
                    ++this.crCount;
                }
            }
        }
        var9_11 = this.makeTag(var1_1, false);
        if (!this.strict && var1_1.getName().equals("form")) {
            if (this.lastFormSent == null) {
                this.lastFormSent = var9_11;
            } else {
                this.handleEndTag(this.lastFormSent);
                this.lastFormSent = var9_11;
            }
        } else if (!var4_4) {
            this.legalTagContext((TagElement)var9_11);
            if (!this.strict && this.skipTag) {
                this.skipTag = false;
                return;
            }
        }
        this.startTag((TagElement)var9_11);
        if (!var1_1.isEmpty()) {
            switch (var1_1.getType()) {
                case 1: {
                    this.parseLiteral(false);
                    break;
                }
                case 16: {
                    this.parseLiteral(true);
                    break;
                }
                default: {
                    if (this.stack == null) break;
                    this.stack.net = var2_2;
                }
            }
        }
    }

    void parseContent() throws IOException {
        Thread thread = Thread.currentThread();
        block9: while (true) {
            char[] cArray;
            if (thread.isInterrupted()) break;
            int n = this.ch;
            this.currentBlockStartPos = this.currentPosition;
            switch (n) {
                case 60: {
                    this.parseTag();
                    this.lastBlockStartPos = this.currentPosition;
                    continue block9;
                }
                case 47: {
                    this.ch = this.readCh();
                    if (this.stack == null || !this.stack.net) break;
                    this.endTag(false);
                    continue block9;
                }
                case -1: {
                    return;
                }
                case 38: {
                    char[] cArray2;
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.breaksFlow()) {
                            this.space = false;
                        }
                    }
                    if (this.textpos + (cArray2 = this.parseEntityReference()).length + 1 > this.text.length) {
                        cArray = new char[Math.max(this.textpos + cArray2.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                        this.text = cArray;
                    }
                    if (this.space) {
                        this.space = false;
                        this.text[this.textpos++] = 32;
                    }
                    if (cArray2.length == 1 && cArray2[0] == '\u00a0') {
                        cArray2[0] = 32;
                    }
                    System.arraycopy(cArray2, 0, this.text, this.textpos, cArray2.length);
                    this.textpos += cArray2.length;
                    continue block9;
                }
                case 10: {
                    ++this.ln;
                    ++this.lfCount;
                    this.ch = this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    if (this.textpos != 0) continue block9;
                    this.lastBlockStartPos = this.currentPosition;
                    continue block9;
                }
                case 13: {
                    ++this.ln;
                    n = 10;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                        ++this.crlfCount;
                    } else {
                        ++this.crCount;
                    }
                    if (this.stack != null && this.stack.pre) break;
                    if (this.textpos == 0) {
                        this.lastBlockStartPos = this.currentPosition;
                    }
                    this.space = true;
                    continue block9;
                }
                case 9: 
                case 32: {
                    this.ch = this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    if (this.textpos != 0) continue block9;
                    this.lastBlockStartPos = this.currentPosition;
                    continue block9;
                }
                default: {
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.breaksFlow()) {
                            this.space = false;
                        }
                    }
                    this.ch = this.readCh();
                }
            }
            if (this.textpos + 2 > this.text.length) {
                cArray = new char[this.text.length + 128];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            if (this.space) {
                if (this.textpos == 0) {
                    --this.lastBlockStartPos;
                }
                this.text[this.textpos++] = 32;
                this.space = false;
            }
            this.text[this.textpos++] = (char)n;
        }
        thread.interrupt();
    }

    String getEndOfLineString() {
        if (this.crlfCount >= this.crCount) {
            if (this.lfCount >= this.crlfCount) {
                return "\n";
            }
            return "\r\n";
        }
        if (this.crCount > this.lfCount) {
            return "\r";
        }
        return "\n";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void parse(Reader reader) throws IOException {
        this.in = reader;
        this.ln = 1;
        this.seenHtml = false;
        this.seenHead = false;
        this.seenBody = false;
        this.crlfCount = 0;
        this.lfCount = 0;
        this.crCount = 0;
        try {
            try {
                try {
                    this.ch = this.readCh();
                    this.text = new char[1024];
                    this.str = new char[128];
                    this.parseContent();
                    while (true) {
                        if (this.stack == null) {
                            Object var3_2 = null;
                            break;
                        }
                        this.endTag(true);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                Object var6_7 = null;
            }
            catch (IOException iOException) {
                this.errorContext();
                this.error("ioexception");
                throw iOException;
            }
            catch (Exception exception) {
                this.errorContext();
                this.error("exception", exception.getClass().getName(), exception.getMessage());
                exception.printStackTrace();
                Object var6_8 = null;
            }
            while (true) {
                if (this.stack == null) break;
                this.handleEndTag(this.stack.tag);
                this.stack = this.stack.next;
            }
            this.text = null;
            this.str = null;
            return;
            while (true) {
                if (this.stack == null) break;
                this.handleEndTag(this.stack.tag);
                this.stack = this.stack.next;
            }
            this.text = null;
            this.str = null;
            return;
            catch (ThreadDeath threadDeath) {
                this.errorContext();
                this.error("terminated");
                threadDeath.printStackTrace();
                throw threadDeath;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
        }
        while (true) {
            if (this.stack == null) {
                this.text = null;
                this.str = null;
                throw throwable;
            }
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
    }

    private final int readCh() throws IOException {
        if (this.pos >= this.len) {
            this.len = this.in.read(this.buf);
            if (this.len <= 0) {
                return -1;
            }
            this.pos = 0;
        }
        ++this.currentPosition;
        return this.buf[this.pos++];
    }

    protected int getCurrentPos() {
        return this.currentPosition;
    }
}

