/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import sun.awt.image.HPOffScreenImageSource;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.NativeLibLoader;

public abstract class Image
extends java.awt.Image {
    ImageProducer source;
    InputStreamImageSource src;
    ImageRepresentation imagerep;
    private int width = -1;
    private int height = -1;
    private Hashtable properties;
    private int availinfo;

    private static native void initIDs();

    protected Image() {
    }

    protected Image(ImageProducer imageProducer) {
        this.source = imageProducer;
        if (imageProducer instanceof InputStreamImageSource) {
            this.src = (InputStreamImageSource)imageProducer;
        }
    }

    protected Image(Component component, int n, int n2) {
        HPOffScreenImageSource hPOffScreenImageSource = new HPOffScreenImageSource(component, n, n2);
        this.source = hPOffScreenImageSource;
        this.width = n;
        this.height = n2;
        this.properties = new Hashtable();
        this.availinfo |= 7;
        this.imagerep = this.makeImageRep();
        this.imagerep.offscreen = true;
        this.imagerep.setDimensions(n, n2);
        this.imagerep.setPdata(this.imagerep.offscreenInit(component.getBackground(), this.imagerep.getPdata()));
        hPOffScreenImageSource.setImageRep(this.imagerep);
    }

    protected void initGraphics(Graphics graphics) {
        HPOffScreenImageSource hPOffScreenImageSource = (HPOffScreenImageSource)this.source;
        graphics.setColor(hPOffScreenImageSource.target.getForeground());
        graphics.setFont(hPOffScreenImageSource.target.getFont());
    }

    public ImageProducer getSource() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        return this.source;
    }

    public int getWidth() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 1) == 0) {
            this.reconstruct(1);
        }
        return this.width;
    }

    public synchronized int getWidth(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 1) == 0) {
            this.addWatcher(imageObserver, true);
            if ((this.availinfo & 1) == 0) {
                return -1;
            }
        }
        return this.width;
    }

    public int getHeight() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 2) == 0) {
            this.reconstruct(2);
        }
        return this.height;
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 2) == 0) {
            this.addWatcher(imageObserver, true);
            if ((this.availinfo & 2) == 0) {
                return -1;
            }
        }
        return this.height;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        Object object;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if (this.properties == null) {
            this.addWatcher(imageObserver, true);
            if (this.properties == null) {
                return null;
            }
        }
        if ((object = this.properties.get(string)) == null) {
            object = java.awt.Image.UndefinedProperty;
        }
        return object;
    }

    public boolean hasError() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        return (this.availinfo & 0x40) != 0;
    }

    public int check(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) == 0 && (~this.availinfo & 7) != 0) {
            this.addWatcher(imageObserver, false);
        }
        return this.availinfo;
    }

    public void preload(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x20) == 0) {
            this.addWatcher(imageObserver, true);
        }
    }

    private synchronized void addWatcher(ImageObserver imageObserver, boolean bl) {
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this, 192, -1, -1, -1, -1);
            }
            return;
        }
        ImageRepresentation imageRepresentation = this.getImageRep();
        imageRepresentation.addWatcher(imageObserver);
        if (bl) {
            imageRepresentation.startProduction();
        }
    }

    private synchronized void reconstruct(int n) {
        if ((n & ~this.availinfo) != 0) {
            if ((this.availinfo & 0x40) != 0) {
                return;
            }
            ImageRepresentation imageRepresentation = this.getImageRep();
            imageRepresentation.startProduction();
            while ((n & ~this.availinfo) != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if ((this.availinfo & 0x40) == 0) continue;
                return;
            }
        }
    }

    synchronized void addInfo(int n) {
        this.availinfo |= n;
        this.notifyAll();
    }

    void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.addInfo(3);
    }

    void setProperties(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.properties = hashtable;
        this.addInfo(4);
    }

    synchronized void infoDone(int n) {
        if (n == 1 || (~this.availinfo & 3) != 0) {
            this.addInfo(64);
        } else if ((this.availinfo & 4) == 0) {
            this.setProperties(null);
        }
    }

    public void flush() {
        ImageRepresentation imageRepresentation;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        Image image = this;
        synchronized (image) {
            this.availinfo &= 0xFFFFFFBF;
            imageRepresentation = this.imagerep;
            this.imagerep = null;
        }
        if (imageRepresentation != null) {
            imageRepresentation.abort();
        }
        if (this.src != null) {
            this.src.flush();
        }
    }

    protected abstract ImageRepresentation makeImageRep();

    protected synchronized ImageRepresentation getImageRep() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if (this.imagerep == null) {
            this.imagerep = this.makeImageRep();
        }
        return this.imagerep;
    }

    protected ColorModel getColorModel() {
        ImageRepresentation imageRepresentation = this.getImageRep();
        return imageRepresentation.getColorModel();
    }

    protected BufferedImage getBufferedImage() {
        ImageRepresentation imageRepresentation = this.getImageRep();
        return imageRepresentation.getBufferedImage();
    }

    static {
        NativeLibLoader.loadLibraries();
        Image.initIDs();
    }
}

