/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import sun.awt.DebugHelper;
import sun.awt.Graphics2Delegate;
import sun.awt.RepaintArea;
import sun.awt.ScreenUpdater;
import sun.awt.SunToolkit;
import sun.awt.UpdateClient;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.OffScreenImage;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Graphics;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11OffScreenImage;

public abstract class MComponentPeer
implements ComponentPeer,
UpdateClient,
DropTargetPeer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$motif$MComponentPeer == null ? (class$sun$awt$motif$MComponentPeer = MComponentPeer.class$("sun.awt.motif.MComponentPeer")) : class$sun$awt$motif$MComponentPeer);
    Component target;
    long pData;
    long jniGlobalRef;
    private X11GraphicsConfig graphicsConfig;
    private boolean repaintPending;
    private Rectangle repaintRect;
    private RepaintArea paintArea;
    private RepaintArea updateArea;
    public static boolean hpEnableFastSwing;
    private static final String swing_prefix = "javax.swing";
    private boolean disposed = false;
    private static int JAWT_LOCK_ERROR;
    private static int JAWT_LOCK_CLIP_CHANGED;
    private static int JAWT_LOCK_BOUNDS_CHANGED;
    private static int JAWT_LOCK_SURFACE_CHANGED;
    private int drawState = JAWT_LOCK_CLIP_CHANGED | JAWT_LOCK_BOUNDS_CHANGED | JAWT_LOCK_SURFACE_CHANGED;
    static final int MOTIF_NA = 0;
    static final int MOTIF_V1 = 1;
    static final int MOTIF_V2 = 2;
    private Font font;
    public int serialNum = 0;
    static /* synthetic */ Class class$sun$awt$motif$MComponentPeer;

    private static native void initIDs();

    abstract void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    void EFcreate(MComponentPeer mComponentPeer, int n) {
    }

    native void pInitialize();

    native void pShow();

    native void pHide();

    native void pEnable();

    native void pDisable();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pMakeCursorVisible();

    native Point pGetLocationOnScreen();

    native void pSetForeground(Color var1);

    native void pSetBackground(Color var1);

    private native void pSetFont(Font var1);

    native int getNativeColor(Color var1, GraphicsConfiguration var2);

    static native Container getParent_NoClientCode(Component var0);

    static native Component[] getComponents_NoClientCode(Container var0);

    void initialize() {
        Font font;
        if (!this.target.isVisible()) {
            this.hide();
        }
        this.pInitialize();
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
        this.setCursor(this.target.getCursor());
        if (!this.target.isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = this.target.getBounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.show();
        }
    }

    public void init(Component component, Object object) {
        this.target = component;
        this.paintArea = new RepaintArea();
        this.updateArea = new RepaintArea();
        if (!hpEnableFastSwing) {
            this.checkSetFastSwing();
        }
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        if (component instanceof MEmbeddedFrame) {
            MEmbeddedFrame mEmbeddedFrame = (MEmbeddedFrame)component;
            this.EFcreate(mComponentPeer, (int)mEmbeddedFrame.handle);
        } else {
            this.create(mComponentPeer, object);
        }
        this.initialize();
    }

    MComponentPeer(Component component, Object object) {
        this.init(component, object);
    }

    MComponentPeer() {
    }

    public void init(Component component) {
        Object object;
        this.target = component;
        this.paintArea = new RepaintArea();
        this.updateArea = new RepaintArea();
        if (!hpEnableFastSwing) {
            this.checkSetFastSwing();
        }
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        if (component instanceof MEmbeddedFrame) {
            object = (MEmbeddedFrame)component;
            this.EFcreate(mComponentPeer, (int)((MEmbeddedFrame)object).handle);
        } else {
            this.create(mComponentPeer);
        }
        if (container != null && container instanceof ScrollPane) {
            object = (MScrollPanePeer)mComponentPeer;
            ((MScrollPanePeer)object).setScrollChild(this);
        }
        this.initialize();
    }

    MComponentPeer(Component component) {
        this.init(component);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private synchronized void addRepaintArea(int n, int n2, int n3, int n4) {
        if (!this.repaintPending) {
            this.repaintPending = true;
            this.repaintRect = new Rectangle(n, n2, n3, n4);
        } else {
            this.repaintRect = this.repaintRect.union(new Rectangle(n, n2, n3, n4));
        }
    }

    private void checkSetFastSwing() {
        Class clazz;
        String string;
        MToolkit mToolkit = (MToolkit)Toolkit.getDefaultToolkit();
        if (MToolkit.hpFastSwing && (string = (clazz = this.target.getClass()).getName()).startsWith(swing_prefix)) {
            hpEnableFastSwing = true;
        }
    }

    public void setFastSwing() {
        if (!hpEnableFastSwing) {
            hpEnableFastSwing = true;
        }
    }

    public void setForeground(Color color) {
        this.pSetForeground(color);
    }

    public void setBackground(Color color) {
        this.pSetBackground(color);
    }

    public void setFont(Font font) {
        this.pSetFont(font);
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            int n = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            while (n2 < n) {
                Font font2;
                ComponentPeer componentPeer;
                if (componentArray[n2] != null && (componentPeer = componentArray[n2].getPeer()) != null && !font.equals(font2 = componentArray[n2].getFont())) {
                    componentPeer.setFont(font2);
                }
                ++n2;
            }
        }
        this.font = font;
    }

    public native void setCursor(Cursor var1);

    public native boolean isBackgroundInherited();

    public native boolean isForegroundInherited();

    public native void pSetScrollbarBackground(Color var1);

    public native void pSetInnerForeground(Color var1);

    public boolean isFocusTraversable() {
        return false;
    }

    public ColorModel getColorModel() {
        return this.graphicsConfig.getColorModel();
    }

    public ColorModel getColorModel(int n) {
        return this.graphicsConfig.getColorModel(n);
    }

    public int updatePriority() {
        return 5;
    }

    public void updateClient(Object object) {
        if (this.target.getPeer() != null) {
            Rectangle rectangle = null;
            MComponentPeer mComponentPeer = this;
            synchronized (mComponentPeer) {
                if (this.repaintPending) {
                    rectangle = this.repaintRect;
                    this.repaintPending = false;
                }
            }
            if (rectangle != null) {
                this.postEvent(new PaintEvent(this.target, 801, rectangle));
            }
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.addRepaintArea(n, n2, n3, n4);
        ScreenUpdater.updater.notify(this, l);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
        this.target.paint(graphics);
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
        this.target.print(graphics);
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        int n = paintEvent.getID();
        switch (n) {
            case 800: {
                this.paintArea.add(rectangle);
                return;
            }
            case 801: {
                this.updateArea.add(rectangle);
                return;
            }
        }
    }

    native void nativeHandleEvent(AWTEvent var1);

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 800: {
                this.paintArea.paint(this.target, false);
                return;
            }
            case 801: {
                this.updateArea.update(this.target);
                return;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public synchronized Graphics getGraphics() {
        if (!this.disposed) {
            X11Graphics x11Graphics = new X11Graphics(this);
            ((Graphics)x11Graphics).setColor(this.target.getForeground());
            ((Graphics)x11Graphics).setFont(this.target.getFont());
            return x11Graphics;
        }
        return null;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public Image createImage(int n, int n2) {
        MToolkit mToolkit = (MToolkit)Toolkit.getDefaultToolkit();
        if (MToolkit.hpFastSwing) {
            return this.createHPImage(n, n2);
        }
        ColorModel colorModel = this.getColorModel(1);
        return new OffScreenImage(this.target, colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied());
    }

    public Image createHPImage(int n, int n2) {
        return new X11OffScreenImage(this.target, n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    protected void disposeImpl() {
        ScreenUpdater.updater.removeClient(this);
        MToolkit.targetDisposedPeer(this.target, this);
        this.pDispose();
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            MComponentPeer mComponentPeer = this;
            synchronized (mComponentPeer) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public native void requestFocus();

    void postEvent(AWTEvent aWTEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(this.target), aWTEvent);
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent(this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent(this.target, 801, new Rectangle(n, n2, n3, n4)));
    }

    public int getZOrderPosition_NoClientCode() {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        if (container != null) {
            Component[] componentArray = MComponentPeer.getComponents_NoClientCode(container);
            int n = 0;
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] == this.target) {
                    return n;
                }
                Object object = MToolkit.targetToPeer(componentArray[n2]);
                if (object != null && !(object instanceof LightweightPeer)) {
                    ++n;
                }
                ++n2;
            }
        }
        return -1;
    }

    void draw3DOval(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawArc(n, n2, n3, n4, 45, 180);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawArc(n, n2, n3, n4, 225, 180);
        graphics.setColor(color2);
    }

    void draw3DRect(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        graphics.setColor(color2);
    }

    void drawScrollbar(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color2 = graphics.getColor();
        double d = (double)(n2 - 2 * (n - 1)) / (double)Math.max(1, n4 - n3 + n6);
        int n7 = n + (int)(d * (double)(n5 - n3));
        int n8 = (int)(d * (double)n6);
        int n9 = n - 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (n2 < 3 * n9) {
            n8 = 0;
            n7 = 0;
            if (n2 < 2 * n9 + 2) {
                n9 = (n2 - 2) / 2;
            }
        } else if (n8 < 7) {
            n7 = Math.max(0, n7 - (7 - n8 >> 1));
            n8 = 7;
        }
        int n10 = n / 2;
        int n11 = n10 - n9 / 2;
        int n12 = n10 + n9 / 2;
        Color color3 = new Color((int)((double)color.getRed() * 0.85), (int)((double)color.getGreen() * 0.85), (int)((double)color.getBlue() * 0.85));
        graphics.setColor(color3);
        if (bl) {
            graphics.fillRect(0, 0, n2, n);
        } else {
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(color);
        if (n7 > 0) {
            if (bl) {
                graphics.fillRect(n7, 3, n8, n - 3);
            } else {
                graphics.fillRect(3, n7, n - 3, n8);
            }
        }
        nArray[0] = n10;
        nArray2[0] = 2;
        nArray[1] = n11;
        nArray2[1] = n9;
        nArray[2] = n12;
        nArray2[2] = n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        nArray2[0] = n2 - 2;
        nArray2[1] = n2 - n9;
        nArray2[2] = n2 - n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        color3 = color.brighter();
        graphics.setColor(color3);
        if (bl) {
            graphics.drawLine(1, n, n2 - 1, n);
            graphics.drawLine(n2 - 1, 1, n2 - 1, n);
            graphics.drawLine(1, n10, n9, n11);
            graphics.drawLine(n2 - n9, n11, n2 - n9, n12);
            graphics.drawLine(n2 - n9, n11, n2 - 2, n10);
        } else {
            graphics.drawLine(n, 1, n, n2 - 1);
            graphics.drawLine(1, n2 - 1, n, n2 - 1);
            graphics.drawLine(n10, 1, n11, n9);
            graphics.drawLine(n11, n2 - n9, n12, n2 - n9);
            graphics.drawLine(n11, n2 - n9, n10, n2 - 2);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7, 2, n7 + n8, 2);
                graphics.drawLine(n7, 2, n7, n - 3);
            } else {
                graphics.drawLine(2, n7, 2, n7 + n8);
                graphics.drawLine(2, n7, n - 3, n7);
            }
        }
        Color color4 = color.darker();
        graphics.setColor(color4);
        if (bl) {
            graphics.drawLine(0, 0, 0, n);
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.drawLine(n9, n11, n9, n12);
            graphics.drawLine(n9, n12, 1, n10);
            graphics.drawLine(n2 - 2, n10, n2 - n9, n12);
        } else {
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(n11, n9, n12, n9);
            graphics.drawLine(n12, n9, n10, 1);
            graphics.drawLine(n10, n2 - 2, n12, n2 - n9);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7 + n8, 2, n7 + n8, n - 2);
                graphics.drawLine(n7, n - 2, n7 + n8, n - 2);
            } else {
                graphics.drawLine(2, n7 + n8, n - 2, n7 + n8);
                graphics.drawLine(n - 2, n7, n - 2, n7 + n8);
            }
        }
        graphics.setColor(color2);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pShow();
        } else {
            this.pHide();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.pEnable();
        } else {
            this.pDisable();
        }
    }

    public Point getLocationOnScreen() {
        return this.pGetLocationOnScreen();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.disposed) {
            return;
        }
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        if (container != null && container instanceof ScrollPane) {
            MScrollPanePeer mScrollPanePeer = (MScrollPanePeer)container.getPeer();
            if (!mScrollPanePeer.ignore) {
                this.pReshape(n, n2, n3, n4);
                mScrollPanePeer.childResized(n3, n4);
            }
        } else {
            this.pReshape(n, n2, n3, n4);
        }
        ++this.serialNum;
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public void addDropTarget(DropTarget dropTarget) {
        this.addNativeDropTarget(dropTarget);
    }

    public void removeDropTarget(DropTarget dropTarget) {
        this.removeNativeDropTarget(dropTarget);
    }

    public void notifyTextComponentChange(boolean bl) {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        if (container instanceof Frame || container instanceof Dialog) {
            if (bl) {
                ((MInputMethodControl)((Object)container.getPeer())).addTextComponent(this);
            } else {
                ((MInputMethodControl)((Object)container.getPeer())).removeTextComponent(this);
            }
        }
    }

    native void addNativeDropTarget(DropTarget var1);

    native void removeNativeDropTarget(DropTarget var1);

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
        if (graphicsConfiguration == null) {
            graphicsConfiguration = this.target.getGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        JAWT_LOCK_ERROR = 1;
        JAWT_LOCK_CLIP_CHANGED = 2;
        JAWT_LOCK_BOUNDS_CHANGED = 4;
        JAWT_LOCK_SURFACE_CHANGED = 8;
        MComponentPeer.initIDs();
    }
}

