/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.PathPermissions;
import sun.misc.URLClassPath;
import sun.security.action.GetPropertyAction;

public class Launcher {
    private static Launcher launcher;
    private static URLStreamHandlerFactory factory;
    private ClassLoader loader;
    private static URLStreamHandler fileHandler;

    static {
        factory = new Factory();
        launcher = (Launcher)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.boot.class.path");
                if (string != null) {
                    return new Launcher();
                }
                return null;
            }
        });
    }

    public Launcher() {
        ExtClassLoader extClassLoader;
        try {
            extClassLoader = ExtClassLoader.getExtClassLoader();
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create extension class loader");
        }
        try {
            this.loader = AppClassLoader.getAppClassLoader(extClassLoader);
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create application class loader");
        }
        Thread.currentThread().setContextClassLoader(this.loader);
        String string = System.getProperty("java.security.manager");
        if (string != null) {
            SecurityManager securityManager = null;
            if ("".equals(string) || "default".equals(string)) {
                securityManager = new SecurityManager();
            } else {
                try {
                    securityManager = (SecurityManager)this.loader.loadClass(string).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {}
            }
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            } else {
                throw new InternalError("Could not create SecurityManager: " + string);
            }
        }
    }

    public static URLClassPath getBootstrapClassPath() {
        URL[] uRLArray;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("java.class.path"));
        }
        if (string != null) {
            final String string2 = string;
            uRLArray = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Launcher.pathToURLs(Launcher.getClassPath(string2));
                }
            });
        } else {
            uRLArray = new URL[]{};
        }
        return new URLClassPath(uRLArray, factory);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private static File[] getClassPath(String string) {
        File[] fileArray;
        if (string != null) {
            int n = 0;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                ++n2;
                n4 = n3 + 1;
            }
            fileArray = new File[n2];
            n3 = 0;
            n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                fileArray[n++] = n3 - n4 > 0 ? new File(string.substring(n4, n3)) : new File(".");
                n4 = n3 + 1;
            }
            fileArray[n++] = n4 < string.length() ? new File(string.substring(n4)) : new File(".");
            if (n != n2) {
                File[] fileArray2 = new File[n];
                System.arraycopy(fileArray, 0, fileArray2, 0, n);
                fileArray = fileArray2;
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {}
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError();
        }
    }

    public static Launcher getLauncher() {
        return launcher;
    }

    private static URL[] pathToURLs(File[] fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            uRLArray[n] = Launcher.getFileURL(fileArray[n]);
            ++n;
        }
        return uRLArray;
    }

    static class ExtClassLoader
    extends URLClassLoader {
        private File[] dirs;

        public ExtClassLoader(File[] fileArray) throws IOException {
            super(ExtClassLoader.getExtURLs(fileArray), null, factory);
            this.dirs = fileArray;
        }

        void addExtURL(URL uRL) {
            super.addURL(uRL);
        }

        public String findLibrary(String string) {
            string = System.mapLibraryName(string);
            int n = 0;
            while (n < this.dirs.length) {
                File file;
                String string2 = System.getProperty("os.arch");
                if (string2 != null && (file = new File(new File(this.dirs[n], string2), string)).exists()) {
                    return file.getAbsolutePath();
                }
                file = new File(this.dirs[n], string);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                ++n;
            }
            return null;
        }

        private static AccessControlContext getContext(File[] fileArray) throws IOException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }

        public static ExtClassLoader getExtClassLoader() throws IOException {
            File[] fileArray = ExtClassLoader.getExtDirs();
            try {
                return (ExtClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(fileArray){
                    private final /* synthetic */ File[] val$dirs;
                    {
                        this.val$dirs = fileArray;
                    }

                    public Object run() throws IOException {
                        return new ExtClassLoader(this.val$dirs);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }

        private static File[] getExtDirs() {
            File[] fileArray;
            String string = System.getProperty("java.ext.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                int n = stringTokenizer.countTokens();
                fileArray = new File[n];
                int n2 = 0;
                while (n2 < n) {
                    fileArray[n2] = new File(stringTokenizer.nextToken());
                    ++n2;
                }
            } else {
                fileArray = new File[]{};
            }
            return fileArray;
        }

        private static URL[] getExtURLs(File[] fileArray) throws IOException {
            Object[] objectArray;
            Vector vector = new Vector();
            int n = 0;
            while (n < fileArray.length) {
                objectArray = fileArray[n].list();
                if (objectArray != null) {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        File file = new File(fileArray[n], (String)objectArray[n2]);
                        vector.add(Launcher.getFileURL(file));
                        ++n2;
                    }
                }
                ++n;
            }
            objectArray = new URL[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        AppClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader, factory);
        }

        public static ClassLoader getAppClassLoader(ClassLoader classLoader) throws IOException {
            String string = System.getProperty("java.class.path");
            File[] fileArray = string == null ? new File[]{} : Launcher.getClassPath(string);
            return (AppClassLoader)AccessController.doPrivileged(new PrivilegedAction(classLoader, fileArray, string){
                private final /* synthetic */ ClassLoader val$extcl;
                private final /* synthetic */ File[] val$path;
                private final /* synthetic */ String val$s;
                {
                    this.val$extcl = classLoader;
                    this.val$path = fileArray;
                    this.val$s = string;
                }

                public Object run() {
                    URL[] uRLArray = this.val$s == null ? new URL[]{} : Launcher.access$1(this.val$path);
                    return new AppClassLoader(uRLArray, this.val$extcl);
                }
            });
        }

        private static AccessControlContext getContext(File[] fileArray) throws MalformedURLException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            permissionCollection.add(new RuntimePermission("exitVM"));
            return permissionCollection;
        }

        public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            SecurityManager securityManager;
            int n = string.lastIndexOf(46);
            if (n != -1 && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            return super.loadClass(string, bl);
        }
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        Factory() {
        }

        public URLStreamHandler createURLStreamHandler(String string) {
            String string2 = String.valueOf(PREFIX) + "." + string + ".Handler";
            try {
                Class clazz = Class.forName(string2);
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw new InternalError("could not load " + string + "system protocol handler");
        }
    }
}

